/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import jive3.JTextTips;

class TipPopup
implements MouseMotionListener,
MouseListener {
    String[] items;
    JLabel text;
    JScrollPane textView;
    JTextTips parent;
    Popup popup;
    int hFont;
    int selectedIdx = -1;
    int[] globalIdx = null;
    boolean visible = false;
    String prefix;
    int compWidth;

    TipPopup(JTextTips parent) {
        this.parent = parent;
        this.text = new JLabel();
        this.text.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.text.setBackground(new Color(245, 245, 250));
        this.text.setHorizontalAlignment(2);
        this.text.setOpaque(true);
        this.hFont = (int)(ATKGraphicsUtils.measureString((String)"ABC", (Font)this.text.getFont()).getHeight() + 0.5) + 1;
        this.text.addMouseMotionListener(this);
        this.text.addMouseListener(this);
        this.textView = new JScrollPane(this.text);
        this.textView.setHorizontalScrollBarPolicy(31);
    }

    void setList(String[] items) {
        this.items = items;
    }

    void down() {
        if (this.visible && this.selectedIdx < this.globalIdx.length - 1) {
            ++this.selectedIdx;
            this.buildText();
            if (this.selectedIdx >= 0) {
                this.parent.setTextInternal(this.items[this.globalIdx[this.selectedIdx]]);
            }
            this.scrollToVisible();
        }
    }

    void up() {
        if (this.visible && this.selectedIdx > 0) {
            --this.selectedIdx;
            this.buildText();
            if (this.selectedIdx < this.globalIdx.length) {
                this.parent.setTextInternal(this.items[this.globalIdx[this.selectedIdx]]);
            }
            this.scrollToVisible();
        }
    }

    void select() {
        if (this.selectedIdx >= 0 && this.selectedIdx < this.globalIdx.length) {
            this.parent.setTextInternal(this.items[this.globalIdx[this.selectedIdx]]);
        }
        this.selectedIdx = -1;
        this.globalIdx = new int[0];
        this.setVisible(false);
    }

    void scrollToVisible() {
        Rectangle r = new Rectangle();
        this.parent.getBounds(r);
        r.x = 0;
        r.y = this.selectedIdx * this.hFont;
        r.height = this.hFont;
        this.text.scrollRectToVisible(r);
    }

    int buildText() {
        int i;
        if (this.items == null || this.items.length == 0 || this.prefix.length() == 0) {
            return 0;
        }
        String prefixLw = this.prefix.toLowerCase();
        int count = 0;
        Vector<Integer> v = new Vector<Integer>();
        StringBuffer str = new StringBuffer();
        str.append("<html>\n");
        str.append("<body>\n");
        str.append("<table cellpadding=\"0\" cellspacing=\"0\" width=\"" + this.compWidth + "px\">\n");
        for (i = 0; i < this.items.length; ++i) {
            if (!this.items[i].toLowerCase().startsWith(prefixLw)) continue;
            String it = "<font color=\"#000000\" >" + this.prefix + "</font><font color=\"#A5A5A5\">" + this.items[i].substring(this.prefix.length()) + "</font>";
            if (count == this.selectedIdx) {
                str.append("<tr><td bgcolor=\"#959595\">" + it + "</td></tr>");
            } else {
                str.append("<tr><td>" + it + "</td></tr>");
            }
            v.add(i);
            ++count;
        }
        str.append("</table>\n");
        str.append("</body>\n");
        str.append("</html>\n");
        this.text.setText(str.toString());
        this.globalIdx = new int[v.size()];
        for (i = 0; i < v.size(); ++i) {
            this.globalIdx[i] = (Integer)v.get(i);
        }
        return count;
    }

    void updateText() {
        this.selectedIdx = -1;
        this.globalIdx = new int[0];
        this.prefix = this.parent.getText();
        this.setVisible(this.buildText() > 0);
    }

    public void setVisible(boolean visible) {
        if (this.popup != null) {
            this.popup.hide();
        }
        if (visible) {
            Rectangle r = new Rectangle();
            this.parent.getBounds(r);
            this.compWidth = r.width;
            int h = this.text.getPreferredSize().height + 10;
            if (h > 150) {
                h = 150;
            }
            this.textView.setPreferredSize(new Dimension(r.width, h));
            Point p = this.parent.getLocationOnScreen();
            this.popup = PopupFactory.getSharedInstance().getPopup(this.parent, this.textView, p.x, p.y + r.height);
            this.popup.show();
        }
        this.visible = visible;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.selectedIdx = e.getY() / this.hFont;
        this.buildText();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.selectedIdx = e.getY() / this.hFont;
        this.select();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

