/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import admin.astor.tools.DeviceHierarchyDialog;
import admin.astor.tools.PoolThreadsManager;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceInfo;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.logviewer.Main;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jive.ExecDev;
import jive.JiveUtils;
import jive3.Action;
import jive3.DbFileWriter;
import jive3.MainPanel;
import jive3.TangoClassSelector;
import jive3.TangoNode;
import jive3.TangoNodeRenderer;
import jive3.UsageDlg;

public abstract class TreePanel
extends JPanel
implements TreeSelectionListener,
MouseListener,
TreeExpansionListener {
    protected JTree tree;
    protected JScrollPane treeView = null;
    protected DefaultTreeModel treeModel;
    protected TangoNode root;
    protected Database db;
    TreePanel self;
    private boolean updateOnChange;
    public static final int ACTION_COPY = 0;
    public static final int ACTION_PASTE = 1;
    public static final int ACTION_RENAME = 2;
    public static final int ACTION_DELETE = 3;
    public static final int ACTION_ADDCLASS = 4;
    public static final int ACTION_TESTADMIN = 5;
    public static final int ACTION_SAVESERVER = 6;
    public static final int ACTION_CLASSWIZ = 7;
    public static final int ACTION_ADDDEVICE = 8;
    public static final int ACTION_DEVICESWIZ = 9;
    public static final int ACTION_MONITORDEV = 10;
    public static final int ACTION_TESTDEV = 11;
    public static final int ACTION_DEFALIAS = 12;
    public static final int ACTION_GOTODEVNODE = 13;
    public static final int ACTION_RESTART = 14;
    public static final int ACTION_DEVICEWIZ = 15;
    public static final int ACTION_GOTOSERVNODE = 16;
    public static final int ACTION_GOTOADMINNODE = 17;
    public static final int ACTION_ADDCLASSATT = 18;
    public static final int ACTION_UNEXPORT = 19;
    public static final int ACTION_SELECT_PROP = 20;
    public static final int ACTION_SELECT_POLLING = 21;
    public static final int ACTION_SELECT_EVENT = 22;
    public static final int ACTION_SELECT_ATTCONF = 23;
    public static final int ACTION_SELECT_LOGGING = 24;
    public static final int ACTION_LOG_VIEWER = 25;
    public static final int ACTION_DEV_DEPEND = 26;
    public static final int ACTION_THREAD_POLL = 27;
    public static final int ACTION_VIEW_HISTORY = 28;
    public static final int ACTION_MOVE_SERVER = 29;
    public static final int ACTION_CREATE_ATTPROP = 30;
    public static final int ACTION_START_SERVER = 31;
    public static final int ACTION_STOP_SERVER = 32;
    public static final int ACTION_RESTART_SERVER = 33;
    public static final int ACTION_START_LEVEL = 34;
    public static final int ACTION_STOP_LEVEL = 35;
    public static final int ACTION_START_HOST = 36;
    public static final int ACTION_STOP_HOST = 37;
    public static final int ACTION_CH_HOST_USAGE = 38;
    public static final int ACTION_GO_TO_STATER = 39;
    public static final int ACTION_CH_LEVEL = 40;
    public static final int ACTION_TERMINAL = 41;
    public static final int ACTION_NEW_SERVERS = 42;
    public static final int ACTION_COPY_ATT_SET = 43;
    public static final int ACTION_SAVE_PROP = 44;
    public static final int ACTION_FIND_USAGE = 45;
    public static final int ACTION_UNEXPORT_HOST = 46;
    public static final Action[] actions = new Action[]{new Action(0, false, "Copy", 67, 128), new Action(1, false, "Paste", 86, 128), new Action(2, false, "Rename", 113, 0), new Action(3, true, "Delete", 127, 0), new Action(4, false, "Add class"), new Action(5, false, "Test admin server"), new Action(6, true, "Save server data"), new Action(7, false, "Class(es) wizard"), new Action(8, false, "Add device"), new Action(9, false, "Device(s) wizard"), new Action(10, true, "Monitor device"), new Action(11, true, "Test device"), new Action(12, false, "Define device alias"), new Action(13, false, "Go to device node"), new Action(14, false, "Restart device"), new Action(15, false, "Device wizard"), new Action(16, false, "Go to server node"), new Action(17, false, "Go to device admin node"), new Action(18, false, "Add attribute"), new Action(19, false, "Unexport devices"), new Action(20, false, "Select 'property node'"), new Action(21, false, "Select 'polling' nodes"), new Action(22, false, "Select 'event' nodes"), new Action(23, false, "Select 'attribute config' nodes"), new Action(24, false, "Select 'logging' nodes"), new Action(25, false, "Log Viewer"), new Action(26, false, "Devices dependencies"), new Action(27, false, "Polling threads manager"), new Action(28, false, "View history"), new Action(29, false, "Move server"), new Action(30, false, "Create attribute property"), new Action(31, false, "Start Server"), new Action(32, false, "Stop Server"), new Action(33, false, "Restart Server"), new Action(34, false, "Start all servers (Level)"), new Action(35, false, "Stop all servers (Level)"), new Action(36, false, "Start all servers (Host)"), new Action(37, false, "Stop all servers (Host)"), new Action(38, false, "Edit Host Usage"), new Action(39, false, "Go to Starter Node"), new Action(40, false, "Change Level"), new Action(41, false, "Open terminal"), new Action(42, false, "Start new servers"), new Action(43, false, "Copy Setpoints"), new Action(44, false, "Save properties", 83, 128), new Action(45, false, "Find usage"), new Action(46, false, "Unexport devices")};
    static File lastFile = null;
    static FileWriter globalResFile;
    static MainPanel invoker;
    static TreePanel panelInvoker;
    private static JPopupMenu actionMenu;

    abstract TangoNode createRoot();

    public void initTree() {
        this.root = this.createRoot();
        this.treeModel = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.treeModel);
        this.tree.setEditable(false);
        this.tree.setCellRenderer(new TangoNodeRenderer());
        this.tree.getSelectionModel().setSelectionMode(4);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setBorder(BorderFactory.createLoweredBevelBorder());
        this.tree.addMouseListener(this);
        this.tree.addTreeSelectionListener(this);
        for (int i = 0; i < actions.length; ++i) {
            final KeyStroke ks = TreePanel.actions[i].keyStroke;
            if (ks == null) continue;
            Object key = this.tree.getInputMap().get(ks);
            this.tree.getActionMap().put(key, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TreePanel.this.execShortCut(ks);
                }
            });
        }
        this.tree.setToggleClickCount(0);
        this.treeView = new JScrollPane(this.tree);
        this.add((Component)this.treeView, "Center");
        this.updateOnChange = true;
        this.tree.addTreeExpansionListener(this);
    }

    static Action getAction(int action) {
        boolean found = false;
        int i = 0;
        while (!found && i < actions.length) {
            found = TreePanel.actions[i].action == action;
            if (found) continue;
            ++i;
        }
        if (!found) {
            throw new IllegalStateException("Action.getAction() unexpected action code");
        }
        return actions[i];
    }

    static Action nodeAction(TangoNode node, int action) {
        boolean found = false;
        int i = 0;
        Action[] nodeActions = node.getAction();
        while (!found && i < nodeActions.length) {
            found = nodeActions[i].action == action;
            if (found) continue;
            ++i;
        }
        if (!found) {
            return null;
        }
        return nodeActions[i];
    }

    static File getSaveFile(MainPanel invoker) {
        int returnVal;
        JFileChooser chooser = new JFileChooser(".");
        int ok = 0;
        if (lastFile != null) {
            chooser.setSelectedFile(lastFile);
        }
        if ((returnVal = chooser.showSaveDialog(invoker)) == 0 && (lastFile = chooser.getSelectedFile()) != null) {
            if (lastFile.exists()) {
                ok = JOptionPane.showConfirmDialog(invoker, "Do you want to overwrite " + lastFile.getName() + " ?", "Confirm overwrite", 0);
            }
            if (ok == 0) {
                return lastFile;
            }
            return null;
        }
        return null;
    }

    public void setDatabase(Database db) {
        this.db = db;
        if (this.treeView != null) {
            this.remove(this.treeView);
            this.treeView = null;
        }
        if (db != null) {
            this.initTree();
        } else {
            this.repaint();
        }
    }

    public void refresh() {
        if (this.treeView == null) {
            return;
        }
        TreePath oldPath = this.tree.getSelectionPath();
        this.remove(this.treeView);
        if (this.db != null) {
            this.initTree();
        }
        invoker.resetNavigation();
        this.selectPath(oldPath);
    }

    public void selectPath(TreePath path) {
        if (path != null) {
            TreePath newPath = new TreePath(this.root);
            TangoNode node = this.root;
            boolean found = true;
            int i = 1;
            while (found && i < path.getPathCount()) {
                String item = path.getPathComponent(i).toString();
                if ((node = this.searchNode(node, item)) != null) {
                    newPath = newPath.pathByAddingChild(node);
                    ++i;
                    continue;
                }
                found = false;
            }
            this.tree.setSelectionPath(newPath);
            this.tree.expandPath(newPath);
            this.tree.makeVisible(newPath);
            this.tree.scrollPathToVisible(newPath);
        }
    }

    public void refreshValues() {
        if (this.treeView == null) {
            return;
        }
        TreePath[] selPaths = this.tree.getSelectionPaths();
        if (selPaths != null) {
            TangoNode[] nodes = new TangoNode[selPaths.length];
            for (int i = 0; i < nodes.length; ++i) {
                nodes[i] = (TangoNode)selPaths[i].getLastPathComponent();
            }
            invoker.updatePanel(nodes);
            if (selPaths.length == 1) {
                this.tree.scrollPathToVisible(selPaths[0]);
            }
        } else {
            invoker.updatePanel(null);
        }
    }

    public boolean checkDeleteDevice(String devName) {
        String msg;
        boolean ok = false;
        ok = devName.toLowerCase().startsWith("dserver") ? JOptionPane.showConfirmDialog(invoker, msg = "Warning! You are about to delete a Tango Admin device " + devName + ".\nIf you delete it, the device server '" + devName.substring(8) + "' will stop working correctly.\nIf you want to delete the '" + devName.substring(8) + "' device server instance,\nyou can do it from the Server tab.\nAre you sure you want to delete '" + devName + "' admin device?", "Confirm delete", 0) == 0 : JOptionPane.showConfirmDialog(invoker, "Delete device " + devName + " ?", "Confirm delete", 0) == 0;
        return ok;
    }

    public boolean isRootItem(String itemName) {
        TangoNode node = this.searchNodeStartingWith(this.root, itemName);
        return node != null;
    }

    public TreePath selectRootItem(String itemName) {
        TangoNode node = this.searchNodeStartingWith(this.root, itemName);
        TreePath selPath = new TreePath(this.root);
        selPath = selPath.pathByAddingChild(node);
        this.tree.setSelectionPath(selPath);
        return selPath;
    }

    public TangoNode searchNode(TangoNode startNode, String value) {
        int numChild = this.treeModel.getChildCount(startNode);
        int i = 0;
        boolean found = false;
        TangoNode elem = null;
        while (i < numChild && !found) {
            elem = (TangoNode)this.treeModel.getChild(startNode, i);
            found = elem.toString().compareToIgnoreCase(value) == 0;
            if (found) continue;
            ++i;
        }
        if (found) {
            return elem;
        }
        return null;
    }

    public TangoNode searchNodeStartingWith(TangoNode startNode, String value) {
        int numChild = this.treeModel.getChildCount(startNode);
        int i = 0;
        boolean found = false;
        TangoNode elem = null;
        while (i < numChild && !found) {
            elem = (TangoNode)this.treeModel.getChild(startNode, i);
            found = elem.toString().toLowerCase().startsWith(value.toLowerCase());
            if (found) continue;
            ++i;
        }
        if (found) {
            return elem;
        }
        return null;
    }

    public TangoNode searchNodeCaseSensitive(TangoNode startNode, String value) {
        int numChild = this.treeModel.getChildCount(startNode);
        int i = 0;
        boolean found = false;
        TangoNode elem = null;
        while (i < numChild && !found) {
            elem = (TangoNode)this.treeModel.getChild(startNode, i);
            found = elem.toString().compareTo(value) == 0;
            if (found) continue;
            ++i;
        }
        if (found) {
            return elem;
        }
        return null;
    }

    public void testDevice(String devName) {
        JDialog dlg = new JDialog((Frame)invoker, false);
        try {
            dlg.setTitle("Device Panel [" + devName + "] on " + this.db.get_tango_host());
        }
        catch (DevFailed e) {
            dlg.setTitle("Device Panel [" + devName + "] on ???");
        }
        try {
            ExecDev p = new ExecDev(devName);
            dlg.setContentPane(p);
            JiveUtils.centerDialog(dlg);
            dlg.setVisible(true);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    public void pasteDeviceProperty(Database db, String devname) {
        try {
            int i;
            JiveUtils.the_clipboard.parse();
            for (i = 0; i < JiveUtils.the_clipboard.getObjectPropertyLength(); ++i) {
                db.put_device_property(devname, JiveUtils.makeDbDatum(JiveUtils.the_clipboard.getObjectPropertyName(i), JiveUtils.the_clipboard.getObjectPropertyValue(i)));
            }
            for (i = 0; i < JiveUtils.the_clipboard.getAttPropertyLength(); ++i) {
                DbAttribute att = new DbAttribute(JiveUtils.the_clipboard.getAttName(i));
                att.add((Object)JiveUtils.makeDbDatum(JiveUtils.the_clipboard.getAttPropertyName(i), JiveUtils.the_clipboard.getAttPropertyValue(i))[0]);
                db.put_device_attribute_property(devname, att);
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    public String getDeviceInfo(String devName) {
        Object result = "";
        try {
            DeviceProxy ds = new DeviceProxy(devName);
            result = "<b>Device Info</b>\n<hr>\n";
            DeviceInfo info = ds.get_info();
            result = (String)result + info.toString() + "\n";
            result = (String)result + "\n\n<b>Polling Status</b>\n<hr>\n";
            String[] pi = ds.polling_status();
            for (int i = 0; i < pi.length; ++i) {
                result = (String)result + pi[i] + "\n\n";
            }
        }
        catch (DevFailed e) {
            for (int i = 0; i < e.errors.length; ++i) {
                result = (String)result + "Desc -> " + e.errors[i].desc + "\n";
                result = (String)result + "Reason -> " + e.errors[i].reason + "\n";
                result = (String)result + "Origin -> " + e.errors[i].origin + "\n";
            }
        }
        return result;
    }

    public void findUsage(String devName) {
        try {
            DeviceData argin = new DeviceData();
            String request = "select distinct device from property_device where name=\"__SubDevices\" and value=\"" + devName.toLowerCase() + "\";";
            argin.insert(request);
            DeviceData argout = this.db.command_inout("DbMySqlSelect", argin);
            DevVarLongStringArray arg = argout.extractLongStringArray();
            StringBuffer str = new StringBuffer();
            for (int i = 0; i < arg.svalue.length; ++i) {
                str.append(arg.svalue[i]);
                if (i >= arg.svalue.length - 1) continue;
                str.append("\n");
            }
            UsageDlg dlg = new UsageDlg(invoker, devName);
            dlg.setText(str.toString());
            dlg.showDlg();
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (this.updateOnChange) {
            this.refreshValues();
        }
    }

    public void refreshNode(TangoNode node, String childToSelect) {
        node.clearNodes();
        node.getChildCount();
        this.treeModel.nodeStructureChanged(node);
        if (childToSelect != null) {
            Object[] nodes = node.getPath();
            TreePath path = new TreePath(nodes);
            TangoNode subNode = this.searchNode(node, childToSelect);
            path = path.pathByAddingChild(subNode);
            this.tree.setSelectionPath(path);
            this.tree.expandPath(path);
            this.tree.makeVisible(path);
            this.tree.scrollPathToVisible(path);
        }
    }

    private void createSelectedNodes(TreePath[] paths) {
        Action.selectedNodes = new TangoNode[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            Action.selectedNodes[i] = (TangoNode)paths[i].getLastPathComponent();
        }
    }

    private TreePath getNodePath(TangoNode node) {
        Object[] pNodes = node.getPath();
        return new TreePath(pNodes);
    }

    private boolean isGoodClass(String devName, String className, String[] devList) {
        boolean found = false;
        for (int i = 0; i < devList.length && !found; i += 2) {
            found = devList[i].equalsIgnoreCase(devName);
            if (!found) continue;
            return devList[i + 1].equalsIgnoreCase(className);
        }
        return false;
    }

    public void selectNodesFromDevices(TangoNode startNode, String nodeName) {
        this.tree.clearSelection();
        this.updateOnChange = false;
        int numDev = this.treeModel.getChildCount(startNode);
        for (int j = 0; j < numDev; ++j) {
            TangoNode devNode = (TangoNode)this.treeModel.getChild(startNode, j);
            this.selectNodes(devNode, nodeName);
        }
        this.refreshValues();
        this.updateOnChange = true;
    }

    public void selectNodesFromDomain(TangoNode startNode, String nodeName) {
        String[] list;
        this.tree.clearSelection();
        this.updateOnChange = false;
        try {
            int i;
            DeviceData argin = new DeviceData();
            String request = "select name,class from device where domain='" + startNode.toString() + "'";
            argin.insert(request);
            DeviceData argout = this.db.command_inout("DbMySqlSelect", argin);
            DevVarLongStringArray arg = argout.extractLongStringArray();
            Vector<String> vList = new Vector<String>();
            for (i = 0; i < arg.svalue.length; i += 2) {
                if (arg.lvalue[i / 2] == 0) continue;
                vList.add(arg.svalue[i]);
                vList.add(arg.svalue[i + 1]);
            }
            list = new String[vList.size()];
            for (i = 0; i < list.length; ++i) {
                list[i] = (String)vList.get(i);
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
            return;
        }
        JFrame top = (JFrame)ATKGraphicsUtils.getWindowForComponent((Component)this);
        TangoClassSelector classSel = new TangoClassSelector(top, list, nodeName);
        String classToSelect = classSel.getSelectedClass();
        if (classToSelect == null) {
            this.updateOnChange = true;
            return;
        }
        int numFamily = this.treeModel.getChildCount(startNode);
        for (int i = 0; i < numFamily; ++i) {
            TangoNode fNode = (TangoNode)this.treeModel.getChild(startNode, i);
            int numDev = this.treeModel.getChildCount(fNode);
            for (int j = 0; j < numDev; ++j) {
                TangoNode devNode = (TangoNode)this.treeModel.getChild(fNode, j);
                String devName = devNode.getParent().getParent().toString() + "/" + devNode.getParent().toString() + "/" + devNode.toString();
                if (!this.isGoodClass(devName, classToSelect, list)) continue;
                this.selectNodes(devNode, nodeName);
            }
        }
        this.refreshValues();
        this.updateOnChange = true;
    }

    public void selectNodesFromFamily(TangoNode startNode, String nodeName) {
        String[] list;
        this.tree.clearSelection();
        this.updateOnChange = false;
        try {
            int i;
            DeviceData argin = new DeviceData();
            String request = "select name,class from device where family='" + startNode.toString() + "' and domain='" + startNode.getParent().toString() + "'";
            argin.insert(request);
            DeviceData argout = this.db.command_inout("DbMySqlSelect", argin);
            DevVarLongStringArray arg = argout.extractLongStringArray();
            Vector<String> vList = new Vector<String>();
            for (i = 0; i < arg.svalue.length; i += 2) {
                if (arg.lvalue[i / 2] == 0) continue;
                vList.add(arg.svalue[i]);
                vList.add(arg.svalue[i + 1]);
            }
            list = new String[vList.size()];
            for (i = 0; i < list.length; ++i) {
                list[i] = (String)vList.get(i);
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
            return;
        }
        JFrame top = (JFrame)ATKGraphicsUtils.getWindowForComponent((Component)this);
        TangoClassSelector classSel = new TangoClassSelector(top, list, nodeName);
        String classToSelect = classSel.getSelectedClass();
        if (classToSelect == null) {
            this.updateOnChange = true;
            return;
        }
        int numDev = this.treeModel.getChildCount(startNode);
        for (int i = 0; i < numDev; ++i) {
            TangoNode devNode = (TangoNode)this.treeModel.getChild(startNode, i);
            String devName = devNode.getParent().getParent().toString() + "/" + devNode.getParent().toString() + "/" + devNode.toString();
            if (!this.isGoodClass(devName, classToSelect, list)) continue;
            this.selectNodes(devNode, nodeName);
        }
        this.refreshValues();
        this.updateOnChange = true;
    }

    private void selectNodes(TangoNode startNode, String nodeName) {
        int numItem = this.treeModel.getChildCount(startNode);
        boolean found = false;
        for (int j = 0; !found && j < numItem; ++j) {
            TangoNode iNode = (TangoNode)this.treeModel.getChild(startNode, j);
            found = nodeName.equalsIgnoreCase(iNode.toString());
            if (!found) continue;
            this.tree.addSelectionPath(this.getNodePath(iNode));
        }
    }

    public String filterToRegExp(String filter) {
        if (filter.equals("*")) {
            return "*";
        }
        String wildcard = "[a-z0-9_\\-\\.]*";
        StringBuffer ret = new StringBuffer();
        int length = filter.length();
        for (int i = 0; i < length; ++i) {
            char c = filter.charAt(i);
            if (c == '*') {
                ret.append(wildcard);
                continue;
            }
            ret.append(c);
        }
        return ret.toString().toLowerCase();
    }

    public String replaceWildcard(String in) {
        StringBuffer ret = new StringBuffer();
        int length = in.length();
        for (int idx = 0; idx < length; ++idx) {
            if (in.charAt(idx) == '*') {
                ret.append('%');
                continue;
            }
            if (in.charAt(idx) == '_') {
                ret.append("\\_");
                continue;
            }
            ret.append(in.charAt(idx));
        }
        return ret.toString();
    }

    public void launchLogViewer(String devName) {
        Main m = new Main(new String[0], true);
        m.selectDevice(devName);
    }

    public void launchDevDepend(String srvName) {
        try {
            DeviceHierarchyDialog dlg = new DeviceHierarchyDialog((Window)invoker, srvName);
            dlg.setTitle("Device Hierarchy");
            dlg.setVisible(true);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    public void launchPollingThreadsManager(String srvName) {
        try {
            PoolThreadsManager dlg = new PoolThreadsManager((Window)invoker, srvName);
            dlg.setTitle("Polling threads manager");
            dlg.setVisible(true);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    public void createEmptyAttributeProperty(String devName) {
        String propName = JOptionPane.showInputDialog(invoker, "Name: (attribute/prop_name)", "Create attribute property", -1);
        if (propName != null) {
            String[] split = propName.split("/");
            if (split.length != 2) {
                JiveUtils.showJiveError("Invalid name syntax\nattribute/prop_name expected");
            } else {
                try {
                    DbAttribute dbAtt = new DbAttribute(split[0]);
                    dbAtt.add(split[1], "");
                    this.db.put_device_attribute_property(devName, dbAtt);
                }
                catch (DevFailed e) {
                    JiveUtils.showTangoError(e);
                }
                this.refresh();
            }
        }
    }

    public void putAttributeProperty(String devName, String attName, String propName, String value) {
        try {
            DbAttribute att = new DbAttribute(attName);
            att.add(propName, JiveUtils.makeStringArray(value));
            this.db.put_device_attribute_property(devName, att);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    public void saveServerData(FileWriter fw, String srvName) throws IOException {
        DbFileWriter.SaveServerData(this.db, fw, srvName);
    }

    public void execShortCut(KeyStroke ks) {
        if (this.tree.isSelectionEmpty()) {
            return;
        }
        TreePath[] paths = this.tree.getSelectionPaths();
        this.createSelectedNodes(paths);
        int action = 0;
        boolean found = false;
        while (action < actions.length && !found) {
            found = actions[action].isShortcut(ks);
            if (found) continue;
            ++action;
        }
        if (!found) {
            return;
        }
        if (!TreePanel.actions[action].allowMultiple && paths.length != 1) {
            return;
        }
        Action a = TreePanel.nodeAction(Action.selectedNodes[0], TreePanel.actions[action].action);
        boolean allOk = a != null;
        for (int i = 1; allOk && i < Action.selectedNodes.length; ++i) {
            allOk = TreePanel.nodeAction(Action.selectedNodes[i], TreePanel.actions[action].action) != null;
        }
        panelInvoker = this;
        if (allOk) {
            a.execAction();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        TreePath selPath = this.tree.getPathForLocation(e.getX(), e.getY());
        if (selPath != null) {
            if (e.getClickCount() == 1 && e.getButton() == 3) {
                if (!this.tree.isSelectionEmpty()) {
                    TreePath[] paths;
                    if (!this.tree.isPathSelected(selPath)) {
                        this.tree.addSelectionPath(selPath);
                    }
                    if ((paths = this.tree.getSelectionPaths()).length > 1) {
                        int i;
                        int[] hasMultiple = new int[actions.length];
                        for (int i2 = 0; i2 < paths.length; ++i2) {
                            Action[] nodeActions = ((TangoNode)paths[i2].getLastPathComponent()).getAction();
                            for (int j = 0; j < nodeActions.length; ++j) {
                                if (!nodeActions[j].allowMultiple) continue;
                                int n = nodeActions[j].action;
                                hasMultiple[n] = hasMultiple[n] + 1;
                            }
                        }
                        boolean popupMultiple = false;
                        for (i = 0; i < hasMultiple.length; ++i) {
                            if (hasMultiple[i] != paths.length) continue;
                            popupMultiple = true;
                        }
                        if (popupMultiple) {
                            this.createSelectedNodes(paths);
                            for (i = 0; i < actions.length; ++i) {
                                if (hasMultiple[i] == paths.length) {
                                    actionMenu.getComponent(i).setVisible(true);
                                    continue;
                                }
                                actionMenu.getComponent(i).setVisible(false);
                            }
                            actionMenu.show(this.tree, e.getX(), e.getY());
                            panelInvoker = this;
                            return;
                        }
                    }
                }
                this.createSelectedNodes(new TreePath[]{selPath});
                this.tree.setSelectionPath(selPath);
                Action[] actionsNode = Action.selectedNodes[0].getAction();
                if (actions.length > 0) {
                    int i;
                    for (i = 0; i < actions.length; ++i) {
                        actionMenu.getComponent(i).setVisible(false);
                    }
                    for (i = 0; i < actionsNode.length; ++i) {
                        actionsNode[i].menuItem.setVisible(true);
                    }
                    actionMenu.show(this.tree, e.getX(), e.getY());
                }
            }
            if (e.getClickCount() == 2 && e.getButton() == 1) {
                this.createSelectedNodes(new TreePath[]{selPath});
                this.tree.setSelectionPath(selPath);
                Action a = TreePanel.nodeAction(Action.selectedNodes[0], 10);
                if (a != null) {
                    a.execAction();
                }
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    static {
        actionMenu = new JPopupMenu();
        for (int i = 0; i < actions.length; ++i) {
            actionMenu.add(TreePanel.actions[i].menuItem);
        }
    }
}

