/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import java.awt.BorderLayout;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import jive.JiveUtils;
import jive3.Action;
import jive3.TangoNode;
import jive3.TangoNodeRenderer;
import jive3.TaskDeviceAttributePropertyNode;
import jive3.TaskSingleAttributeNode;
import jive3.TreePanel;

public class TreePanelAttributeAlias
extends TreePanel {
    String aliasFilterString = "*";
    Pattern aliasPattern = null;

    public TreePanelAttributeAlias() {
        this.self = this;
        this.setLayout(new BorderLayout());
    }

    @Override
    public TangoNode createRoot() {
        return new RootNode();
    }

    public void applyFilter(String filter) {
        this.aliasFilterString = filter;
        if (filter.equals("*")) {
            this.aliasPattern = null;
        } else if (filter.length() == 0) {
            this.aliasPattern = null;
        } else {
            try {
                String f = this.filterToRegExp(this.aliasFilterString);
                this.aliasPattern = Pattern.compile(f);
            }
            catch (PatternSyntaxException e) {
                JOptionPane.showMessageDialog(invoker, e.getMessage());
            }
        }
    }

    public String getFilter() {
        return this.aliasFilterString;
    }

    class RootNode
    extends TangoNode {
        RootNode() {
        }

        @Override
        void populateNode() throws DevFailed {
            String[] list = TreePanelAttributeAlias.this.db.get_attribute_alias_list("*");
            JiveUtils.sortList(list);
            for (int i = 0; i < list.length; ++i) {
                if (TreePanelAttributeAlias.this.aliasPattern != null) {
                    Matcher matcher = TreePanelAttributeAlias.this.aliasPattern.matcher(list[i].toLowerCase());
                    if (!matcher.find() || matcher.start() != 0 || matcher.end() != list[i].length()) continue;
                    this.add(new AliasNode(list[i]));
                    continue;
                }
                this.add(new AliasNode(list[i]));
            }
        }

        @Override
        public String toString() {
            return "AttAlias:";
        }

        @Override
        void execAction(int number, boolean multipleCall) {
        }
    }

    class AliasNode
    extends TangoNode {
        private String aliasName = null;
        private String attName = null;

        AliasNode(String aliasName) {
            this.aliasName = aliasName;
        }

        @Override
        void populateNode() throws DevFailed {
            if (this.attName == null) {
                this.attName = TreePanelAttributeAlias.this.db.get_attribute_from_alias(this.aliasName);
            }
            int aslash = this.attName.lastIndexOf("/");
            String devName = this.attName.substring(0, aslash);
            String aName = this.attName.substring(aslash + 1);
            DeviceProxy ds = new DeviceProxy(devName);
            int idl = ds.get_idl_version();
            this.add(new TaskDeviceAttributePropertyNode(TreePanelAttributeAlias.this.self, TreePanelAttributeAlias.this.db, devName, aName, idl, false));
            this.add(new TaskSingleAttributeNode(TreePanelAttributeAlias.this.self, TreePanelAttributeAlias.this.db, devName, this.attName, idl));
        }

        @Override
        public String toString() {
            return this.aliasName;
        }

        @Override
        public ImageIcon getIcon() {
            return TangoNodeRenderer.atticon;
        }

        @Override
        public Action[] getAction() {
            if (JiveUtils.readOnly) {
                return new Action[]{TreePanel.getAction(13)};
            }
            return new Action[]{TreePanel.getAction(13), TreePanel.getAction(3)};
        }

        public void goToDeviceNode() {
            try {
                if (this.attName == null) {
                    this.attName = TreePanelAttributeAlias.this.db.get_attribute_from_alias(this.aliasName);
                }
                int aslash = this.attName.lastIndexOf("/");
                String devName = this.attName.substring(0, aslash);
                TreePanel.invoker.goToDeviceNode(devName);
            }
            catch (DevFailed e) {
                JiveUtils.showTangoError(e);
            }
        }

        @Override
        public void execAction(int actionNumber, boolean multipleCall) throws IOException {
            switch (actionNumber) {
                case 3: {
                    if (multipleCall) {
                        try {
                            TreePanelAttributeAlias.this.db.delete_attribute_alias(this.aliasName);
                            break;
                        }
                        catch (DevFailed e) {
                            throw new IOException(this.aliasName + ":" + e.errors[0].desc);
                        }
                    }
                    int ok = JOptionPane.showConfirmDialog(TreePanel.invoker, "Delete attribute alias " + this.aliasName + " ?", "Confirm delete", 0);
                    if (ok != 0) break;
                    try {
                        TreePanelAttributeAlias.this.db.delete_attribute_alias(this.aliasName);
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                    }
                    TreePanelAttributeAlias.this.refresh();
                    break;
                }
                case 13: {
                    this.goToDeviceNode();
                }
            }
        }

        @Override
        public String getValue() {
            if (this.attName == null) {
                try {
                    this.attName = TreePanelAttributeAlias.this.db.get_attribute_from_alias(this.aliasName);
                }
                catch (DevFailed e) {
                    JiveUtils.showTangoError(e);
                }
            }
            return this.aliasName + " = " + this.attName;
        }

        @Override
        public String getTitle() {
            return "Attribute alias";
        }
    }
}

