/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import java.awt.BorderLayout;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;
import jive.DevWizard;
import jive.JiveUtils;
import jive3.Action;
import jive3.AttributeNode;
import jive3.DbFileWriter;
import jive3.TangoNode;
import jive3.TangoNodeRenderer;
import jive3.TaskAttributeNode;
import jive3.TaskDevicePropertyNode;
import jive3.TaskEventNode;
import jive3.TaskLoggingNode;
import jive3.TaskPipeNode;
import jive3.TaskPollingNode;
import jive3.TreePanel;

public class TreePanelDevice
extends TreePanel {
    String deviceFilterString = "*/*/*";
    String domainFilterString = "*";
    String familyFilterString = "*";
    String memberFilterString = "*";

    public TreePanelDevice() {
        this.self = this;
        this.setLayout(new BorderLayout());
    }

    public boolean isDomain(String domain) {
        TangoNode domainNode = this.searchNode(this.root, domain);
        return domainNode != null;
    }

    public TangoNode selectDevice(String devName) {
        int bslash = devName.indexOf(47);
        int lslash = devName.lastIndexOf(47);
        String domain = devName.substring(0, bslash);
        String family = devName.substring(bslash + 1, lslash);
        String member = devName.substring(lslash + 1);
        TangoNode domainNode = this.searchNode(this.root, domain);
        if (domainNode == null) {
            return null;
        }
        TangoNode familyNode = this.searchNode(domainNode, family);
        if (familyNode == null) {
            return null;
        }
        TangoNode memberNode = this.searchNode(familyNode, member);
        if (memberNode == null) {
            return null;
        }
        TreePath selPath = new TreePath(this.root);
        selPath = selPath.pathByAddingChild(domainNode);
        selPath = selPath.pathByAddingChild(familyNode);
        selPath = selPath.pathByAddingChild(memberNode);
        this.tree.setSelectionPath(selPath);
        return memberNode;
    }

    @Override
    public TangoNode createRoot() {
        return new RootNode(this);
    }

    public void applyFilter(String filter) {
        String[] filters = filter.split("/");
        if (filters.length != 3) {
            JOptionPane.showMessageDialog(invoker, "Invalid device filter\n3 fields expected: domain/family/member");
            return;
        }
        this.deviceFilterString = filter;
        this.domainFilterString = filters[0];
        this.familyFilterString = filters[1];
        this.memberFilterString = filters[2];
    }

    public String getFilter() {
        return this.deviceFilterString;
    }

    class RootNode
    extends TangoNode {
        RootNode(TreePanel parentPanel) {
            this.parentPanel = parentPanel;
        }

        @Override
        void populateNode() throws DevFailed {
            if (TreePanelDevice.this.domainFilterString.equals("*") && TreePanelDevice.this.familyFilterString.equals("*") && TreePanelDevice.this.memberFilterString.equals("*")) {
                String[] list = TreePanelDevice.this.db.get_device_domain(TreePanelDevice.this.domainFilterString);
                for (int i = 0; i < list.length; ++i) {
                    this.add(new DomainNode(list[i], this.parentPanel));
                }
            } else {
                String nameFilter = TreePanelDevice.this.domainFilterString + "/" + TreePanelDevice.this.familyFilterString + "/" + TreePanelDevice.this.memberFilterString;
                String nameFilterSQL = this.parentPanel.replaceWildcard(nameFilter);
                DeviceData argin = new DeviceData();
                String request = "select distinct domain from device where name LIKE '" + nameFilterSQL + "' order by domain";
                argin.insert(request);
                DeviceData argout = TreePanelDevice.this.db.command_inout("DbMySqlSelect", argin);
                DevVarLongStringArray arg = argout.extractLongStringArray();
                for (int i = 0; i < arg.svalue.length; ++i) {
                    this.add(new DomainNode(arg.svalue[i], this.parentPanel));
                }
            }
        }

        @Override
        public String toString() {
            return "Device:";
        }

        @Override
        void execAction(int number, boolean multipleCall) {
        }
    }

    class DeviceNode
    extends TangoNode {
        private String domain;
        private String family;
        private String member;
        private String devName;

        DeviceNode(String domain, String family, String member) {
            this.domain = domain;
            this.family = family;
            this.member = member;
            this.devName = this.domain + "/" + this.family + "/" + member;
        }

        @Override
        void populateNode() throws DevFailed {
            this.add(new TaskDevicePropertyNode(TreePanelDevice.this.self, TreePanelDevice.this.db, this.devName));
            this.add(new TaskPollingNode(TreePanelDevice.this.db, this.devName));
            this.add(new TaskEventNode(TreePanelDevice.this.db, this.devName));
            this.add(new TaskAttributeNode(TreePanelDevice.this.db, this.devName));
            this.add(new TaskPipeNode(TreePanelDevice.this.db, this.devName));
            this.add(new AttributeNode(TreePanelDevice.this.self, this.devName, TreePanelDevice.this.db));
            this.add(new TaskLoggingNode(TreePanelDevice.this.db, this.devName));
        }

        @Override
        public String toString() {
            return this.member;
        }

        @Override
        ImageIcon getIcon() {
            return TangoNodeRenderer.devicon;
        }

        @Override
        String getValue() {
            return TreePanelDevice.this.getDeviceInfo(this.devName);
        }

        @Override
        String getTitle() {
            return "Device Info";
        }

        @Override
        Action[] getAction() {
            if (JiveUtils.readOnly) {
                return new Action[]{TreePanel.getAction(10), TreePanel.getAction(11), TreePanel.getAction(16), TreePanel.getAction(17), TreePanel.getAction(45)};
            }
            return new Action[]{TreePanel.getAction(0), TreePanel.getAction(1), TreePanel.getAction(3), TreePanel.getAction(10), TreePanel.getAction(11), TreePanel.getAction(12), TreePanel.getAction(16), TreePanel.getAction(14), TreePanel.getAction(17), TreePanel.getAction(25), TreePanel.getAction(15), TreePanel.getAction(44), TreePanel.getAction(45)};
        }

        @Override
        void execAction(int actionNumber, boolean multipleCall) throws IOException {
            switch (actionNumber) {
                case 0: {
                    JiveUtils.the_clipboard.clear();
                    JiveUtils.copyDeviceProperties(TreePanelDevice.this.db, this.devName);
                    break;
                }
                case 1: {
                    TreePanelDevice.this.pasteDeviceProperty(TreePanelDevice.this.db, this.devName);
                    break;
                }
                case 3: {
                    if (multipleCall) {
                        try {
                            TreePanelDevice.this.db.delete_device(this.devName);
                            break;
                        }
                        catch (DevFailed e) {
                            throw new IOException(this.devName + ":" + e.errors[0].desc);
                        }
                    }
                    if (!TreePanelDevice.this.checkDeleteDevice(this.devName)) break;
                    try {
                        TreePanelDevice.this.db.delete_device(this.devName);
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                    }
                    TreePanelDevice.this.refresh();
                    break;
                }
                case 10: {
                    JiveUtils.launchAtkPanel(this.devName);
                    break;
                }
                case 11: {
                    TreePanelDevice.this.testDevice(this.devName);
                    break;
                }
                case 12: {
                    String alias = JOptionPane.showInputDialog(null, "Define device alias", "");
                    if (alias == null) {
                        return;
                    }
                    try {
                        JiveUtils.put_device_alias(TreePanelDevice.this.db, this.devName, alias);
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                    }
                    break;
                }
                case 16: {
                    try {
                        DbDevImportInfo info = TreePanelDevice.this.db.import_device(this.devName);
                        TreePanel.invoker.goToServerFullNode(info.server);
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                    }
                    break;
                }
                case 14: {
                    try {
                        DbDevImportInfo info = TreePanelDevice.this.db.import_device(this.devName);
                        DeviceProxy ds = new DeviceProxy("dserver/" + info.server);
                        DeviceData in = new DeviceData();
                        in.insert(this.devName);
                        ds.command_inout("DevRestart", in);
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                    }
                    break;
                }
                case 17: {
                    try {
                        DbDevImportInfo info = TreePanelDevice.this.db.import_device(this.devName);
                        TreePanelDevice.this.selectDevice("dserver/" + info.server);
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                    }
                    break;
                }
                case 25: {
                    TreePanelDevice.this.launchLogViewer(this.devName);
                    break;
                }
                case 15: {
                    try {
                        DbDevImportInfo info = TreePanelDevice.this.db.import_device(this.devName);
                        DevWizard dwdlg = new DevWizard(TreePanel.invoker);
                        String className = TreePanelDevice.this.db.get_class_for_device(this.devName);
                        dwdlg.showDeviceWizard(info.server, className, this.devName);
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                    }
                    break;
                }
                case 44: {
                    try {
                        DbFileWriter.SaveAllDeviceProperties(this.devName);
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                    }
                    catch (IOException e2) {
                        JiveUtils.showJiveError(e2.getMessage());
                    }
                    break;
                }
                case 45: {
                    TreePanelDevice.this.findUsage(this.devName);
                }
            }
        }
    }

    class FamilyNode
    extends TangoNode {
        private String domain;
        private String family;

        FamilyNode(String domain, String family, TreePanel parentPanel) {
            this.domain = domain;
            this.family = family;
            this.parentPanel = parentPanel;
        }

        @Override
        void populateNode() throws DevFailed {
            if (TreePanelDevice.this.domainFilterString.equals("*") && TreePanelDevice.this.familyFilterString.equals("*") && TreePanelDevice.this.memberFilterString.equals("*")) {
                String prefix = this.domain + "/" + this.family + "/";
                String[] list = TreePanelDevice.this.db.get_device_member(prefix + TreePanelDevice.this.memberFilterString);
                for (int i = 0; i < list.length; ++i) {
                    this.add(new DeviceNode(this.domain, this.family, list[i]));
                }
            } else {
                String nameFilter = this.domain + "/" + this.family + "/" + TreePanelDevice.this.memberFilterString;
                String nameFilterSQL = this.parentPanel.replaceWildcard(nameFilter);
                DeviceData argin = new DeviceData();
                String request = "select distinct member from device where name LIKE '" + nameFilterSQL + "' order by member";
                argin.insert(request);
                DeviceData argout = TreePanelDevice.this.db.command_inout("DbMySqlSelect", argin);
                DevVarLongStringArray arg = argout.extractLongStringArray();
                for (int i = 0; i < arg.svalue.length; ++i) {
                    this.add(new DeviceNode(this.domain, this.family, arg.svalue[i]));
                }
            }
        }

        @Override
        public String toString() {
            return this.family;
        }

        @Override
        Action[] getAction() {
            return new Action[]{TreePanel.getAction(20), TreePanel.getAction(21), TreePanel.getAction(22), TreePanel.getAction(23), TreePanel.getAction(24)};
        }

        @Override
        void execAction(int actionNumber, boolean multipleCall) {
            switch (actionNumber) {
                case 20: {
                    this.parentPanel.selectNodesFromFamily(this, "Properties");
                    break;
                }
                case 21: {
                    this.parentPanel.selectNodesFromFamily(this, "Polling");
                    break;
                }
                case 22: {
                    this.parentPanel.selectNodesFromFamily(this, "Event");
                    break;
                }
                case 23: {
                    this.parentPanel.selectNodesFromFamily(this, "Attribute config");
                    break;
                }
                case 24: {
                    this.parentPanel.selectNodesFromFamily(this, "Logging");
                }
            }
        }
    }

    class DomainNode
    extends TangoNode {
        private String domain;

        DomainNode(String domain, TreePanel parentPanel) {
            this.domain = domain;
            this.parentPanel = parentPanel;
        }

        @Override
        void populateNode() throws DevFailed {
            if (TreePanelDevice.this.domainFilterString.equals("*") && TreePanelDevice.this.familyFilterString.equals("*") && TreePanelDevice.this.memberFilterString.equals("*")) {
                String[] list = TreePanelDevice.this.db.get_device_family(this.domain + "/" + TreePanelDevice.this.familyFilterString);
                for (int i = 0; i < list.length; ++i) {
                    this.add(new FamilyNode(this.domain, list[i], this.parentPanel));
                }
            } else {
                String nameFilter = this.domain + "/" + TreePanelDevice.this.familyFilterString + "/" + TreePanelDevice.this.memberFilterString;
                String nameFilterSQL = this.parentPanel.replaceWildcard(nameFilter);
                DeviceData argin = new DeviceData();
                String request = "select distinct family from device where name LIKE '" + nameFilterSQL + "' order by family";
                argin.insert(request);
                DeviceData argout = TreePanelDevice.this.db.command_inout("DbMySqlSelect", argin);
                DevVarLongStringArray arg = argout.extractLongStringArray();
                for (int i = 0; i < arg.svalue.length; ++i) {
                    this.add(new FamilyNode(this.domain, arg.svalue[i], this.parentPanel));
                }
            }
        }

        @Override
        public String toString() {
            return this.domain;
        }

        @Override
        Action[] getAction() {
            return new Action[]{TreePanel.getAction(20), TreePanel.getAction(21), TreePanel.getAction(22), TreePanel.getAction(23), TreePanel.getAction(24)};
        }

        @Override
        void execAction(int actionNumber, boolean multipleCall) {
            switch (actionNumber) {
                case 20: {
                    this.parentPanel.selectNodesFromDomain(this, "Properties");
                    break;
                }
                case 21: {
                    this.parentPanel.selectNodesFromDomain(this, "Polling");
                    break;
                }
                case 22: {
                    this.parentPanel.selectNodesFromDomain(this, "Event");
                    break;
                }
                case 23: {
                    this.parentPanel.selectNodesFromDomain(this, "Attribute config");
                    break;
                }
                case 24: {
                    this.parentPanel.selectNodesFromDomain(this, "Logging");
                }
            }
        }
    }
}

