/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import JSSHTerminal.MainPanel;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevExportInfo;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DbServInfo;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.tree.TreePath;
import jive.DevWizard;
import jive.JiveUtils;
import jive.ServerDlg;
import jive3.Action;
import jive3.AttributeNode;
import jive3.IServerAction;
import jive3.ServerInfoDlg;
import jive3.StartServerDlg;
import jive3.TangoNode;
import jive3.TangoNodeRenderer;
import jive3.TaskAttributeNode;
import jive3.TaskDevicePropertyNode;
import jive3.TaskEventNode;
import jive3.TaskLoggingNode;
import jive3.TaskPipeNode;
import jive3.TaskPollingNode;
import jive3.TreePanel;

public class TreePanelHostCollection
extends TreePanel {
    public static int NB_LEVELS = 5;

    public TreePanelHostCollection() {
        this.self = this;
        this.setLayout(new BorderLayout());
    }

    @Override
    public TangoNode createRoot() {
        return new RootNode();
    }

    String getLevelStr(int level) {
        if (level == 0) {
            return "Not Controlled";
        }
        return "Level " + Integer.toString(level);
    }

    DevState[] getServerState(DeviceProxy starter, String[] serverNames) throws DevFailed {
        String[] list;
        DevState[] retStates = new DevState[serverNames.length];
        for (int i = 0; i < serverNames.length; ++i) {
            retStates[i] = DevState.UNKNOWN;
        }
        DeviceAttribute att = starter.read_attribute("Servers");
        for (String line : list = att.extractStringArray()) {
            StringTokenizer stk = new StringTokenizer(line);
            String name = stk.nextToken();
            String st = stk.nextToken();
            int idx = JiveUtils.isInsideArray(name, serverNames);
            if (idx < 0) continue;
            retStates[idx] = st.equalsIgnoreCase("FAULT") ? DevState.OFF : DevState.ON;
        }
        return retStates;
    }

    String getHostStateString(DevState state) {
        switch (state.value()) {
            case 0: {
                return "<font color=\"green\">All servers are running</font>";
            }
            case 1: {
                return "<font color=\"#A0A0A0\">All servers are stopped</font>";
            }
            case 11: {
                return "<font color=\"orange\">At least one of the servers is stopped</font>";
            }
            case 6: {
                return "<font color=\"blue\">At least one of the servers is not responding</font>";
            }
            case 8: {
                return "<font color=\"red\">FAULT</font>";
            }
        }
        return "<font color=\"red\">Not responding</font>";
    }

    String getServerStateString(DevState state) {
        if (state == DevState.OFF) {
            return "<font color=\"red\">Stopped</font>";
        }
        if (state == DevState.ON) {
            return "<font color=\"green\">Running</font>";
        }
        return "<font color=\"grey\">Unknown</font>";
    }

    boolean allServersOff(DevState[] allStates) {
        boolean off = true;
        for (int i = 0; off && i < allStates.length; ++i) {
            off = allStates[i] == DevState.OFF || allStates[i] == DevState.UNKNOWN;
        }
        return off;
    }

    public void stopServer(DeviceProxy starter, String serverName) throws DevFailed {
        this.stopServers(starter, new String[]{serverName});
    }

    public void stopServers(DeviceProxy starter, String[] serverNames) throws DevFailed {
        DevState[] srvState = this.getServerState(starter, serverNames);
        for (int i = 0; i < serverNames.length; ++i) {
            if (srvState[i] != DevState.ON) continue;
            DeviceData argin = new DeviceData();
            argin.insert(serverNames[i]);
            starter.command_inout("DevStop", argin);
        }
        if (!this.allServersOff(srvState)) {
            int nbTry = 5;
            while (!this.allServersOff(srvState) && nbTry > 0) {
                int ok;
                JiveUtils.sleep(1000L);
                srvState = this.getServerState(starter, serverNames);
                if (this.allServersOff(srvState) || --nbTry != 0 || (ok = JOptionPane.showConfirmDialog(null, "Some servers are still running.\nSend Hard kill ?", "Question", 0)) != 0) continue;
                for (int i = 0; i < serverNames.length; ++i) {
                    if (srvState[i] != DevState.ON) continue;
                    DeviceData argin = new DeviceData();
                    argin.insert(serverNames[i]);
                    starter.command_inout("HardKillServer", argin);
                }
                nbTry = 1;
            }
        }
    }

    public void startServer(DeviceProxy starter, String serverName) throws DevFailed {
        this.startServers(starter, new String[]{serverName});
    }

    public void startServers(DeviceProxy starter, String[] serverNames) throws DevFailed {
        for (int i = 0; i < serverNames.length; ++i) {
            DeviceData argin = new DeviceData();
            argin.insert(serverNames[i]);
            starter.command_inout("DevStart", argin);
        }
    }

    public TangoNode selectHost(String collection, String host) {
        TangoNode colNode = this.searchNode(this.root, collection);
        if (colNode == null) {
            return null;
        }
        TangoNode hostNode = this.searchNode(colNode, host);
        if (hostNode == null) {
            return null;
        }
        TreePath selPath = new TreePath(this.root);
        selPath = selPath.pathByAddingChild(colNode);
        selPath = selPath.pathByAddingChild(hostNode);
        this.tree.setSelectionPath(selPath);
        return hostNode;
    }

    public TangoNode selectServer(String collection, String host, int level, String server) {
        TangoNode colNode = this.searchNode(this.root, collection);
        if (colNode == null) {
            return null;
        }
        TangoNode hostNode = this.searchNode(colNode, host);
        if (hostNode == null) {
            return null;
        }
        TangoNode lvNode = this.searchNode(hostNode, this.getLevelStr(level));
        if (lvNode == null) {
            return null;
        }
        TangoNode srvNode = this.searchNode(lvNode, server);
        if (srvNode == null) {
            return null;
        }
        TreePath selPath = new TreePath(this.root);
        selPath = selPath.pathByAddingChild(colNode);
        selPath = selPath.pathByAddingChild(hostNode);
        selPath = selPath.pathByAddingChild(lvNode);
        selPath = selPath.pathByAddingChild(srvNode);
        this.tree.setSelectionPath(selPath);
        return srvNode;
    }

    public TangoNode selectClass(String collection, String host, int level, String server, String className) {
        TangoNode colNode = this.searchNode(this.root, collection);
        if (colNode == null) {
            return null;
        }
        TangoNode hostNode = this.searchNode(colNode, host);
        if (hostNode == null) {
            return null;
        }
        TangoNode lvNode = this.searchNode(hostNode, this.getLevelStr(level));
        if (lvNode == null) {
            return null;
        }
        TangoNode srvNode = this.searchNode(lvNode, server);
        if (srvNode == null) {
            return null;
        }
        TangoNode classNode = this.searchNode(srvNode, className);
        if (classNode == null) {
            return null;
        }
        TreePath selPath = new TreePath(this.root);
        selPath = selPath.pathByAddingChild(colNode);
        selPath = selPath.pathByAddingChild(hostNode);
        selPath = selPath.pathByAddingChild(lvNode);
        selPath = selPath.pathByAddingChild(srvNode);
        selPath = selPath.pathByAddingChild(classNode);
        this.tree.setSelectionPath(selPath);
        return classNode;
    }

    public TangoNode selectDevice(String collection, String host, int level, String server, String className, String devName) {
        TangoNode colNode = this.searchNode(this.root, collection);
        if (colNode == null) {
            return null;
        }
        TangoNode hostNode = this.searchNode(colNode, host);
        if (hostNode == null) {
            return null;
        }
        TangoNode lvNode = this.searchNode(hostNode, this.getLevelStr(level));
        if (lvNode == null) {
            return null;
        }
        TangoNode srvNode = this.searchNode(lvNode, server);
        if (srvNode == null) {
            return null;
        }
        TangoNode classNode = this.searchNode(srvNode, className);
        if (classNode == null) {
            return null;
        }
        TangoNode devNode = this.searchNode(classNode, devName);
        if (devNode == null) {
            return null;
        }
        TreePath selPath = new TreePath(this.root);
        selPath = selPath.pathByAddingChild(colNode);
        selPath = selPath.pathByAddingChild(hostNode);
        selPath = selPath.pathByAddingChild(lvNode);
        selPath = selPath.pathByAddingChild(srvNode);
        selPath = selPath.pathByAddingChild(classNode);
        selPath = selPath.pathByAddingChild(devNode);
        this.tree.setSelectionPath(selPath);
        return devNode;
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        TangoNode expanded = (TangoNode)event.getPath().getLastPathComponent();
        if (expanded instanceof HostNode) {
            for (int i = 0; i < expanded.getChildCount(); ++i) {
                TangoNode nd = (TangoNode)expanded.getChildAt(i);
                this.tree.expandPath(nd.getCompletePath());
            }
        }
    }

    class RootNode
    extends TangoNode {
        RootNode() {
        }

        @Override
        void populateNode() throws DevFailed {
            int i;
            DeviceData argin = new DeviceData();
            String request = "select distinct value from property_device where device like '" + JiveUtils.getStarterDeviceHeader() + "%' and name='HostCollection'";
            argin.insert(request);
            DeviceData argout = TreePanelHostCollection.this.db.command_inout("DbMySqlSelect", argin);
            DevVarLongStringArray arg = argout.extractLongStringArray();
            ArrayList<String> collection = new ArrayList<String>();
            ArrayList<String> lastCollection = new ArrayList<String>();
            String[] lastCols = new String[]{};
            DbDatum datum = TreePanelHostCollection.this.db.get_property("Astor", "LastCollections");
            if (!datum.is_empty()) {
                lastCols = datum.extractStringArray();
            }
            for (i = 0; i < arg.svalue.length; ++i) {
                if (JiveUtils.isInsideArray(arg.svalue[i], lastCols) < 0) {
                    collection.add(arg.svalue[i]);
                    continue;
                }
                lastCollection.add(arg.svalue[i]);
            }
            Collections.sort(collection);
            Collections.sort(lastCollection);
            collection.addAll(lastCollection);
            for (i = 0; i < collection.size(); ++i) {
                this.add(new CollectionNode((String)collection.get(i)));
            }
        }

        @Override
        public String toString() {
            return "Collection:";
        }

        @Override
        void execAction(int number, boolean allowMultiple) {
        }
    }

    class HostNode
    extends TangoNode {
        private String collection;
        private String host;
        private String hostUsage = "";
        private DeviceProxy starter = null;
        private String hostInfo = "";
        private String[] allHostServers;
        private String starterName;

        HostNode(String collection, String host) {
            this.host = host;
            this.collection = collection;
            this.allHostServers = new String[0];
            this.starterName = JiveUtils.getStarterDeviceHeader() + host;
            try {
                this.starter = new DeviceProxy(this.starterName);
                this.hostUsage = TreePanelHostCollection.this.db.get_device_property(this.starterName, "HostUsage").extractString();
            }
            catch (DevFailed e) {
                JiveUtils.showTangoError(e);
            }
            try {
                DeviceProxy hI = new DeviceProxy("host/info/" + host);
                String arch = hI.read_attribute("kernelVersion").extractString();
                String ht = hI.read_attribute("hostType").extractString();
                String os = hI.read_attribute("osDistribution").extractString();
                this.hostInfo = ht + " " + os + " (" + arch + ")";
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
        }

        @Override
        void populateNode() throws DevFailed {
            DeviceData argin = new DeviceData();
            argin.insert(this.host);
            DeviceData argout = TreePanelHostCollection.this.db.command_inout("DbGetHostServersInfo", argin);
            String[] arg = argout.extractStringArray();
            DbDatum da = TreePanelHostCollection.this.db.get_class_property("Starter", "NbStartupLevels");
            if (!da.is_empty()) {
                NB_LEVELS = da.extractLong();
            }
            Integer[] allLevels = new Integer[NB_LEVELS + 1];
            for (int i = 1; i <= NB_LEVELS; ++i) {
                allLevels[i - 1] = i;
            }
            allLevels[TreePanelHostCollection.NB_LEVELS] = 0;
            ArrayList<String> allHS = new ArrayList<String>();
            Integer[] integerArray = allLevels;
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int level = integerArray[i];
                ArrayList<String> servers = new ArrayList<String>();
                for (int i2 = 0; i2 < arg.length; i2 += 3) {
                    int l = 0;
                    try {
                        l = Integer.parseInt(arg[i2 + 2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (l == level && !arg[i2].toLowerCase().contains("starter")) {
                        servers.add(arg[i2]);
                    }
                    if (l <= 0 || arg[i2].toLowerCase().contains("starter")) continue;
                    allHS.add(arg[i2]);
                }
                if (servers.size() <= 0) continue;
                this.add(new LevelNode(this.collection, this.host, level, servers));
            }
            this.allHostServers = new String[allHS.size()];
            for (int i = 0; i < allHS.size(); ++i) {
                this.allHostServers[i] = (String)allHS.get(i);
            }
        }

        String getState() {
            try {
                DeviceData dd = this.starter.command_inout("State");
                return this.host + ": " + TreePanelHostCollection.this.getHostStateString(dd.extractDevState());
            }
            catch (DevFailed e) {
                return this.host + ": " + TreePanelHostCollection.this.getHostStateString(DevState.UNKNOWN);
            }
        }

        @Override
        public String getValue() {
            StringBuffer result = new StringBuffer();
            if (this.hostInfo.length() > 0) {
                result.append("<b>");
                result.append(this.hostInfo);
                result.append("</b>\n\n");
            }
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                LevelNode l = (LevelNode)this.getChildAt(i);
                result.append("<b>" + l.toString() + "</b>\n");
                result.append("<hr>\n");
                result.append(l.getValue(true));
                result.append("\n");
            }
            return result.toString();
        }

        @Override
        public String getDisplayValue() {
            if (this.hostUsage.length() > 0) {
                return this.toString() + " (" + this.hostUsage + ")";
            }
            return this.toString();
        }

        @Override
        public String toString() {
            return this.host;
        }

        @Override
        ImageIcon getIcon() {
            return TangoNodeRenderer.hostsmallicon;
        }

        @Override
        Action[] getAction() {
            return new Action[]{TreePanel.getAction(36), TreePanel.getAction(37), TreePanel.getAction(38), TreePanel.getAction(39), TreePanel.getAction(42), TreePanel.getAction(41), TreePanel.getAction(46)};
        }

        @Override
        void execAction(int actionNumber, boolean multipleCall) {
            switch (actionNumber) {
                case 36: {
                    int ok = JOptionPane.showConfirmDialog(TreePanel.invoker, "Start all servers on " + this.host + " ?", "Confirmation", 0);
                    if (ok != 0) break;
                    try {
                        TreePanelHostCollection.this.startServers(this.starter, this.allHostServers);
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                    }
                    break;
                }
                case 37: {
                    int ok = JOptionPane.showConfirmDialog(TreePanel.invoker, "Stop all servers on " + this.host + "?", "Confirmation", 0);
                    if (ok != 0) break;
                    try {
                        TreePanelHostCollection.this.stopServers(this.starter, this.allHostServers);
                        TreePanelHostCollection.this.refreshValues();
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                    }
                    break;
                }
                case 38: {
                    String newUsage = JOptionPane.showInputDialog(TreePanel.invoker, "Host Usage", this.hostUsage);
                    if (newUsage == null) break;
                    try {
                        DbDatum datum = new DbDatum("HostUsage", newUsage);
                        TreePanelHostCollection.this.db.put_device_property(this.starterName, new DbDatum[]{datum});
                        TreePanelHostCollection.this.refresh();
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                    }
                    break;
                }
                case 39: {
                    TreePanel.invoker.goToServerNode("Starter/" + this.host);
                    break;
                }
                case 42: {
                    StartServerDlg dlg = new StartServerDlg(TreePanelHostCollection.this.db, this.host, this.starter, TreePanel.invoker);
                    try {
                        dlg.setServerList(TreePanelHostCollection.this.db.get_server_list());
                        ATKGraphicsUtils.centerFrameOnScreen((Frame)dlg);
                        dlg.setVisible(true);
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                    }
                    break;
                }
                case 41: {
                    String defaultUser = null;
                    String defaultPassword = null;
                    try {
                        DbDatum dd = TreePanelHostCollection.this.db.get_property("Astor", "RloginUser");
                        if (!dd.is_empty()) {
                            defaultUser = dd.extractString();
                        }
                        if (!(dd = TreePanelHostCollection.this.db.get_property("Astor", "RloginPassword")).is_empty()) {
                            defaultPassword = dd.extractString();
                        }
                    }
                    catch (DevFailed dd) {
                        // empty catch block
                    }
                    if (defaultUser != null) {
                        MainPanel terminal = new MainPanel(this.host, defaultUser, defaultPassword, 80, 24, 500);
                        terminal.setX11Forwarding(true);
                        terminal.setExitOnClose(false);
                        ATKGraphicsUtils.centerFrameOnScreen((Frame)terminal);
                        terminal.setVisible(true);
                        break;
                    }
                    JiveUtils.showJiveError("No username !\nAStor/RloginUser free property not defined.");
                    break;
                }
                case 46: {
                    try {
                        DeviceData argin = new DeviceData();
                        argin.insert(this.host);
                        DeviceData argout = TreePanelHostCollection.this.db.command_inout("DbGetHostServersInfo", argin);
                        String[] arg = argout.extractStringArray();
                        int ok = JOptionPane.showConfirmDialog(TreePanel.invoker, "Unexport all devices on " + this.host + " (" + arg.length / 3 + " servers)?", "Confirmation", 0);
                        if (ok != 0) break;
                        for (int i = 0; i < arg.length; i += 3) {
                            String srvName = arg[i];
                            TreePanelHostCollection.this.db.unexport_server(srvName);
                        }
                        TreePanelHostCollection.this.refreshValues();
                        break;
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                    }
                }
            }
        }
    }

    class DeviceServerNode
    extends TangoNode {
        private String collection;
        private String host;
        private int level;
        private String server;
        private String className;
        private String devName;

        DeviceServerNode(String collection, String host, int level, String server, String className, String devName) {
            this.collection = collection;
            this.host = host;
            this.level = level;
            this.server = server;
            this.className = className;
            this.devName = devName;
        }

        @Override
        void populateNode() throws DevFailed {
            this.add(new TaskDevicePropertyNode(TreePanelHostCollection.this.self, TreePanelHostCollection.this.db, this.devName));
            this.add(new TaskPollingNode(TreePanelHostCollection.this.db, this.devName));
            this.add(new TaskEventNode(TreePanelHostCollection.this.db, this.devName));
            this.add(new TaskAttributeNode(TreePanelHostCollection.this.db, this.devName));
            this.add(new TaskPipeNode(TreePanelHostCollection.this.db, this.devName));
            this.add(new AttributeNode(TreePanelHostCollection.this.self, this.devName, TreePanelHostCollection.this.db));
            this.add(new TaskLoggingNode(TreePanelHostCollection.this.db, this.devName));
        }

        @Override
        public String toString() {
            return this.devName;
        }

        @Override
        ImageIcon getIcon() {
            return TangoNodeRenderer.devicon;
        }

        @Override
        String getValue() {
            return TreePanelHostCollection.this.getDeviceInfo(this.devName);
        }

        @Override
        String getTitle() {
            return "Device Info";
        }

        @Override
        Action[] getAction() {
            if (JiveUtils.readOnly) {
                return new Action[]{TreePanel.getAction(10), TreePanel.getAction(11), TreePanel.getAction(13)};
            }
            return new Action[]{TreePanel.getAction(0), TreePanel.getAction(1), TreePanel.getAction(2), TreePanel.getAction(3), TreePanel.getAction(10), TreePanel.getAction(11), TreePanel.getAction(12), TreePanel.getAction(13), TreePanel.getAction(14), TreePanel.getAction(15), TreePanel.getAction(25)};
        }

        @Override
        void execAction(int actionNumber, boolean multipleCall) throws IOException {
            switch (actionNumber) {
                case 0: {
                    JiveUtils.the_clipboard.clear();
                    JiveUtils.copyDeviceProperties(TreePanelHostCollection.this.db, this.devName);
                    break;
                }
                case 1: {
                    TreePanelHostCollection.this.pasteDeviceProperty(TreePanelHostCollection.this.db, this.devName);
                    break;
                }
                case 2: {
                    String newName = JOptionPane.showInputDialog(null, "Rename device", this.devName);
                    if (newName == null) {
                        return;
                    }
                    if (!this.renameDevice(newName)) break;
                    TreePanelHostCollection.this.refresh();
                    TreePanelHostCollection.this.selectDevice(this.collection, this.host, this.level, this.server, this.className, newName);
                    break;
                }
                case 3: {
                    if (multipleCall) {
                        try {
                            TreePanelHostCollection.this.db.delete_device(this.devName);
                            break;
                        }
                        catch (DevFailed e) {
                            throw new IOException(this.devName + ":" + e.errors[0].desc);
                        }
                    }
                    if (!TreePanelHostCollection.this.checkDeleteDevice(this.devName)) break;
                    try {
                        TreePanelHostCollection.this.db.delete_device(this.devName);
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                    }
                    TreePanelHostCollection.this.refresh();
                    break;
                }
                case 10: {
                    JiveUtils.launchAtkPanel(this.devName);
                    break;
                }
                case 11: {
                    TreePanelHostCollection.this.testDevice(this.devName);
                    break;
                }
                case 12: {
                    String alias = JOptionPane.showInputDialog(null, "Define device alias", "");
                    if (alias == null) {
                        return;
                    }
                    try {
                        JiveUtils.put_device_alias(TreePanelHostCollection.this.db, this.devName, alias);
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                    }
                    break;
                }
                case 13: {
                    TreePanel.invoker.goToDeviceNode(this.devName);
                    break;
                }
                case 14: {
                    try {
                        DeviceProxy ds = new DeviceProxy("dserver/" + this.server);
                        DeviceData in = new DeviceData();
                        in.insert(this.devName);
                        ds.command_inout("DevRestart", in);
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                    }
                    break;
                }
                case 15: {
                    DevWizard dwdlg = new DevWizard(TreePanel.invoker);
                    dwdlg.showDeviceWizard(this.server, this.className, this.devName);
                    break;
                }
                case 25: {
                    TreePanelHostCollection.this.launchLogViewer(this.devName);
                }
            }
        }

        boolean renameDevice(String nDevName) {
            boolean isAlive = false;
            boolean success = false;
            try {
                DbDevImportInfo ii = TreePanelHostCollection.this.db.import_device(nDevName);
                JiveUtils.showJiveError("The device " + nDevName + " already exits.\nServer: " + ii.server);
            }
            catch (DevFailed e1) {
                try {
                    TreePanelHostCollection.this.db.add_device(nDevName, this.className, this.server);
                    success = true;
                    DeviceProxy ds = null;
                    try {
                        ds = new DeviceProxy(this.devName);
                        ds.ping();
                        isAlive = true;
                    }
                    catch (DevFailed devFailed) {
                        // empty catch block
                    }
                    int ok = JOptionPane.showConfirmDialog(TreePanel.invoker, "Do you want to copy properties of " + this.devName + " to " + nDevName + " ?", "Confirm property move", 0);
                    if (ok == 0) {
                        String[] propList = TreePanelHostCollection.this.db.get_device_property_list(this.devName, "*");
                        if (propList.length > 0) {
                            DbDatum[] data = TreePanelHostCollection.this.db.get_device_property(this.devName, propList);
                            TreePanelHostCollection.this.db.put_device_property(nDevName, data);
                        }
                        try {
                            String[] attList = TreePanelHostCollection.this.db.get_device_attribute_list(this.devName);
                            if (attList.length > 0) {
                                DbAttribute[] adata = TreePanelHostCollection.this.db.get_device_attribute_property(this.devName, attList);
                                TreePanelHostCollection.this.db.put_device_attribute_property(nDevName, adata);
                            }
                        }
                        catch (DevFailed e3) {
                            JiveUtils.showJiveError("Failed to copy attribute properties of " + this.devName + "\n" + e3.errors[0].desc);
                        }
                    }
                    if (isAlive) {
                        JiveUtils.showJiveWarning("The old device " + this.devName + " is still alive and should be removed by hand.");
                    } else {
                        TreePanelHostCollection.this.db.delete_device(this.devName);
                    }
                }
                catch (DevFailed e4) {
                    JiveUtils.showTangoError(e4);
                }
            }
            return success;
        }
    }

    class ClassNode
    extends TangoNode
    implements IServerAction {
        private String collection;
        private String host;
        private int level;
        private String server;
        private String className;
        private String[] devList = new String[0];

        ClassNode(String collection, String host, int level, String server, String className) {
            this.collection = collection;
            this.host = host;
            this.level = level;
            this.server = server;
            this.className = className;
            try {
                this.devList = TreePanelHostCollection.this.db.get_device_name(server, className);
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
        }

        @Override
        void populateNode() throws DevFailed {
            for (int i = 0; i < this.devList.length; ++i) {
                this.add(new DeviceServerNode(this.collection, this.host, this.level, this.server, this.className, this.devList[i]));
            }
        }

        @Override
        public boolean isLeaf() {
            return this.devList.length == 0;
        }

        @Override
        ImageIcon getIcon() {
            if (this.devList.length == 0) {
                return TangoNodeRenderer.uclassicon;
            }
            return TangoNodeRenderer.classicon;
        }

        @Override
        public String toString() {
            return this.className;
        }

        @Override
        Action[] getAction() {
            if (JiveUtils.readOnly) {
                return new Action[0];
            }
            return new Action[]{TreePanel.getAction(2), TreePanel.getAction(3), TreePanel.getAction(8), TreePanel.getAction(9)};
        }

        @Override
        void execAction(int actionNumber, boolean multipleCall) throws IOException {
            switch (actionNumber) {
                case 2: {
                    String newName = JOptionPane.showInputDialog(null, "Rename class", this.className);
                    if (newName == null) {
                        return;
                    }
                    if (TreePanelHostCollection.this.searchNode((TangoNode)this.getParent(), newName) != null) {
                        JiveUtils.showJiveError("Name already exists.");
                        return;
                    }
                    for (int i = 0; i < this.getChildCount(); ++i) {
                        TangoNode n0 = (TangoNode)this.getChildAt(i);
                        try {
                            TreePanelHostCollection.this.db.add_device(n0.toString(), newName, this.server);
                            continue;
                        }
                        catch (DevFailed e) {
                            JiveUtils.showTangoError(e);
                        }
                    }
                    TreePanelHostCollection.this.refresh();
                    TreePanelHostCollection.this.selectClass(this.collection, this.host, this.level, this.server, newName);
                    break;
                }
                case 3: {
                    if (multipleCall) {
                        for (int i = 0; i < this.getChildCount(); ++i) {
                            TangoNode n0 = (TangoNode)this.getChildAt(i);
                            try {
                                TreePanelHostCollection.this.db.delete_device(n0.toString());
                                continue;
                            }
                            catch (DevFailed e) {
                                throw new IOException(n0.toString() + ":" + e.errors[0].desc);
                            }
                        }
                        break;
                    }
                    int ok = JOptionPane.showConfirmDialog(TreePanel.invoker, "Delete class " + this.className + " ?", "Confirm delete", 0);
                    if (ok != 0) break;
                    for (int i = 0; i < this.getChildCount(); ++i) {
                        TangoNode n0 = (TangoNode)this.getChildAt(i);
                        try {
                            TreePanelHostCollection.this.db.delete_device(n0.toString());
                            continue;
                        }
                        catch (DevFailed e) {
                            JiveUtils.showTangoError(e);
                        }
                    }
                    TreePanelHostCollection.this.refresh();
                    TreePanelHostCollection.this.selectServer(this.collection, this.host, this.level, this.server);
                    break;
                }
                case 8: {
                    ServerDlg sdlg = new ServerDlg(this);
                    sdlg.setValidFields(false, false);
                    sdlg.setDefaults(this.server, this.className);
                    ATKGraphicsUtils.centerFrame((JComponent)TreePanel.invoker.innerPanel, (Frame)sdlg);
                    sdlg.setVisible(true);
                    break;
                }
                case 9: {
                    DevWizard dswdlg = new DevWizard(TreePanel.invoker);
                    dswdlg.showDevicesWizard(this.server, this.className);
                    TreePanelHostCollection.this.refresh();
                }
            }
        }

        @Override
        public void doJob(String server, String classname, String[] devices) {
            try {
                for (int i = 0; i < devices.length; ++i) {
                    TreePanelHostCollection.this.db.add_device(devices[i], classname, server);
                }
            }
            catch (DevFailed e) {
                JiveUtils.showTangoError(e);
            }
            TreePanelHostCollection.this.refresh();
            TreePanelHostCollection.this.selectClass(this.collection, this.host, this.level, server, classname);
        }
    }

    class ServerNode
    extends TangoNode
    implements IServerAction {
        private String collection;
        private String host;
        private int level;
        private String server;

        ServerNode(String collection, String host, int level, String server) {
            this.server = server;
            this.host = host;
            this.level = level;
            this.collection = collection;
        }

        DeviceProxy getStarter() {
            return ((LevelNode)this.getParent()).getStarter();
        }

        @Override
        void populateNode() throws DevFailed {
            String[] srvList = null;
            String[] dbList = null;
            try {
                String admName = "dserver/" + this.server;
                DeviceProxy adm = new DeviceProxy(admName);
                DeviceData datum = adm.command_inout("QueryClass");
                srvList = datum.extractStringArray();
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
            dbList = TreePanelHostCollection.this.db.get_server_class_list(this.server);
            if (srvList != null) {
                int i;
                for (i = 0; i < srvList.length; ++i) {
                    this.add(new ClassNode(this.collection, this.host, this.level, this.server, srvList[i]));
                }
                for (i = 0; i < dbList.length; ++i) {
                    if (JiveUtils.contains(srvList, dbList[i])) continue;
                    this.add(new ClassNode(this.collection, this.host, this.level, this.server, dbList[i]));
                }
            } else {
                for (int i = 0; i < dbList.length; ++i) {
                    this.add(new ClassNode(this.collection, this.host, this.level, this.server, dbList[i]));
                }
            }
        }

        @Override
        String getTitle() {
            return "Server Info";
        }

        @Override
        public String toString() {
            return this.server;
        }

        @Override
        ImageIcon getIcon() {
            return TangoNodeRenderer.srvicon;
        }

        DevState getState() throws DevFailed {
            return TreePanelHostCollection.this.getServerState(this.getStarter(), new String[]{this.server})[0];
        }

        @Override
        String getValue() {
            Object result = "";
            if (this.getStarter() == null) {
                return result;
            }
            try {
                DevState serverState = this.getState();
                result = this.server + ": " + TreePanelHostCollection.this.getServerStateString(serverState) + "\n";
                result = (String)result + "-- Log ------------------------------\n";
                DeviceData argin = new DeviceData();
                argin.insert(this.server);
                DeviceData argout = this.getStarter().command_inout("DevReadLog", argin);
                result = (String)result + argout.extractString();
            }
            catch (DevFailed e) {
                for (int i = 0; i < e.errors.length; ++i) {
                    result = (String)result + "Desc -> " + e.errors[i].desc + "\n";
                    result = (String)result + "Reason -> " + e.errors[i].reason + "\n";
                    result = (String)result + "Origin -> " + e.errors[i].origin + "\n";
                }
            }
            return result;
        }

        @Override
        Action[] getAction() {
            if (JiveUtils.readOnly) {
                return new Action[0];
            }
            return new Action[]{TreePanel.getAction(3), TreePanel.getAction(4), TreePanel.getAction(5), TreePanel.getAction(6), TreePanel.getAction(7), TreePanel.getAction(19), TreePanel.getAction(26), TreePanel.getAction(27), TreePanel.getAction(29), TreePanel.getAction(33), TreePanel.getAction(31), TreePanel.getAction(32), TreePanel.getAction(40)};
        }

        @Override
        void execAction(int actionNumber, boolean multipleCall) throws IOException {
            switch (actionNumber) {
                case 3: {
                    if (multipleCall) {
                        try {
                            TreePanelHostCollection.this.db.delete_server(this.server);
                            break;
                        }
                        catch (DevFailed e) {
                            throw new IOException(this.server + ":" + e.errors[0].desc);
                        }
                    }
                    int ok = JOptionPane.showConfirmDialog(TreePanel.invoker, "Delete server " + this.server + " ?", "Confirm delete", 0);
                    if (ok != 0) break;
                    try {
                        TreePanelHostCollection.this.db.delete_server(this.server);
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                    }
                    TreePanelHostCollection.this.refresh();
                    TreePanelHostCollection.this.selectHost(this.collection, this.host);
                    break;
                }
                case 4: {
                    ServerDlg sdlg = new ServerDlg(this);
                    sdlg.setClassList(TreePanel.invoker.getClassTreePanel().getClassList());
                    sdlg.setValidFields(false, true);
                    sdlg.setDefaults(this.server, "");
                    ATKGraphicsUtils.centerFrame((JComponent)TreePanel.invoker.innerPanel, (Frame)sdlg);
                    sdlg.setVisible(true);
                    break;
                }
                case 5: {
                    TreePanelHostCollection.this.testDevice("dserver/" + this.server);
                    break;
                }
                case 6: {
                    if (multipleCall) {
                        TreePanelHostCollection.this.saveServerData(TreePanel.globalResFile, this.server);
                        break;
                    }
                    File file = TreePanel.getSaveFile(TreePanel.invoker);
                    if (file == null) break;
                    try {
                        FileWriter resFile = new FileWriter(file.getAbsolutePath());
                        Date date = new Date(System.currentTimeMillis());
                        resFile.write("#\n# Resource backup , created " + date + "\n#\n\n");
                        TreePanelHostCollection.this.saveServerData(resFile, this.server);
                        resFile.close();
                    }
                    catch (IOException e) {
                        JiveUtils.showJiveError("Failed to create resource file !\n" + e.getMessage());
                    }
                    break;
                }
                case 7: {
                    DevWizard cwdlg = new DevWizard(TreePanel.invoker);
                    cwdlg.showClassesWizard(this.server);
                    TreePanelHostCollection.this.refresh();
                    break;
                }
                case 19: {
                    int ok = JOptionPane.showConfirmDialog(TreePanel.invoker, "This will unexport all devices of " + this.server + "\n Do you want to continue ?", "Confirm unexport device", 0);
                    if (ok != 0) break;
                    try {
                        TreePanelHostCollection.this.db.unexport_server(this.server);
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                    }
                    break;
                }
                case 26: {
                    TreePanelHostCollection.this.launchDevDepend(this.server);
                    break;
                }
                case 27: {
                    TreePanelHostCollection.this.launchPollingThreadsManager(this.server);
                    break;
                }
                case 29: {
                    String newSName = JOptionPane.showInputDialog(null, "Rename server", this.server);
                    if (newSName == null) {
                        return;
                    }
                    try {
                        TreePanelHostCollection.this.db.rename_server(this.server, newSName);
                        TreePanelHostCollection.this.refresh();
                        TreePanelHostCollection.this.selectServer(this.collection, this.host, this.level, newSName);
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                    }
                    break;
                }
                case 33: {
                    try {
                        if (this.getStarter() == null) break;
                        TreePanelHostCollection.this.stopServer(this.getStarter(), this.server);
                        TreePanelHostCollection.this.startServer(this.getStarter(), this.server);
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                    }
                    break;
                }
                case 31: {
                    try {
                        if (this.getStarter() == null) break;
                        TreePanelHostCollection.this.startServer(this.getStarter(), this.server);
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                    }
                    break;
                }
                case 32: {
                    try {
                        if (this.getStarter() != null) {
                            TreePanelHostCollection.this.stopServer(this.getStarter(), this.server);
                        }
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                    }
                    TreePanelHostCollection.this.refreshValues();
                    break;
                }
                case 40: {
                    DbServer dbs;
                    DbServInfo info = null;
                    try {
                        dbs = new DbServer(this.server);
                        info = dbs.get_info();
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                        return;
                    }
                    ServerInfoDlg dlg = new ServerInfoDlg(TreePanel.invoker);
                    if (dlg.showDialog(info) != 0) break;
                    try {
                        info = dlg.getSelection();
                        if (info != null) {
                            info.host = this.host;
                            if (info.startup_level == 0) {
                                info.controlled = false;
                            }
                            dbs.put_info(info);
                            TreePanelHostCollection.this.refresh();
                            TreePanelHostCollection.this.selectServer(this.collection, this.host, info.startup_level, this.server);
                            break;
                        }
                        if (this.getState() == DevState.ON) {
                            JiveUtils.showJiveError("Stop " + this.server + "  Server before !");
                            return;
                        }
                        dbs.put_info(new DbServInfo(this.server, this.host, false, 0));
                        String[] deviceName = dbs.get_device_class_list();
                        for (int i = 0; i < deviceName.length; i += 2) {
                            TreePanelHostCollection.this.db.export_device(new DbDevExportInfo(deviceName[i], "", "", ""));
                            TreePanelHostCollection.this.db.unexport_device(deviceName[i]);
                        }
                        TreePanelHostCollection.this.refresh();
                        TreePanelHostCollection.this.selectHost(this.collection, this.host);
                        break;
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                    }
                }
            }
        }

        @Override
        public void doJob(String server, String classname, String[] devices) {
            try {
                for (int i = 0; i < devices.length; ++i) {
                    TreePanelHostCollection.this.db.add_device(devices[i], classname, server);
                }
            }
            catch (DevFailed e) {
                JiveUtils.showTangoError(e);
            }
            TreePanelHostCollection.this.refresh();
            TreePanelHostCollection.this.selectClass(this.collection, this.host, this.level, server, classname);
        }
    }

    class LevelNode
    extends TangoNode {
        private String collection;
        private String host;
        private int level;
        private String[] allServers;

        LevelNode(String collection, String host, int level, ArrayList<String> servers) {
            this.host = host;
            this.collection = collection;
            this.level = level;
            this.allServers = new String[servers.size()];
            for (int i = 0; i < servers.size(); ++i) {
                this.add(new ServerNode(collection, host, level, servers.get(i)));
                this.allServers[i] = servers.get(i);
            }
        }

        @Override
        void populateNode() throws DevFailed {
        }

        DeviceProxy getStarter() {
            return ((HostNode)this.getParent()).starter;
        }

        @Override
        public String toString() {
            return TreePanelHostCollection.this.getLevelStr(this.level);
        }

        @Override
        public String getTitle() {
            return this.host + " - " + this.toString();
        }

        String getValue(boolean tab) {
            String bStr = "";
            if (tab) {
                bStr = "   ";
            }
            Object result = "";
            if (this.getStarter() == null) {
                return result;
            }
            try {
                DevState[] allStates = TreePanelHostCollection.this.getServerState(this.getStarter(), this.allServers);
                for (int i = 0; i < this.allServers.length; ++i) {
                    result = (String)result + bStr + this.allServers[i] + ": " + TreePanelHostCollection.this.getServerStateString(allStates[i]) + "\n";
                }
            }
            catch (DevFailed e) {
                for (int i = 0; i < e.errors.length; ++i) {
                    result = (String)result + bStr + "Desc -> " + e.errors[i].desc + "\n";
                    result = (String)result + bStr + "Reason -> " + e.errors[i].reason + "\n";
                    result = (String)result + bStr + "Origin -> " + e.errors[i].origin + "\n";
                }
            }
            return result;
        }

        @Override
        String getValue() {
            return this.getValue(false);
        }

        @Override
        ImageIcon getIcon() {
            return TangoNodeRenderer.levelicon;
        }

        @Override
        Action[] getAction() {
            return new Action[]{TreePanel.getAction(34), TreePanel.getAction(35)};
        }

        @Override
        void execAction(int actionNumber, boolean multipleCall) {
            switch (actionNumber) {
                case 34: {
                    int ok = JOptionPane.showConfirmDialog(TreePanel.invoker, "Start level " + this.level + " on " + this.host + " ?", "Confirmation", 0);
                    if (ok != 0) break;
                    try {
                        TreePanelHostCollection.this.startServers(this.getStarter(), this.allServers);
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                    }
                    break;
                }
                case 35: {
                    int ok = JOptionPane.showConfirmDialog(TreePanel.invoker, "Stop level " + this.level + " on " + this.host + "?", "Confirmation", 0);
                    if (ok != 0) break;
                    try {
                        TreePanelHostCollection.this.stopServers(this.getStarter(), this.allServers);
                        TreePanelHostCollection.this.refreshValues();
                        break;
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                    }
                }
            }
        }
    }

    class CollectionNode
    extends TangoNode {
        private String collection;

        CollectionNode(String collection) {
            this.collection = collection;
        }

        @Override
        void populateNode() throws DevFailed {
            DeviceData argin = new DeviceData();
            String request = "select distinct device from property_device where device like '" + JiveUtils.getStarterDeviceHeader() + "%' and name='HostCollection' and value='" + this.collection + "'";
            argin.insert(request);
            DeviceData argout = TreePanelHostCollection.this.db.command_inout("DbMySqlSelect", argin);
            DevVarLongStringArray arg = argout.extractLongStringArray();
            for (int i = 0; i < arg.svalue.length; ++i) {
                String s = arg.svalue[i];
                this.add(new HostNode(this.collection, s.substring(s.lastIndexOf(47) + 1)));
            }
        }

        @Override
        public String getValue() {
            StringBuffer retStr = new StringBuffer();
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                HostNode n = (HostNode)this.getChildAt(i);
                retStr.append(n.getState());
                retStr.append("\n");
            }
            return retStr.toString();
        }

        @Override
        public String toString() {
            return this.collection;
        }

        @Override
        public String getTitle() {
            return this.collection;
        }

        @Override
        ImageIcon getIcon() {
            return TangoNodeRenderer.hostcollectionicon;
        }

        @Override
        void execAction(int number, boolean multipleCall) {
        }
    }
}

