/*
 *  Copyright (C) :	2002,2003,2004,2005,2006,2007,2008,2009
 *			European Synchrotron Radiation Facility
 *			BP 220, Grenoble 38043
 *			FRANCE
 * 
 *  This file is part of Tango.
 * 
 *  Tango is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  Tango is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *  
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Tango.  If not, see <http://www.gnu.org/licenses/>.
 */
 
/*
 * CommandOutput.java
 *
 * Created on January 16, 2002, 4:52 PM
 */

package fr.esrf.tangoatk.widget.command;
import java.util.*;
/**
 *
 * @author  root
 */
public class CommandOutput extends javax.swing.JPanel {
    
    /** Creates new form CommandOutput */
    public CommandOutput() {
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
          jScrollPane1 = new javax.swing.JScrollPane();
          jTextArea1 = new javax.swing.JTextArea();
          
          setLayout(new java.awt.GridBagLayout());
          java.awt.GridBagConstraints gridBagConstraints1;
          
          jScrollPane1.setVerticalScrollBarPolicy(javax.swing.JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
          jTextArea1.setBackground(new java.awt.Color(204, 204, 204));
          jTextArea1.setColumns(40);
          jTextArea1.setEditable(false);
          jTextArea1.setRows(10);
          jScrollPane1.setViewportView(jTextArea1);
          
          gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints1.weightx = 0.1;
        gridBagConstraints1.weighty = 0.1;
        add(jScrollPane1, gridBagConstraints1);
        
    }//GEN-END:initComponents

    public void setResult(String result) {
	jTextArea1.setText(result);
    }
	
    public void setResult(java.util.List result)
    {
	jTextArea1.setText("");
	if (result == null) return;
	if (result.size() < 1) return;
	
	if (result.get(0) instanceof List) // table results like Tango_DEVVAR_DOUBLESTRINGARRAY or Tango_DEVVAR_LONGSTRINGARRAY
	   setTableResult(result);
	else //not table results (scalars or arrays)
	{
	   for (Iterator i = result.iterator(); i.hasNext();)
	   {
	       jTextArea1.append((String)i.next());
	       jTextArea1.append("\n");
	   } // end of for ()
        }
    }
    
    public void setTableResult(java.util.List result)
    {
	jTextArea1.setText("");
	if (result == null) return;
	if (result.size() != 2) return;
	if (!(result.get(0) instanceof List))
	   return;
	if (!(result.get(1) instanceof List))
	   return;
	   
	List  res1 = (List) result.get(0);
	List  res2 = (List) result.get(1);
	int   res1size = res1.size();
	int   res2size = res2.size();

        for (int i=0; i<res1size; i++)
	{
	    jTextArea1.append(res1.get(i).toString());
	    if (i < res2size)
	       jTextArea1.append(", "+ res2.get(i).toString());
	    jTextArea1.append("\n");
	}
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextArea jTextArea1;
    // End of variables declaration//GEN-END:variables
    
}
