/*
 *  Copyright (C) :	2002,2003,2004,2005,2006,2007,2008,2009
 *			European Synchrotron Radiation Facility
 *			BP 220, Grenoble 38043
 *			FRANCE
 * 
 *  This file is part of Tango.
 * 
 *  Tango is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  Tango is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *  
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Tango.  If not, see <http://www.gnu.org/licenses/>.
 */
 

package fr.esrf.tangoatk.widget.command;
import fr.esrf.tangoatk.core.*;

/**
 *
 * @author  root
 */
public class PropertyFrame extends javax.swing.JFrame {
    IEntity model;
    boolean added = false;
    /** Creates new form AttributePropertyFrame */
    public PropertyFrame() {
        initComponents();
    }

    public void setEditable(boolean b) {
        propertyListViewer1.setEditable(b);
    }
    
    public boolean isEditable() {
         return propertyListViewer1.isEditable();
    }

    public void setModel(ICommand m) {
	model = m;
	propertyListViewer1.setModel(model.getPropertyMap());
	jTabbedPane2.remove(setPanel);
    }


    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
            closeButton = new javax.swing.JButton();
            jTabbedPane2 = new javax.swing.JTabbedPane();
            jScrollPane1 = new javax.swing.JScrollPane();
            propertyListViewer1 = new fr.esrf.tangoatk.widget.properties.PropertyListViewer2();
            setPanel = new javax.swing.JPanel();
            //value = new fr.esrf.tangoatk.widget.attribute.AScalarViewer();
            optionPanel = new javax.swing.JPanel();
            trendButton = new javax.swing.JButton();
            addTrendButton = new javax.swing.JButton();
            
            getContentPane().setLayout(new java.awt.GridBagLayout());
            java.awt.GridBagConstraints gridBagConstraints1;
            
            addWindowListener(new java.awt.event.WindowAdapter() {
                public void windowClosing(java.awt.event.WindowEvent evt) {
                    exitForm(evt);
                }
            });
            
            closeButton.setText("Close");
            closeButton.addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
                    closeButtonActionPerformed(evt);
                }
            });
            
            closeButton.addMouseListener(new java.awt.event.MouseAdapter() {
                public void mouseClicked(java.awt.event.MouseEvent evt) {
                    closeButtonMouseClicked(evt);
                }
            });
            
            gridBagConstraints1 = new java.awt.GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.insets = new java.awt.Insets(5, 0, 5, 7);
            gridBagConstraints1.anchor = java.awt.GridBagConstraints.EAST;
            getContentPane().add(closeButton, gridBagConstraints1);
            
            jTabbedPane2.setTabPlacement(javax.swing.JTabbedPane.BOTTOM);
            jScrollPane1.setViewportView(propertyListViewer1);
            
            jTabbedPane2.addTab("Properties", jScrollPane1);
          
            jTabbedPane2.addTab("Set Attribute", setPanel);
          
	    optionPanel.setLayout(new java.awt.GridBagLayout());
            java.awt.GridBagConstraints gridBagConstraints2;
            
            trendButton.setText("Trend...");
            gridBagConstraints2 = new java.awt.GridBagConstraints();
            gridBagConstraints2.anchor = java.awt.GridBagConstraints.WEST;
            optionPanel.add(trendButton, gridBagConstraints2);
            
            addTrendButton.setText("add to trend...");
            gridBagConstraints2 = new java.awt.GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.anchor = java.awt.GridBagConstraints.WEST;
            optionPanel.add(addTrendButton, gridBagConstraints2);
            
            jTabbedPane2.addTab("Options", optionPanel);
          
          gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints1.weightx = 0.1;
        gridBagConstraints1.weighty = 0.1;
        getContentPane().add(jTabbedPane2, gridBagConstraints1);
        
        pack();
    }//GEN-END:initComponents

    private void closeButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_closeButtonMouseClicked
        setVisible(false);      // Add your handling code here:
    }//GEN-LAST:event_closeButtonMouseClicked

    private void closeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_closeButtonActionPerformed
        // Add your handling code here:
    }//GEN-LAST:event_closeButtonActionPerformed

    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
	setVisible(false);
    }//GEN-LAST:event_exitForm

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        new PropertyFrame().setVisible(true);
    }


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton closeButton;
    private javax.swing.JTabbedPane jTabbedPane2;
    private javax.swing.JScrollPane jScrollPane1;
    private fr.esrf.tangoatk.widget.properties.PropertyListViewer2 propertyListViewer1;
    private javax.swing.JPanel setPanel;
    private javax.swing.JPanel optionPanel;
    private javax.swing.JButton trendButton;
    private javax.swing.JButton addTrendButton;
    // End of variables declaration//GEN-END:variables

}

