/*
 *  Copyright (C) :	2002,2003,2004,2005,2006,2007,2008,2009
 *			European Synchrotron Radiation Facility
 *			BP 220, Grenoble 38043
 *			FRANCE
 * 
 *  This file is part of Tango.
 * 
 *  Tango is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  Tango is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *  
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Tango.  If not, see <http://www.gnu.org/licenses/>.
 */
 

package fr.esrf.tangoatk.widget.device;

import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.StatusEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IDevice;
import fr.esrf.tangoatk.widget.util.ATKDiagnostic;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.UIManagerHelper;
import fr.esrf.tangoatk.widget.util.IControlee;

import javax.swing.*;

/**
 *
 * @author  root
 */
public class StatusViewer extends javax.swing.JPanel implements fr.esrf.tangoatk.core.IStatusListener, IControlee {
  IDevice device;

  /** Creates new form StatusViewer */

  public StatusViewer() {
    initComponents();
    UIManagerHelper.setAll("StatusViewer.TextArea", status);
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
  private void initComponents() {//GEN-BEGIN:initComponents
    jScrollPane1 = new javax.swing.JScrollPane();
    status = new javax.swing.JTextArea();

    setLayout(new java.awt.BorderLayout());

    setBorder(new javax.swing.border.TitledBorder("Status"));
    jScrollPane1.setVerticalScrollBarPolicy(javax.swing.JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
    status.setLineWrap(true);
    status.setEditable(false);
    status.setColumns(50);
    status.setRows(4);
    status.setText("Unknown");
    status.setBackground(new java.awt.Color(204, 204, 204));
    jScrollPane1.setViewportView(status);

    add(jScrollPane1, java.awt.BorderLayout.CENTER);

  }//GEN-END:initComponents

  public void setModel(IDevice device) {
    if (this.device != null)
      this.device.removeStatusListener(this);
    status.setText("");
    this.device = device;
    if( device!=null ) {
      device.addStatusListener(this);
      setStatus(device.getStatus());
    }
  }

  /**
   * <code>getModel</code> gets the model of this statusViewer.
   *
   * @return a <code>Device</code> value
   */
  public IDevice getModel() {
    return device;
  }


  public int getRows() {
    return status.getRows();
  }

  public void setRows(int rows) {
    status.setRows(rows);
  }

  public int getColumns() {
    return status.getColumns();
  }

  public void setColumns(int columns) {
    status.setColumns(columns);
  }

  public JTextArea getText() {
    return status;
  }

/* javax.swing.JTextArea:setText(String) method has a memory
leak on SUN Solaris JVM (seems to be OK on windows)
The statusChange method is called each time the status is read by
the refresher even if it has not changed. This will be changed in the
future when the Tango Events will be used instead of ATK refreshers.
For the time being a test has been added to limit the memory leak.
Modified by F. Poncet  on 22/septembre/2003

    public void setStatus(String s) {
        status.setText(s);
    }

    */

  public void setStatus(String s) {
    if (s.equals(status.getText()))
      return;
    else
      status.setText(s);
  }

  public void statusChange(StatusEvent evt) {
    setStatus(evt.getStatus());
  }

  public void errorChange(ErrorEvent evt) {

  }

  public void ok() {
    getRootPane().getParent().setVisible(false);
  }

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JScrollPane jScrollPane1;
  private javax.swing.JTextArea status;
  // End of variables declaration//GEN-END:variables

  public static void main(String[] args) {

    JFrame f = new JFrame();
    f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    StatusViewer sv = new StatusViewer();
    Device d=null;
    try {
      d = new Device("taco:sr/rf-foc/tra3-1");
    } catch(DevFailed e) {
      ErrorPane.showErrorMessage(null,"taco:sr/rf-foc/tra3-1",e);
      System.exit(0);
    }
    sv.setModel(d);
    f.setContentPane(sv);
    f.setVisible(true);
    ATKDiagnostic.showDiagnostic();

  }

}
