/*
 *  Copyright (C) :	2002,2003,2004,2005,2006,2007,2008,2009
 *			European Synchrotron Radiation Facility
 *			BP 220, Grenoble 38043
 *			FRANCE
 * 
 *  This file is part of Tango.
 * 
 *  Tango is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  Tango is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *  
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Tango.  If not, see <http://www.gnu.org/licenses/>.
 */
 
/*
 * PropertyListViewer2.java
 *
 * Created on April 25, 2002, 6:09 PM
 */

package fr.esrf.tangoatk.widget.properties;
import java.util.*;
import javax.swing.*;
import fr.esrf.tangoatk.core.*;
import fr.esrf.tangoatk.widget.util.IControlee;
import fr.esrf.tangoatk.widget.util.IApplicable;

/**
 *
 * @author  root
 */
public class PropertyListViewer2 extends javax.swing.JPanel {

    /** Creates new form PropertyListViewer2 */
    public PropertyListViewer2() {
        initComponents();

    }

    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
          jMenuBar1 = new javax.swing.JMenuBar();
          jMenu1 = new javax.swing.JMenu();
          jScrollPane2 = new javax.swing.JScrollPane();
          jSplitPane1 = new javax.swing.JSplitPane();
          namePanel = new javax.swing.JPanel();
          valuePanel = new javax.swing.JPanel();
          
          jMenu1.setText("Menu");
          jMenuBar1.add(jMenu1);
          
            setLayout(new java.awt.GridBagLayout());
            java.awt.GridBagConstraints gridBagConstraints1;
            
            setBackground(java.awt.Color.red);
            jSplitPane1.setDividerSize(3);
            jSplitPane1.setResizeWeight(0.5);
            namePanel.setLayout(new java.awt.GridBagLayout());
            java.awt.GridBagConstraints gridBagConstraints4;
            
            jSplitPane1.setLeftComponent(namePanel);
            
            valuePanel.setLayout(new java.awt.GridBagLayout());
            java.awt.GridBagConstraints gridBagConstraints5;
            
            valuePanel.setForeground(new java.awt.Color(0, 51, 153));
            jSplitPane1.setRightComponent(valuePanel);
            
            jScrollPane2.setViewportView(jSplitPane1);
          
	    gridBagConstraints1 = new java.awt.GridBagConstraints();
	    gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
	    gridBagConstraints1.weightx = 0.1;
	    gridBagConstraints1.weighty = 0.1;
	    add(jScrollPane2, gridBagConstraints1);
        
    }//GEN-END:initComponents

    boolean editable;
    
    /**
     * Get the value of editable.
     * @return value of editable.
     */
    public boolean isEditable() {
	if (adapter != null)
	    return adapter.isEditable();
	
	return editable;
    }
    
    /**
     * Set the value of editable.
     * @param v  Value to assign to editable.
     */
    public void setEditable(boolean  v) {
	if (adapter != null) 
	    adapter.setEditable(v);
	
	this.editable = v;
    }
    
    public IControlee getControlee() {
	return controlee;
    }
	
    public void setModel(Map m) {
	adapter = new PropertyListAdapter();
	adapter.setEditable(editable);
	adapter.setModel(m, valuePanel, namePanel);
	if (isEditable()) {
	    controlee = new IApplicable() {
		    public void ok() {
			apply();
			getRootPane().getParent().setVisible(false);
			java.awt.Container cont = getTopLevelAncestor();
			if (cont instanceof java.awt.Window)
			{
			  java.awt.event.WindowEvent  we;
			  we = new java.awt.event.WindowEvent((java.awt.Window) cont, java.awt.event.WindowEvent.WINDOW_CLOSING);
			  cont.dispatchEvent(we);
			}
		    }

		    public void apply() {
			store();
		    }

		    public void cancel() {
			_cancel();
		    }
		};

	    
	} else {
	    controlee = new DefaultControlee();
	} 
	
    }

    public void store() {
	adapter.store();
    }

    public void _cancel() {
	adapter.cancel();
	getRootPane().getParent().setVisible(false);
	java.awt.Container cont = getTopLevelAncestor();
	if (cont instanceof java.awt.Window)
	{
	  java.awt.event.WindowEvent  we;
	  we = new java.awt.event.WindowEvent((java.awt.Window) cont, java.awt.event.WindowEvent.WINDOW_CLOSING);
	  cont.dispatchEvent(we);
	}
    }

    IControlee controlee = new DefaultControlee();
    
    PropertyListAdapter adapter;

    class DefaultControlee implements IControlee {
	public void ok() {
	    getRootPane().getParent().setVisible(false);
	}
	
	public void cancel() {
	    _cancel();
	}

    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JMenuBar jMenuBar1;
    private javax.swing.JMenu jMenu1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JSplitPane jSplitPane1;
    private javax.swing.JPanel namePanel;
    private javax.swing.JPanel valuePanel;
    // End of variables declaration//GEN-END:variables

    public static void main (String[] args) throws Exception{
	JFrame frame = new JFrame();
	PropertyListViewer2 v = new PropertyListViewer2();
	Map m = new HashMap();
	AttributeList list = new AttributeList();
 	v.setModel(((IAttribute)list.add("eas/test-api/1/Att_eas")).getPropertyMap());
	list.startRefresher();
	frame.setContentPane(v);
	frame.pack();
	frame.setVisible(true);
    } // end of main ()
    
}
