/*
 *  Copyright (C) :	2002,2003,2004,2005,2006,2007,2008,2009
 *			European Synchrotron Radiation Facility
 *			BP 220, Grenoble 38043
 *			FRANCE
 * 
 *  This file is part of Tango.
 * 
 *  Tango is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  Tango is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *  
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Tango.  If not, see <http://www.gnu.org/licenses/>.
 */
 
/*
 * ATKFrame.java
 *
 * Created on February 28, 2002, 10:11 AM
 */

package fr.esrf.tangoatk.widget.util;

/**
 *
 * @author  root
 */
public abstract class ATKFrame extends javax.swing.JFrame implements fr.esrf.tangoatk.core.IErrorListener {

    protected Splash splash = null;
    
    /** Creates new form ATKFrame */
    public ATKFrame() {
	splash = new Splash();
	splash.setVisible(true);
        initComponents();
    }

    public void showAtkFrame() {
	splash.setVisible(false);
	splash = null;
	super.setVisible(true);
    }

    public void setSplashMessage(String message) {
	splash.setMessage(message);
    }

    public String getSplashMessage() {
	return splash.getMessage();
    }
    
    public void setSplashTitle(String title) {
        splash.setTitle(title);
    }
    
    public String getSplashTitle() {
        return splash.getTitle();
    }
    

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });
        
        pack();
    }//GEN-END:initComponents

    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        System.exit(0);
    }//GEN-LAST:event_exitForm

    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables

    public abstract String getAuthor();

    public String getVersion() {
	return "$Id";
    }

    public void errorChange(fr.esrf.tangoatk.core.ErrorEvent evt) {
	System.out.println(evt);
    }

}
