/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package fr.esrf.tangoatk.widget.util;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import javax.swing.JFileChooser;
import javax.swing.JFrame;

/**
 *
 * @author poncet
 */
public class FileContentViewer extends javax.swing.JPanel
                               implements PropertyChangeListener
{
    private int       width, height;
    private File      theFile = null;

  /**
   * Creates new form FileContentViewer
   * @param w Width
   * @param h Height
   */
    public FileContentViewer(int w, int h)
    {
        width = w;
        height = h;
        initComponents();
    }

    @Override
    public Dimension getPreferredSize()
    {
        return new Dimension(width, height);
    }
    
    

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents()
    {
        java.awt.GridBagConstraints gridBagConstraints;

        jScrollPane1 = new javax.swing.JScrollPane();
        jTextArea1 = new javax.swing.JTextArea();

        setLayout(new java.awt.GridBagLayout());

        jScrollPane1.setViewportView(jTextArea1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(jScrollPane1, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextArea jTextArea1;
    // End of variables declaration//GEN-END:variables

    
    private boolean useProbeContentType()
    {
        
        String typeStr;
        
        try
        {
            typeStr = Files.probeContentType(theFile.toPath());
            if (typeStr == null)
                typeStr = "???";
            else
                typeStr = typeStr.toLowerCase();
            
            if (theFile.getName().endsWith(".ts")) // SettingsManager file
            {
//                System.out.println("File Type was : "+typeStr);
                typeStr = "text";
//                System.out.println("File Type changed to : "+typeStr);
            }           
        }
        catch (IOException ex)
        {
            return false;
        }

//        System.out.println("File Type is : "+typeStr);
        
        if  (typeStr.contains("text/plain"))
            return true;
        if  (typeStr.contains("application/x-shellscript"))
            return true;
        if  (typeStr.contains("text/vnd.trolltech.linguist"))  // suffix .ts
            return true;
        if  (typeStr.contains("text"))  // hope that it is text ascii
            return true;
        return false;
    }
    
    
    private boolean isTextFile()
    {
        if (theFile == null) return false;
        if (!theFile.isFile()) return false; // not a normal file
        
        boolean isText;
        
        isText = useProbeContentType();
        
        return isText;
    }
    
    
    private void previewTextFile()
    {
        jTextArea1.setText(" ");
        BufferedReader br = null;
        try
        {
            br = new BufferedReader(new FileReader(theFile));
        }
        catch (FileNotFoundException ex)
        {
//            repaint();
            return;
        }
        
        StringBuilder sb = new StringBuilder();
        String line = null;
       
        try
        {
            line = br.readLine();
            while (line != null)
            {
                // workaround the swing bug introduced in JTextArea since java 1.8
                // Swing Bug : for the very long lines (more than 8783 characters)
                // the line content is displayed overlapping the characters.
                if (line.length() > 6000)
                {
                    line = line.substring(0, 6000);
                }
                sb.append(line);
                sb.append("\n");
                line = br.readLine();
            }
            jTextArea1.setText(sb.toString());
        }
        catch (IOException ex) {}
        
        try
        {
            br.close();
        }
        catch (IOException ex) {}
        
//        repaint();
    }
                
                
    private void previewFile()
    {
        if (!isTextFile())
        {
            jTextArea1.setText(" ");
            this.repaint();
            return;
        }
        
        previewTextFile();
    }
    
    
    
    public void propertyChange(PropertyChangeEvent e)
    {
        boolean update = false;
        String prop = e.getPropertyName();

        //If the directory changed, don't show an image.
        if (JFileChooser.DIRECTORY_CHANGED_PROPERTY.equals(prop))
        {
            theFile = null;
            update = true;
        } 
        else //If a file became selected, find out which one
        {
            if (JFileChooser.SELECTED_FILE_CHANGED_PROPERTY.equals(prop))
            {
                theFile = (File) e.getNewValue();
                update = true;
            }
        }

        //Update the preview accordingly.
        if (update)
        {
            if (isShowing())
            {
                previewFile();
//                jTextArea1.getDocument()
                repaint();
            }
        }
    }
    
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[])
    {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
//        try {
//            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
//                if ("Nimbus".equals(info.getName())) {
//                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
//                    break;
//                }
//            }
//        } catch (ClassNotFoundException ex) {
//            java.util.logging.Logger.getLogger(GenericDeviceFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
//        } catch (InstantiationException ex) {
//            java.util.logging.Logger.getLogger(GenericDeviceFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
//        } catch (IllegalAccessException ex) {
//            java.util.logging.Logger.getLogger(GenericDeviceFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
//        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
//            java.util.logging.Logger.getLogger(GenericDeviceFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
//        }
        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable()
        {
            public void run()
            {
                JFrame jf = new JFrame();
                jf.setVisible(true);
                
                JFileChooser jfc = new JFileChooser("/users/poncet");
                FileContentViewer  fcv = new FileContentViewer(500, 250);
                jfc.addPropertyChangeListener(fcv);
                jfc.setAccessory(fcv);
                jfc.showOpenDialog(jf.getContentPane());
            }
        });
    }
}
