/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLArrayData;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.fixedfunc.GLPointerFuncUtil;
import com.jogamp.opengl.util.GLBuffers;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import jogamp.opengl.Debug;

public class GLArrayDataWrapper
implements GLArrayData {
    public static final boolean DEBUG = Debug.debug("GLArrayData");
    protected boolean alive;
    protected int index;
    protected int location;
    protected String name;
    protected int componentsPerElement;
    protected int componentType;
    protected Class<?> componentClazz;
    protected int componentByteSize;
    protected boolean normalized;
    protected int strideB;
    protected int strideL;
    protected Buffer buffer;
    protected int mappedElementCount;
    protected boolean isVertexAttribute;
    protected long vboOffset;
    protected int vboName;
    protected boolean vboEnabled;
    protected int vboUsage;
    protected int vboTarget;

    public static GLArrayDataWrapper createFixed(int n, int n2, int n3, boolean bl, int n4, Buffer buffer, int n5, long l, int n6, int n7) throws GLException {
        GLArrayDataWrapper gLArrayDataWrapper = new GLArrayDataWrapper();
        gLArrayDataWrapper.init(null, n, n2, n3, bl, n4, buffer, 0, false, n5, l, n6, n7);
        return gLArrayDataWrapper;
    }

    public static GLArrayDataWrapper createFixed(int n, int n2, int n3, boolean bl, int n4, int n5, int n6, long l, int n7, int n8) throws GLException {
        GLArrayDataWrapper gLArrayDataWrapper = new GLArrayDataWrapper();
        gLArrayDataWrapper.init(null, n, n2, n3, bl, n4, null, n5, false, n6, l, n7, n8);
        return gLArrayDataWrapper;
    }

    public static GLArrayDataWrapper createGLSL(String string, int n, int n2, boolean bl, int n3, Buffer buffer, int n4, long l, int n5, int n6) throws GLException {
        GLArrayDataWrapper gLArrayDataWrapper = new GLArrayDataWrapper();
        gLArrayDataWrapper.init(string, -1, n, n2, bl, n3, buffer, 0, true, n4, l, n5, n6);
        return gLArrayDataWrapper;
    }

    public static GLArrayDataWrapper createGLSL(String string, int n, int n2, boolean bl, int n3, int n4, int n5, long l, int n6, int n7) throws GLException {
        GLArrayDataWrapper gLArrayDataWrapper = new GLArrayDataWrapper();
        gLArrayDataWrapper.init(string, -1, n, n2, bl, n3, null, n4, true, n5, l, n6, n7);
        return gLArrayDataWrapper;
    }

    public final boolean validate(GLProfile gLProfile, boolean bl) {
        if (!this.alive) {
            if (bl) {
                throw new GLException("Instance !alive " + this);
            }
            return false;
        }
        if (this.isVertexAttribute() && !gLProfile.hasGLSL()) {
            if (bl) {
                throw new GLException("GLSL not supported on " + gLProfile + ", " + this);
            }
            return false;
        }
        return gLProfile.isValidArrayDataType(this.getIndex(), this.getComponentCount(), this.getComponentType(), this.isVertexAttribute(), bl);
    }

    @Override
    public void associate(Object object, boolean bl) {
    }

    @Override
    public final boolean isVertexAttribute() {
        return this.isVertexAttribute;
    }

    @Override
    public final int getIndex() {
        return this.index;
    }

    @Override
    public final int getLocation() {
        return this.location;
    }

    @Override
    public final int setLocation(int n) {
        this.location = n;
        return this.location;
    }

    @Override
    public final int setLocation(GL2ES2 gL2ES2, int n) {
        this.location = gL2ES2.glGetAttribLocation(n, this.name);
        return this.location;
    }

    @Override
    public final int setLocation(GL2ES2 gL2ES2, int n, int n2) {
        this.location = n2;
        gL2ES2.glBindAttribLocation(n, n2, this.name);
        return n2;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final long getVBOOffset() {
        return this.vboEnabled ? this.vboOffset : 0L;
    }

    @Override
    public final int getVBOName() {
        return this.vboEnabled ? this.vboName : 0;
    }

    @Override
    public final boolean isVBO() {
        return this.vboEnabled;
    }

    @Override
    public final int getVBOUsage() {
        return this.vboEnabled ? this.vboUsage : 0;
    }

    @Override
    public final int getVBOTarget() {
        return this.vboEnabled ? this.vboTarget : 0;
    }

    @Override
    public Buffer getBuffer() {
        return this.buffer;
    }

    @Override
    public final int getComponentCount() {
        return this.componentsPerElement;
    }

    @Override
    public final int getComponentType() {
        return this.componentType;
    }

    @Override
    public final int getComponentSizeInBytes() {
        return this.componentByteSize;
    }

    @Override
    public final int getElementCount() {
        if (0 != this.mappedElementCount) {
            return this.mappedElementCount;
        }
        if (null != this.buffer) {
            int n = 0 == this.buffer.position() ? this.buffer.limit() : this.buffer.position();
            return n * this.componentByteSize / this.strideB;
        }
        return 0;
    }

    @Override
    public final int getSizeInBytes() {
        if (0 != this.mappedElementCount) {
            return this.mappedElementCount * this.componentsPerElement * this.componentByteSize;
        }
        if (null != this.buffer) {
            return this.buffer.position() == 0 ? this.buffer.limit() * this.componentByteSize : this.buffer.position() * this.componentByteSize;
        }
        return 0;
    }

    @Override
    public final boolean getNormalized() {
        return this.normalized;
    }

    @Override
    public final int getStride() {
        return this.strideB;
    }

    public final Class<?> getBufferClass() {
        return this.componentClazz;
    }

    @Override
    public void destroy(GL gL) {
        this.buffer = null;
        this.vboName = 0;
        this.vboEnabled = false;
        this.vboOffset = 0L;
        this.alive = false;
    }

    @Override
    public String toString() {
        return "GLArrayDataWrapper[" + this.name + ", index " + this.index + ", location " + this.location + ", isVertexAttribute " + this.isVertexAttribute + ", dataType 0x" + Integer.toHexString(this.componentType) + ", bufferClazz " + this.componentClazz + ", elements " + this.getElementCount() + ", components " + this.componentsPerElement + ", stride " + this.strideB + "b " + this.strideL + "c" + ", mappedElementCount " + this.mappedElementCount + ", buffer " + this.buffer + ", vboEnabled " + this.vboEnabled + ", vboName " + this.vboName + ", vboUsage 0x" + Integer.toHexString(this.vboUsage) + ", vboTarget 0x" + Integer.toHexString(this.vboTarget) + ", vboOffset " + this.vboOffset + ", alive " + this.alive + "]";
    }

    public static final Class<?> getBufferClass(int n) {
        switch (n) {
            case 5120: 
            case 5121: {
                return ByteBuffer.class;
            }
            case 5122: 
            case 5123: {
                return ShortBuffer.class;
            }
            case 5124: 
            case 5125: 
            case 5132: {
                return IntBuffer.class;
            }
            case 5126: {
                return FloatBuffer.class;
            }
        }
        throw new GLException("Given OpenGL data type not supported: " + n);
    }

    @Override
    public void setName(String string) {
        this.location = -1;
        this.name = string;
    }

    public void setVBOEnabled(boolean bl) {
        this.vboEnabled = bl;
    }

    public void setVBOName(int n) {
        this.vboName = n;
        this.setVBOEnabled(0 != n);
    }

    public void setVBOUsage(int n) {
        this.vboUsage = n;
    }

    public void setVBOTarget(int n) {
        this.vboTarget = n;
    }

    protected void init(String string, int n, int n2, int n3, boolean bl, int n4, Buffer buffer, int n5, boolean bl2, int n6, long l, int n7, int n8) throws GLException {
        if (0 < n5 && null != buffer) {
            throw new IllegalArgumentException("mappedElementCount:=" + n5 + " specified, but passing non null buffer");
        }
        this.isVertexAttribute = bl2;
        this.index = n;
        this.location = -1;
        if (34963 != n8) {
            if (0 == n7 && 0 == n8 || 34962 == n8) {
                String string2 = this.name = null == string ? GLPointerFuncUtil.getPredefinedArrayIndexName(n) : string;
                if (null == this.name) {
                    throw new GLException("Not a valid array buffer index: " + n);
                }
            } else if (0 < n8) {
                throw new GLException("Invalid GPUBuffer target: 0x" + Integer.toHexString(n8));
            }
        }
        this.componentType = n3;
        this.componentClazz = GLArrayDataWrapper.getBufferClass(n3);
        this.normalized = GLBuffers.isGLTypeFixedPoint(n3) ? bl : false;
        this.componentByteSize = GLBuffers.sizeOfGLType(n3);
        if (0 > this.componentByteSize) {
            throw new GLException("Given componentType not supported: " + n3 + ":\n\t" + this);
        }
        if (0 >= n2) {
            throw new GLException("Invalid number of components: " + n2);
        }
        this.componentsPerElement = n2;
        if (0 < n4 && n4 < n2 * this.componentByteSize) {
            throw new GLException("stride (" + n4 + ") lower than component bytes, " + n2 + " * " + this.componentByteSize);
        }
        if (0 < n4 && n4 % this.componentByteSize != 0) {
            throw new GLException("stride (" + n4 + ") not a multiple of bpc " + this.componentByteSize);
        }
        this.buffer = buffer;
        this.mappedElementCount = n5;
        this.strideB = 0 == n4 ? n2 * this.componentByteSize : n4;
        this.strideL = this.strideB / this.componentByteSize;
        this.vboName = n6;
        this.vboEnabled = 0 != n6;
        this.vboOffset = l;
        switch (n7) {
            case 0: 
            case 35040: 
            case 35044: 
            case 35048: {
                break;
            }
            default: {
                throw new GLException("invalid gpuBufferUsage: " + n7 + ":\n\t" + this);
            }
        }
        switch (n8) {
            case 0: 
            case 34962: 
            case 34963: {
                break;
            }
            default: {
                throw new GLException("invalid gpuBufferTarget: " + n8 + ":\n\t" + this);
            }
        }
        this.vboUsage = n7;
        this.vboTarget = n8;
        this.alive = true;
    }

    protected GLArrayDataWrapper() {
    }

    public GLArrayDataWrapper(GLArrayDataWrapper gLArrayDataWrapper) {
        this.alive = gLArrayDataWrapper.alive;
        this.index = gLArrayDataWrapper.index;
        this.location = gLArrayDataWrapper.location;
        this.name = gLArrayDataWrapper.name;
        this.componentsPerElement = gLArrayDataWrapper.componentsPerElement;
        this.componentType = gLArrayDataWrapper.componentType;
        this.componentClazz = gLArrayDataWrapper.componentClazz;
        this.componentByteSize = gLArrayDataWrapper.componentByteSize;
        this.normalized = gLArrayDataWrapper.normalized;
        this.strideB = gLArrayDataWrapper.strideB;
        this.strideL = gLArrayDataWrapper.strideL;
        this.buffer = null != gLArrayDataWrapper.buffer ? (gLArrayDataWrapper.buffer.position() == 0 ? Buffers.slice(gLArrayDataWrapper.buffer) : Buffers.slice(gLArrayDataWrapper.buffer, 0, gLArrayDataWrapper.buffer.limit())) : null;
        this.mappedElementCount = gLArrayDataWrapper.mappedElementCount;
        this.isVertexAttribute = gLArrayDataWrapper.isVertexAttribute;
        this.vboOffset = gLArrayDataWrapper.vboOffset;
        this.vboName = gLArrayDataWrapper.vboName;
        this.vboEnabled = gLArrayDataWrapper.vboEnabled;
        this.vboUsage = gLArrayDataWrapper.vboUsage;
        this.vboTarget = gLArrayDataWrapper.vboTarget;
    }
}

