/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IAttributeStateListener;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.IScalarAttribute;
import fr.esrf.tangoatk.widget.attribute.IAttributeViewer;
import fr.esrf.tangoatk.widget.attribute.SimplePropertyFrame;
import fr.esrf.tangoatk.widget.attribute.Trend;
import fr.esrf.tangoatk.widget.properties.PropertyViewer;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKField;
import fr.esrf.tangoatk.widget.util.ATKFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class AScalarViewer
extends JPanel
implements IAttributeStateListener,
IErrorListener,
IAttributeViewer {
    SimplePropertyFrame f;
    IScalarAttribute supermodel;
    Color background = this.getBackground();
    Trend globalTrend;
    boolean fullState = false;
    boolean propertyListEditable = false;
    boolean setter = false;
    boolean valueEditable;
    boolean alarmEnabled = true;
    private JPanel jPanel1;
    private PropertyViewer label;
    private ATKField value;
    private PropertyViewer unit;
    private JButton info;

    public AScalarViewer() {
        this.initComponents();
        this.label.setValueHorizontalAlignment(4);
        this.setUnitBorder(null);
        this.setLabelBorder(null);
        Dimension id = this.info.getPreferredSize();
        Dimension vd = this.getValue().getPreferredSize();
        id.setSize(id.getWidth(), vd.getHeight() - 1.0);
        this.info.setPreferredSize(id);
        this.info.setMaximumSize(id);
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        if (this.jPanel1 == null) {
            return;
        }
        this.setLabelFont(f);
        this.setUnitFont(f);
        this.setValueFont(f);
        this.info.setFont(f);
    }

    protected void setValueField(ATKField field) {
        GridBagLayout layout = (GridBagLayout)this.jPanel1.getLayout();
        this.jPanel1.remove(this.value);
        this.value = field;
        this.jPanel1.add((Component)this.value, 1);
    }

    public void fullStateChange(String state) {
        if ("VALID".equals(state)) {
            this.setBackground(this.background);
            return;
        }
        this.setBackground(ATKConstant.getColor4Quality(state));
    }

    public void stateChange(String state) {
        if (!this.alarmEnabled) {
            return;
        }
        if (this.fullState) {
            this.fullStateChange(state);
            return;
        }
        if ("VALID".equals(state)) {
            this.value.setState(this.getBackground());
            return;
        }
        this.value.setState(ATKConstant.getColor4Quality(state));
    }

    protected void init(IScalarAttribute model) {
        if (this.supermodel != null) {
            this.supermodel.removeStateListener((IAttributeStateListener)this);
        }
        this.supermodel = model;
        this.supermodel.addStateListener((IAttributeStateListener)this);
        this.getLabel().setModel(this.supermodel.getProperty("label"));
        this.getLabel().setEditable(false);
        this.getUnit().setModel(this.supermodel.getProperty("unit"));
        this.getUnit().setEditable(false);
        this.getValue().setFormat(this.supermodel.getProperty("format").getPresentation());
        Border border = this.getBorder();
        if (border != null && border instanceof TitledBorder && this.supermodel != null && this.supermodel.getName() != null) {
            ((TitledBorder)border).setTitle(this.supermodel.getName());
        }
        this.stateChange(model.getState());
    }

    public boolean isFullState() {
        return this.fullState;
    }

    public void setFullState(boolean v) {
        this.fullState = v;
    }

    public void setUserFormat(ATKFormat format) {
        this.value.setUserFormat(format);
    }

    public ATKFormat getUserFormat() {
        return this.value.getUserFormat();
    }

    public void setLabelFont(Font f) {
        this.label.setFont(f);
    }

    public Font getLabelFont() {
        return this.label.getFont();
    }

    public void setUnitFont(Font f) {
        this.unit.setFont(f);
    }

    public Font getUnitFont() {
        return this.unit.getFont();
    }

    public void setValueFont(Font f) {
        this.value.setFont(f);
    }

    public Font getValueFont() {
        return this.value.getFont();
    }

    public Dimension getLabelPreferredSize() {
        return this.label.getPreferredSize();
    }

    public void setLabelPreferredSize(Dimension d) {
        this.label.setPreferredSize(d);
    }

    public Dimension getValuePreferredSize() {
        return this.value.getPreferredSize();
    }

    public void setValuePreferredSize(Dimension d) {
        this.value.setPreferredSize(d);
    }

    public void setGlobalTrend(Trend t) {
        this.globalTrend = t;
    }

    public Trend getGlobalTrend() {
        return this.globalTrend;
    }

    public Dimension getUnitPreferredSize() {
        return this.unit.getPreferredSize();
    }

    public void setUnitPreferredSize(Dimension d) {
        this.unit.setPreferredSize(d);
    }

    public void setUnitMaximumLength(int characters) {
        this.unit.setValueMaximumLength(characters);
    }

    public int getUnitMaximumLength() {
        return this.unit.getValueMaximumLength();
    }

    public void setLabelMaximumLength(int characters) {
        this.label.setValueMaximumLength(characters);
    }

    public int getLabelMaximumLength() {
        return this.label.getValueMaximumLength();
    }

    public void setValueMaximumLength(int characters) {
        this.value.setMaximumLength(characters);
    }

    public int getValueMaximumLength() {
        return this.value.getMaximumLength();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.label = new PropertyViewer();
        this.value = new ATKField();
        this.unit = new PropertyViewer();
        this.info = new JButton();
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder("Not Connected"));
        this.setAlignmentX(0.0f);
        this.setAlignmentY(0.0f);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setAlignmentX(0.0f);
        this.jPanel1.setAlignmentY(0.0f);
        this.label.setLabelVisible(false);
        this.label.setValue("label");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(0, 0, 0, 2);
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.weighty = 0.1;
        this.jPanel1.add((Component)this.label, gridBagConstraints2);
        this.value.setHorizontalAlignment(11);
        this.value.setText("-------");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 0.1;
        this.jPanel1.add((Component)this.value, gridBagConstraints2);
        this.unit.setLabelVisible(false);
        this.unit.setValue("unit");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(0, 3, 0, 0);
        gridBagConstraints2.anchor = 13;
        this.jPanel1.add((Component)this.unit, gridBagConstraints2);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.weightx = 0.1;
        this.add((Component)this.jPanel1, gridBagConstraints1);
        this.info.setFont(new Font("Dialog", 0, 12));
        this.info.setText("...");
        this.info.setAlignmentY(0.0f);
        this.info.setHorizontalTextPosition(0);
        this.info.setMargin(new Insets(0, 5, 0, 5));
        this.info.setMinimumSize(new Dimension(0, 0));
        this.info.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AScalarViewer.this.infoMouseClicked(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.anchor = 13;
        this.add((Component)this.info, gridBagConstraints1);
    }

    private void infoMouseClicked(MouseEvent evt) {
        if (this.f == null) {
            this.f = new SimplePropertyFrame();
            this.f.setSize(300, 400);
            this.f.setEditable(this.propertyListEditable);
            this.f.setModel((IAttribute)this.supermodel);
            this.f.pack();
        }
        this.f.setVisible(true);
    }

    public static void main(String[] args) {
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.jPanel1 == null) {
            return;
        }
        this.unit.setForeground(color);
        this.label.setForeground(color);
        this.value.setForeground(color);
        this.jPanel1.setForeground(color);
        this.info.setForeground(color);
    }

    @Override
    public void setBackground(Color color) {
        this.background = color;
        super.setBackground(color);
        if (this.jPanel1 == null) {
            return;
        }
        this.unit.setBackground(color);
        this.label.setBackground(color);
        this.value.setBackground(color);
        this.jPanel1.setBackground(color);
        this.info.setBackground(color);
    }

    public void setUnitVisible(boolean b) {
        this.unit.setVisible(b);
    }

    public boolean isUnitVisible() {
        return this.unit.isVisible();
    }

    public boolean isLabelVisible() {
        return this.label.isVisible();
    }

    public void setLabelVisible(boolean b) {
        this.label.setVisible(b);
    }

    public void setInfoVisible(boolean b) {
        this.info.setVisible(b);
    }

    public boolean isInfoVisible() {
        return this.info.isVisible();
    }

    public void setPropertyListEditable(boolean b) {
        this.propertyListEditable = b;
        if (this.f == null) {
            return;
        }
        this.f.setEditable(b);
    }

    public boolean isPropertyListEditable() {
        return this.propertyListEditable;
    }

    public void setSetter(boolean b) {
        this.setter = b;
        this.value.setEditable(this.setter);
    }

    public boolean isSetter() {
        return this.value.isEditable();
    }

    public void setValueEditable(boolean b) {
        this.valueEditable = b;
    }

    @Override
    public boolean isValueEditable() {
        return this.valueEditable;
    }

    public void setValueBorder(Border border) {
        this.value.setBorder(border);
    }

    public Border getValueBorder() {
        return this.value.getBorder();
    }

    public void setLabelBorder(Border border) {
        this.label.setBorder(border);
    }

    public Border getLabelBorder() {
        return this.label.getBorder();
    }

    public void setUnitBorder(Border border) {
        this.unit.setBorder(border);
    }

    public Border getUnitBorder() {
        return this.unit.getBorder();
    }

    public void setValueOpaque(boolean isOpaque) {
        this.value.setOpaque(isOpaque);
    }

    public boolean isValueOpaque() {
        return this.value.isOpaque();
    }

    public void setLabelOpaque(boolean isOpaque) {
        this.label.setOpaque(isOpaque);
    }

    public boolean isLabelOpaque() {
        return this.label.isOpaque();
    }

    public void setUnitOpaque(boolean isOpaque) {
        this.unit.setOpaque(isOpaque);
    }

    public boolean isUnitOpaque() {
        return this.unit.isOpaque();
    }

    @Override
    public void setOpaque(boolean isOpaque) {
        super.setOpaque(isOpaque);
        if (this.jPanel1 == null) {
            return;
        }
        this.setUnitOpaque(isOpaque);
        this.setLabelOpaque(isOpaque);
        this.jPanel1.setOpaque(isOpaque);
    }

    @Override
    public boolean isOpaque() {
        return super.isOpaque();
    }

    protected PropertyViewer getUnit() {
        return this.unit;
    }

    protected PropertyViewer getLabel() {
        return this.label;
    }

    protected ATKField getValue() {
        return this.value;
    }

    public double getValueWidth() {
        return AScalarViewer.getWidth(this.getValue());
    }

    public double getLabelWidth() {
        return AScalarViewer.getWidth(this.label);
    }

    public double getUnitWidth() {
        return AScalarViewer.getWidth(this.unit);
    }

    public void setLabelWidth(double width) {
        AScalarViewer.setWidth(this.label, width);
    }

    public void setUnitWidth(double width) {
        AScalarViewer.setWidth(this.unit, width);
    }

    public void setValueWidth(double width) {
        AScalarViewer.setWidth(this.getValue(), width);
    }

    static double getWidth(JComponent c) {
        return c.getPreferredSize().getWidth();
    }

    static void setWidth(JComponent c, double width) {
        Dimension d = c.getPreferredSize();
        d.setSize(width, d.getHeight());
        c.setPreferredSize(d);
        c.setMinimumSize(d);
    }

    public boolean isAlarmEnabled() {
        return this.alarmEnabled;
    }

    public void setAlarmEnabled(boolean v) {
        this.alarmEnabled = v;
    }

    public void errorChange(ErrorEvent errorEvent) {
        this.value.setError();
        this.stateChange("UNKNOWN");
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
        this.stateChange(attributeStateEvent.getState());
    }

    @Override
    public IAttribute getModel() {
        return this.supermodel;
    }
}

