/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.BooleanScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IBooleanScalarListener;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.ISetErrorListener;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawable;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class BooleanScalarCheckBoxViewer
extends JCheckBox
implements ActionListener,
IBooleanScalarListener,
ISetErrorListener,
JDrawable {
    private IBooleanScalar attModel = null;
    private String trueLabel = null;
    private String falseLabel = null;
    private String fixedLabel = null;
    private boolean hasToolTip = false;
    private boolean qualityEnabled = false;
    private Color background;
    static String[] exts = new String[]{"text"};
    private boolean enabled;

    public BooleanScalarCheckBoxViewer() {
        this.addActionListener(this);
        this.background = this.getBackground();
        this.enabled = this.isEnabled();
    }

    public BooleanScalarCheckBoxViewer(String title) {
        super(title);
        this.addActionListener(this);
        this.background = this.getBackground();
        this.enabled = this.isEnabled();
    }

    public IBooleanScalar getAttModel() {
        return this.attModel;
    }

    public void setAttModel(IBooleanScalar boolModel) {
        if (this.attModel != null) {
            this.attModel.removeBooleanScalarListener((IBooleanScalarListener)this);
            if (this.attModel.isWritable()) {
                this.attModel.removeSetErrorListener((ISetErrorListener)this);
            }
            this.attModel = null;
            this.setText("");
        }
        if (boolModel != null) {
            this.attModel = boolModel;
            this.attModel.addBooleanScalarListener((IBooleanScalarListener)this);
            if (this.attModel.isWritable()) {
                this.attModel.addSetErrorListener((ISetErrorListener)this);
            }
            if (this.trueLabel == null && this.falseLabel == null && this.fixedLabel == null) {
                this.setText(boolModel.getLabel());
            }
            if (this.hasToolTip) {
                this.setToolTipText(boolModel.getName());
            }
            this.setBoolValue(this.attModel.getDeviceValue());
        }
    }

    public String getTrueLabel() {
        return this.trueLabel;
    }

    public void setTrueLabel(String tLabel) {
        this.trueLabel = tLabel;
        if (this.trueLabel == null || this.falseLabel == null) {
            if (this.attModel != null) {
                this.setText(this.attModel.getLabel());
            } else {
                this.setText(null);
            }
        } else if (this.isSelected()) {
            this.setText(this.trueLabel);
        }
    }

    public String getFalseLabel() {
        return this.falseLabel;
    }

    public void setFalseLabel(String fLabel) {
        this.falseLabel = fLabel;
        if (this.trueLabel == null || this.falseLabel == null) {
            if (this.attModel != null) {
                this.setText(this.attModel.getLabel());
            } else {
                this.setText(null);
            }
        } else if (!this.isSelected()) {
            this.setText(this.falseLabel);
        }
    }

    public boolean getHasToolTip() {
        return this.hasToolTip;
    }

    public void setHasToolTip(boolean b) {
        if (this.hasToolTip != b) {
            if (!b) {
                this.setToolTipText(null);
            } else if (this.attModel != null) {
                this.setToolTipText(this.attModel.getName());
            }
            this.hasToolTip = b;
        }
    }

    public boolean getQualityEnabled() {
        return this.qualityEnabled;
    }

    public void setQualityEnabled(boolean b) {
        this.qualityEnabled = b;
        if (!this.qualityEnabled) {
            super.setBackground(this.background);
            this.repaint();
        }
    }

    public void clearModel() {
        this.setAttModel(null);
    }

    @Override
    public void initForEditing() {
        this.setText("CheckBox");
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String getDescription(String extName) {
        if (extName.equalsIgnoreCase("text")) {
            return "Overrides text given by the model.";
        }
        return "";
    }

    @Override
    public String[] getExtensionList() {
        return exts;
    }

    @Override
    public boolean setExtendedParam(String name, String value, boolean popupErr) {
        if (name.equalsIgnoreCase("text")) {
            this.fixedLabel = value;
            if (this.fixedLabel.length() == 0) {
                this.fixedLabel = null;
                this.setText("CheckBox");
            } else {
                this.setText(this.fixedLabel);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getExtendedParam(String name) {
        if (name.equalsIgnoreCase("text") && this.fixedLabel != null) {
            return this.fixedLabel;
        }
        return "";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.attModel == null) {
            return;
        }
        if (!this.attModel.isWritable()) {
            this.setSelected(!this.isSelected());
            return;
        }
        if (this.isSelected()) {
            this.attModel.setValue(true);
        } else {
            this.attModel.setValue(false);
        }
    }

    public void booleanScalarChange(BooleanScalarEvent e) {
        this.setBoolValue(e.getValue());
    }

    public void stateChange(AttributeStateEvent evt) {
        String state = evt.getState();
        if (!this.qualityEnabled) {
            return;
        }
        super.setBackground(ATKConstant.getColor4Quality(state));
        this.repaint();
    }

    public void errorChange(ErrorEvent evt) {
        super.setEnabled(false);
    }

    protected void setBoolValue(boolean val) {
        if (this.enabled && !this.isEnabled()) {
            super.setEnabled(this.enabled);
        }
        this.setSelected(val);
        if (this.trueLabel != null || this.falseLabel != null) {
            if (val) {
                this.setText(this.trueLabel);
            } else {
                this.setText(this.falseLabel);
            }
        }
    }

    public void setErrorOccured(ErrorEvent evt) {
        if (this.attModel == null) {
            return;
        }
        if (evt.getSource() != this.attModel) {
            return;
        }
        this.setBoolValue(this.attModel.getDeviceValue());
    }

    @Override
    public void setBackground(Color bg) {
        this.background = bg;
        super.setBackground(bg);
    }

    @Override
    public void setEnabled(boolean b) {
        this.enabled = b;
        super.setEnabled(b);
    }

    public static void main(String[] args) {
        AttributeList attl = new AttributeList();
        JFrame f = new JFrame();
        BooleanScalarCheckBoxViewer bsv = new BooleanScalarCheckBoxViewer();
        try {
            IEntity ie = attl.add("jlp/test/1/att_boolean");
            if (!(ie instanceof IBooleanScalar)) {
                System.out.println("jlp/test/1/att_boolean is not a booleanScalar");
                System.exit(0);
            }
            IBooleanScalar bAtt = (IBooleanScalar)ie;
            bsv.setAttModel(bAtt);
        }
        catch (Exception ex) {
            System.out.println("Cannot connect to elin/mod/aux-1/Economy");
        }
        f.setContentPane(bsv);
        f.setDefaultCloseOperation(3);
        f.pack();
        f.setVisible(true);
    }
}

