/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.BooleanScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IBooleanScalarListener;
import fr.esrf.tangoatk.widget.attribute.BooleanTrend;
import fr.esrf.tangoatk.widget.util.chart.DataList;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

class BooleanTrendSelectionNode
extends DefaultMutableTreeNode
implements IBooleanScalarListener,
PropertyChangeListener {
    private String devname = "";
    private IBooleanScalar model;
    private int selected;
    private JLDataView data;
    private long lastErrorTime = 0L;
    static GregorianCalendar calendar = new GregorianCalendar();
    static SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
    BooleanTrend chart;

    public BooleanTrendSelectionNode(BooleanTrend g) {
        this.devname = "Trend";
        this.model = null;
        this.data = null;
        this.chart = g;
    }

    public BooleanTrendSelectionNode(BooleanTrend g, String name) {
        this.devname = name;
        this.data = null;
        this.model = null;
        this.chart = g;
    }

    public BooleanTrendSelectionNode(BooleanTrend g, String name, IBooleanScalar model, int selection, Color c) {
        this.devname = name;
        this.model = model;
        this.selected = selection;
        this.chart = g;
        this.data = new JLDataView();
        this.data.setColor(c);
        this.data.setMarkerColor(c);
        model.addBooleanScalarListener((IBooleanScalarListener)this);
        model.getProperty("label").addPresentationListener((PropertyChangeListener)this);
        model.getProperty("unit").addPresentationListener((PropertyChangeListener)this);
        model.getProperty("format").addPresentationListener((PropertyChangeListener)this);
    }

    public void refreshNode() {
        this.data.setUnit(this.model.getUnit());
        this.data.setUserFormat(this.model.getFormat());
        if (this.model.getLabel().length() > 0 && !this.model.getLabel().equalsIgnoreCase("not specified")) {
            if (this.chart.displayDeviceNames()) {
                this.data.setName(this.devname + "/" + this.model.getLabel());
            } else {
                this.data.setName(this.model.getLabel());
            }
        } else {
            this.data.setName(this.model.getName());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.model != null) {
            this.refreshNode();
            this.chart.refreshNode(this);
        }
    }

    public int getSelected() {
        return this.selected;
    }

    public void setSelected(int s) {
        switch (s) {
            case 0: {
                switch (this.selected) {
                    case 2: {
                        this.chart.getChart().getY1Axis().removeDataView(this.data);
                        break;
                    }
                    case 3: {
                        this.chart.getChart().getY2Axis().removeDataView(this.data);
                    }
                }
                break;
            }
            case 2: {
                switch (this.selected) {
                    case 3: {
                        this.chart.getChart().getY2Axis().removeDataView(this.data);
                    }
                }
                this.chart.getChart().getY1Axis().addDataView(this.data);
                break;
            }
            case 3: {
                switch (this.selected) {
                    case 2: {
                        this.chart.getChart().getY1Axis().removeDataView(this.data);
                    }
                }
                this.chart.getChart().getY2Axis().addDataView(this.data);
            }
        }
        this.selected = s;
    }

    @Override
    public boolean isLeaf() {
        return this.model != null;
    }

    public IBooleanScalar getModel() {
        return this.model;
    }

    public JLDataView getData() {
        return this.data;
    }

    public void delItem(IBooleanScalar model) {
        int i = 0;
        int j = 0;
        int nb = this.getChildCount();
        boolean found = false;
        String attname = model.getName();
        String devname = attname.substring(0, attname.lastIndexOf(47));
        while (i < nb && !found) {
            found = devname.equals(this.getChild(i).toString());
            if (found) continue;
            ++i;
        }
        if (found) {
            BooleanTrendSelectionNode dev = (BooleanTrendSelectionNode)this.getChildAt(i);
            found = false;
            j = 0;
            int nb_att = dev.getChildCount();
            while (j < nb_att && !found) {
                found = attname.equals(dev.getChild(j).getModelName());
                if (found) continue;
                ++j;
            }
            if (found) {
                dev.getChild(j).setSelected(0);
                model.removeBooleanScalarListener((IBooleanScalarListener)dev.getChild(j));
                dev.remove(j);
                if (nb_att == 1) {
                    this.remove(i);
                }
            }
        }
    }

    public BooleanTrendSelectionNode addItem(BooleanTrend g, IBooleanScalar model, Color c) {
        int i = 0;
        int nb = this.getChildCount();
        boolean found = false;
        String attname = model.getName();
        String devname = attname.substring(0, attname.lastIndexOf(47));
        while (i < nb && !found) {
            found = devname.equals(this.getChild(i).toString());
            if (found) continue;
            ++i;
        }
        BooleanTrendSelectionNode nn = new BooleanTrendSelectionNode(g, devname, model, 0, c);
        if (found) {
            this.getChild(i).add(nn);
        } else {
            BooleanTrendSelectionNode n = new BooleanTrendSelectionNode(g, devname);
            this.add(n);
            n.add(nn);
        }
        return nn;
    }

    public Vector getSelectableItems() {
        Vector<BooleanTrendSelectionNode> v;
        if (this.isLeaf()) {
            v = new Vector<BooleanTrendSelectionNode>();
            v.add(this);
        } else {
            int nb = this.getChildCount();
            v = new Vector();
            for (int i = 0; i < nb; ++i) {
                BooleanTrendSelectionNode child = this.getChild(i);
                v.addAll(child.getSelectableItems());
            }
        }
        return v;
    }

    public void showOptions() {
        if (this.data != null) {
            this.chart.getChart().showDataOptionDialog(this.data);
        }
    }

    public String getModelName() {
        if (this.model != null) {
            return this.model.getName();
        }
        return "";
    }

    public void clearModel() {
        if (this.model != null) {
            this.model.removeBooleanScalarListener((IBooleanScalarListener)this);
            this.model.getProperty("label").removePresentationListener((PropertyChangeListener)this);
            this.model.getProperty("unit").removePresentationListener((PropertyChangeListener)this);
            this.model.getProperty("format").removePresentationListener((PropertyChangeListener)this);
        }
        this.data = null;
        this.model = null;
    }

    public BooleanTrendSelectionNode getChild(int id) {
        return (BooleanTrendSelectionNode)this.getChildAt(id);
    }

    public void booleanScalarChange(BooleanScalarEvent evt) {
        if (this.model == null) {
            return;
        }
        boolean ok = true;
        DataList lv = this.data.getLastValue();
        double x = evt.getTimeStamp();
        boolean y = evt.getValue();
        if (lv != null) {
            boolean bl = lv.x != x || lv.y == 1.0 != y ? true : (ok = false);
        }
        if (ok) {
            this.data.add(evt.getTimeStamp(), evt.getValue() ? 1.0 : 0.0);
            this.chart.getChart().garbageData(this.data);
        }
    }

    public void errorChange(ErrorEvent evt) {
        if (this.model == null) {
            return;
        }
        if (this.lastErrorTime != evt.getTimeStamp()) {
            this.lastErrorTime = evt.getTimeStamp();
            this.data.add(this.lastErrorTime, Double.NaN);
            this.chart.getChart().garbageData(this.data);
        }
    }

    public void stateChange(AttributeStateEvent evt) {
    }

    @Override
    public String toString() {
        if (this.model != null) {
            if (this.model.getLabel().length() > 0 && !this.model.getLabel().equalsIgnoreCase("not specified")) {
                return this.model.getLabel();
            }
            return this.model.getNameSansDevice();
        }
        return this.devname;
    }
}

