/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.DevStateSpectrumEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IDevStateSpectrum;
import fr.esrf.tangoatk.core.IDevStateSpectrumListener;
import fr.esrf.tangoatk.core.Property;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DevStateSpectrumViewer
extends JPanel
implements IDevStateSpectrumListener,
PropertyChangeListener {
    public static final String TOOLTIP_NONE = "None";
    public static final String TOOLTIP_ATTNAME = "Name";
    private Vector<JLabel> labelJLabels = null;
    private Vector<JLabel> colorJLabels = null;
    private Vector<JLabel> stateJLabels = null;
    private Font globalFont = new Font("Dialog", 0, 12);
    private boolean stateLabelVisible = true;
    private boolean stateStringVisible = true;
    private String toolTipMode = "Name";
    private IDevStateSpectrum model = null;
    String[] modelStateLabels = null;
    String modelLabel = null;

    public DevStateSpectrumViewer() {
        this.setLayout(new GridBagLayout());
    }

    public IDevStateSpectrum getModel() {
        return this.model;
    }

    public void setModel(IDevStateSpectrum stateSpec) {
        this.clearModel();
        if (stateSpec == null) {
            return;
        }
        this.model = stateSpec;
        if (!this.model.areAttPropertiesLoaded()) {
            this.model.loadAttProperties();
        }
        this.modelStateLabels = this.model.getStateLabels();
        this.modelLabel = this.model.getLabel();
        this.model.getProperty("label").addPresentationListener((PropertyChangeListener)this);
        this.initComponents();
        this.setVisible(true);
        this.model.addDevStateSpectrumListener((IDevStateSpectrumListener)this);
        this.model.refresh();
    }

    public void clearModel() {
        if (this.model != null) {
            this.model.removeDevStateSpectrumListener((IDevStateSpectrumListener)this);
            this.model.getProperty("label").removePresentationListener((PropertyChangeListener)this);
            this.removeComponents();
            this.model = null;
            this.modelStateLabels = null;
            this.modelLabel = null;
        }
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        String[] stateElements = this.model.getDeviceValue();
        if (stateElements == null || stateElements.length <= 0) {
            return;
        }
        this.labelJLabels = new Vector();
        this.colorJLabels = new Vector();
        this.stateJLabels = new Vector();
        GridBagConstraints gbc = new GridBagConstraints();
        int idx = 0;
        while (idx < stateElements.length) {
            JLabel elemLabel = new JLabel();
            JLabel elemColor = new JLabel();
            JLabel elemState = new JLabel();
            String ttip = null;
            if (this.toolTipMode.equals(TOOLTIP_ATTNAME)) {
                ttip = this.model.getName() + "[" + idx + "]";
            }
            elemLabel.setFont(this.globalFont);
            elemLabel.setBackground(this.getBackground());
            elemLabel.setToolTipText(ttip);
            elemState.setFont(this.globalFont);
            elemState.setBackground(this.getBackground());
            elemState.setText(stateElements[idx]);
            elemState.setToolTipText(ttip);
            elemColor.setPreferredSize(new Dimension(40, 14));
            elemColor.setOpaque(true);
            elemColor.setBackground(ATKConstant.getColor4State(stateElements[idx]));
            elemColor.setToolTipText(ttip);
            if (this.modelStateLabels != null && idx < this.modelStateLabels.length) {
                elemLabel.setText(this.modelStateLabels[idx]);
            } else {
                elemLabel.setText(this.modelLabel + "[" + idx + "]");
            }
            this.labelJLabels.add(elemLabel);
            this.colorJLabels.add(elemColor);
            this.stateJLabels.add(elemState);
            gbc.gridx = 0;
            gbc.gridy = idx;
            gbc.fill = 1;
            gbc.insets = new Insets(5, 5, 5, 5);
            this.add((Component)elemLabel, gbc);
            gbc.gridx = 1;
            gbc.gridy = idx;
            gbc.fill = 1;
            gbc.insets = new Insets(5, 5, 5, 5);
            this.add((Component)elemColor, gbc);
            gbc.gridx = 2;
            gbc.gridy = idx++;
            gbc.fill = 1;
            gbc.insets = new Insets(5, 5, 5, 5);
            this.add((Component)elemState, gbc);
            elemLabel.setVisible(this.stateLabelVisible);
            elemState.setVisible(this.stateStringVisible);
        }
    }

    private void removeComponents() {
        if (this.labelJLabels != null) {
            this.labelJLabels.removeAllElements();
        }
        if (this.colorJLabels != null) {
            this.colorJLabels.removeAllElements();
        }
        if (this.stateJLabels != null) {
            this.stateJLabels.removeAllElements();
        }
        this.removeAll();
        this.labelJLabels = null;
        this.colorJLabels = null;
        this.stateJLabels = null;
    }

    public Font getGlobalFont() {
        return this.globalFont;
    }

    public void setGlobalFont(Font ft) {
        JLabel jlab = null;
        if (ft == null) {
            return;
        }
        this.globalFont = ft;
        if (this.model == null) {
            return;
        }
        int nbStateElements = this.model.getValue().length;
        for (int idx = 0; idx < nbStateElements; ++idx) {
            if (this.labelJLabels != null) {
                try {
                    jlab = this.labelJLabels.get(idx);
                    jlab.setFont(this.globalFont);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.stateJLabels == null) continue;
            try {
                jlab = this.stateJLabels.get(idx);
                jlab.setFont(this.globalFont);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean getStateLabelVisible() {
        return this.stateLabelVisible;
    }

    public void setStateLabelVisible(boolean slv) {
        if (this.stateLabelVisible != slv) {
            this.stateLabelVisible = slv;
            this.changeStateLabelVisibility();
        }
    }

    private void changeStateLabelVisibility() {
        JLabel jlab = null;
        if (this.labelJLabels == null) {
            return;
        }
        for (int idx = 0; idx < this.labelJLabels.size(); ++idx) {
            try {
                jlab = this.labelJLabels.get(idx);
                jlab.setVisible(this.stateLabelVisible);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean getStateStringVisible() {
        return this.stateStringVisible;
    }

    public void setStateStringVisible(boolean ssv) {
        if (this.stateStringVisible != ssv) {
            this.stateStringVisible = ssv;
            this.changeStateStringVisibility();
        }
    }

    private void changeStateStringVisibility() {
        JLabel jlab = null;
        if (this.stateJLabels == null) {
            return;
        }
        for (int idx = 0; idx < this.stateJLabels.size(); ++idx) {
            try {
                jlab = this.stateJLabels.get(idx);
                jlab.setVisible(this.stateStringVisible);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getToolTipMode() {
        return this.toolTipMode;
    }

    public void setToolTipMode(String ttMode) {
        if (ttMode.equalsIgnoreCase(this.toolTipMode)) {
            return;
        }
        this.toolTipMode = ttMode.equalsIgnoreCase(TOOLTIP_ATTNAME) ? TOOLTIP_ATTNAME : TOOLTIP_NONE;
    }

    public void devStateSpectrumChange(DevStateSpectrumEvent evt) {
        String[] newStates = evt.getValue();
        if (newStates == null) {
            this.setAllStates("UNKNOWN");
        } else {
            this.updateSpectrumValues(newStates);
        }
    }

    public void stateChange(AttributeStateEvent e) {
    }

    public void errorChange(ErrorEvent evt) {
        this.setAllStates("UNKNOWN");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Property src = (Property)evt.getSource();
        if (this.model != null && src.getName().equalsIgnoreCase("label")) {
            this.setNewAttLabel(src.getValue().toString());
        }
    }

    private void updateSpectrumValues(String[] newStates) {
        for (int idx = 0; idx < newStates.length; ++idx) {
            if (this.colorJLabels != null) {
                try {
                    JLabel colLab = this.colorJLabels.get(idx);
                    colLab.setBackground(ATKConstant.getColor4State(newStates[idx], this.model.getInvertedOpenCloseForElement(idx), this.model.getInvertedInsertExtractForElement(idx)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.stateJLabels == null) continue;
            try {
                JLabel stateLab = this.stateJLabels.get(idx);
                stateLab.setText(newStates[idx]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setAllStates(String devStateStr) {
        int idx;
        if (this.colorJLabels == null || this.stateJLabels == null) {
            return;
        }
        for (idx = 0; idx < this.colorJLabels.size(); ++idx) {
            try {
                JLabel colLab = this.colorJLabels.get(idx);
                colLab.setBackground(ATKConstant.getColor4State(devStateStr, this.model.getInvertedOpenCloseForElement(idx), this.model.getInvertedInsertExtractForElement(idx)));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (idx = 0; idx < this.stateJLabels.size(); ++idx) {
            try {
                JLabel stateLab = this.stateJLabels.get(idx);
                stateLab.setText(devStateStr);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setNewAttLabel(String newLabel) {
        this.modelLabel = newLabel;
        if (this.labelJLabels == null) {
            return;
        }
        for (int idx = 0; idx < this.labelJLabels.size(); ++idx) {
            JLabel elemLabel = this.labelJLabels.get(idx);
            if (this.modelStateLabels != null && idx < this.modelStateLabels.length) continue;
            elemLabel.setText(this.modelLabel + "[" + idx + "]");
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AttributeList attList = new AttributeList();
                IDevStateSpectrum stateSpectAtt = null;
                try {
                    stateSpectAtt = (IDevStateSpectrum)attList.add("sr/rf-cavi/cav12/SubDevicesStates");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (stateSpectAtt == null) {
                    System.exit(-1);
                }
                attList.startRefresher();
                JFrame mainFrame = new JFrame();
                DevStateSpectrumViewer dssv = new DevStateSpectrumViewer();
                dssv.setModel(stateSpectAtt);
                mainFrame.setContentPane(dssv);
                mainFrame.pack();
                mainFrame.setVisible(true);
            }
        });
    }
}

