/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributePolledList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;

public class DualNumberScalarChart
extends JLChart
implements INumberScalarListener {
    private JLDataView pointView = new JLDataView();
    private JLDataView midleLineView = new JLDataView();
    private int markerStyle = 1;
    private boolean middleLineVisible = true;
    private INumberScalar xattribute = null;
    private INumberScalar yattribute = null;
    private double defaultXMinValue = -100.0;
    private double defaultXMaxValue = 100.0;
    private double defaultXMinAlarm = -100.0;
    private double defaultXMaxAlarm = 100.0;
    private double defaultYMinValue = -100.0;
    private double defaultYMaxValue = 100.0;
    private double defaultYMinAlarm = -100.0;
    private double defaultYMaxAlarm = 100.0;

    public DualNumberScalarChart() {
        this.initComponents();
    }

    public int getMarkerStyle() {
        return this.markerStyle;
    }

    public void setMarkerStyle(int style) {
        this.markerStyle = style;
        if (this.pointView != null) {
            this.pointView.setMarker(this.markerStyle);
            this.repaint();
        }
    }

    protected void initComponents() {
        this.setSize(640, 480);
        this.setHeaderVisible(true);
        this.setLabelVisible(true);
        this.getXAxis().setDrawOpposite(true);
        this.setXAxisOnBottom(false);
        this.setMarkerStyle(this.markerStyle);
        this.getY1Axis().setDrawOpposite(true);
        this.getY1Axis().setAutoScale(false);
        this.getY1Axis().setGridVisible(true);
        this.getY1Axis().setSubGridVisible(true);
        this.getY1Axis().setMinimum(this.defaultYMinValue);
        this.getY1Axis().setMaximum(this.defaultYMaxValue);
        this.getXAxis().setAutoScale(false);
        this.getXAxis().setMinimum(this.defaultXMinValue);
        this.getXAxis().setMaximum(this.defaultXMaxValue);
        this.getXAxis().setAnnotation(2);
        this.getXAxis().setGridVisible(false);
        this.getXAxis().setSubGridVisible(true);
        this.setPaintAxisFirst(false);
    }

    public void setXYModel(INumberScalar axattribute, INumberScalar ayattribute) {
        if (this.xattribute != null || this.yattribute != null) {
            this.clearXYModel();
        }
        if (axattribute == null || ayattribute == null) {
            return;
        }
        this.xattribute = axattribute;
        this.yattribute = ayattribute;
        if (this.xattribute.getMaxValue() > this.defaultXMaxValue) {
            this.setDefaultXMaxValue(this.xattribute.getMaxValue());
        }
        if (this.xattribute.getMaxAlarm() < this.defaultXMaxAlarm) {
            this.setDefaultXMaxAlarm(this.xattribute.getMaxAlarm());
        }
        if (this.xattribute.getMinValue() < this.defaultXMinValue) {
            this.setDefaultXMinValue(this.xattribute.getMinValue());
        }
        if (this.xattribute.getMinAlarm() > this.defaultXMinAlarm) {
            this.setDefaultXMinAlarm(this.xattribute.getMinAlarm());
        }
        if (this.yattribute.getMaxValue() > this.defaultYMaxValue) {
            this.setDefaultYMaxValue(this.yattribute.getMaxValue());
        }
        if (this.yattribute.getMaxAlarm() < this.defaultYMaxAlarm) {
            this.setDefaultYMaxAlarm(this.yattribute.getMaxAlarm());
        }
        if (this.yattribute.getMinValue() < this.defaultYMinValue) {
            this.setDefaultYMinValue(this.yattribute.getMinValue());
        }
        if (this.yattribute.getMinAlarm() > this.defaultYMinAlarm) {
            this.setDefaultYMinAlarm(this.yattribute.getMinAlarm());
        }
        this.setHeader(this.xattribute.getName());
        this.pointView.setName(this.yattribute.getName());
        this.pointView.setLineWidth(2);
        this.pointView.setColor(ATKConstant.getColor4State("VALID"));
        this.pointView.setLabelVisible(true);
        this.pointView.setStyle(1);
        this.pointView.setLineWidth(1);
        this.pointView.setFillStyle(1);
        this.pointView.setMarker(this.markerStyle);
        this.getY1Axis().addDataView(this.pointView);
        this.yattribute.addNumberScalarListener((INumberScalarListener)this);
        this.setMiddleLineVisible(this.middleLineVisible);
        this.midleLineView.setColor(Color.BLACK);
        this.midleLineView.setStyle(0);
        this.midleLineView.setMarker(7);
        this.midleLineView.setName("X middle axis");
        double xmidle = (this.defaultXMaxValue + this.defaultXMinValue) / 2.0;
        this.midleLineView.add(xmidle, this.defaultYMinValue);
        this.midleLineView.add(xmidle, this.defaultYMaxValue);
        this.getY1Axis().addDataView(this.midleLineView);
    }

    public void clearXYModel() {
        if (this.xattribute != null) {
            this.xattribute = null;
        }
        if (this.yattribute != null) {
            this.yattribute.removeNumberScalarListener((INumberScalarListener)this);
            this.yattribute = null;
        }
        this.getY1Axis().clearDataView();
        this.pointView.reset();
        this.midleLineView.reset();
    }

    public boolean isMiddleLineVisible() {
        return this.middleLineVisible;
    }

    public void setMiddleLineVisible(boolean middleLineVisible) {
        this.middleLineVisible = middleLineVisible;
        if (middleLineVisible) {
            this.midleLineView.setLineWidth(1);
        } else {
            this.midleLineView.setLineWidth(0);
        }
    }

    public double getDefaultXMaxAlarm() {
        return this.defaultXMaxAlarm;
    }

    public void setDefaultXMaxAlarm(double defaultXMaxAlarm) {
        this.defaultXMaxAlarm = defaultXMaxAlarm;
    }

    public double getDefaultXMaxValue() {
        return this.defaultXMaxValue;
    }

    public void setDefaultXMaxValue(double defaultXMaxValue) {
        this.defaultXMaxValue = defaultXMaxValue;
        this.getXAxis().setMaximum(defaultXMaxValue);
    }

    public double getDefaultXMinAlarm() {
        return this.defaultXMinAlarm;
    }

    public void setDefaultXMinAlarm(double defaultXMinAlarm) {
        this.defaultXMinAlarm = defaultXMinAlarm;
    }

    public double getDefaultXMinValue() {
        return this.defaultXMinValue;
    }

    public void setDefaultXMinValue(double defaultXMinValue) {
        this.defaultXMinValue = defaultXMinValue;
        this.getXAxis().setMinimum(defaultXMinValue);
    }

    public double getDefaultYMaxAlarm() {
        return this.defaultYMaxAlarm;
    }

    public void setDefaultYMaxAlarm(double defaultYMaxAlarm) {
        this.defaultYMaxAlarm = defaultYMaxAlarm;
    }

    public double getDefaultYMaxValue() {
        return this.defaultYMaxValue;
    }

    public void setDefaultYMaxValue(double defaultYMaxValue) {
        this.defaultYMaxValue = defaultYMaxValue;
        this.getY1Axis().setMaximum(defaultYMaxValue);
    }

    public double getDefaultYMinAlarm() {
        return this.defaultYMinAlarm;
    }

    public void setDefaultYMinAlarm(double defaultYMinAlarm) {
        this.defaultYMinAlarm = defaultYMinAlarm;
    }

    public double getDefaultYMinValue() {
        return this.defaultYMinValue;
    }

    public void setDefaultYMinValue(double defaultYMinValue) {
        this.defaultYMinValue = defaultYMinValue;
        this.getY1Axis().setMinimum(defaultYMinValue);
    }

    public void numberScalarChange(NumberScalarEvent numberScalarEvent) {
        double yvalue = numberScalarEvent.getValue();
        double xvalue = this.xattribute.getNumberScalarValue();
        this.pointView.reset();
        this.pointView.add(xvalue, yvalue);
        if (yvalue <= this.defaultYMinValue || yvalue >= this.defaultYMaxValue) {
            this.pointView.setMarkerColor(ATKConstant.getColor4Quality("INVALID"));
        } else if (yvalue <= this.defaultYMinAlarm || yvalue >= this.defaultYMaxAlarm) {
            this.pointView.setMarkerColor(ATKConstant.getColor4Quality("ALARM"));
        } else if (xvalue >= this.defaultXMaxValue || xvalue <= this.defaultXMinValue) {
            this.pointView.setMarkerColor(ATKConstant.getColor4Quality("INVALID"));
        } else if (xvalue >= this.defaultXMaxAlarm || xvalue <= this.defaultXMinAlarm) {
            this.pointView.setMarkerColor(ATKConstant.getColor4Quality("ALARM"));
        } else {
            this.pointView.setMarkerColor(ATKConstant.getColor4Quality("VALID"));
        }
        this.getY1Axis().addDataView(this.pointView);
        this.repaint();
    }

    public void stateChange(AttributeStateEvent arg0) {
    }

    public void errorChange(ErrorEvent arg0) {
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        DualNumberScalarChart f = new DualNumberScalarChart();
        INumberScalar xattribute = null;
        INumberScalar yattribute = null;
        AttributePolledList attributeList = new AttributePolledList();
        try {
            if (args != null && args.length > 1) {
                xattribute = (INumberScalar)attributeList.add(args[0].trim());
                yattribute = (INumberScalar)attributeList.add(args[1].trim());
            } else {
                xattribute = (INumberScalar)attributeList.add("LT1/AE/CH.1/voltage");
                yattribute = (INumberScalar)attributeList.add("LT1/AE/CH.2/voltage");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        f.setDefaultYMaxValue(1.0);
        f.setDefaultYMinValue(-1.0);
        f.setDefaultXMaxValue(1.0);
        f.setDefaultXMinValue(-1.0);
        f.setMiddleLineVisible(true);
        f.setXYModel(xattribute, yattribute);
        attributeList.startRefresher();
        frame.getContentPane().add((Component)f, "Center");
        frame.setSize(640, 480);
        frame.setTitle(f.getHeader() + " Example 1");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.setVisible(true);
    }
}

