/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.ISpectrumListener;
import fr.esrf.tangoatk.core.NumberSpectrumEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class IconNumberSpectrumViewer
extends JPanel
implements ISpectrumListener {
    protected JLabel[] iconViewers;
    protected Color[] colors;
    protected int columns = 4;
    protected Icon[] icons;
    protected Icon invalidIcon;
    protected INumberSpectrum model;
    protected int rows = 0;
    protected String[][] texts;
    protected double[] oldValue = null;
    protected int horizontalAlignment = 2;
    protected Font font = null;
    protected int spectrumDimension = 0;

    public IconNumberSpectrumViewer() {
        this.initComponents();
    }

    protected void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public void errorChange(ErrorEvent errorEvent) {
    }

    public void stateChange(AttributeStateEvent evt) {
    }

    protected void updateIcon(JLabel icon, int val) {
        try {
            if (val < this.icons.length) {
                icon.setIcon(this.icons[val]);
            } else {
                icon.setIcon(this.getInvalidIcon());
            }
        }
        catch (Exception e) {
            icon.setIcon(this.getInvalidIcon());
        }
    }

    protected void updateText(JLabel icon, String[] texts, int val) {
        try {
            icon.setText(texts[val]);
        }
        catch (Exception e) {
            icon.setText("");
        }
    }

    protected void updateColor(JLabel icon, int val) {
        try {
            if (val < this.colors.length) {
                icon.setBackground(this.colors[val]);
            } else {
                icon.setBackground(this.getBackground());
            }
        }
        catch (Exception e) {
            icon.setBackground(this.getBackground());
        }
    }

    public void spectrumChange(NumberSpectrumEvent numberSpectrumEvent) {
        double[] value = numberSpectrumEvent.getValue();
        if (!Arrays.equals(value, this.oldValue)) {
            this.removeAll();
            this.setLayout(new GridLayout(this.rows, this.columns));
            if (this.spectrumDimension != this.model.getXDimension()) {
                this.spectrumDimension = this.model.getXDimension();
                this.iconViewers = null;
                this.iconViewers = new JLabel[this.spectrumDimension];
                for (i = 0; i < this.iconViewers.length; ++i) {
                    this.iconViewers[i] = new JLabel(Integer.toString(i), this.horizontalAlignment);
                    if (this.font != null) {
                        this.iconViewers[i].setFont(this.font);
                    }
                    this.iconViewers[i].setOpaque(true);
                    this.iconViewers[i].setBorder(BorderFactory.createEtchedBorder());
                    this.add(this.iconViewers[i]);
                }
            } else {
                for (i = 0; i < this.iconViewers.length; ++i) {
                    this.iconViewers[i].setText(Integer.toString(i));
                    this.iconViewers[i].setToolTipText(Integer.toString(i));
                    this.iconViewers[i].setHorizontalAlignment(this.horizontalAlignment);
                    if (this.font != null) {
                        this.iconViewers[i].setFont(this.font);
                    }
                    this.iconViewers[i].setOpaque(true);
                    this.add(this.iconViewers[i]);
                }
            }
            int length = this.iconViewers.length;
            for (int i = 0; i < length; ++i) {
                int val = (int)value[i];
                this.updateIcon(this.iconViewers[i], val);
                if (this.texts != null) {
                    this.updateText(this.iconViewers[i], this.texts[i], val);
                }
                this.updateColor(this.iconViewers[i], val);
            }
            this.updateUI();
            this.oldValue = (double[])value.clone();
        }
    }

    public Color[] getColors() {
        return this.colors;
    }

    public void setColors(Color[] v) {
        this.colors = v;
    }

    public String[][] getTexts() {
        return this.texts;
    }

    public void setTexts(String[][] v) {
        this.texts = v;
    }

    public Icon getInvalidIcon() {
        return this.invalidIcon;
    }

    public void setInvalidIcon(Icon v) {
        this.invalidIcon = v;
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int v) {
        this.columns = v;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int v) {
        this.rows = v;
    }

    public INumberSpectrum getModel() {
        return this.model;
    }

    public void setModel(INumberSpectrum v) {
        if (this.model == null || !this.model.equals(this.model)) {
            if (this.model != null) {
                this.model.removeSpectrumListener((ISpectrumListener)this);
                this.removeAll();
                this.iconViewers = null;
                this.spectrumDimension = 0;
            }
            this.model = v;
            if (this.model != null) {
                this.spectrumDimension = this.model.getXDimension();
                this.iconViewers = new JLabel[this.spectrumDimension];
                this.setLayout(new GridLayout(this.rows, this.columns));
                for (int i = 0; i < this.iconViewers.length; ++i) {
                    this.iconViewers[i] = new JLabel(Integer.toString(i), this.horizontalAlignment);
                    if (this.font != null) {
                        this.iconViewers[i].setFont(this.font);
                    }
                    this.iconViewers[i].setOpaque(true);
                    this.iconViewers[i].setBorder(BorderFactory.createEtchedBorder());
                    this.add(this.iconViewers[i]);
                }
                this.model.addSpectrumListener((ISpectrumListener)this);
            }
        }
    }

    public void setIconBorders(Border border) {
        for (int i = 0; i < this.iconViewers.length; ++i) {
            this.iconViewers[i].setBorder(border);
        }
    }

    public Border getIconBorders() {
        return this.iconViewers[0].getBorder();
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
        if (this.iconViewers == null) {
            return;
        }
        for (int i = 0; i < this.iconViewers.length; ++i) {
            this.iconViewers[i].setFont(font);
            this.iconViewers[i].revalidate();
            this.iconViewers[i].repaint();
        }
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    public void setHorizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        if (this.iconViewers == null) {
            return;
        }
        for (int i = 0; i < this.iconViewers.length; ++i) {
            this.iconViewers[i].setHorizontalAlignment(horizontalAlignment);
            this.iconViewers[i].revalidate();
            this.iconViewers[i].repaint();
        }
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public Icon[] getIcons() {
        return this.icons;
    }

    public void setIcons(Icon[] v) {
        this.icons = v;
    }

    public static void main(String[] args) throws Exception {
        String attributeName = "tests/machine/status/stateOfIDs";
        if (args.length > 0) {
            attributeName = args[0];
        }
        Icon[] icons = new Icon[13];
        AttributeList list = new AttributeList();
        INumberSpectrum ns = (INumberSpectrum)list.add(attributeName);
        IconNumberSpectrumViewer insv = new IconNumberSpectrumViewer();
        icons[0] = new ImageIcon(insv.getClass().getResource("/fr/esrf/tangoatk/widget/icons/bulbDisabled.gif"));
        icons[1] = new ImageIcon(insv.getClass().getResource("/fr/esrf/tangoatk/widget/icons/bulbEnabled.gif"));
        icons[2] = new ImageIcon(insv.getClass().getResource("/fr/esrf/tangoatk/widget/icons/ledBlue.gif"));
        icons[3] = new ImageIcon(insv.getClass().getResource("/fr/esrf/tangoatk/widget/icons/ledBrownGray.gif"));
        icons[4] = new ImageIcon(insv.getClass().getResource("/fr/esrf/tangoatk/widget/icons/ledDarkGray.gif"));
        icons[5] = new ImageIcon(insv.getClass().getResource("/fr/esrf/tangoatk/widget/icons/ledDarkOrange.gif"));
        icons[6] = new ImageIcon(insv.getClass().getResource("/fr/esrf/tangoatk/widget/icons/ledGray.gif"));
        icons[7] = new ImageIcon(insv.getClass().getResource("/fr/esrf/tangoatk/widget/icons/ledGreen.gif"));
        icons[8] = new ImageIcon(insv.getClass().getResource("/fr/esrf/tangoatk/widget/icons/ledLightOrange.gif"));
        icons[9] = new ImageIcon(insv.getClass().getResource("/fr/esrf/tangoatk/widget/icons/ledPink.gif"));
        icons[10] = new ImageIcon(insv.getClass().getResource("/fr/esrf/tangoatk/widget/icons/ledRed.gif"));
        icons[11] = new ImageIcon(insv.getClass().getResource("/fr/esrf/tangoatk/widget/icons/ledWhite.gif"));
        icons[12] = new ImageIcon(insv.getClass().getResource("/fr/esrf/tangoatk/widget/icons/ledYellow.gif"));
        insv.setColumns(4);
        insv.setIcons(icons);
        insv.setModel(ns);
        list.startRefresher();
        JFrame f = new JFrame();
        f.getContentPane().add(insv);
        f.pack();
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }
}

