/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.ISpectrumListener;
import fr.esrf.tangoatk.core.NumberSpectrumEvent;
import fr.esrf.tangoatk.widget.util.JDWAttribute;
import fr.esrf.tangoatk.widget.util.chart.CfFileReader;
import fr.esrf.tangoatk.widget.util.chart.IJLChartListener;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLChartEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import fr.esrf.tangoatk.widget.util.chart.OFormat;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawable;
import java.awt.Color;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.border.EtchedBorder;

public class MultiNumberSpectrumViewer
extends JLChart
implements ISpectrumListener,
IJLChartListener,
JDrawable {
    static String[] exts = new String[]{"graphSettings"};
    public static final String AXIS_X = "X";
    public static final String AXIS_Y1 = "Y1";
    public static final String AXIS_Y2 = "Y2";
    protected final Color[] defColors = new Color[]{Color.red, Color.blue, Color.magenta, Color.cyan, new Color(50, 120, 0), Color.black, new Color(255, 120, 0), Color.pink, Color.green, Color.yellow};
    protected Map<INumberSpectrum, JLDataView> attMap = new HashMap<INumberSpectrum, JLDataView>();
    protected double affineA0 = 0.0;
    protected double affineA1 = 1.0;
    protected String defaultAxis = new String("Y1");
    private Vector<JDWAttribute> dvs = null;

    public MultiNumberSpectrumViewer() {
        this.setBorder(new EtchedBorder());
        this.setBackground(Color.white);
        this.getY1Axis().setAutoScale(true);
        this.getY2Axis().setAutoScale(true);
        this.getXAxis().setAutoScale(true);
        this.getXAxis().setAnnotation(2);
        this.setJLChartListener(this);
    }

    public void addNumberSpectrumModel(INumberSpectrum ins) {
        String attFormat = null;
        JLDataView attDvy = null;
        int orderNumber = 0;
        if (ins == null) {
            return;
        }
        if (this.attMap.containsKey(ins)) {
            return;
        }
        orderNumber = this.attMap.size();
        attFormat = ins.getFormat();
        attDvy = new JLDataView();
        attDvy.setUserFormat(attFormat);
        attDvy.setUnit(ins.getUnit());
        attDvy.setName(ins.getName());
        attDvy.setColor(this.defColors[orderNumber % this.defColors.length]);
        if (this.defaultAxis.equalsIgnoreCase(AXIS_Y1)) {
            this.getY1Axis().addDataView(attDvy);
        } else {
            this.getY2Axis().addDataView(attDvy);
        }
        this.attMap.put(ins, attDvy);
        ins.addSpectrumListener((ISpectrumListener)this);
        ins.refresh();
    }

    public int getJDWAttributeNumber() {
        return this.dvs.size();
    }

    public JDWAttribute getJDWAttribute(int idx) {
        return this.dvs.get(idx);
    }

    public void addNumberSpectrumModel(INumberSpectrum ins, JDWAttribute jdwAtt) {
        if (ins == null) {
            return;
        }
        if (this.attMap.containsKey(ins)) {
            return;
        }
        jdwAtt.dv.setUserFormat(ins.getFormat());
        jdwAtt.dv.setUnit(ins.getUnit());
        jdwAtt.dv.setName(ins.getName());
        if (jdwAtt.axis == 1) {
            this.getY1Axis().addDataView(jdwAtt.dv);
        } else {
            this.getY2Axis().addDataView(jdwAtt.dv);
        }
        this.attMap.put(ins, jdwAtt.dv);
        ins.addSpectrumListener((ISpectrumListener)this);
        ins.refresh();
    }

    public void addNumberSpectrumModel(INumberSpectrum ins, String axis) {
        String attFormat = null;
        JLDataView attDvy = null;
        int orderNumber = 0;
        if (this.defaultAxis.equalsIgnoreCase(axis)) {
            this.addNumberSpectrumModel(ins);
            return;
        }
        if (axis.equalsIgnoreCase(AXIS_X)) {
            this.addNumberSpectrumModelToX(ins);
            return;
        }
        if (ins == null) {
            return;
        }
        if (this.attMap.containsKey(ins)) {
            return;
        }
        orderNumber = this.attMap.size();
        attFormat = ins.getFormat();
        attDvy = new JLDataView();
        attDvy.setUserFormat(attFormat);
        attDvy.setUnit(ins.getUnit());
        attDvy.setName(ins.getName());
        attDvy.setColor(this.defColors[orderNumber % this.defColors.length]);
        if (axis.equalsIgnoreCase(AXIS_Y1)) {
            this.getY1Axis().addDataView(attDvy);
        } else {
            this.getY2Axis().addDataView(attDvy);
        }
        this.attMap.put(ins, attDvy);
        ins.addSpectrumListener((ISpectrumListener)this);
        ins.refresh();
    }

    protected void addNumberSpectrumModelToX(INumberSpectrum ins) {
        String attFormat = null;
        JLDataView attDvx = null;
        boolean orderNumber = false;
        if (ins == null) {
            return;
        }
        if (this.attMap.containsKey(ins)) {
            return;
        }
        if (this.getXAxis().getViewNumber() > 0) {
            Set<INumberSpectrum> attSet;
            JLDataView dvx = this.getXAxis().getDataView(0);
            if (this.attMap.containsValue(dvx) && (attSet = this.attMap.keySet()) != null) {
                for (INumberSpectrum currIns : attSet) {
                    JLDataView attDv = this.attMap.get(currIns);
                    if (attDv != dvx) continue;
                    currIns.removeSpectrumListener((ISpectrumListener)this);
                    this.attMap.remove(currIns);
                    break;
                }
            }
            this.getXAxis().clearDataView();
        }
        attFormat = ins.getFormat();
        attDvx = new JLDataView();
        attDvx.setUserFormat(attFormat);
        attDvx.setUnit(ins.getUnit());
        attDvx.setName(ins.getName());
        this.getXAxis().addDataView(attDvx);
        this.attMap.put(ins, attDvx);
        ins.addSpectrumListener((ISpectrumListener)this);
        ins.refresh();
    }

    public void removeNumberSpectrumModel(INumberSpectrum ins) {
        Object attFormat = null;
        JLDataView attDvy = null;
        boolean contained = false;
        if (ins == null) {
            return;
        }
        if (!this.attMap.containsKey(ins)) {
            return;
        }
        attDvy = this.attMap.get(ins);
        ins.removeSpectrumListener((ISpectrumListener)this);
        this.attMap.remove(ins);
        if (attDvy == null) {
            return;
        }
        JLAxis dvAxis = attDvy.getAxis();
        if (dvAxis == this.getY1Axis()) {
            this.getY1Axis().removeDataView(attDvy);
        } else if (dvAxis == this.getY2Axis()) {
            this.getY2Axis().removeDataView(attDvy);
        } else {
            this.getXAxis().removeDataView(attDvy);
        }
    }

    public void clearModel() {
        Set<INumberSpectrum> attSet = null;
        JLDataView attDvy = null;
        INumberSpectrum ins2 = null;
        boolean contained = false;
        if (this.attMap == null) {
            return;
        }
        attSet = this.attMap.keySet();
        if (attSet == null) {
            return;
        }
        for (INumberSpectrum ins2 : attSet) {
            attDvy = this.attMap.get(ins2);
            ins2.removeSpectrumListener((ISpectrumListener)this);
            if (attDvy == null || (contained = this.getY1Axis().checkRemoveDataView(attDvy))) continue;
            this.getY2Axis().removeDataView(attDvy);
        }
        this.attMap = new HashMap<INumberSpectrum, JLDataView>();
    }

    public JLDataView getDataView(INumberSpectrum ins) {
        if (ins == null) {
            return null;
        }
        if (this.attMap == null) {
            return null;
        }
        if (!this.attMap.containsKey(ins)) {
            return null;
        }
        JLDataView attDvy = this.attMap.get(ins);
        return attDvy;
    }

    public String getDefaultAxis() {
        return this.defaultAxis;
    }

    public void setDefaultAxis(String axisName) {
        if (axisName.equalsIgnoreCase(AXIS_Y1)) {
            this.defaultAxis = AXIS_Y1;
        }
        if (axisName.equalsIgnoreCase(AXIS_Y2)) {
            this.defaultAxis = AXIS_Y2;
        }
    }

    public void setXAxisAffineTransform(double a0, double a1) {
        this.affineA0 = a0;
        this.affineA1 = a1;
    }

    public String setSettings(String cfg) {
        boolean renew;
        CfFileReader f = new CfFileReader();
        if (!f.parseText(cfg)) {
            return "MultiNumberSpectrumViewer.setSettings: Failed to parse given config";
        }
        this.applyConfiguration(f);
        Vector<String> p = f.getParam("xaxis_transform");
        if (p != null) {
            this.setXAxisAffineTransform(OFormat.getDouble(p.get(0).toString()), OFormat.getDouble(p.get(1).toString()));
        }
        this.getXAxis().applyConfiguration("x", f);
        this.getY1Axis().applyConfiguration("y1", f);
        this.getY2Axis().applyConfiguration("y2", f);
        p = f.getParam("dv_number");
        if (p == null) {
            return "MultiNumberSpectrumViewer.setSettings: dv_number not found";
        }
        int nbDv = OFormat.getInt(p.get(0).toString());
        boolean bl = renew = this.dvs == null || this.dvs.size() != nbDv;
        if (renew) {
            this.dvs = new Vector();
        }
        for (int i = 0; i < nbDv; ++i) {
            String prefix = "dv" + Integer.toString(i);
            String pName = prefix + "_att";
            p = f.getParam(pName);
            if (p == null) {
                return "MultiNumberSpectrumViewer.setSettings: " + pName + " not found";
            }
            String attName = p.get(0).toString();
            String aName = prefix + "_axis";
            p = f.getParam(aName);
            if (p == null) {
                return "MultiNumberSpectrumViewer.setSettings: " + aName + " not found";
            }
            int axis = OFormat.getInt(p.get(0).toString());
            JDWAttribute jdwAtt = renew ? new JDWAttribute() : this.dvs.get(i);
            jdwAtt.attName = attName;
            jdwAtt.axis = axis;
            jdwAtt.dv = new JLDataView();
            jdwAtt.dv.applyConfiguration(prefix, f);
            if (!renew) continue;
            this.dvs.add(jdwAtt);
        }
        return "";
    }

    public String getSettings() {
        Object to_write = "";
        to_write = (String)to_write + this.getConfiguration();
        to_write = (String)to_write + "xaxis_transform:" + this.affineA0 + "," + this.affineA1 + "\n";
        to_write = (String)to_write + this.getXAxis().getConfiguration("x");
        to_write = (String)to_write + this.getY1Axis().getConfiguration("y1");
        to_write = (String)to_write + this.getY2Axis().getConfiguration("y2");
        to_write = (String)to_write + "dv_number:" + this.dvs.size() + "\n";
        for (int i = 0; i < this.dvs.size(); ++i) {
            JDWAttribute jdwAtt = this.dvs.get(i);
            to_write = (String)to_write + "dv" + Integer.toString(i) + "_att:" + jdwAtt.attName + "\n";
            to_write = (String)to_write + "dv" + Integer.toString(i) + "_axis:" + Integer.toString(jdwAtt.axis) + "\n";
            to_write = (String)to_write + jdwAtt.dv.getConfiguration("dv" + Integer.toString(i));
        }
        return to_write;
    }

    @Override
    public void initForEditing() {
        if (this.dvs == null || this.dvs.size() == 0) {
            this.dvs = new Vector();
            JDWAttribute jdwAtt = new JDWAttribute();
            jdwAtt.attName = "my/device/example/my_attribute";
            jdwAtt.dv = new JLDataView();
            this.dvs.add(jdwAtt);
        }
        this.setPreferredSize(new Dimension(400, 300));
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String getDescription(String name) {
        if (name.equalsIgnoreCase("graphSettings")) {
            return this.getHelpString();
        }
        return "";
    }

    @Override
    public String[] getExtensionList() {
        return exts;
    }

    @Override
    public boolean setExtendedParam(String name, String value, boolean popupErr) {
        if (name.equalsIgnoreCase("graphSettings")) {
            String err;
            if (!((String)value).endsWith("\n")) {
                value = (String)value + "\n";
            }
            if ((err = this.setSettings((String)value)).length() > 0) {
                this.showJdrawError(popupErr, "graphSettings", err);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getExtendedParam(String name) {
        if (name.equalsIgnoreCase("graphSettings")) {
            return this.getSettings();
        }
        return "";
    }

    private void showJdrawError(boolean popup, String paramName, String message) {
        String msg = "MultiNumberSpectrumViewer: " + paramName + " incorrect.\n" + message;
        if (popup) {
            JOptionPane.showMessageDialog(null, msg, "Error", 0);
        } else {
            System.out.println("Warning, " + msg);
        }
    }

    @Override
    public String[] clickOnChart(JLChartEvent e) {
        JLDataView attDv = e.getDataView();
        if (attDv == null) {
            return null;
        }
        if (!this.attMap.containsValue(attDv)) {
            return null;
        }
        String nameStr = null;
        String xStr = null;
        String yStr = null;
        nameStr = attDv.getExtendedName() + " " + attDv.getAxis().getAxeName();
        xStr = "X=" + e.getTransformedXValue();
        yStr = "Y=" + attDv.formatValue(e.getTransformedYValue()) + " " + attDv.getUnit();
        String[] str = new String[]{nameStr, xStr, yStr};
        return str;
    }

    public void errorChange(ErrorEvent errorEvent) {
        INumberSpectrum ins = null;
        JLDataView attDvy = null;
        ins = (INumberSpectrum)errorEvent.getSource();
        if (ins == null) {
            return;
        }
        if (this.attMap == null) {
            return;
        }
        if (!this.attMap.containsKey(ins)) {
            return;
        }
        attDvy = this.attMap.get(ins);
        if (attDvy == null) {
            return;
        }
        attDvy.reset();
        this.repaint();
    }

    public void stateChange(AttributeStateEvent evt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spectrumChange(NumberSpectrumEvent evt) {
        INumberSpectrum ins = null;
        JLDataView attDvy = null;
        double[] value = null;
        ins = (INumberSpectrum)evt.getSource();
        if (ins == null) {
            return;
        }
        if (this.attMap == null) {
            return;
        }
        if (!this.attMap.containsKey(ins)) {
            return;
        }
        attDvy = this.attMap.get(ins);
        if (attDvy == null) {
            return;
        }
        value = evt.getValue();
        JLDataView jLDataView = attDvy;
        synchronized (jLDataView) {
            attDvy.reset();
            int length = value.length;
            if (attDvy.getAxis() == this.getXAxis()) {
                for (int i = 0; i < length; ++i) {
                    attDvy.add(i, value[i]);
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    attDvy.add(this.affineA0 + this.affineA1 * (double)i, value[i]);
                }
            }
            this.repaint();
        }
    }

    public static void main(String[] args) {
        AttributeList attl = new AttributeList();
        JFrame jf = new JFrame();
        MultiNumberSpectrumViewer mnsv = new MultiNumberSpectrumViewer();
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                try {
                    INumberSpectrum ins = (INumberSpectrum)attl.add(args[i]);
                    mnsv.addNumberSpectrumModel(ins);
                    continue;
                }
                catch (ClassCastException cce) {
                    System.out.println(args[i] + " is not a valid spectrum");
                    cce.printStackTrace();
                    continue;
                }
                catch (Exception ex) {
                    System.out.println("Cannot connect to " + args[i]);
                    ex.printStackTrace();
                }
            }
        } else {
            try {
                INumberSpectrum ins = (INumberSpectrum)attl.add("jlp/test/1/att_spectrum");
                mnsv.addNumberSpectrumModel(ins);
                ins = (INumberSpectrum)attl.add("jlp/test/2/att_spectrum");
                mnsv.addNumberSpectrumModel(ins);
            }
            catch (Exception ex) {
                System.out.println("Cannot connect to jlp/test/1");
                ex.printStackTrace();
            }
        }
        attl.startRefresher();
        jf.setDefaultCloseOperation(3);
        jf.setContentPane(mnsv);
        jf.setSize(640, 480);
        jf.pack();
        jf.setVisible(true);
    }
}

