/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.BooleanScalarEvent;
import fr.esrf.tangoatk.core.EnumScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IBooleanScalarListener;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IEnumScalar;
import fr.esrf.tangoatk.core.IEnumScalarListener;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.core.IStringScalarListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.core.StringScalarEvent;
import fr.esrf.tangoatk.widget.attribute.BooleanScalarCheckBoxViewer;
import fr.esrf.tangoatk.widget.attribute.ScalarAttributeSetPanel;
import fr.esrf.tangoatk.widget.attribute.SimpleEnumScalarViewer;
import fr.esrf.tangoatk.widget.attribute.SimpleScalarViewer;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RootPaneContainer;
import javax.swing.plaf.BorderUIResource;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class MultiScalarTableViewer
extends JTable {
    protected int nbRows = 0;
    protected int nbColumns = 0;
    protected String[] columnIdents = null;
    protected String[] rowIdents = null;
    protected IEntity[][] entityModels = null;
    protected MultiScalarViewerTableModel tabModel = new MultiScalarViewerTableModel();
    protected MultiScalarCellRendererAndEditor cellRendererAndEditor = null;
    private RowIdentsCellRenderer rowIdentsRenderer = null;
    private ColHeaderCellRenderer colHeadRenderer = null;
    private long firstClickTime = 0L;
    protected boolean alarmEnabled = true;
    protected boolean unitVisible = true;
    protected Color panelBackground = null;
    private RootPaneContainer rpcParent = null;
    private JDialog attSetDialWindow = null;
    private ScalarAttributeSetPanel attSetPanel = null;
    protected boolean noAttModel = true;

    public MultiScalarTableViewer() {
        this.setModel(this.tabModel);
        this.cellRendererAndEditor = new MultiScalarCellRendererAndEditor(this);
        this.rowIdentsRenderer = new RowIdentsCellRenderer();
        this.colHeadRenderer = new ColHeaderCellRenderer();
        this.panelBackground = new Color(235, 235, 235);
        this.setRowMargin(0);
        this.getColumnModel().setColumnMargin(this.getColumnModel().getColumnMargin() + 2);
        this.addMouseListener(this.cellRendererAndEditor);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        if (this.tabModel.getHasRowLabels() && column == 0) {
            return this.rowIdentsRenderer;
        }
        Object obj = this.tabModel.getValueAt(row, column);
        if (obj != null && obj instanceof SimpleScalarViewer) {
            return this.cellRendererAndEditor;
        }
        if (obj != null && obj instanceof SimpleEnumScalarViewer) {
            return this.cellRendererAndEditor;
        }
        if (obj != null && obj instanceof BooleanScalarCheckBoxViewer) {
            return this.cellRendererAndEditor;
        }
        return super.getCellRenderer(row, column);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        Object obj = this.tabModel.getValueAt(row, column);
        if (obj != null && obj instanceof SimpleScalarViewer) {
            return this.cellRendererAndEditor;
        }
        if (obj != null && obj instanceof SimpleEnumScalarViewer) {
            return this.cellRendererAndEditor;
        }
        if (obj != null && obj instanceof BooleanScalarCheckBoxViewer) {
            return this.cellRendererAndEditor;
        }
        return super.getCellEditor(row, column);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.tabModel.isCellEditable(row, column);
    }

    public Color getPanelBackground() {
        return this.panelBackground;
    }

    public void setPanelBackground(Color bg) {
        this.panelBackground = bg;
        this.attSetDialWindow.setBackground(this.panelBackground);
        this.attSetPanel.setBackground(this.panelBackground);
    }

    private void doEdit(int r, int c) {
        int col = c;
        if (this.tabModel.getHasRowLabels()) {
            col = c - 1;
        }
        if (r < 0 || col < 0) {
            return;
        }
        if (r >= this.nbRows || col >= this.nbColumns) {
            return;
        }
        IAttribute iatt = (IAttribute)this.entityModels[r][col];
        if (iatt == null) {
            return;
        }
        if (!iatt.isWritable()) {
            return;
        }
        if (!(iatt instanceof INumberScalar || iatt instanceof IStringScalar || iatt instanceof IEnumScalar)) {
            return;
        }
        if (this.attSetDialWindow == null || this.attSetPanel == null) {
            this.creatScalarSetWindows();
        }
        if (this.attSetDialWindow == null || this.attSetPanel == null) {
            return;
        }
        if (this.attSetPanel.getAttModel() != iatt) {
            this.attSetDialWindow.setVisible(false);
            this.attSetPanel.setAttModel(iatt);
            this.attSetDialWindow.setTitle(iatt.getName());
            this.attSetDialWindow.pack();
        }
        ATKGraphicsUtils.centerDialog(this.attSetDialWindow);
        this.attSetDialWindow.setVisible(true);
    }

    private void creatScalarSetWindows() {
        Container parent = this;
        while (this.rpcParent == null && (parent = parent.getParent()) != null) {
            if (!(parent instanceof RootPaneContainer)) continue;
            this.rpcParent = (RootPaneContainer)((Object)parent);
            break;
        }
        if (this.rpcParent != null) {
            System.out.println("MultiScalarTableViewer : the parent class (implementing RootPaneContainer) is : " + this.rpcParent.getClass().getName());
        }
        this.attSetDialWindow = this.rpcParent == null ? new JDialog() : (this.rpcParent instanceof Frame ? new JDialog((Frame)((Object)this.rpcParent)) : (this.rpcParent instanceof Dialog ? new JDialog((Dialog)((Object)this.rpcParent)) : new JDialog()));
        this.attSetDialWindow.getContentPane().setLayout(new GridBagLayout());
        this.attSetDialWindow.getContentPane().setBackground(this.panelBackground);
        this.attSetPanel = new ScalarAttributeSetPanel();
        this.attSetPanel.setBackground(this.panelBackground);
        this.attSetPanel.setFont(this.getFont());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.attSetDialWindow.getContentPane().add((Component)this.attSetPanel, gbc);
        JButton dismissButton = new JButton();
        dismissButton.setText("Dismiss");
        dismissButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiScalarTableViewer.this.attSetDialWindow.setVisible(false);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 10;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.attSetDialWindow.getContentPane().add((Component)dismissButton, gbc);
    }

    public int getNbRows() {
        return this.nbRows;
    }

    public void setNbRows(int nr) {
        if (nr <= 0) {
            return;
        }
        if (this.entityModels != null) {
            return;
        }
        if (this.rowIdents != null && nr != this.rowIdents.length) {
            return;
        }
        this.nbRows = nr;
    }

    public int getNbColumns() {
        return this.nbColumns;
    }

    public void setNbColumns(int nc) {
        if (nc <= 0) {
            return;
        }
        if (this.entityModels != null) {
            return;
        }
        if (this.columnIdents != null && nc != this.columnIdents.length) {
            return;
        }
        this.nbColumns = nc;
    }

    public String[] getColumnIdents() {
        return this.columnIdents;
    }

    public void setColumnIdents(String[] colIds) {
        if (colIds == null) {
            this.columnIdents = null;
            return;
        }
        if (this.entityModels != null && this.entityModels[0].length != colIds.length) {
            return;
        }
        if (this.entityModels == null) {
            this.nbColumns = colIds.length;
        }
        this.columnIdents = colIds;
        if (this.noAttModel && this.nbRows > 0) {
            this.initAttModels();
        }
    }

    public String[] getRowIdents() {
        return this.rowIdents;
    }

    public void setRowIdents(String[] rowIds) {
        if (rowIds == null) {
            this.rowIdents = null;
            return;
        }
        if (this.entityModels != null && this.entityModels.length != rowIds.length) {
            return;
        }
        if (this.entityModels == null) {
            this.nbRows = rowIds.length;
        }
        this.rowIdents = rowIds;
        if (this.noAttModel && this.nbColumns > 0) {
            this.initAttModels();
        }
    }

    public boolean getAlarmEnabled() {
        return this.alarmEnabled;
    }

    public void setAlarmEnabled(boolean alarm) {
        if (this.alarmEnabled == alarm) {
            return;
        }
        this.alarmEnabled = alarm;
        if (this.entityModels == null) {
            return;
        }
        for (int i = 0; i < this.entityModels.length; ++i) {
            for (int j = 0; j < this.entityModels[i].length; ++j) {
                Object obj;
                int col = j;
                if (this.tabModel.getHasRowLabels()) {
                    col = j + 1;
                }
                if (!((obj = this.tabModel.getValueAt(i, col)) instanceof SimpleScalarViewer)) continue;
                SimpleScalarViewer ssv = (SimpleScalarViewer)obj;
                ssv.setAlarmEnabled(this.alarmEnabled);
            }
        }
    }

    public boolean getUnitVisible() {
        return this.unitVisible;
    }

    public void setUnitVisible(boolean b) {
        if (this.unitVisible == b) {
            return;
        }
        this.unitVisible = b;
        if (this.attSetPanel != null) {
            this.attSetPanel.setUnitVisible(this.unitVisible);
        }
        if (this.entityModels == null) {
            return;
        }
        for (int i = 0; i < this.entityModels.length; ++i) {
            for (int j = 0; j < this.entityModels[i].length; ++j) {
                Object obj;
                int col = j;
                if (this.tabModel.getHasRowLabels()) {
                    col = j + 1;
                }
                if (!((obj = this.tabModel.getValueAt(i, col)) instanceof SimpleScalarViewer)) continue;
                SimpleScalarViewer ssv = (SimpleScalarViewer)obj;
                ssv.setUnitVisible(this.unitVisible);
            }
        }
    }

    public JLabel getRowIdCellRenderer() {
        return this.rowIdentsRenderer;
    }

    public IEntity[][] getEntityModels() {
        return this.entityModels;
    }

    public void setModelAt(IAttribute iatt, int r, int c) {
        boolean supportedAttribute = false;
        if (this.nbRows <= 0 || this.nbColumns <= 0) {
            System.out.println("Please set the number of columns and rows of the table before calling setModelAt.");
            return;
        }
        if (iatt instanceof INumberScalar || iatt instanceof IStringScalar || iatt instanceof IEnumScalar || iatt instanceof IBooleanScalar) {
            supportedAttribute = true;
        }
        if (!supportedAttribute) {
            System.out.println("Unsupported type of attribute; setModelAt failed.");
            return;
        }
        if (this.entityModels == null) {
            this.initAttModels();
        }
        if (this.noAttModel) {
            this.noAttModel = false;
        }
        if (r < 0 || c < 0) {
            return;
        }
        if (r >= this.nbRows || c >= this.nbColumns) {
            return;
        }
        this.clearModelAt(r, c);
        if (iatt == null) {
            return;
        }
        this.entityModels[r][c] = iatt;
        if (iatt instanceof INumberScalar) {
            INumberScalar ins = (INumberScalar)iatt;
            this.addAttributeAt(ins, r, c);
            return;
        }
        if (iatt instanceof IStringScalar) {
            IStringScalar iss = (IStringScalar)iatt;
            this.addAttributeAt(iss, r, c);
            return;
        }
        if (iatt instanceof IEnumScalar) {
            IEnumScalar ies = (IEnumScalar)iatt;
            this.addAttributeAt(ies, r, c);
            return;
        }
        if (iatt instanceof IBooleanScalar) {
            IBooleanScalar ibs = (IBooleanScalar)iatt;
            this.addAttributeAt(ibs, r, c);
            return;
        }
    }

    private void addAttributeAt(INumberScalar ins, int r, int c) {
        SimpleScalarViewer ssViewer = new SimpleScalarViewer();
        ssViewer.setBackgroundColor(this.getBackground());
        ssViewer.setFont(this.getFont());
        ssViewer.setModel(ins);
        ssViewer.setAlarmEnabled(this.alarmEnabled);
        ssViewer.setUnitVisible(this.unitVisible);
        ssViewer.setHasToolTip(true);
        if ((double)this.rowHeight < ssViewer.getPreferredSize().getHeight()) {
            this.rowHeight = (int)ssViewer.getPreferredSize().getHeight();
        }
        this.tabModel.addAttributeAt(r, c, (IAttribute)ins, ssViewer);
    }

    private void addAttributeAt(IStringScalar iss, int r, int c) {
        SimpleScalarViewer ssViewer = new SimpleScalarViewer();
        ssViewer.setBackgroundColor(this.getBackground());
        ssViewer.setFont(this.getFont());
        ssViewer.setModel(iss);
        ssViewer.setAlarmEnabled(this.alarmEnabled);
        ssViewer.setHasToolTip(true);
        if ((double)this.rowHeight < ssViewer.getPreferredSize().getHeight()) {
            this.rowHeight = (int)ssViewer.getPreferredSize().getHeight();
        }
        this.tabModel.addAttributeAt(r, c, (IAttribute)iss, ssViewer);
    }

    private void addAttributeAt(IEnumScalar ies, int r, int c) {
        SimpleEnumScalarViewer enumViewer = new SimpleEnumScalarViewer();
        enumViewer.setBackgroundColor(this.getBackground());
        enumViewer.setFont(this.getFont());
        enumViewer.setModel(ies);
        enumViewer.setAlarmEnabled(this.alarmEnabled);
        if ((double)this.rowHeight < enumViewer.getPreferredSize().getHeight()) {
            this.rowHeight = (int)enumViewer.getPreferredSize().getHeight();
        }
        this.tabModel.addAttributeAt(r, c, (IAttribute)ies, enumViewer);
    }

    private void addAttributeAt(IBooleanScalar ibs, int r, int c) {
        BooleanScalarCheckBoxViewer boolCbViewer = new BooleanScalarCheckBoxViewer();
        boolCbViewer.setBorderPainted(true);
        boolCbViewer.setBorder(BorderUIResource.getEtchedBorderUIResource());
        boolCbViewer.setBackground(this.getBackground());
        boolCbViewer.setFont(this.getFont());
        boolCbViewer.setAttModel(ibs);
        boolCbViewer.setTrueLabel(new String());
        boolCbViewer.setFalseLabel(new String());
        boolCbViewer.setHasToolTip(true);
        boolCbViewer.setHorizontalAlignment(0);
        if ((double)this.rowHeight < boolCbViewer.getPreferredSize().getHeight()) {
            this.rowHeight = (int)boolCbViewer.getPreferredSize().getHeight();
        }
        this.tabModel.addAttributeAt(r, c, (IAttribute)ibs, boolCbViewer);
    }

    public void clearModelAt(int r, int c) {
        if (this.entityModels == null) {
            return;
        }
        if (this.nbRows <= 0 || this.nbColumns <= 0) {
            System.out.println("Please set the number of columns and rows before calling clearModelAt.");
            return;
        }
        if (r < 0 || c < 0) {
            return;
        }
        if (r >= this.nbRows || c >= this.nbColumns) {
            return;
        }
        if (this.entityModels[r][c] == null) {
            return;
        }
        if (this.entityModels[r][c] instanceof IAttribute) {
            this.tabModel.removeAttributeAt(r, c);
            this.entityModels[r][c] = null;
        }
    }

    public void clearModel() {
        if (this.entityModels == null) {
            return;
        }
        for (int i = 0; i < this.entityModels.length; ++i) {
            for (int j = 0; j < this.entityModels[i].length; ++j) {
                this.clearModelAt(i, j);
            }
        }
        this.entityModels = null;
        this.noAttModel = true;
        this.columnIdents = null;
        this.rowIdents = null;
        this.nbRows = 0;
        this.nbColumns = 0;
        this.tabModel.setColumnCount(0);
        this.tabModel.setRowCount(0);
        this.tabModel = new MultiScalarViewerTableModel();
        this.setModel(this.tabModel);
    }

    protected void initAttModels() {
        if (this.nbRows <= 0 || this.nbColumns <= 0) {
            System.out.println("Please set the number of columns and rows before calling initAttModels.");
            return;
        }
        TableModel tm = super.getModel();
        if (!(tm instanceof MultiScalarViewerTableModel)) {
            this.tabModel = new MultiScalarViewerTableModel();
            this.setModel(this.tabModel);
        }
        this.entityModels = new IEntity[this.nbRows][this.nbColumns];
        for (int i = 0; i < this.nbRows; ++i) {
            for (int j = 0; j < this.nbColumns; ++j) {
                this.entityModels[i][j] = null;
            }
        }
        if (this.columnIdents == null) {
            this.columnIdents = new String[this.nbColumns];
        }
        this.tabModel.init();
        this.initColumnHeaderRenderers();
    }

    protected void initColumnHeaderRenderers() {
        if (this.columnIdents == null) {
            return;
        }
        for (int i = 0; i < this.columnIdents.length; ++i) {
            try {
                TableColumn tc = this.getColumn(this.columnIdents[i]);
                tc.setHeaderRenderer(this.colHeadRenderer);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) {
        String[] colLabs = new String[]{"att_un", "att_deux", "att_trois", "att_cinq", "att_six", "att_bool"};
        String[] rowLabs = new String[]{"jlp/test/1", "jlp/test/2"};
        AttributeList attl = new AttributeList();
        JFrame f = new JFrame();
        MultiScalarTableViewer mstv = new MultiScalarTableViewer();
        IAttribute[][] attArray = null;
        mstv.setUnitVisible(false);
        mstv.setFont(new Font("Dialog", 0, 16));
        mstv.setNbRows(2);
        mstv.setNbColumns(6);
        mstv.setRowIdents(rowLabs);
        mstv.setColumnIdents(colLabs);
        attArray = new IAttribute[2][6];
        try {
            IAttribute att;
            attArray[0][0] = att = (IAttribute)attl.add("jlp/test/1/att_un");
            mstv.setModelAt(att, 0, 0);
            attArray[0][1] = att = (IAttribute)attl.add("jlp/test/1/att_deux");
            mstv.setModelAt(att, 0, 1);
            attArray[0][2] = att = (IAttribute)attl.add("jlp/test/1/att_trois");
            mstv.setModelAt(att, 0, 2);
            attArray[0][3] = att = (IAttribute)attl.add("jlp/test/1/att_cinq");
            mstv.setModelAt(att, 0, 3);
            attArray[0][4] = att = (IAttribute)attl.add("jlp/test/1/att_six");
            mstv.setModelAt(att, 0, 4);
            attArray[0][5] = att = (IAttribute)attl.add("jlp/test/1/att_boolean");
            mstv.setModelAt(att, 0, 5);
            attArray[1][0] = att = (IAttribute)attl.add("jlp/test/2/att_un");
            mstv.setModelAt(att, 1, 0);
            attArray[1][1] = att = (IAttribute)attl.add("jlp/test/2/att_deux");
            mstv.setModelAt(att, 1, 1);
            attArray[1][2] = att = (IAttribute)attl.add("jlp/test/2/att_trois");
            mstv.setModelAt(att, 1, 2);
            attArray[1][3] = att = (IAttribute)attl.add("jlp/test/2/att_cinq");
            mstv.setModelAt(att, 1, 3);
            attArray[1][4] = att = (IAttribute)attl.add("jlp/test/2/att_six");
            mstv.setModelAt(att, 1, 4);
            attArray[1][5] = att = (IAttribute)attl.add("jlp/test/2/att_boolean");
            mstv.setModelAt(att, 1, 5);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("Cannot connect to jlp/test/1");
        }
        attl.startRefresher();
        mstv.setPreferredScrollableViewportSize(new Dimension(700, 70));
        JScrollPane scrollPane = new JScrollPane(mstv);
        f.setContentPane(scrollPane);
        f.setDefaultCloseOperation(3);
        f.pack();
        f.setVisible(true);
        try {
            System.in.read();
        }
        catch (Exception ex) {
            System.out.println("cannot read");
        }
        mstv.clearModel();
        mstv.setNbRows(2);
        mstv.setNbColumns(6);
        mstv.setRowIdents(rowLabs);
        mstv.setColumnIdents(colLabs);
    }

    protected class MultiScalarViewerTableModel
    extends DefaultTableModel
    implements INumberScalarListener,
    IStringScalarListener,
    IEnumScalarListener,
    IBooleanScalarListener {
        protected boolean hasRowLabels = false;
        protected HashMap<IEntity, ArrayList<Integer>> entityMap = new HashMap();
        protected Object[][] tableData = null;

        protected MultiScalarViewerTableModel() {
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            IAttribute iatt;
            IEntity ient = this.getEntity(row, column);
            if (ient == null) {
                return false;
            }
            return ient instanceof IAttribute && (iatt = (IAttribute)ient).isWritable();
        }

        private IEntity getEntity(int row, int column) {
            if (row < 0 || column < 0) {
                return null;
            }
            if (this.tableData == null) {
                return null;
            }
            if (MultiScalarTableViewer.this.entityModels == null) {
                return null;
            }
            int col = column;
            if (row < MultiScalarTableViewer.this.entityModels.length) {
                if (this.hasRowLabels) {
                    --col;
                }
                if (col < MultiScalarTableViewer.this.entityModels[0].length) {
                    IEntity ie = MultiScalarTableViewer.this.entityModels[row][col];
                    return ie;
                }
            }
            return null;
        }

        protected void init() {
            if (MultiScalarTableViewer.this.entityModels == null) {
                return;
            }
            if (MultiScalarTableViewer.this.entityModels.length != MultiScalarTableViewer.this.nbRows) {
                MultiScalarTableViewer.this.nbRows = MultiScalarTableViewer.this.entityModels.length;
            }
            if (MultiScalarTableViewer.this.entityModels[0].length != MultiScalarTableViewer.this.nbColumns) {
                MultiScalarTableViewer.this.nbColumns = MultiScalarTableViewer.this.entityModels[0].length;
            }
            if (MultiScalarTableViewer.this.rowIdents != null && MultiScalarTableViewer.this.rowIdents.length != MultiScalarTableViewer.this.nbRows) {
                MultiScalarTableViewer.this.rowIdents = null;
            }
            if (MultiScalarTableViewer.this.rowIdents != null) {
                this.hasRowLabels = true;
                Object[] colIds = null;
                if (MultiScalarTableViewer.this.columnIdents != null) {
                    colIds = new String[MultiScalarTableViewer.this.columnIdents.length + 1];
                    colIds[0] = " ";
                    for (j = 0; j < MultiScalarTableViewer.this.columnIdents.length; ++j) {
                        colIds[j + 1] = MultiScalarTableViewer.this.columnIdents[j];
                    }
                } else {
                    colIds = new String[MultiScalarTableViewer.this.nbColumns + 1];
                    for (j = 0; j < MultiScalarTableViewer.this.nbColumns + 1; ++j) {
                        colIds[j] = " ";
                    }
                }
                this.tableData = new Object[MultiScalarTableViewer.this.entityModels.length][MultiScalarTableViewer.this.entityModels[0].length + 1];
                this.setDataVector(this.tableData, colIds);
                for (int i = 0; i < MultiScalarTableViewer.this.nbRows; ++i) {
                    this.setValueAt(MultiScalarTableViewer.this.rowIdents[i], i, 0);
                }
            } else {
                this.tableData = new Object[MultiScalarTableViewer.this.entityModels.length][MultiScalarTableViewer.this.entityModels[0].length];
                this.setDataVector(this.tableData, MultiScalarTableViewer.this.columnIdents);
            }
        }

        void addAttributeAt(int r, int c, IAttribute iatt, SimpleScalarViewer ssViewer) {
            INumberScalar ins = null;
            IStringScalar iss = null;
            if (iatt instanceof INumberScalar) {
                ins = (INumberScalar)iatt;
            } else if (iatt instanceof IStringScalar) {
                iss = (IStringScalar)iatt;
            }
            if (ins == null && iss == null) {
                return;
            }
            if (ins != null) {
                ins.addNumberScalarListener((INumberScalarListener)this);
            } else if (iss != null) {
                iss.addStringScalarListener((IStringScalarListener)this);
            }
            int col = c;
            if (this.hasRowLabels) {
                col = c + 1;
            }
            this.setValueAt(ssViewer, r, col);
            ArrayList<Integer> attIndexes = new ArrayList<Integer>();
            attIndexes.add(0, new Integer(r));
            attIndexes.add(1, new Integer(col));
            if (!this.entityMap.containsKey(iatt)) {
                this.entityMap.put((IEntity)iatt, attIndexes);
            }
            this.fireTableDataChanged();
        }

        void addAttributeAt(int r, int c, IAttribute iatt, SimpleEnumScalarViewer enumViewer) {
            IEnumScalar ies = null;
            if (iatt instanceof IEnumScalar) {
                ies = (IEnumScalar)iatt;
            }
            if (ies == null) {
                return;
            }
            int col = c;
            if (this.hasRowLabels) {
                col = c + 1;
            }
            ies.addEnumScalarListener((IEnumScalarListener)this);
            this.setValueAt(enumViewer, r, col);
            ArrayList<Integer> attIndexes = new ArrayList<Integer>();
            attIndexes.add(0, new Integer(r));
            attIndexes.add(1, new Integer(col));
            if (!this.entityMap.containsKey(iatt)) {
                this.entityMap.put((IEntity)iatt, attIndexes);
            }
            this.fireTableDataChanged();
        }

        void addAttributeAt(int r, int c, IAttribute iatt, BooleanScalarCheckBoxViewer boolViewer) {
            IBooleanScalar ibs = null;
            if (iatt instanceof IBooleanScalar) {
                ibs = (IBooleanScalar)iatt;
            }
            if (ibs == null) {
                return;
            }
            int col = c;
            if (this.hasRowLabels) {
                col = c + 1;
            }
            ibs.addBooleanScalarListener((IBooleanScalarListener)this);
            this.setValueAt(boolViewer, r, col);
            ArrayList<Integer> attIndexes = new ArrayList<Integer>();
            attIndexes.add(0, new Integer(r));
            attIndexes.add(1, new Integer(col));
            if (!this.entityMap.containsKey(iatt)) {
                this.entityMap.put((IEntity)iatt, attIndexes);
            }
            this.fireTableDataChanged();
        }

        protected void removeAttributeAt(int r, int c) {
            Object obj;
            int col = c;
            if (this.hasRowLabels) {
                col = c + 1;
            }
            if ((obj = this.getValueAt(r, col)) == null) {
                return;
            }
            if (obj instanceof SimpleScalarViewer) {
                SimpleScalarViewer ssv = (SimpleScalarViewer)obj;
                this.removeAttributeAt(ssv, r, col);
                return;
            }
            if (obj instanceof SimpleEnumScalarViewer) {
                SimpleEnumScalarViewer enumv = (SimpleEnumScalarViewer)obj;
                this.removeAttributeAt(enumv, r, col);
                return;
            }
            if (obj instanceof BooleanScalarCheckBoxViewer) {
                BooleanScalarCheckBoxViewer boolv = (BooleanScalarCheckBoxViewer)obj;
                this.removeAttributeAt(boolv, r, col);
                return;
            }
        }

        private void removeAttributeAt(SimpleScalarViewer ssv, int r, int c) {
            INumberScalar ins = ssv.getNumberModel();
            IStringScalar iss = ssv.getStringModel();
            if (ins != null) {
                if (this.entityMap.containsKey(ins)) {
                    this.entityMap.remove(ins);
                }
                ins.removeNumberScalarListener((INumberScalarListener)this);
            } else if (iss != null) {
                if (this.entityMap.containsKey(iss)) {
                    this.entityMap.remove(iss);
                }
                iss.removeStringScalarListener((IStringScalarListener)this);
            }
            ssv.clearModel();
            ssv = null;
            this.setValueAt(null, r, c);
            this.fireTableDataChanged();
        }

        private void removeAttributeAt(SimpleEnumScalarViewer enumv, int r, int c) {
            IEnumScalar ies = enumv.getModel();
            if (ies != null) {
                if (this.entityMap.containsKey(ies)) {
                    this.entityMap.remove(ies);
                }
                ies.removeEnumScalarListener((IEnumScalarListener)this);
            }
            enumv.clearModel();
            enumv = null;
            this.setValueAt(null, r, c);
            this.fireTableDataChanged();
        }

        private void removeAttributeAt(BooleanScalarCheckBoxViewer boolv, int r, int c) {
            IBooleanScalar ibs = boolv.getAttModel();
            if (ibs != null) {
                if (this.entityMap.containsKey(ibs)) {
                    this.entityMap.remove(ibs);
                }
                ibs.removeBooleanScalarListener((IBooleanScalarListener)this);
            }
            boolv.clearModel();
            boolv = null;
            this.setValueAt(null, r, c);
            this.fireTableDataChanged();
        }

        boolean getHasRowLabels() {
            return this.hasRowLabels;
        }

        public void stateChange(AttributeStateEvent evt) {
            IAttribute iatt = (IAttribute)evt.getSource();
            this.doUpdateAttCell(iatt);
        }

        public void errorChange(ErrorEvent evt) {
            Object src = evt.getSource();
            if (src instanceof IAttribute) {
                IAttribute ia = (IAttribute)src;
                this.doUpdateAttCell(ia);
            }
        }

        public void numberScalarChange(NumberScalarEvent evt) {
            INumberScalar ins = evt.getNumberSource();
            this.doUpdateAttCell((IAttribute)ins);
        }

        public void stringScalarChange(StringScalarEvent evt) {
            IStringScalar iss = (IStringScalar)evt.getSource();
            this.doUpdateAttCell((IAttribute)iss);
        }

        public void enumScalarChange(EnumScalarEvent evt) {
            IEnumScalar ies = (IEnumScalar)evt.getSource();
            this.doUpdateAttCell((IAttribute)ies);
        }

        public void booleanScalarChange(BooleanScalarEvent evt) {
            IBooleanScalar ibs = (IBooleanScalar)evt.getSource();
            this.doUpdateAttCell((IAttribute)ibs);
        }

        protected void doUpdateAttCell(IAttribute iatt) {
            if (!this.entityMap.containsKey(iatt)) {
                return;
            }
            ArrayList<Integer> attIndexes = this.entityMap.get(iatt);
            if (attIndexes == null) {
                return;
            }
            if (attIndexes.size() >= 2) {
                Integer indObj = attIndexes.get(0);
                int row = indObj;
                indObj = attIndexes.get(1);
                int col = indObj;
                this.fireTableCellUpdated(row, col);
            }
        }
    }

    protected class MultiScalarCellRendererAndEditor
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor,
    MouseListener {
        protected JTable table;
        protected Component rendererComp;
        protected Component editorComp;
        protected Object editorValue;

        protected MultiScalarCellRendererAndEditor(JTable tbl) {
            this.table = tbl;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof SimpleScalarViewer) {
                SimpleScalarViewer ssv = (SimpleScalarViewer)value;
                this.rendererComp = ssv;
                return this.rendererComp;
            }
            if (value instanceof SimpleEnumScalarViewer) {
                SimpleEnumScalarViewer enumv = (SimpleEnumScalarViewer)value;
                this.rendererComp = enumv;
                return this.rendererComp;
            }
            if (value instanceof BooleanScalarCheckBoxViewer) {
                BooleanScalarCheckBoxViewer boolv = (BooleanScalarCheckBoxViewer)value;
                this.rendererComp = boolv;
                return this.rendererComp;
            }
            return new JLabel("Unsupported Class");
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof Component) {
                this.editorComp = (Component)value;
                this.editorValue = value;
                return this.editorComp;
            }
            return new JLabel("Unsupported Condition");
        }

        @Override
        public Object getCellEditorValue() {
            return this.editorValue;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            boolean ed = this.table.isEditing();
            TableCellEditor tce = this.table.getCellEditor();
            if (this.table.getCellEditor() == this && this.table.isEditing()) {
                this.table.getCellEditor().stopCellEditing();
                MultiScalarTableViewer.this.doEdit(MultiScalarTableViewer.this.getSelectedRow(), MultiScalarTableViewer.this.getSelectedColumn());
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    class RowIdentsCellRenderer
    extends JLabel
    implements TableCellRenderer {
        RowIdentsCellRenderer() {
            this.setHorizontalAlignment(2);
            this.setOpaque(true);
            this.setBackground(new Color(220, 220, 220));
            this.setBorder(BorderUIResource.getEtchedBorderUIResource());
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof String) {
                String rowId = (String)value;
                this.setText(rowId);
                return this;
            }
            return new JLabel("Unsupported row id Class");
        }
    }

    class ColHeaderCellRenderer
    extends RowIdentsCellRenderer {
        ColHeaderCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof String) {
                String colId = (String)value;
                this.setText(colId);
                return this;
            }
            return new JLabel("Unsupported column header Class");
        }
    }
}

