/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IImageListener;
import fr.esrf.tangoatk.core.INumberImage;
import fr.esrf.tangoatk.core.NumberImageEvent;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class NumberImageJTableAdapter
extends AbstractTableModel
implements IImageListener {
    Double[] vals = new Double[256];
    double[][] value;
    JTable table;
    INumberImage model;

    public NumberImageJTableAdapter() {
        for (int i = 0; i < this.vals.length; ++i) {
            this.vals[i] = new Double(i);
        }
    }

    @Override
    public int getRowCount() {
        if (this.model == null) {
            return 0;
        }
        return this.model.getYDimension();
    }

    @Override
    public int getColumnCount() {
        if (this.model == null) {
            return 0;
        }
        return this.model.getXDimension();
    }

    public void imageChange(NumberImageEvent evt) {
        double[][] tempValue = evt.getValue();
        if (tempValue == null) {
            tempValue = new double[0][0];
        }
        boolean changeAll = false;
        if (this.value == null) {
            changeAll = true;
        } else if (this.value.length != tempValue.length) {
            changeAll = true;
        } else if (this.value.length > 0 && this.value[0].length != tempValue[0].length) {
            changeAll = true;
        }
        this.value = tempValue;
        if (changeAll) {
            this.fireTableStructureChanged();
        } else {
            this.fireTableRowsUpdated(0, this.value.length);
        }
    }

    @Override
    public Object getValueAt(int row, int column) {
        double val = -1.0;
        try {
            val = this.value[row][column];
            if (Math.rint(val) == val && val > -1.0 && val < 256.0) {
                return this.vals[(int)val];
            }
            return new Double(val);
        }
        catch (Exception e) {
            System.out.println("Caught exception at (" + row + ", " + column + ") value = " + val);
            return new Double(Double.NaN);
        }
    }

    public void stateChange(AttributeStateEvent attributestateevent) {
    }

    public void errorChange(ErrorEvent errorevent) {
    }

    public void setModel(INumberImage inumberimage) {
        if (this.model != null) {
            this.model.removeImageListener((IImageListener)this);
        }
        this.model = inumberimage;
        this.model.addImageListener((IImageListener)this);
        this.fireTableStructureChanged();
    }

    public INumberImage getModel() {
        return this.model;
    }

    public void setJTable(JTable jtable) {
        this.setViewer(jtable);
    }

    public JTable getJTable() {
        return this.getViewer();
    }

    public void setViewer(JTable jtable) {
        this.table = jtable;
        jtable.setModel(this);
    }

    public JTable getViewer() {
        return this.table;
    }

    public static void main(String[] args) throws Exception {
        AttributeList attributelist = new AttributeList();
        NumberImageJTableAdapter numberimagejtableadapter = new NumberImageJTableAdapter();
        JTable jtable = new JTable();
        numberimagejtableadapter.setViewer(jtable);
        numberimagejtableadapter.setModel((INumberImage)attributelist.add("fe/imacq/2/Image"));
        attributelist.startRefresher();
        JFrame jframe = new JFrame();
        jframe.setContentPane(jtable);
        jframe.pack();
        jframe.setVisible(true);
    }
}

