/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.widget.attribute.BooleanScalarCheckBoxViewer;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;

public class NumberScalarCheckBoxViewer
extends BooleanScalarCheckBoxViewer
implements INumberScalarListener {
    private INumberScalar numberModel = null;

    public NumberScalarCheckBoxViewer() {
    }

    public NumberScalarCheckBoxViewer(String title) {
        super(title);
    }

    @Override
    public IBooleanScalar getAttModel() {
        return null;
    }

    @Override
    public void setAttModel(IBooleanScalar ibs) {
    }

    public INumberScalar getNumberModel() {
        return this.numberModel;
    }

    public void setNumberModel(INumberScalar numModel) {
        if (this.numberModel != null) {
            this.numberModel.removeNumberScalarListener((INumberScalarListener)this);
            this.numberModel = null;
            this.setText("");
        }
        if (numModel != null) {
            this.numberModel = numModel;
            this.numberModel.addNumberScalarListener((INumberScalarListener)this);
            if (this.getTrueLabel() == null && this.getFalseLabel() == null) {
                this.setText(numModel.getLabel());
            }
            this.setNumberValue(this.numberModel.getNumberScalarValue());
        }
    }

    @Override
    public void clearModel() {
        this.setNumberModel(null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.numberModel == null) {
            return;
        }
        if (!this.numberModel.isWritable()) {
            this.setSelected(!this.isSelected());
            return;
        }
        if (this.isSelected()) {
            this.numberModel.setValue(1.0);
        } else {
            this.numberModel.setValue(0.0);
        }
    }

    public void numberScalarChange(NumberScalarEvent e) {
        this.setNumberValue(e.getValue());
    }

    @Override
    public void stateChange(AttributeStateEvent e) {
    }

    @Override
    public void errorChange(ErrorEvent evt) {
        this.setEnabled(false);
    }

    private void setNumberValue(double val) {
        if (!this.isEnabled()) {
            this.setEnabled(true);
        }
        if (val == 0.0) {
            this.setSelected(false);
            if (this.getFalseLabel() != null) {
                this.setText(this.getFalseLabel());
            } else if (this.numberModel != null) {
                this.setText(this.numberModel.getLabel());
            }
        } else {
            this.setSelected(true);
            if (this.getTrueLabel() != null) {
                this.setText(this.getTrueLabel());
            } else if (this.numberModel != null) {
                this.setText(this.numberModel.getLabel());
            }
        }
    }

    public static void main(String[] args) {
        AttributeList attributeList = new AttributeList();
        NumberScalarCheckBoxViewer nscbv = new NumberScalarCheckBoxViewer();
        nscbv.setTrueLabel("yes");
        nscbv.setFalseLabel("no");
        try {
            if (args.length != 0) {
                nscbv.setNumberModel((INumberScalar)attributeList.add(args[0]));
            } else {
                nscbv.setNumberModel((INumberScalar)attributeList.add("test/testSignal2/1/signal"));
            }
            attributeList.setRefreshInterval(1000);
            attributeList.startRefresher();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        JFrame f = new JFrame();
        f.getContentPane().add(nscbv);
        f.pack();
        f.setVisible(true);
    }
}

