/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.widget.attribute.NumberScalarComboEditor;
import fr.esrf.tangoatk.widget.attribute.NumberScalarWheelEditor;
import fr.esrf.tangoatk.widget.attribute.SimplePropertyFrame;
import fr.esrf.tangoatk.widget.attribute.SimpleScalarViewer;
import fr.esrf.tangoatk.widget.properties.LabelViewer;
import fr.esrf.tangoatk.widget.util.JAutoScrolledText;
import fr.esrf.tangoatk.widget.util.JAutoScrolledTextListener;
import fr.esrf.tangoatk.widget.util.JSmoothLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class NumberScalarListViewer
extends JPanel
implements JAutoScrolledTextListener {
    public static final String DEFAULT_SETTER = "WheelEditor";
    public static final String COMBO_SETTER = "ComboEditor";
    protected Vector<IAttribute> listModel = null;
    protected Vector<LabelViewer> nsLabels = null;
    protected Vector<JComponent> nsViewers = null;
    protected Vector<JComponent> nsSetters = null;
    protected Vector<JButton> nsPropButtons = null;
    protected SimplePropertyFrame propFrame = new SimplePropertyFrame();
    protected Font theFont = new Font("Dialog", 0, 14);
    private boolean labelVisible = true;
    private boolean setterVisible = true;
    private boolean propertyButtonVisible = true;
    private boolean propertyListEditable = true;
    private boolean unitVisible = true;
    private String setterType = "WheelEditor";
    private Color arrowColor = null;
    private String toolTipDisplay = "None";
    public static final String TOOLTIP_DISPLAY_NONE = "None";
    public static final String TOOLTIP_DISPLAY_NAME_ONLY = "Name";
    public static final String TOOLTIP_DISPLAY_ALL = "All";

    public NumberScalarListViewer() {
        this.setLayout(new GridBagLayout());
        this.setVisible(false);
    }

    public void setModel(AttributeList scalarList) {
        if (this.listModel != null) {
            this.removeComponents();
            this.listModel = null;
        }
        if (scalarList == null) {
            return;
        }
        int nbAtts = scalarList.getSize();
        if (nbAtts <= 0) {
            return;
        }
        boolean containsNumberScalar = false;
        for (int idx = 0; idx < nbAtts; ++idx) {
            Object elem = scalarList.getElementAt(idx);
            if (!(elem instanceof INumberScalar)) continue;
            containsNumberScalar = true;
            break;
        }
        if (!containsNumberScalar) {
            return;
        }
        this.initComponents(scalarList);
        this.setVisible(true);
    }

    protected void removeComponents() {
        IAttribute iatt = null;
        INumberScalar ins = null;
        LabelViewer nsLabel = null;
        JComponent jcomp = null;
        SimpleScalarViewer viewer = null;
        NumberScalarWheelEditor setter = null;
        NumberScalarComboEditor comboSetter = null;
        this.propFrame = null;
        this.propFrame = new SimplePropertyFrame();
        int nbRows = this.listModel.size();
        for (int indRow = 0; indRow < nbRows; ++indRow) {
            try {
                iatt = this.listModel.get(indRow);
                if (!(iatt instanceof INumberScalar)) continue;
                ins = (INumberScalar)iatt;
                nsLabel = this.nsLabels.get(indRow);
                nsLabel.setModel(null);
                jcomp = this.nsViewers.get(indRow);
                if (jcomp instanceof SimpleScalarViewer) {
                    viewer = (SimpleScalarViewer)jcomp;
                    viewer.clearModel();
                }
                if ((jcomp = this.nsSetters.get(indRow)) instanceof NumberScalarWheelEditor) {
                    setter = (NumberScalarWheelEditor)jcomp;
                    if (!ins.isWritable()) continue;
                    setter.setModel(null);
                    continue;
                }
                if (!(jcomp instanceof NumberScalarComboEditor)) continue;
                comboSetter = (NumberScalarComboEditor)jcomp;
                if (!ins.isWritable()) continue;
                comboSetter.setNumberModel(null);
                continue;
            }
            catch (Exception e) {
                System.out.println("NumberScalarListViewer : setTheFont : Caught exception  " + e.getMessage());
            }
        }
        this.nsLabels.removeAllElements();
        this.nsViewers.removeAllElements();
        this.nsSetters.removeAllElements();
        this.nsPropButtons.removeAllElements();
        this.listModel.removeAllElements();
        this.removeAll();
        this.listModel = null;
        this.nsLabels = null;
        this.nsViewers = null;
        this.nsSetters = null;
        this.nsPropButtons = null;
    }

    public Font getTheFont() {
        return this.theFont;
    }

    public void setTheFont(Font ft) {
        LabelViewer nsLabel = null;
        JButton propertyButton = null;
        JComponent viewer = null;
        JComponent setter = null;
        if (ft != null) {
            this.theFont = ft;
            if (this.listModel != null) {
                int nbRows = this.listModel.size();
                for (int indRow = 0; indRow < nbRows; ++indRow) {
                    try {
                        nsLabel = this.nsLabels.get(indRow);
                        nsLabel.setFont(this.theFont);
                        viewer = this.nsViewers.get(indRow);
                        if (viewer != null && viewer instanceof SimpleScalarViewer) {
                            viewer.setFont(this.theFont);
                        }
                        if ((setter = this.nsSetters.get(indRow)) != null && (setter instanceof NumberScalarWheelEditor || setter instanceof NumberScalarComboEditor)) {
                            setter.setFont(this.theFont);
                        }
                        propertyButton = this.nsPropButtons.get(indRow);
                        propertyButton.setFont(this.theFont);
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println("NumberScalarListViewer : setTheFont : Caught exception  " + e.getMessage());
                    }
                }
            }
        }
    }

    public boolean getLabelVisible() {
        return this.labelVisible;
    }

    public void setLabelVisible(boolean lv) {
        if (this.labelVisible != lv) {
            this.labelVisible = lv;
            this.changeLabelVisibility();
        }
    }

    private void changeLabelVisibility() {
        LabelViewer nsLabel = null;
        if (this.nsLabels != null) {
            int nbRows = this.nsLabels.size();
            for (int indRow = 0; indRow < nbRows; ++indRow) {
                try {
                    nsLabel = this.nsLabels.get(indRow);
                    nsLabel.setVisible(this.labelVisible);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("NumberScalarListViewer : changeLabelVisibility : Caught exception  " + e.getMessage());
                }
            }
        }
    }

    public boolean getSetterVisible() {
        return this.setterVisible;
    }

    public void setSetterVisible(boolean sv) {
        if (this.setterVisible != sv) {
            this.setterVisible = sv;
            this.changeSetterVisibility();
        }
    }

    private void changeSetterVisibility() {
        JComponent setter = null;
        if (this.nsSetters != null) {
            int nbRows = this.nsSetters.size();
            for (int indRow = 0; indRow < nbRows; ++indRow) {
                try {
                    setter = this.nsSetters.get(indRow);
                    if (setter == null || !(setter instanceof NumberScalarWheelEditor) && !(setter instanceof NumberScalarComboEditor)) continue;
                    setter.setVisible(this.setterVisible);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("NumberScalarListViewer : changeSetterVisibility : Caught exception  " + e.getMessage());
                }
            }
        }
    }

    public boolean getPropertyButtonVisible() {
        return this.propertyButtonVisible;
    }

    public void setPropertyButtonVisible(boolean pv) {
        if (this.propertyButtonVisible != pv) {
            this.propertyButtonVisible = pv;
            this.changePropButtonVisibility();
        }
    }

    private void changePropButtonVisibility() {
        JButton propertyButton = null;
        if (this.nsPropButtons != null) {
            int nbRows = this.nsPropButtons.size();
            for (int indRow = 0; indRow < nbRows; ++indRow) {
                try {
                    propertyButton = this.nsPropButtons.get(indRow);
                    propertyButton.setVisible(this.propertyButtonVisible);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("NumberScalarListViewer : changePropButtonVisibility : Caught exception  " + e.getMessage());
                }
            }
        }
    }

    public boolean getPropertyListEditable() {
        return this.propertyListEditable;
    }

    public void setPropertyListEditable(boolean pv) {
    }

    public boolean getUnitVisible() {
        return this.unitVisible;
    }

    public void setUnitVisible(boolean uv) {
        if (this.unitVisible != uv) {
            this.unitVisible = uv;
            this.changeUnitVisibility();
        }
    }

    private void changeUnitVisibility() {
        JComponent jcomp = null;
        SimpleScalarViewer viewer = null;
        NumberScalarComboEditor setter = null;
        if (this.nsViewers != null) {
            int nbRows = this.nsViewers.size();
            for (int indRow = 0; indRow < nbRows; ++indRow) {
                try {
                    jcomp = this.nsViewers.get(indRow);
                    if (jcomp instanceof SimpleScalarViewer) {
                        viewer = (SimpleScalarViewer)jcomp;
                        viewer.setUnitVisible(this.unitVisible);
                    }
                    if ((jcomp = this.nsSetters.get(indRow)) == null || !(jcomp instanceof NumberScalarComboEditor)) continue;
                    setter = (NumberScalarComboEditor)jcomp;
                    setter.setUnitVisible(this.unitVisible);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("NumberScalarListViewer : changeUnitVisibility : Caught exception  " + e.getMessage());
                }
            }
        }
    }

    public String getToolTipDisplay() {
        return this.toolTipDisplay;
    }

    public void setToolTipDisplay(String ttType) {
        if (this.listModel != null) {
            return;
        }
        this.toolTipDisplay = ttType.equalsIgnoreCase(TOOLTIP_DISPLAY_ALL) ? TOOLTIP_DISPLAY_ALL : (ttType.equalsIgnoreCase(TOOLTIP_DISPLAY_NAME_ONLY) ? TOOLTIP_DISPLAY_NAME_ONLY : TOOLTIP_DISPLAY_NONE);
    }

    public String getSetterType() {
        return this.setterType;
    }

    public void setSetterType(String setType) {
        if (this.listModel != null) {
            return;
        }
        this.setterType = setType.equalsIgnoreCase(DEFAULT_SETTER) ? DEFAULT_SETTER : (setType.equalsIgnoreCase(COMBO_SETTER) ? COMBO_SETTER : DEFAULT_SETTER);
    }

    public Color getArrowColor() {
        if (this.arrowColor == null) {
            return this.getBackground();
        }
        return this.arrowColor;
    }

    public void setArrowColor(Color ac) {
        if (ac == this.arrowColor) {
            return;
        }
        this.changeArrowColors(ac);
        this.arrowColor = ac;
    }

    private void changeArrowColors(Color ac) {
        JComponent jcomp = null;
        NumberScalarWheelEditor setter = null;
        if (this.nsSetters != null) {
            int nbRows = this.nsSetters.size();
            for (int indRow = 0; indRow < nbRows; ++indRow) {
                try {
                    jcomp = this.nsSetters.get(indRow);
                    if (!(jcomp instanceof NumberScalarWheelEditor)) continue;
                    setter = (NumberScalarWheelEditor)jcomp;
                    if (ac == null) {
                        setter.setButtonColor(setter.getBackground());
                        continue;
                    }
                    setter.setButtonColor(ac);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("NumberScalarListViewer : changeArrowColors : Caught exception  " + e.getMessage());
                }
            }
        }
    }

    @Override
    public void textExceedBounds(JAutoScrolledText source) {
        this.revalidate();
    }

    protected void initComponents(AttributeList scalarList) {
        LabelViewer nsLabel = null;
        SimpleScalarViewer viewer = null;
        NumberScalarWheelEditor wheelSetter = null;
        NumberScalarComboEditor comboSetter = null;
        JComponent setter = null;
        JButton propertyButton = null;
        boolean arrowHeight = false;
        this.listModel = new Vector();
        this.nsLabels = new Vector();
        this.nsViewers = new Vector();
        this.nsSetters = new Vector();
        this.nsPropButtons = new Vector();
        int viewerRow = 0;
        int nbAtts = scalarList.size();
        for (int idx = 0; idx < nbAtts; ++idx) {
            Object elem = scalarList.getElementAt(idx);
            if (!(elem instanceof INumberScalar)) continue;
            INumberScalar ins = (INumberScalar)elem;
            boolean insHasValueList = false;
            if (ins.getPossibleValues() != null && ins.getPossibleValues().length > 0) {
                insHasValueList = true;
            }
            nsLabel = new LabelViewer();
            viewer = new SimpleScalarViewer();
            propertyButton = new JButton();
            nsLabel.setFont(this.theFont);
            nsLabel.setHorizontalAlignment(JSmoothLabel.RIGHT_ALIGNMENT);
            nsLabel.setBackground(this.getBackground());
            nsLabel.setText(ins.getLabel());
            if (this.labelVisible) {
                nsLabel.setVisible(true);
            } else {
                nsLabel.setVisible(false);
            }
            nsLabel.setModel((IAttribute)ins);
            if (insHasValueList) {
                comboSetter = new NumberScalarComboEditor();
                comboSetter.setFont(this.theFont);
                comboSetter.setBackground(this.getBackground());
                comboSetter.setUnitVisible(this.unitVisible);
                if (ins.isWritable()) {
                    comboSetter.setNumberModel(ins);
                    comboSetter.setVisible(this.setterVisible);
                    setter = comboSetter;
                } else {
                    setter = null;
                }
                this.nsSetters.add(setter);
            } else {
                wheelSetter = new NumberScalarWheelEditor();
                wheelSetter.setFont(this.theFont);
                wheelSetter.setBackground(this.getBackground());
                if (ins.isWritable()) {
                    wheelSetter.setModel(ins);
                    wheelSetter.setVisible(this.setterVisible);
                    setter = wheelSetter;
                } else {
                    setter = null;
                }
                this.nsSetters.add(setter);
            }
            if (this.toolTipDisplay.equalsIgnoreCase(TOOLTIP_DISPLAY_ALL)) {
                viewer.setHasToolTip(true);
                viewer.setQualityInTooltip(true);
            } else if (this.toolTipDisplay.equalsIgnoreCase(TOOLTIP_DISPLAY_NAME_ONLY)) {
                viewer.setHasToolTip(true);
                viewer.setQualityInTooltip(false);
            } else {
                viewer.setHasToolTip(false);
                viewer.setQualityInTooltip(false);
            }
            viewer.setFont(this.theFont);
            viewer.setUnitVisible(this.unitVisible);
            viewer.setBackgroundColor(this.getBackground());
            viewer.setBorder(BorderFactory.createLoweredBevelBorder());
            viewer.setAlarmEnabled(true);
            viewer.setModel(ins);
            propertyButton.setFont(this.theFont);
            propertyButton.setBackground(this.getBackground());
            propertyButton.setText(" ... ");
            propertyButton.setMargin(new Insets(-3, 0, 3, 0));
            propertyButton.setToolTipText("Attribute Properties");
            if (!this.propertyButtonVisible && propertyButton != null) {
                propertyButton.setVisible(false);
            }
            propertyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    NumberScalarListViewer.this.propertyButtonActionPerformed(evt);
                }
            });
            ins.refresh();
            viewer.addTextListener(this);
            int maxRowElementHeight = 0;
            int currH = nsLabel.getPreferredSize().height + 4;
            if (currH > maxRowElementHeight) {
                maxRowElementHeight = currH;
            }
            if ((currH = viewer.getPreferredSize().height + 4) > maxRowElementHeight) {
                maxRowElementHeight = currH;
            }
            if (setter != null && setter.isVisible() && (currH = setter.getPreferredSize().height + 4) > maxRowElementHeight) {
                maxRowElementHeight = currH;
            }
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = viewerRow;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(1, 5, 1, 1);
            this.add((Component)nsLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = viewerRow;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(1, 2, 1, 1);
            this.add((Component)viewer, gridBagConstraints);
            if (setter != null) {
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = viewerRow;
                gridBagConstraints.fill = 1;
                gridBagConstraints.insets = new Insets(1, 1, 1, 1);
                this.add((Component)setter, gridBagConstraints);
            }
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = viewerRow;
            gridBagConstraints.insets = new Insets(1, 3, 1, 5);
            this.add((Component)propertyButton, gridBagConstraints);
            this.listModel.add((IAttribute)ins);
            this.nsLabels.add(nsLabel);
            this.nsViewers.add(viewer);
            this.nsPropButtons.add(propertyButton);
            if (viewer instanceof SimpleScalarViewer) {
                SimpleScalarViewer sv = viewer;
                currH = viewer.getPreferredSize().height;
                int hMargin = currH < maxRowElementHeight ? (maxRowElementHeight - currH) / 2 : 0;
                Insets marge = sv.getMargin();
                marge.top += hMargin;
                marge.bottom += hMargin;
                marge.left += 2;
                marge.right += 2;
                sv.setMargin(marge);
            }
            ++viewerRow;
        }
    }

    private void propertyButtonActionPerformed(ActionEvent evt) {
        int buttonIndex = -1;
        if (this.nsPropButtons == null) {
            return;
        }
        if (this.listModel == null) {
            return;
        }
        int nbButtons = this.nsPropButtons.size();
        for (int ind = 0; ind < nbButtons; ++ind) {
            try {
                JButton propertyButton = this.nsPropButtons.get(ind);
                if (!propertyButton.equals(evt.getSource())) continue;
                buttonIndex = ind;
                break;
            }
            catch (Exception e) {
                System.out.println("NumberScalarListViewer : propertyButtonActionPerformed : Caught exception  " + e.getMessage());
                return;
            }
        }
        if (buttonIndex < 0) {
            return;
        }
        INumberScalar ins = null;
        try {
            IAttribute iatt = this.listModel.get(buttonIndex);
            if (iatt instanceof INumberScalar) {
                ins = (INumberScalar)iatt;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ins == null) {
            return;
        }
        if (this.propFrame != null) {
            this.propFrame.setModel((IAttribute)ins);
            this.propFrame.setVisible(true);
        }
    }

    public static void main(String[] args) {
        final AttributeList attList = new AttributeList();
        NumberScalarListViewer nslv = new NumberScalarListViewer();
        double[] vals = new double[]{0.1, 0.3, 1.0, 3.0, 10.0, 30.0, 100.0, 300.0};
        try {
            INumberScalar att = (INumberScalar)attList.add("jlp/test/1/att_un");
            att = (INumberScalar)attList.add("jlp/test/1/att_deux");
            att = (INumberScalar)attList.add("jlp/test/1/att_trois");
            att = (INumberScalar)attList.add("jlp/test/1/att_quatre");
            nslv.setModel(attList);
        }
        catch (Exception ex) {
            System.out.println("caught exception : " + ex.getMessage());
            System.exit(-1);
        }
        JFrame mainFrame = new JFrame();
        mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent evt) {
                attList.startRefresher();
            }
        });
        mainFrame.setContentPane(nslv);
        mainFrame.pack();
        mainFrame.setVisible(true);
    }
}

