/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.core.attribute.NumberScalar;
import fr.esrf.tangoatk.widget.util.ATKFormat;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JFrame;
import javax.swing.JProgressBar;

public class NumberScalarProgressBar
extends JProgressBar
implements INumberScalarListener {
    protected INumberScalar nsModel = null;
    protected int min = -1;
    protected int max = -1;
    protected boolean printVal = true;
    protected String nsDispFormat = null;
    private static final String ERROR = "Error";

    public NumberScalarProgressBar() {
        this.setStringPainted(true);
        this.setIndeterminate(true);
    }

    public INumberScalar getNsModel() {
        return this.nsModel;
    }

    public void setNsModel(INumberScalar numberScalar) {
        if (this.nsModel != null) {
            this.nsModel.removeNumberScalarListener((INumberScalarListener)this);
            this.nsModel = null;
        }
        this.progressString = null;
        this.setIndeterminate(true);
        this.nsDispFormat = null;
        if (numberScalar == null) {
            return;
        }
        this.nsModel = numberScalar;
        if (this.nsModel instanceof NumberScalar) {
            NumberScalar ns = (NumberScalar)this.nsModel;
            double currVal = ns.getNumberScalarValue();
            if (this.min == -1 && this.max == -1) {
                double minVal = ns.getMinValue();
                double maxVal = ns.getMaxValue();
                this.min = (int)minVal;
                this.max = (int)maxVal;
            }
            if (this.min == this.max && this.min < 0) {
                this.min = -1;
                this.max = -1;
            } else {
                this.setMinimum(this.min);
                this.setMaximum(this.max);
            }
            this.nsDispFormat = this.nsModel.getProperty("format").getPresentation();
            int val = (int)currVal;
            this.setValue(val);
            this.setIndeterminate(false);
            if (this.printVal) {
                this.progressString = this.getDisplayString(currVal);
                this.setToolTipText(this.getString());
            } else if (Double.isNaN(this.getPercentComplete())) {
                this.progressString = ERROR;
                this.setToolTipText("Min: " + this.getMinimum() + ", Max: " + this.getMaximum() + ", Value: " + val);
            } else {
                this.setToolTipText(this.getString());
            }
        }
        this.nsModel.addNumberScalarListener((INumberScalarListener)this);
        this.repaint();
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int m) {
        this.min = m;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int m) {
        this.max = m;
    }

    public boolean getPrintVal() {
        return this.printVal;
    }

    public void setPrintVal(boolean b) {
        this.printVal = b;
        if (!this.printVal) {
            this.progressString = null;
        }
    }

    public void numberScalarChange(NumberScalarEvent evt) {
        double newVal = evt.getValue();
        int progressBarVal = (int)Math.rint(newVal);
        this.setValue(progressBarVal);
        if (this.printVal) {
            this.progressString = this.getDisplayString(newVal);
            this.setToolTipText(this.getString());
        } else if (Double.isNaN(this.getPercentComplete())) {
            this.progressString = ERROR;
            this.setToolTipText("Min: " + this.getMinimum() + ", Max: " + this.getMaximum() + ", Value: " + evt.getValue());
        } else {
            this.setToolTipText(this.getString());
        }
        this.repaint();
    }

    protected String getDisplayString(double val) {
        Double attDouble = new Double(val);
        try {
            if (this.nsDispFormat == null) {
                String dispStr = String.format("%3.0f", attDouble);
                return dispStr;
            }
            if (this.nsDispFormat.equalsIgnoreCase("Not Specified")) {
                String dispStr = String.format("%3.0f", attDouble);
                return dispStr;
            }
            if (this.nsDispFormat.indexOf(37) < 0) {
                String dispStr = String.format("%3.0f", attDouble);
                return dispStr;
            }
            String dispStr = ATKFormat.format(this.nsDispFormat, attDouble);
            return dispStr;
        }
        catch (Exception e) {
            return "Exception while formating";
        }
    }

    public void stateChange(AttributeStateEvent evt) {
    }

    public void errorChange(ErrorEvent evt) {
    }

    public static void main(String[] args) {
        AttributeList attributeList = new AttributeList();
        NumberScalarProgressBar nspb = new NumberScalarProgressBar();
        String attName = "elin/gun/aux/Temporization";
        INumberScalar attr = null;
        if (args.length > 0) {
            attName = args[0];
        }
        if (args.length == 3) {
            nspb.setPrintVal(false);
            nspb.setMin(Integer.parseInt(args[1]));
            nspb.setMax(Integer.parseInt(args[2]));
        } else {
            nspb.setPrintVal(true);
        }
        try {
            attr = (INumberScalar)attributeList.add(attName);
            nspb.setNsModel(attr);
            attributeList.startRefresher();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        JFrame f = attr != null ? new JFrame(attr.getName()) : new JFrame(ERROR);
        f.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 5);
        f.getContentPane().add((Component)nspb, gbc);
        f.setDefaultCloseOperation(3);
        f.pack();
        f.setVisible(true);
    }

    @Override
    public String toString() {
        return "{NumberScalarProgressBar}";
    }
}

