/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.ISetErrorListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.core.Property;
import fr.esrf.tangoatk.widget.util.ATKFormat;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import javax.swing.JTextField;

public class NumberScalarTextEditor
extends JTextField
implements INumberScalarListener,
PropertyChangeListener,
ISetErrorListener {
    String format = "";
    private INumberScalar model = null;
    private String lastSet = null;
    private String readErrorStr = "Read Error";

    public NumberScalarTextEditor() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NumberScalarTextEditor.this.textInsertActionPerformed(evt);
            }
        });
        this.setMargin(new Insets(0, 0, 0, 0));
    }

    public void clearModel() {
        if (this.model == null) {
            return;
        }
        this.model.getProperty("format").removePresentationListener((PropertyChangeListener)this);
        this.model.removeNumberScalarListener((INumberScalarListener)this);
        this.model.removeSetErrorListener((ISetErrorListener)this);
        this.model = null;
    }

    public void setReadError(String errorStr) {
        this.readErrorStr = errorStr;
    }

    public void setModel(INumberScalar ins) {
        this.clearModel();
        if (ins == null) {
            return;
        }
        if (!ins.isWritable()) {
            throw new IllegalArgumentException("NumberScalarTextEditor: Only accept writeable attribute.");
        }
        this.model = ins;
        this.format = this.model.getProperty("format").getPresentation();
        this.model.addNumberScalarListener((INumberScalarListener)this);
        this.model.getProperty("format").addPresentationListener((PropertyChangeListener)this);
        this.model.addSetErrorListener((ISetErrorListener)this);
        this.model.refresh();
    }

    public INumberScalar getModel() {
        return this.model;
    }

    private String getDisplayString(double value) {
        String dispStr;
        Double attDouble = new Double(value);
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            dispStr = Double.toString(value);
        } else {
            try {
                dispStr = this.format.indexOf(37) == -1 ? String.format("%.2f", value) : ATKFormat.format(this.format, attDouble);
            }
            catch (Exception e) {
                dispStr = String.format("%.2f", value);
            }
        }
        return dispStr;
    }

    public void numberScalarChange(NumberScalarEvent evt) {
        double set = Double.NaN;
        set = this.hasFocus() ? this.model.getNumberScalarSetPointFromDevice() : this.model.getNumberScalarSetPoint();
        String strValue = this.getDisplayString(set);
        if (this.lastSet == null) {
            this.setText(strValue);
            this.lastSet = strValue;
        } else if (!this.lastSet.equals(strValue)) {
            this.setText(strValue);
            this.lastSet = strValue;
        }
    }

    public void errorChange(ErrorEvent e) {
        this.setText(this.readErrorStr);
        this.lastSet = this.readErrorStr;
    }

    public void stateChange(AttributeStateEvent e) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Property src = (Property)evt.getSource();
        if (this.model != null) {
            if (src.getName().equalsIgnoreCase("format")) {
                this.format = src.getValue().toString();
            }
            this.model.refresh();
        }
    }

    private void textInsertActionPerformed(ActionEvent evt) {
        if (this.model == null) {
            return;
        }
        String valStr = this.getText();
        try {
            double value = Double.parseDouble(valStr);
            this.model.setValue(value);
        }
        catch (NumberFormatException nfe) {
            this.lastSet = null;
            this.model.refresh();
        }
    }

    public void setErrorOccured(ErrorEvent evt) {
        this.lastSet = null;
    }

    public static void main(String[] args) {
        AttributeList attList = new AttributeList();
        NumberScalarTextEditor nste = new NumberScalarTextEditor();
        try {
            INumberScalar att = (INumberScalar)attList.add("id-carr/TD13/GAP/Position");
            nste.setModel(att);
        }
        catch (Exception ex) {
            System.out.println("caught exception : " + ex.getMessage());
            System.exit(-1);
        }
        JFrame mainFrame = new JFrame();
        mainFrame.getContentPane().add(nste);
        mainFrame.pack();
        mainFrame.setVisible(true);
        attList.startRefresher();
    }
}

