/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.core.Property;
import fr.esrf.tangoatk.widget.attribute.NumberScalarWheelEditor;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.WheelSwitch;
import java.awt.Color;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class NumberScalarViewer
extends WheelSwitch
implements INumberScalarListener,
PropertyChangeListener {
    private INumberScalar model = null;
    boolean alarmEnabled = false;
    Color backgroundColor = ATKConstant.getColor4Quality("VALID");

    public NumberScalarViewer() {
        super(false);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color bg) {
        this.backgroundColor = bg;
    }

    public void setAlarmEnabled(boolean b) {
        this.alarmEnabled = b;
    }

    public boolean isAlarmEnabled() {
        return this.alarmEnabled;
    }

    public INumberScalar getModel() {
        return this.model;
    }

    public void setModel(INumberScalar m) {
        if (this.model != null) {
            this.model.removeNumberScalarListener((INumberScalarListener)this);
            this.model.getProperty("format").removePresentationListener((PropertyChangeListener)this);
            this.model = null;
        }
        if (m == null) {
            return;
        }
        this.model = m;
        this.model.addNumberScalarListener((INumberScalarListener)this);
        this.model.getProperty("format").addPresentationListener((PropertyChangeListener)this);
        this.setFormat(this.model.getProperty("format").getPresentation(), this.model.getName());
        this.model.refresh();
        double d = this.model.getNumberScalarValue();
        this.setValue(d);
    }

    public void numberScalarChange(NumberScalarEvent evt) {
        double val = evt.getValue();
        if (this.getValue() != val) {
            this.setValue(val);
        }
    }

    public void errorChange(ErrorEvent e) {
        this.setValue(Double.NaN);
        if (!this.alarmEnabled) {
            return;
        }
        this.setBackground(ATKConstant.getColor4Quality("UNKNOWN"));
    }

    public void stateChange(AttributeStateEvent e) {
        String state = e.getState();
        if (state.equals("INVALID")) {
            this.setValue(Double.NaN);
        }
        if (!this.alarmEnabled) {
            return;
        }
        if (state.equals("VALID")) {
            this.setBackground(this.backgroundColor);
            return;
        }
        this.setBackground(ATKConstant.getColor4Quality(state));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Property src = (Property)evt.getSource();
        if (this.model != null && src.getName().equalsIgnoreCase("format")) {
            this.setFormat(src.getValue().toString(), this.model.getName());
            this.model.refresh();
        }
    }

    public static void main(String[] args) {
        INumberScalar attr = null;
        AttributeList attributeList = new AttributeList();
        try {
            attr = (INumberScalar)attributeList.add("jlp/test/1/att_trois");
        }
        catch (Exception e) {
            ErrorPane.showErrorMessage(null, "jlp/test/1", e);
            System.exit(0);
        }
        attributeList.startRefresher();
        JFrame f = new JFrame();
        JPanel innerPanel = new JPanel(new GridLayout(2, 1));
        NumberScalarWheelEditor we = new NumberScalarWheelEditor();
        NumberScalarViewer wv = new NumberScalarViewer();
        we.setModel(attr);
        wv.setModel(attr);
        innerPanel.add(we);
        innerPanel.add(wv);
        f.setContentPane(innerPanel);
        ATKGraphicsUtils.centerFrameOnScreen(f);
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }
}

