/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.ATKException;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.ISetErrorListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.core.Property;
import fr.esrf.tangoatk.core.attribute.ANumber;
import fr.esrf.tangoatk.core.attribute.NumberScalar;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.ErrorPopup;
import fr.esrf.tangoatk.widget.util.IWheelSwitchListener;
import fr.esrf.tangoatk.widget.util.WheelSwitch;
import fr.esrf.tangoatk.widget.util.WheelSwitchEvent;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class NumberScalarWheelEditor
extends WheelSwitch
implements INumberScalarListener,
IWheelSwitchListener,
PropertyChangeListener,
JDrawable {
    static String[] exts = new String[]{"arrowColor", "arrowSelColor"};
    private INumberScalar model = null;
    boolean alarmEnabled = false;
    Color backgroundColor = ATKConstant.getColor4Quality("VALID");

    public NumberScalarWheelEditor() {
        this.addWheelSwitchListener(this);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color bg) {
        this.backgroundColor = bg;
    }

    public void setAlarmEnabled(boolean b) {
        this.alarmEnabled = b;
    }

    public boolean isAlarmEnabled() {
        return this.alarmEnabled;
    }

    public INumberScalar getModel() {
        return this.model;
    }

    public void setModel(INumberScalar m) {
        if (this.model != null) {
            this.model.removeNumberScalarListener((INumberScalarListener)this);
            this.model.getProperty("format").removePresentationListener((PropertyChangeListener)this);
            this.model = null;
        }
        if (m == null) {
            return;
        }
        if (!m.isWritable()) {
            throw new IllegalArgumentException("NumberScalarWheelEditor: Only accept writeable attribute.");
        }
        this.model = m;
        this.model.addSetErrorListener((ISetErrorListener)ErrorPopup.getInstance());
        this.model.addNumberScalarListener((INumberScalarListener)this);
        this.model.getProperty("format").addPresentationListener((PropertyChangeListener)this);
        NumberScalar ns = (NumberScalar)this.model;
        if (!Double.isNaN(ns.getMinimumIncrement())) {
            this.setMinimumIncrement(ns.getMinimumIncrement());
        }
        this.setFormat(this.model.getProperty("format").getPresentation(), this.model.getName());
        ANumber an = null;
        if (this.model instanceof ANumber) {
            an = (ANumber)this.model;
        }
        double max = this.model.getMaxValue();
        if (an != null) {
            max = an.getValueInDisplayUnit(max);
        }
        if (!Double.isNaN(max)) {
            this.setMaxValue(max);
        }
        double min = this.model.getMinValue();
        if (an != null) {
            min = an.getValueInDisplayUnit(min);
        }
        if (!Double.isNaN(min)) {
            this.setMinValue(min);
        }
        this.model.refresh();
    }

    @Override
    public void initForEditing() {
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String getDescription(String extName) {
        if (extName.equalsIgnoreCase("arrowColor")) {
            return "Sets the arrow button color (r,g,b).";
        }
        if (extName.equalsIgnoreCase("arrowSelColor")) {
            return "Sets the color of selected arrow buttons.(r,g,b).";
        }
        return "";
    }

    @Override
    public String[] getExtensionList() {
        return exts;
    }

    @Override
    public boolean setExtendedParam(String name, String value, boolean popupErr) {
        if (name.equalsIgnoreCase("arrowColor")) {
            String[] c = value.split(",");
            if (c.length != 3) {
                this.showJdrawError(popupErr, "arrowColor", "Integer list expected: r,g,b");
                return false;
            }
            try {
                int r = Integer.parseInt(c[0]);
                int g = Integer.parseInt(c[1]);
                int b = Integer.parseInt(c[2]);
                if (r < 0 || r > 255 || g < 0 || g > 255 || b < 0 || b > 255) {
                    this.showJdrawError(popupErr, "arrowColor", "Parameter out of bounds. [0..255]");
                    return false;
                }
                this.setButtonColor(new Color(r, g, b));
                return true;
            }
            catch (NumberFormatException e) {
                this.showJdrawError(popupErr, "arrowColor", "Wrong integer syntax.");
                return false;
            }
        }
        if (name.equalsIgnoreCase("arrowSelColor")) {
            String[] c = value.split(",");
            if (c.length != 3) {
                this.showJdrawError(popupErr, "arrowSelColor", "Integer list expected: r,g,b");
                return false;
            }
            try {
                int r = Integer.parseInt(c[0]);
                int g = Integer.parseInt(c[1]);
                int b = Integer.parseInt(c[2]);
                if (r < 0 || r > 255 || g < 0 || g > 255 || b < 0 || b > 255) {
                    this.showJdrawError(popupErr, "arrowSelColor", "Parameter out of bounds. [0..255]");
                    return false;
                }
                this.setSelButtonColor(new Color(r, g, b));
                return true;
            }
            catch (NumberFormatException e) {
                this.showJdrawError(popupErr, "arrowSelColor", "Wrong integer syntax.");
                return false;
            }
        }
        return false;
    }

    @Override
    public String getExtendedParam(String name) {
        if (name.equalsIgnoreCase("arrowColor")) {
            Color c = this.getButtonColor();
            return c.getRed() + "," + c.getGreen() + "," + c.getBlue();
        }
        if (name.equalsIgnoreCase("arrowSelColor")) {
            Color c = this.getSelButtonColor();
            return c.getRed() + "," + c.getGreen() + "," + c.getBlue();
        }
        return "";
    }

    private void showJdrawError(boolean popup, String paramName, String message) {
        if (popup) {
            JOptionPane.showMessageDialog(null, "NumberScalarWheelEditor: " + paramName + " incorrect.\n" + message, "Error", 0);
        }
    }

    public void numberScalarChange(NumberScalarEvent evt) {
        double set = Double.NaN;
        set = this.hasFocus() ? this.model.getNumberScalarSetPointFromDevice() : this.model.getNumberScalarSetPoint();
        if (this.getValue() != set) {
            this.setValue(set);
        }
    }

    public void errorChange(ErrorEvent e) {
        this.setValue(Double.NaN);
        if (!this.alarmEnabled) {
            return;
        }
        this.setTextBackground(ATKConstant.getColor4Quality("UNKNOWN"));
    }

    public void stateChange(AttributeStateEvent e) {
        if (!this.alarmEnabled) {
            return;
        }
        String state = e.getState();
        if (state.equals("VALID")) {
            this.setTextBackground(this.backgroundColor);
            return;
        }
        this.setBackground(ATKConstant.getColor4Quality(state));
    }

    @Override
    public void valueChange(WheelSwitchEvent e) {
        if (this.model != null) {
            this.model.setValue(e.getValue());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Property src = (Property)evt.getSource();
        if (this.model != null && src.getName().equalsIgnoreCase("format")) {
            this.setFormat(src.getValue().toString(), this.model.getName());
            this.model.refresh();
        }
    }

    public static void main(String[] args) {
        AttributeList attributeList = new AttributeList();
        NumberScalarWheelEditor nsv = new NumberScalarWheelEditor();
        NumberScalarWheelEditor nsv2 = new NumberScalarWheelEditor();
        JFrame f = new JFrame();
        try {
            nsv.setFont(new Font("Dialog", 0, 12));
            INumberScalar attr = (INumberScalar)attributeList.add("srrf/anode/tra1/current");
            nsv.setModel(attr);
            nsv.setAlarmEnabled(false);
            nsv2.setModel(attr);
            nsv2.setAlarmEnabled(false);
            nsv2.setEnabled(false);
            attributeList.setRefreshInterval(1000);
            attributeList.startRefresher();
        }
        catch (ConnectionException e) {
            ErrorPane.showErrorMessage((Component)f, "sy/rfssa-pinatt/tra0", (ATKException)((Object)e));
        }
        f.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        f.getContentPane().add((Component)nsv, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        f.getContentPane().add((Component)nsv2, gridBagConstraints);
        f.pack();
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }
}

