/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributePolledList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.ISpectrumListener;
import fr.esrf.tangoatk.core.NumberSpectrumEvent;
import fr.esrf.tangoatk.widget.attribute.NumberSpectrumViewer;
import fr.esrf.tangoatk.widget.util.chart.DataList;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class NumberSpectrumRecorder
extends JPanel
implements ISpectrumListener,
ActionListener {
    protected static final Color[] defaultColor = new Color[]{Color.red, Color.blue, Color.magenta, Color.orange, Color.cyan, Color.green, Color.pink, Color.yellow, Color.black};
    protected int index = 0;
    protected NumberSpectrumViewer viewer = null;
    protected JLDataView dvy = null;
    protected INumberSpectrum model = null;
    protected Vector snapshots = null;
    protected JButton snapshotButton = null;
    protected JButton clearButton = null;
    protected JPanel buttonPanel = null;

    public NumberSpectrumRecorder() {
        this.initComponents();
        this.dvy = this.viewer.getY1Axis().getDataView(0);
        this.dvy.setMarkerColor(defaultColor[this.index]);
        this.dvy.setColor(defaultColor[this.index]);
        this.snapshots = new Vector();
        this.initLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spectrumChange(NumberSpectrumEvent event) {
        JLDataView jLDataView = this.dvy;
        synchronized (jLDataView) {
            this.viewer.spectrumChange(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeSnaphot() {
        JLDataView jLDataView = this.dvy;
        synchronized (jLDataView) {
            ++this.index;
            JLDataView snapshot = new JLDataView();
            snapshot.setMarkerColor(defaultColor[this.index % defaultColor.length]);
            snapshot.setColor(defaultColor[this.index % defaultColor.length]);
            snapshot.setMarkerSize(this.dvy.getMarkerSize());
            snapshot.setMarker(this.dvy.getMarker());
            snapshot.setLineWidth(this.dvy.getLineWidth());
            snapshot.setStyle(this.dvy.getStyle());
            snapshot.setViewType(this.dvy.getViewType());
            snapshot.setUnit(this.dvy.getUnit());
            snapshot.setUserFormat(this.dvy.getUserFormat());
            snapshot.setBarWidth(this.dvy.getBarWidth());
            snapshot.setA0(this.dvy.getA0());
            snapshot.setA1(this.dvy.getA1());
            snapshot.setA2(this.dvy.getA2());
            DataList data = this.dvy.getData();
            while (data != null) {
                snapshot.add(data.x, data.y);
                data = data.next;
            }
            this.snapshots.add(snapshot);
            snapshot.setName(this.dvy.getName() + " - Record " + this.snapshots.size());
            this.viewer.getY1Axis().addDataView(snapshot);
        }
        this.viewer.repaint();
    }

    public synchronized void clearSnapshots() {
        for (int i = 0; i < this.snapshots.size(); ++i) {
            this.viewer.getY1Axis().removeDataView((JLDataView)this.snapshots.get(i));
        }
        this.snapshots.clear();
        this.index = 0;
        this.viewer.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChange(AttributeStateEvent event) {
        JLDataView jLDataView = this.dvy;
        synchronized (jLDataView) {
            this.viewer.stateChange(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void errorChange(ErrorEvent event) {
        JLDataView jLDataView = this.dvy;
        synchronized (jLDataView) {
            this.viewer.errorChange(event);
        }
    }

    public INumberSpectrum getModel() {
        return this.model;
    }

    public void setModel(INumberSpectrum v) {
        if (this.model != null) {
            this.model.removeSpectrumListener((ISpectrumListener)this);
        }
        this.viewer.setModel(v);
        if (v != null) {
            v.removeSpectrumListener((ISpectrumListener)this.viewer);
            v.addSpectrumListener((ISpectrumListener)this);
        }
    }

    public void clearModel() {
        this.setModel(null);
    }

    public NumberSpectrumViewer getViewer() {
        return this.viewer;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.snapshotButton) {
            this.makeSnaphot();
        } else if (e.getSource() == this.clearButton) {
            this.clearSnapshots();
        }
    }

    protected void initComponents() {
        this.viewer = new NumberSpectrumViewer();
        this.snapshotButton = new JButton("Record Values");
        this.snapshotButton.setMargin(new Insets(0, 0, 0, 0));
        this.snapshotButton.addActionListener(this);
        this.clearButton = new JButton("Clear Records");
        this.clearButton.setMargin(new Insets(0, 0, 0, 0));
        this.clearButton.addActionListener(this);
        this.viewer.setOpaque(false);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setOpaque(false);
        this.setBackground(this.viewer.getChartBackground());
    }

    protected void initLayout() {
        GridBagConstraints snapBConstraint = new GridBagConstraints();
        snapBConstraint.fill = 0;
        snapBConstraint.gridx = 0;
        snapBConstraint.gridy = 0;
        snapBConstraint.weightx = 0.0;
        snapBConstraint.weighty = 0.0;
        GridBagConstraints emptyConstraint = new GridBagConstraints();
        emptyConstraint.fill = 2;
        emptyConstraint.gridx = 1;
        emptyConstraint.gridy = 0;
        emptyConstraint.weightx = 1.0;
        emptyConstraint.weighty = 0.0;
        GridBagConstraints clearBConstraint = new GridBagConstraints();
        clearBConstraint.fill = 0;
        clearBConstraint.gridx = 2;
        clearBConstraint.gridy = 0;
        clearBConstraint.weightx = 0.0;
        clearBConstraint.weighty = 0.0;
        this.buttonPanel.setLayout(new GridBagLayout());
        this.buttonPanel.add((Component)this.snapshotButton, snapBConstraint);
        this.buttonPanel.add(Box.createGlue(), emptyConstraint);
        this.buttonPanel.add((Component)this.clearButton, clearBConstraint);
        GridBagConstraints viewerConstraint = new GridBagConstraints();
        viewerConstraint.fill = 1;
        viewerConstraint.gridx = 0;
        viewerConstraint.gridy = 0;
        viewerConstraint.weightx = 1.0;
        viewerConstraint.weighty = 1.0;
        GridBagConstraints panelConstraint = new GridBagConstraints();
        panelConstraint.fill = 2;
        panelConstraint.gridx = 0;
        panelConstraint.gridy = 1;
        panelConstraint.weightx = 1.0;
        panelConstraint.weighty = 0.0;
        this.setLayout(new GridBagLayout());
        this.add((Component)this.viewer, viewerConstraint);
        this.add((Component)this.buttonPanel, panelConstraint);
        this.repaint();
    }

    public static void main(String[] args) {
        try {
            AttributePolledList attributeList = new AttributePolledList();
            NumberSpectrumRecorder recorder = new NumberSpectrumRecorder();
            String spectrumName = "tango/tangotest/1/short_spectrum_ro";
            if (args.length > 0) {
                spectrumName = args[0];
            }
            INumberSpectrum spectrum = (INumberSpectrum)attributeList.add(spectrumName);
            recorder.setModel(spectrum);
            JFrame f = new JFrame("NumberSpectrumRecorder");
            f.setDefaultCloseOperation(3);
            attributeList.startRefresher();
            f.setContentPane(recorder);
            f.setSize(640, 480);
            f.setVisible(true);
            f.repaint();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

