/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.DevStateSpectrumEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IDevStateSpectrum;
import fr.esrf.tangoatk.core.IDevStateSpectrumListener;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.ISpectrumListener;
import fr.esrf.tangoatk.core.IStringSpectrum;
import fr.esrf.tangoatk.core.IStringSpectrumListener;
import fr.esrf.tangoatk.core.NumberSpectrumEvent;
import fr.esrf.tangoatk.core.Property;
import fr.esrf.tangoatk.core.StringSpectrumEvent;
import fr.esrf.tangoatk.widget.attribute.SimplePropertyFrame;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKFormat;
import fr.esrf.tangoatk.widget.util.chart.ColorItem;
import fr.esrf.tangoatk.widget.util.chart.IJLChartListener;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLChartEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.border.EtchedBorder;

public class NumberSpectrumStateBarChartViewer
extends JLChart
implements IJLChartListener,
ISpectrumListener,
IDevStateSpectrumListener,
IStringSpectrumListener,
PropertyChangeListener {
    private INumberSpectrum numberModel = null;
    private IDevStateSpectrum stateModel = null;
    private IStringSpectrum nameModel = null;
    protected JLDataView dvy = null;
    protected JLDataView minAlarmDv = null;
    protected JLDataView maxAlarmDv = null;
    private SimplePropertyFrame pf = null;
    private double A0 = 0.0;
    private double A1 = 1.0;
    private String format = null;
    private String[] currentStates = null;
    protected String[] names = null;
    private Color defaultBarChartColor = ATKConstant.getColor4State("UNKNOWN");
    private int barChartFillMethod = 2;
    private long lastForcedUpdateTime = System.currentTimeMillis() - 60000L;
    private boolean drawOnNaN = false;
    private boolean minAlarmVisible = false;
    private boolean maxAlarmVisible = false;
    private Color minAlarmColor = ATKConstant.getColor4State("ALARM");
    private Color maxAlarmColor = ATKConstant.getColor4State("ALARM");
    private int minAlarmStyle = 0;
    private int maxAlarmStyle = 0;
    private Double minAlarmValue = null;
    private Double maxAlarmValue = null;

    public NumberSpectrumStateBarChartViewer() {
        this.setBorder(new EtchedBorder());
        this.getY1Axis().setAutoScale(true);
        this.getXAxis().setAutoScale(true);
        this.getXAxis().setAnnotation(2);
        this.dvy = new JLDataView();
        this.dvy.setViewType(1);
        this.dvy.setBarWidth(5);
        this.dvy.setFillStyle(1);
        this.dvy.setLineWidth(0);
        this.dvy.setColor(this.defaultBarChartColor);
        this.dvy.setFillColor(this.defaultBarChartColor);
        this.dvy.setLabelVisible(false);
        this.getY1Axis().addDataView(this.dvy);
        this.minAlarmDv = new JLDataView();
        this.minAlarmDv.setName("Min Alarm");
        this.minAlarmDv.setStyle(this.minAlarmStyle);
        this.minAlarmDv.setLineWidth(2);
        this.minAlarmDv.setColor(this.minAlarmColor);
        this.minAlarmDv.setLabelVisible(false);
        this.maxAlarmDv = new JLDataView();
        this.maxAlarmDv.setName("Max Alarm");
        this.maxAlarmDv.setStyle(this.maxAlarmStyle);
        this.maxAlarmDv.setLineWidth(2);
        this.maxAlarmDv.setColor(this.maxAlarmColor);
        this.maxAlarmDv.setLabelVisible(false);
        this.setJLChartListener(this);
    }

    public Color getDefaultBarChartColor() {
        return this.defaultBarChartColor;
    }

    public void setDefaultBarChartColor(Color col) {
        if (this.defaultBarChartColor != col) {
            this.defaultBarChartColor = col;
            this.dvy.setColor(this.defaultBarChartColor);
            this.dvy.setFillColor(this.defaultBarChartColor);
            this.repaint();
        }
    }

    public int getBarChartFillMethod() {
        return this.barChartFillMethod;
    }

    public void setBarChartFillMethod(int fillMethod) {
        if (this.barChartFillMethod != fillMethod) {
            this.dvy.setFillMethod(fillMethod);
            this.barChartFillMethod = this.dvy.getFillMethod();
        }
    }

    public boolean getDrawOnNaN() {
        this.drawOnNaN = this.dvy.isDrawOnNaN();
        return this.drawOnNaN;
    }

    public void setDrawOnNaN(boolean don) {
        this.dvy.setDrawOnNaN(don);
        this.drawOnNaN = don;
    }

    public boolean getMinAlarmVisible() {
        return this.minAlarmVisible;
    }

    public void setMinAlarmVisible(boolean vis) {
        if (this.minAlarmVisible != vis) {
            this.changeMinAlarmVisibility(vis);
        }
        this.minAlarmVisible = vis;
    }

    public boolean getMaxAlarmVisible() {
        return this.maxAlarmVisible;
    }

    public void setMaxAlarmVisible(boolean vis) {
        if (this.maxAlarmVisible != vis) {
            this.changeMaxAlarmVisibility(vis);
        }
        this.maxAlarmVisible = vis;
    }

    public Color getMinAlarmColor() {
        return this.minAlarmColor;
    }

    public void setMinAlarmColor(Color macol) {
        this.minAlarmDv.setColor(macol);
        this.minAlarmColor = macol;
    }

    public Color getMaxAlarmColor() {
        return this.maxAlarmColor;
    }

    public void setMaxAlarmColor(Color macol) {
        this.maxAlarmDv.setColor(macol);
        this.maxAlarmColor = macol;
    }

    public int getMinAlarmStyle() {
        return this.minAlarmStyle;
    }

    public void setMinAlarmStyle(int maStyle) {
        this.minAlarmDv.setStyle(maStyle);
        this.minAlarmStyle = maStyle;
    }

    public int getMaxAlarmStyle() {
        return this.maxAlarmStyle;
    }

    public void setMaxAlarmStyle(int maStyle) {
        this.maxAlarmDv.setStyle(maStyle);
        this.maxAlarmStyle = maStyle;
    }

    public INumberSpectrum getModel() {
        return this.numberModel;
    }

    public void setModel(INumberSpectrum ins) {
        this.clearNumberModel();
        if (ins == null) {
            this.repaint();
            return;
        }
        this.numberModel = ins;
        this.format = this.numberModel.getFormat();
        this.dvy.setUserFormat(this.format);
        this.dvy.setUnit(ins.getUnit());
        this.dvy.setName(ins.getName());
        this.numberModel.addSpectrumListener((ISpectrumListener)this);
        this.numberModel.refresh();
        double minAlarm = this.numberModel.getMinAlarm();
        if (Double.isNaN(minAlarm)) {
            this.minAlarmValue = null;
            this.changeMinAlarmVisibility(false);
        } else {
            this.minAlarmValue = new Double(minAlarm);
            if (this.minAlarmVisible) {
                this.changeMinAlarmVisibility(true);
            }
        }
        double maxAlarm = this.numberModel.getMaxAlarm();
        if (Double.isNaN(maxAlarm)) {
            this.maxAlarmValue = null;
            this.changeMaxAlarmVisibility(false);
        } else {
            this.maxAlarmValue = new Double(maxAlarm);
            if (this.maxAlarmVisible) {
                this.changeMaxAlarmVisibility(true);
            }
        }
        if (this.pf != null) {
            this.pf.setModel((IAttribute)this.numberModel);
        }
        this.numberModel.getProperty("min_alarm").addPresentationListener((PropertyChangeListener)this);
        this.numberModel.getProperty("max_alarm").addPresentationListener((PropertyChangeListener)this);
        this.repaint();
    }

    public void clearNumberModel() {
        if (this.numberModel != null) {
            this.numberModel.removeSpectrumListener((ISpectrumListener)this);
            if (this.pf != null) {
                this.pf.setModel(null);
            }
            this.setMinAlarmVisible(false);
            this.setMaxAlarmVisible(false);
            this.numberModel.getProperty("min_alarm").removePresentationListener((PropertyChangeListener)this);
            this.numberModel.getProperty("max_alarm").removePresentationListener((PropertyChangeListener)this);
            this.numberModel = null;
            this.minAlarmValue = null;
            this.maxAlarmValue = null;
        }
        this.setToolTipText(null);
    }

    public IDevStateSpectrum getStatesModel() {
        return this.stateModel;
    }

    public void setModel(IDevStateSpectrum idss) {
        this.clearStateModel();
        if (idss == null) {
            this.repaint();
            return;
        }
        this.stateModel = idss;
        this.stateModel.addDevStateSpectrumListener((IDevStateSpectrumListener)this);
        this.repaint();
    }

    public void clearStateModel() {
        if (this.stateModel != null) {
            this.stateModel.removeDevStateSpectrumListener((IDevStateSpectrumListener)this);
            this.stateModel = null;
            for (int i = 0; i < this.currentStates.length; ++i) {
                this.dvy.setBarFillColorAt(i, ATKConstant.getColor4State("UNKNOWN"));
            }
        }
        this.currentStates = null;
    }

    public IStringSpectrum getNamesModel() {
        return this.nameModel;
    }

    public void setModel(IStringSpectrum iss) {
        this.clearNameModel();
        if (iss == null) {
            return;
        }
        this.nameModel = iss;
        this.nameModel.addListener((IStringSpectrumListener)this);
    }

    public void clearNameModel() {
        if (this.nameModel != null) {
            this.nameModel.removeListener((IStringSpectrumListener)this);
            this.nameModel = null;
        }
    }

    void changeMinAlarmVisibility(boolean vis) {
        if (!vis) {
            this.minAlarmDv.reset();
            this.getY1Axis().removeDataView(this.minAlarmDv);
            this.repaint();
        } else {
            if (this.numberModel == null) {
                return;
            }
            if (this.minAlarmValue == null) {
                return;
            }
            this.getY1Axis().addDataView(this.minAlarmDv);
            this.refreshAlarmDv(this.minAlarmDv, this.minAlarmValue);
        }
    }

    void changeMaxAlarmVisibility(boolean vis) {
        if (!vis) {
            this.maxAlarmDv.reset();
            this.getY1Axis().removeDataView(this.maxAlarmDv);
            this.repaint();
        } else {
            if (this.numberModel == null) {
                return;
            }
            if (this.maxAlarmValue == null) {
                return;
            }
            this.getY1Axis().addDataView(this.maxAlarmDv);
            this.refreshAlarmDv(this.maxAlarmDv, this.maxAlarmValue);
        }
    }

    @Override
    public String[] clickOnChart(JLChartEvent evt) {
        int nameIndex;
        String[] ret;
        String yValue = null;
        String xValue = null;
        int indX = -1;
        if (evt.getDataView() != this.dvy) {
            return null;
        }
        if (this.numberModel == null) {
            ret = new String[2];
            indX = 0;
        } else {
            ret = new String[3];
            ret[0] = this.numberModel.getName();
            indX = 1;
            yValue = this.format != null ? ATKFormat.format(this.format, evt.getTransformedYValue()) + " " + this.numberModel.getUnit() : evt.getTransformedYValue() + " " + this.numberModel.getUnit();
        }
        if (this.names != null && (nameIndex = evt.getDataViewIndex()) >= 0 && nameIndex < this.names.length) {
            xValue = this.names[nameIndex];
        }
        ret[indX] = xValue != null ? "X=" + xValue : "X=" + evt.getTransformedXValue();
        ret[indX + 1] = yValue != null ? "Y=" + yValue : "Y=" + evt.getTransformedYValue();
        return ret;
    }

    public void setXAxisAffineTransform(double a0, double a1) {
        this.A0 = a0;
        this.A1 = a1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spectrumChange(NumberSpectrumEvent nse) {
        double[] value = nse.getValue();
        int length = value.length;
        JLDataView jLDataView = this.dvy;
        synchronized (jLDataView) {
            Vector barColors = (Vector)this.dvy.getBarFillColors().clone();
            this.dvy.reset();
            for (int i = 0; i < length; ++i) {
                this.dvy.add(this.A0 + this.A1 * (double)i, value[i], false);
            }
            this.dvy.updateFilters();
            this.dvy.setBarFillColors(barColors);
            this.repaint();
            this.refreshTableSingle(this.dvy);
        }
    }

    public void devStateSpectrumChange(DevStateSpectrumEvent dsse) {
        String[] states = dsse.getValue();
        if (states == null) {
            return;
        }
        if (this.currentStates == null) {
            for (int i = 0; i < states.length; ++i) {
                this.dvy.setBarFillColorAt(i, ATKConstant.getColor4State(states[i]));
            }
            this.currentStates = (String[])dsse.getValue().clone();
            this.repaint();
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastForcedUpdateTime > 10000L) {
            for (int i = 0; i < states.length; ++i) {
                this.dvy.setBarFillColorAt(i, ATKConstant.getColor4State(states[i]));
                this.currentStates[i] = states[i];
            }
            this.repaint();
            this.lastForcedUpdateTime = now;
            return;
        }
        for (int i = 0; i < states.length; ++i) {
            if (this.currentStates[i].equalsIgnoreCase(states[i])) continue;
            this.dvy.setBarFillColorAt(i, ATKConstant.getColor4State(states[i]));
            this.currentStates[i] = states[i];
        }
        this.repaint();
    }

    public void stringSpectrumChange(StringSpectrumEvent evt) {
        if (evt.getValue() != null) {
            if (evt.getValue().length <= 0) {
                return;
            }
            this.names = evt.getValue();
        }
    }

    public void refreshAlarmDv(JLDataView alarmDv, double alarmValue) {
        if (this.dvy.getDataLength() < 3) {
            return;
        }
        double firstX = this.dvy.getXValueByIndex(0);
        double lastX = this.dvy.getXValueByIndex(this.dvy.getDataLength() - 1);
        alarmDv.reset();
        alarmDv.add(firstX, alarmValue);
        alarmDv.add(lastX, alarmValue);
        this.repaint();
    }

    public void stateChange(AttributeStateEvent e) {
    }

    public void errorChange(ErrorEvent errEvt) {
        if (errEvt.getSource() == this.numberModel) {
            this.dvy.reset();
            this.repaint();
            this.refreshTableSingle(this.dvy);
            return;
        }
        if (errEvt.getSource() == this.stateModel) {
            Vector<ColorItem> barColors = this.dvy.getBarFillColors();
            barColors.clear();
            this.currentStates = null;
            this.repaint();
            return;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Property src = (Property)evt.getSource();
        if (this.numberModel != null) {
            if (src.getName().equalsIgnoreCase("min_alarm")) {
                double minAlarm = this.numberModel.getMinAlarm();
                if (Double.isNaN(minAlarm)) {
                    this.minAlarmValue = null;
                    this.changeMinAlarmVisibility(false);
                } else {
                    this.minAlarmValue = new Double(minAlarm);
                    if (this.minAlarmVisible) {
                        this.changeMinAlarmVisibility(true);
                    }
                }
                return;
            }
            if (src.getName().equalsIgnoreCase("max_alarm")) {
                double maxAlarm = this.numberModel.getMaxAlarm();
                if (Double.isNaN(maxAlarm)) {
                    this.maxAlarmValue = null;
                    this.changeMaxAlarmVisibility(false);
                } else {
                    this.maxAlarmValue = new Double(maxAlarm);
                    if (this.maxAlarmVisible) {
                        this.changeMaxAlarmVisibility(true);
                    }
                }
            }
        }
    }

    public static void main(String[] args) {
        try {
            AttributeList attl = new AttributeList();
            NumberSpectrumStateBarChartViewer nssbcv = new NumberSpectrumStateBarChartViewer();
            nssbcv.setBarChartFillMethod(1);
            nssbcv.getXAxis().setGridVisible(true);
            nssbcv.getY1Axis().setGridVisible(true);
            nssbcv.getY1Axis().setName("Neutron Dose Rate");
            nssbcv.setMaxAlarmColor(Color.red);
            nssbcv.setMaxAlarmVisible(true);
            INumberSpectrum ins = (INumberSpectrum)attl.add("sr/neutron/all/Dose");
            nssbcv.setModel(ins);
            IDevStateSpectrum idss = (IDevStateSpectrum)attl.add("sr/neutron/all/SubDevicesStates");
            nssbcv.setModel(idss);
            IStringSpectrum iss = (IStringSpectrum)attl.add("sr/neutron/all/SubDevicesNames");
            nssbcv.setModel(iss);
            nssbcv.setBorder(BorderFactory.createLoweredBevelBorder());
            nssbcv.setFont(new Font("Dialog", 0, 12));
            nssbcv.setPreferredSize(new Dimension(850, 480));
            attl.startRefresher();
            JFrame f = new JFrame();
            f.setContentPane(nssbcv);
            f.pack();
            f.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

