/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.INumberSpectrumHistory;
import fr.esrf.tangoatk.core.ISpectrumListener;
import fr.esrf.tangoatk.core.NumberSpectrumEvent;
import fr.esrf.tangoatk.widget.attribute.I3DTrendChangeListener;
import fr.esrf.tangoatk.widget.attribute.I3DTrendCursorListener;
import fr.esrf.tangoatk.widget.attribute.NumberSpectrumTrend3DViewerListener;
import fr.esrf.tangoatk.widget.attribute.SimplePropertyFrame;
import fr.esrf.tangoatk.widget.attribute.TrendData;
import fr.esrf.tangoatk.widget.attribute.ZoomInfo;
import fr.esrf.tangoatk.widget.image.LineProfilerViewer;
import fr.esrf.tangoatk.widget.properties.LabelViewer;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKFormat;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.Gradient;
import fr.esrf.tangoatk.widget.util.J3DTrend;
import fr.esrf.tangoatk.widget.util.J3DTrendListener;
import fr.esrf.tangoatk.widget.util.JGradientEditor;
import fr.esrf.tangoatk.widget.util.JGradientViewer;
import fr.esrf.tangoatk.widget.util.JSmoothLabel;
import fr.esrf.tangoatk.widget.util.chart.IJLChartListener;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLChartEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.event.EventListenerList;

public class NumberSpectrumTrend3DViewer
extends JComponent
implements ISpectrumListener,
ActionListener,
MouseListener,
J3DTrendListener,
IJLChartListener,
AdjustmentListener {
    public static final ZoomInfo[] zoomInfos = new ZoomInfo[]{new ZoomInfo("10%", -10), new ZoomInfo("25%", -4), new ZoomInfo("50%", -2), new ZoomInfo("100%", 1), new ZoomInfo("200%", 2), new ZoomInfo("300%", 3), new ZoomInfo("400%", 4), new ZoomInfo("500%", 5), new ZoomInfo("800%", 8), new ZoomInfo("1600%", 16)};
    static final GregorianCalendar calendar = new GregorianCalendar();
    static final SimpleDateFormat genFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    protected INumberSpectrum model = null;
    private TrendData[] data;
    private TrendData[] derivativeData;
    private J3DTrend trend;
    private JScrollPane trendView;
    private int historyLength;
    private int[] gColormap;
    private Gradient gColor;
    private double zMin;
    private double zMax;
    private boolean zAutoScale;
    private JGradientViewer gradientViewer;
    private JLabel statusLabel;
    private Color NaNColor = new Color(128, 128, 128);
    private int rdimx;
    private int rdimy;
    private int vZoom;
    private int hZoom;
    private boolean readPollingHistory = true;
    private String valueName = "value";
    private String yName = "Y";
    private String[] yIndexName = new String[0];
    private String yUnit = "";
    private double yGain = 1.0;
    private double yOffset = 0.0;
    private String generalName = " ";
    private String unitName = "";
    private boolean logScale = false;
    private boolean showDerivative = false;
    private int zoomScroll;
    private String format;
    private File currentFile = null;
    private EventListenerList listenerList = new EventListenerList();
    private int lastHScrollPos = 0;
    private int lastVScrollPos = 0;
    private String[] zoomText;
    private boolean showingMenu;
    protected JPopupMenu popupMenu;
    protected JMenuItem saveFileMenuItem;
    protected JMenuItem settingsMenuItem;
    protected JMenuItem hProfileMenuItem;
    protected JMenuItem vProfileMenuItem;
    protected JMenu hZoomMenu;
    protected JMenu vZoomMenu;
    protected JFrame settingsFrame = null;
    private JPanel settingsPanel;
    private LabelViewer attNameLabel = null;
    private JButton propButton;
    private JCheckBox autoScaleCheck;
    private JTextField minText;
    private JTextField maxText;
    private JGradientEditor gradEditor;
    private JButton gradButton;
    private JTextField hLengthText;
    private JComboBox hZoomCombo = null;
    private JComboBox vZoomCombo = null;
    private JButton okButton;
    private JButton cancelButton;
    private JCheckBox logScaleCheck;
    private JCheckBox derivativeCheck;
    private JTextField formatText;
    protected SimplePropertyFrame propDialog = null;
    protected LineProfilerViewer vProfiler = null;
    protected JFrame hProfiler = null;
    protected JLChart hProfilerGraph;
    protected JLDataView hProfilerData;

    public NumberSpectrumTrend3DViewer() {
        JCheckBoxMenuItem m;
        int i;
        this.setLayout(new BorderLayout());
        this.historyLength = 0;
        this.setHistoryLength(800);
        this.derivativeData = null;
        this.zAutoScale = true;
        this.zMin = 0.0;
        this.zMax = 100.0;
        this.rdimx = this.historyLength;
        this.rdimy = 256;
        this.hZoom = 1;
        this.vZoom = 1;
        this.zoomScroll = 0;
        this.gColor = new Gradient();
        this.gColor.buildRainbowGradient();
        this.gColormap = this.gColor.buildColorMap(65536);
        this.format = "";
        this.trend = new J3DTrend();
        this.trend.setParent(this);
        this.trend.addMouseListener(this);
        this.trendView = new JScrollPane(this.trend);
        this.trendView.getHorizontalScrollBar().addAdjustmentListener(this);
        this.trendView.getVerticalScrollBar().addAdjustmentListener(this);
        this.add((Component)this.trendView, "Center");
        this.gradientViewer = new JGradientViewer();
        this.gradientViewer.setGradient(this.gColor);
        this.add((Component)this.gradientViewer, "East");
        this.statusLabel = new JLabel(" ");
        this.add((Component)this.statusLabel, "North");
        this.showingMenu = true;
        this.popupMenu = new JPopupMenu();
        this.hZoomMenu = new JMenu("Horz. Zoom");
        this.popupMenu.add(this.hZoomMenu);
        for (i = 0; i < zoomInfos.length; ++i) {
            m = new JCheckBoxMenuItem(NumberSpectrumTrend3DViewer.zoomInfos[i].text);
            m.addActionListener(this);
            this.hZoomMenu.add(m);
        }
        this.vZoomMenu = new JMenu("Vert. Zoom");
        for (i = 0; i < zoomInfos.length; ++i) {
            m = new JCheckBoxMenuItem(NumberSpectrumTrend3DViewer.zoomInfos[i].text);
            m.addActionListener(this);
            this.vZoomMenu.add(m);
        }
        this.popupMenu.add(this.vZoomMenu);
        this.popupMenu.add(this.vZoomMenu);
        this.popupMenu.add(new JSeparator());
        this.hProfileMenuItem = new JMenuItem("Horz. profile");
        this.hProfileMenuItem.addActionListener(this);
        this.popupMenu.add(this.hProfileMenuItem);
        this.vProfileMenuItem = new JMenuItem("Vert. profile");
        this.vProfileMenuItem.addActionListener(this);
        this.popupMenu.add(this.vProfileMenuItem);
        this.popupMenu.add(new JSeparator());
        this.settingsMenuItem = new JMenuItem("Settings");
        this.settingsMenuItem.addActionListener(this);
        this.popupMenu.add(this.settingsMenuItem);
        this.popupMenu.add(new JSeparator());
        this.saveFileMenuItem = new JMenuItem("Save data");
        this.saveFileMenuItem.addActionListener(this);
        this.popupMenu.add(this.saveFileMenuItem);
        this.buildImage();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent evt) {
        int value;
        Object src = evt.getSource();
        if (evt.getAdjustmentType() != 1 && evt.getAdjustmentType() != 2 && evt.getAdjustmentType() != 4 && evt.getAdjustmentType() != 3 && evt.getAdjustmentType() != 5) {
            return;
        }
        if (src == this.trendView.getHorizontalScrollBar()) {
            int value2 = this.trendView.getHorizontalScrollBar().getValue();
            if (this.lastHScrollPos != value2) {
                this.fireHScroolChange(value2);
                this.lastHScrollPos = value2;
            }
        } else if (src == this.trendView.getVerticalScrollBar() && (value = this.trendView.getVerticalScrollBar().getValue()) != this.lastVScrollPos) {
            this.fireVScroolChange(value);
            this.lastVScrollPos = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHistoryLength(int length) {
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            int i;
            TrendData[] newData = new TrendData[length];
            for (i = 0; i < this.historyLength && i < length; ++i) {
                newData[i] = this.data[i];
            }
            while (i < length) {
                newData[i] = null;
                ++i;
            }
            this.data = newData;
            this.historyLength = length;
            if (this.showDerivative) {
                this.buildDerivative();
            }
        }
    }

    public J3DTrend getTrend() {
        return this.trend;
    }

    public int getHistoryLength() {
        return this.historyLength;
    }

    public void clearData() {
        this.setData((double[])null, null);
        this.trend.clearCursor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(long[] dates, double[][] data) {
        if (dates == null || data == null) {
            NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
            synchronized (numberSpectrumTrend3DViewer) {
                TrendData[] newData = new TrendData[this.historyLength];
                for (int i = 0; i < this.historyLength; ++i) {
                    newData[i] = null;
                }
                this.data = newData;
                if (this.showDerivative) {
                    this.buildDerivative();
                }
                this.buildImage();
                return;
            }
        }
        if (dates.length != data.length) {
            System.out.println("Invalid data: date length and data length differ");
            return;
        }
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            int nbData = dates.length;
            TrendData[] newData = new TrendData[nbData];
            for (int i = 0; i < nbData; ++i) {
                newData[nbData - i - 1] = new TrendData();
                newData[nbData - i - 1].time = dates[i];
                newData[nbData - i - 1].values = data[i];
            }
            this.data = newData;
            this.historyLength = nbData;
            if (this.showDerivative) {
                this.buildDerivative();
            }
            this.buildImage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(double[] dates, double[][] data) {
        if (dates == null || data == null) {
            NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
            synchronized (numberSpectrumTrend3DViewer) {
                TrendData[] newData = new TrendData[this.historyLength];
                for (int i = 0; i < this.historyLength; ++i) {
                    newData[i] = null;
                }
                this.data = newData;
                if (this.showDerivative) {
                    this.buildDerivative();
                }
                this.buildImage();
                return;
            }
        }
        if (dates.length != data.length) {
            System.out.println("Invalid data: date length and data length differ");
            return;
        }
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            int nbData = dates.length;
            TrendData[] newData = new TrendData[nbData];
            for (int i = 0; i < nbData; ++i) {
                newData[nbData - i - 1] = new TrendData();
                newData[nbData - i - 1].time = dates[i];
                newData[nbData - i - 1].values = data[i];
            }
            this.data = newData;
            this.historyLength = nbData;
            if (this.showDerivative) {
                this.buildDerivative();
            }
            this.buildImage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setZMinimum(double min) {
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.zMin = min;
        }
    }

    public double getZMinimum() {
        return this.zMin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setZMaximum(double max) {
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.zMax = max;
        }
    }

    public double getZMaximum() {
        return this.zMax;
    }

    public boolean isZAutoScale() {
        return this.zAutoScale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setZAutoScale(boolean autoScale) {
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.zAutoScale = autoScale;
        }
    }

    public boolean isLogScale() {
        return this.logScale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogScale(boolean logScale) {
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.logScale = logScale;
        }
    }

    public boolean isShowDerivative() {
        return this.showDerivative;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShowDerivative(boolean show) {
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.showDerivative = show;
            this.buildDerivative();
            this.buildImage();
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGradient(Gradient g) {
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.gColor = g;
            this.gColormap = g.buildColorMap(65536);
            this.gradientViewer.setGradient(this.gColor);
            this.gradientViewer.repaint();
        }
    }

    public Gradient getGradient() {
        return this.gColor;
    }

    public void setGradientVisible(boolean b) {
        this.gradientViewer.setVisible(b);
    }

    public boolean isGradientVisible() {
        return this.gradientViewer.isVisible();
    }

    public void setNaNColor(Color nanColor) {
        this.NaNColor = nanColor;
    }

    public JLAxis getXAxis() {
        return this.trend.getXAxis();
    }

    public JLAxis getYAxis() {
        return this.trend.getYAxis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHorizontalZoom(int zoom) {
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.zoomScroll = 0;
            this.setZoomCombo(this.hZoomCombo, zoom);
            this.hZoom = zoom;
        }
    }

    public int getHorizontalZoom() {
        return this.hZoom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVerticalZoom(int zoom) {
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.setZoomCombo(this.vZoomCombo, zoom);
            this.vZoom = zoom;
        }
    }

    public int getVerticalZoom() {
        return this.vZoom;
    }

    public void setFormat(String f) {
        this.format = f;
    }

    public String getFormat() {
        return this.format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModel(INumberSpectrum v) {
        this.clearModel();
        if (v == null) {
            this.repaint();
            return;
        }
        this.model = v;
        if (this.readPollingHistory) {
            this.readHistory();
        }
        this.statusLabel.setText(this.model.getName());
        this.model.addSpectrumListener((ISpectrumListener)this);
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.buildImage();
        }
        this.repaint();
    }

    public void clearModel() {
        if (this.model != null) {
            this.model.removeSpectrumListener((ISpectrumListener)this);
            if (this.attNameLabel != null) {
                this.attNameLabel.setModel(null);
            }
        }
        this.model = null;
    }

    public double getTimeAt(int x) {
        int xData = this.hZoom >= 1 ? this.historyLength - x / this.hZoom - 1 : this.historyLength - x * -this.hZoom - 1;
        if (xData >= 0 && xData < this.historyLength) {
            if (this.data[xData] != null) {
                return this.data[xData].time;
            }
            return 0.0;
        }
        return 0.0;
    }

    public void addNumberSpectrumTrend3DViewerListener(NumberSpectrumTrend3DViewerListener l) {
        this.listenerList.add(NumberSpectrumTrend3DViewerListener.class, l);
    }

    public void addCursorListener(I3DTrendCursorListener l) {
        this.listenerList.add(I3DTrendCursorListener.class, l);
    }

    public void removeCursorListener(I3DTrendCursorListener l) {
        this.listenerList.remove(I3DTrendCursorListener.class, l);
    }

    public void addChangeListener(I3DTrendChangeListener l) {
        this.listenerList.add(I3DTrendChangeListener.class, l);
    }

    public void removeChangeListener(I3DTrendChangeListener l) {
        this.listenerList.remove(I3DTrendChangeListener.class, l);
    }

    private void fireZoomChange() {
        I3DTrendChangeListener[] list = (I3DTrendChangeListener[])this.listenerList.getListeners(I3DTrendChangeListener.class);
        for (int i = 0; i < list.length; ++i) {
            list[i].zoomChanged(this, this.getHorizontalZoom(), this.getVerticalZoom());
        }
    }

    private void fireVScroolChange(int value) {
        I3DTrendChangeListener[] list = (I3DTrendChangeListener[])this.listenerList.getListeners(I3DTrendChangeListener.class);
        for (int i = 0; i < list.length; ++i) {
            list[i].verticalScrollChanged(this, value);
        }
    }

    private void fireHScroolChange(int value) {
        I3DTrendChangeListener[] list = (I3DTrendChangeListener[])this.listenerList.getListeners(I3DTrendChangeListener.class);
        for (int i = 0; i < list.length; ++i) {
            list[i].horinzontalScrollChanged(this, value);
        }
    }

    private void fireCursorMove() {
        I3DTrendCursorListener[] list = (I3DTrendCursorListener[])this.listenerList.getListeners(I3DTrendCursorListener.class);
        for (int i = 0; i < list.length; ++i) {
            list[i].cursorMove(this, this.getXCursor(), this.getYCursor());
        }
    }

    public void setCursorPos(int x, int y) {
        int xImg = this.hZoom >= 1 ? this.hZoom * (this.historyLength - (x + 1)) : (this.historyLength - (x + 1)) / -this.hZoom;
        int yImg = this.vZoom >= 1 ? this.vZoom * y : y / -this.vZoom;
        this.trend.setCursor(xImg, yImg);
    }

    public int getXCursor() {
        int x = this.trend.getXCursor();
        if (x < 0) {
            return -1;
        }
        int xData = this.hZoom >= 1 ? this.historyLength - x / this.hZoom - 1 : this.historyLength - x * -this.hZoom - 1;
        return xData;
    }

    public int getYCursor() {
        int y = this.trend.getYCursor();
        if (y < 0) {
            return -1;
        }
        int yData = this.vZoom >= 1 ? y / this.vZoom : y * -this.vZoom;
        return yData;
    }

    public double getValueAt(int x, int y) {
        int xData = this.hZoom >= 1 ? this.historyLength - x / this.hZoom - 1 : this.historyLength - x * -this.hZoom - 1;
        if (xData >= 0 && xData < this.historyLength) {
            if (this.data[xData] != null) {
                int yData = this.vZoom >= 1 ? y / this.vZoom : y * -this.vZoom;
                if (yData >= 0 && yData < this.data[xData].values.length) {
                    return this.data[xData].values[yData];
                }
                return Double.NaN;
            }
            return Double.NaN;
        }
        return Double.NaN;
    }

    public void setCursorEnabled(boolean enable) {
        this.trend.setCursorEnabled(enable);
    }

    public void clearStatusLabel() {
        this.trend.clearCursor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCursor(int xCursor, int yCursor, boolean fireCursorChange) {
        String modelName = this.generalName;
        String modelUnit = this.unitName;
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            NumberSpectrumTrend3DViewerListener[] list;
            if (this.model != null) {
                modelName = this.model.getName();
                modelUnit = this.model.getUnit();
                this.format = this.model.getFormat();
            }
            if ((list = (NumberSpectrumTrend3DViewerListener[])this.listenerList.getListeners(NumberSpectrumTrend3DViewerListener.class)).length > 0) {
                int yIndex = this.vZoom >= 1 ? yCursor / this.vZoom : yCursor * -this.vZoom;
                int xIndex = this.hZoom >= 1 ? this.historyLength - xCursor / this.hZoom - 1 : this.historyLength - xCursor * -this.hZoom - 1;
                long time = (long)this.getTimeAt(xCursor);
                double val = this.getValueAt(xCursor, yCursor);
                String status = xCursor < 0 | yCursor < 0 ? list[0].getStatusLabel(this, -1, -1, time, val) : list[0].getStatusLabel(this, xIndex, yIndex, time, val);
                this.statusLabel.setText(status);
            } else if (xCursor < 0) {
                this.statusLabel.setText(modelName);
            } else {
                double time = this.getTimeAt(xCursor);
                if (time == 0.0) {
                    this.statusLabel.setText(modelName + "  | no data at marker position");
                } else {
                    String timeStr = this.buildTime(time);
                    double val = this.getValueAt(xCursor, yCursor);
                    if (Double.isNaN(val)) {
                        if (this.vZoom >= 1) {
                            int yIndex = (int)((double)(yCursor / this.vZoom) * this.yGain + this.yOffset + 0.5);
                            if (yIndex >= 0 && yIndex < this.yIndexName.length) {
                                this.statusLabel.setText(modelName + "  | " + timeStr + " " + this.valueName + "=NaN at " + this.yName + "=" + this.yIndexName[yIndex] + " " + this.yUnit);
                            } else {
                                this.statusLabel.setText(modelName + "  | " + timeStr + " " + this.valueName + "=NaN at " + this.yName + "=" + ((double)(yCursor / this.vZoom) * this.yGain + this.yOffset) + " " + this.yUnit);
                            }
                        } else {
                            int yIndex = (int)((double)(yCursor * -this.vZoom) * this.yGain + this.yOffset + 0.5);
                            if (yIndex >= 0 && yIndex < this.yIndexName.length) {
                                this.statusLabel.setText(modelName + "  | " + timeStr + " " + this.valueName + "=NaN at " + this.yName + "=" + this.yIndexName[yIndex] + " " + this.yUnit);
                            } else {
                                this.statusLabel.setText(modelName + "  | " + timeStr + " " + this.valueName + "=NaN at " + this.yName + "=" + ((double)(yCursor * -this.vZoom) * this.yGain + this.yOffset) + " " + this.yUnit);
                            }
                        }
                    } else {
                        String value = this.format.length() > 0 ? ATKFormat.format(this.format, val) : Double.toString(val);
                        if (this.vZoom >= 1) {
                            int yIndex = (int)((double)(yCursor / this.vZoom) * this.yGain + this.yOffset + 0.5);
                            if (yIndex >= 0 && yIndex < this.yIndexName.length) {
                                this.statusLabel.setText(modelName + "  | " + timeStr + " " + this.valueName + "=" + value + " " + modelUnit + " at " + this.yName + "=" + this.yIndexName[yIndex] + " " + this.yUnit);
                            } else {
                                this.statusLabel.setText(modelName + "  | " + timeStr + " " + this.valueName + "=" + value + " " + modelUnit + " at " + this.yName + "=" + ((double)(yCursor / this.vZoom) * this.yGain + this.yOffset) + " " + this.yUnit);
                            }
                        } else {
                            int yIndex = (int)((double)(yCursor * -this.vZoom) * this.yGain + this.yOffset + 0.5);
                            if (yIndex >= 0 && yIndex < this.yIndexName.length) {
                                this.statusLabel.setText(modelName + "  | " + timeStr + " " + this.valueName + "=" + value + " " + modelUnit + " at " + this.yName + "=" + this.yIndexName[yIndex] + " " + this.yUnit);
                            } else {
                                this.statusLabel.setText(modelName + "  | " + timeStr + " " + this.valueName + "=" + value + " " + modelUnit + " at " + this.yName + "=" + ((double)(yCursor * -this.vZoom) * this.yGain + this.yOffset) + " " + this.yUnit);
                            }
                        }
                    }
                }
            }
            if (this.vProfiler != null && this.vProfiler.isVisible()) {
                this.buildVerticalProfile();
            }
            if (this.hProfiler != null && this.hProfiler.isVisible()) {
                this.buildHorizontalProfile();
            }
        }
        if (fireCursorChange) {
            this.fireCursorMove();
        }
    }

    public void setShowingMenu(boolean b) {
        this.showingMenu = b;
    }

    public boolean isShowingMenu() {
        return this.showingMenu;
    }

    public void readPollingHistory(boolean readPolling) {
        this.readPollingHistory = readPolling;
    }

    public void setValueName(String vName) {
        this.valueName = vName.length() == 0 ? "value" : vName;
    }

    public void setYName(String yName) {
        this.yName = yName.length() == 0 ? "Y" : yName;
    }

    public void setYIndexName(String[] idxName) {
        this.yIndexName = idxName == null ? new String[0] : idxName;
    }

    public void setYUnit(String unit) {
        this.yUnit = unit;
    }

    public void setYTransfom(double gain, double offset) {
        this.yGain = gain;
        this.yOffset = offset;
    }

    public void setUnit(String unit) {
        this.unitName = unit;
    }

    @Override
    public void setName(String name) {
        this.generalName = name.length() == 0 ? " " : name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.buildImage();
        }
        this.repaint();
    }

    public void scrollToRight() {
        JScrollBar bar = this.trendView.getHorizontalScrollBar();
        int p = bar.getMaximum();
        bar.setValue(p);
    }

    public void scrollToLeft() {
        JScrollBar bar = this.trendView.getHorizontalScrollBar();
        int p = bar.getMinimum();
        bar.setValue(p);
    }

    public void setHorinzontalScrollPos(int pos) {
        JScrollBar bar = this.trendView.getHorizontalScrollBar();
        bar.setValue(pos);
    }

    public void setVertitalScrollPos(int pos) {
        JScrollBar bar = this.trendView.getVerticalScrollBar();
        bar.setValue(pos);
    }

    public void setTrendBackground(Color bg) {
        this.trend.setBackground(bg);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.settingsMenuItem) {
            this.showSettings();
        } else if (src == this.saveFileMenuItem) {
            this.saveDataFile();
        } else if (src == this.propButton) {
            this.showPropertyFrame();
        } else if (src == this.autoScaleCheck) {
            this.applyAutoScale();
        } else if (src == this.cancelButton) {
            this.settingsFrame.setVisible(false);
        } else if (src == this.okButton) {
            this.applySettings();
        } else if (src == this.minText) {
            this.applyMinMaxAndBuild();
        } else if (src == this.maxText) {
            this.applyMinMaxAndBuild();
        } else if (src == this.gradButton) {
            this.showGradientEditor();
        } else if (src == this.hLengthText) {
            this.applyHistoryLengthAndBuild();
        } else if (src == this.hZoomCombo) {
            this.applyHorizontalZoom();
        } else if (src == this.vZoomCombo) {
            this.applyVerticalZoom();
        } else if (src == this.vProfileMenuItem) {
            this.showVerticalProfile();
        } else if (src == this.hProfileMenuItem) {
            this.showHorizontalProfile();
        } else if (src == this.logScaleCheck) {
            this.applyLogScale();
        } else if (src == this.derivativeCheck) {
            this.applyDerivative();
        } else if (src == this.formatText) {
            this.applyFormat();
        } else {
            int vIdx;
            int hIdx = this.foundZoomMenu(this.hZoomMenu, src);
            if (hIdx >= 0) {
                this.applyHorizontalZoom(hIdx);
            }
            if ((vIdx = this.foundZoomMenu(this.vZoomMenu, src)) >= 0) {
                this.applyVerticalZoom(vIdx);
            }
        }
    }

    @Override
    public String[] clickOnChart(JLChartEvent evt) {
        Object src;
        String[] ret = new String[]{};
        String modelUnit = this.unitName;
        if (this.model != null) {
            modelUnit = this.model.getUnit();
        }
        if ((src = evt.getSource()) == this.hProfilerGraph) {
            ret = new String[2];
            long time = (long)evt.getTransformedXValue();
            ret[0] = this.buildTime(time);
            double val = evt.getTransformedYValue();
            String value = this.format.length() > 0 ? ATKFormat.format(this.format, val) : Double.toString(val);
            ret[1] = this.valueName + "=" + value + " " + modelUnit;
        }
        return ret;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 3 && this.showingMenu && e.getSource() == this.trend) {
            this.hProfileMenuItem.setEnabled(this.trend.isCursorInside());
            this.vProfileMenuItem.setEnabled(this.trend.isCursorInside());
            this.setZoomMenu(this.hZoomMenu, this.hZoom);
            this.setZoomMenu(this.vZoomMenu, this.vZoom);
            this.popupMenu.show(this.trend, e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spectrumChange(NumberSpectrumEvent evt) {
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            TrendData vals = new TrendData();
            vals.values = evt.getValue();
            vals.time = evt.getTimeStamp();
            this.shiftData();
            if (this.hZoom >= 1) {
                this.trend.shiftCursorX(-this.hZoom);
            } else {
                ++this.zoomScroll;
                if (this.zoomScroll >= -this.hZoom) {
                    this.trend.shiftCursorX(-1);
                    this.zoomScroll = 0;
                }
            }
            this.data[0] = vals;
            if (this.showDerivative) {
                TrendData dvals = new TrendData();
                dvals.time = evt.getTimeStamp();
                this.derivativeData[0] = dvals;
                this.calcD(0);
            }
            this.buildImage();
            this.repaint();
            if (this.hProfiler != null && this.hProfiler.isVisible()) {
                this.buildHorizontalProfile();
            }
        }
    }

    public void stateChange(AttributeStateEvent evt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void errorChange(ErrorEvent evt) {
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            TrendData vals = new TrendData();
            vals.values = new double[0];
            vals.time = evt.getTimeStamp();
            this.shiftData();
            if (this.hZoom >= 1) {
                this.trend.shiftCursorX(-this.hZoom);
            } else {
                ++this.zoomScroll;
                if (this.zoomScroll >= -this.hZoom) {
                    this.trend.shiftCursorX(-1);
                    this.zoomScroll = 0;
                }
            }
            this.data[0] = vals;
            if (this.showDerivative) {
                TrendData dvals = new TrendData();
                dvals.time = evt.getTimeStamp();
                this.derivativeData[0] = dvals;
                this.calcD(0);
            }
            this.buildImage();
            this.repaint();
            if (this.hProfiler != null && this.hProfiler.isVisible()) {
                this.buildHorizontalProfile();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showVerticalProfile() {
        String modelUnit = this.unitName;
        if (this.model != null) {
            modelUnit = this.model.getUnit();
        }
        this.constructVerticalProfiler();
        this.vProfiler.setMode(1);
        if (this.yUnit.length() > 0) {
            this.vProfiler.setXAxisName(this.yName + " [" + this.yUnit + "]");
        } else {
            this.vProfiler.setXAxisName(this.yName);
        }
        if (modelUnit.length() > 0) {
            this.vProfiler.setYAxisName(this.valueName + " [" + modelUnit + "]");
        } else {
            this.vProfiler.setYAxisName(this.valueName);
        }
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.buildVerticalProfile();
        }
        if (!this.vProfiler.isVisible()) {
            ATKGraphicsUtils.centerFrameOnScreen(this.vProfiler);
        }
        this.vProfiler.setVisible(true);
    }

    private void buildVerticalProfile() {
        int x = this.trend.getXCursor();
        double[] vals = new double[this.rdimy];
        for (int i = 0; i < this.rdimy; ++i) {
            vals[i] = Double.NaN;
        }
        Object title = "Vertical profile";
        int xData = this.hZoom >= 1 ? this.historyLength - x / this.hZoom - 1 : this.historyLength - x * -this.hZoom - 1;
        if (xData >= 0 && xData < this.historyLength && this.data[xData] != null) {
            String timeStr = this.buildTime(this.data[xData].time);
            title = (String)title + " at " + timeStr;
            for (int i = 0; i < this.rdimy; ++i) {
                vals[i] = i < this.data[xData].values.length ? this.data[xData].values[i] : Double.NaN;
            }
        }
        this.vProfiler.setData(vals, this.yGain, this.yOffset);
        this.vProfiler.setTitle("[profile]");
        this.vProfiler.getProfile1().getChart().setHeader((String)title);
        this.vProfiler.getProfile1().getChart().setLabelVisible(false);
        this.vProfiler.setFormat(this.format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showHorizontalProfile() {
        this.constructHorizontalProfiler();
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.buildHorizontalProfile();
        }
        if (!this.hProfiler.isVisible()) {
            ATKGraphicsUtils.centerFrameOnScreen(this.hProfiler);
        }
        this.hProfiler.setVisible(true);
    }

    private void buildHorizontalProfile() {
        int y = this.trend.getYCursor();
        int yData = this.vZoom >= 1 ? y / this.vZoom : y * -this.vZoom;
        this.hProfilerData.reset();
        for (int i = this.rdimx - 1; i >= 0; --i) {
            if (this.data[i] == null || !(this.data[i].time > 0.0)) continue;
            if (yData >= 0 && yData < this.data[i].values.length) {
                this.hProfilerData.add(this.data[i].time, this.data[i].values[yData]);
                continue;
            }
            this.hProfilerData.add(this.data[i].time, Double.NaN);
        }
        if (yData >= 0 && yData < this.rdimy) {
            int idx = (int)((double)yData * this.yGain + this.yOffset + 0.5);
            if (idx >= 0 && idx < this.yIndexName.length) {
                this.hProfilerGraph.setHeader("Horizontal profile at " + this.yName + "=" + this.yIndexName[idx]);
            } else {
                this.hProfilerGraph.setHeader("Horizontal profile at " + this.yName + "=" + ((double)yData * this.yGain + this.yOffset));
            }
        } else {
            this.hProfilerGraph.setHeader("Horizontal profile");
        }
        this.hProfilerGraph.repaint();
    }

    private void constructHorizontalProfiler() {
        if (this.hProfiler == null) {
            String modelUnit = this.unitName;
            if (this.model != null) {
                modelUnit = this.model.getUnit();
            }
            JPanel innerPanel = new JPanel(new BorderLayout());
            this.hProfilerGraph = new JLChart();
            this.hProfilerGraph.setBorder(new EtchedBorder());
            this.hProfilerGraph.getXAxis().setAutoScale(true);
            this.hProfilerGraph.getXAxis().setAnnotation(1);
            this.hProfilerGraph.getXAxis().setGridVisible(true);
            this.hProfilerGraph.getXAxis().setName("Time");
            this.hProfilerGraph.getY1Axis().setAutoScale(true);
            this.hProfilerGraph.getY1Axis().setGridVisible(true);
            if (modelUnit.length() > 0) {
                this.hProfilerGraph.getY1Axis().setName(this.valueName + " [" + modelUnit + "]");
            } else {
                this.hProfilerGraph.getY1Axis().setName(this.valueName);
            }
            this.hProfilerGraph.setPreferredSize(new Dimension(600, 400));
            this.hProfilerGraph.setMinimumSize(new Dimension(600, 400));
            this.hProfilerGraph.setHeaderFont(new Font("Dialog", 1, 18));
            this.hProfilerGraph.setHeader("Horizontal profile");
            this.hProfilerGraph.setLabelVisible(false);
            this.hProfilerGraph.setJLChartListener(this);
            innerPanel.add((Component)this.hProfilerGraph, "Center");
            this.hProfilerData = new JLDataView();
            this.hProfilerGraph.getY1Axis().addDataView(this.hProfilerData);
            this.hProfiler = new JFrame();
            this.hProfiler.setTitle("[profile]");
            this.hProfiler.setContentPane(innerPanel);
        }
    }

    private void constructVerticalProfiler() {
        if (this.vProfiler == null) {
            this.vProfiler = new LineProfilerViewer();
            this.vProfiler.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    NumberSpectrumTrend3DViewer.this.vProfiler.setData(null);
                    NumberSpectrumTrend3DViewer.this.vProfiler.dispose();
                }
            });
        }
    }

    public void showSettings() {
        this.constructSettingsPanel();
        this.initSettings();
        if (!this.settingsFrame.isVisible()) {
            ATKGraphicsUtils.centerFrame(this, this.settingsFrame);
        }
        this.settingsFrame.setVisible(true);
    }

    private int getZoomIndex(int zoom) {
        boolean found = false;
        int i = 0;
        while (!found && i < zoomInfos.length) {
            found = NumberSpectrumTrend3DViewer.zoomInfos[i].ratio == zoom;
            if (found) continue;
            ++i;
        }
        if (found) {
            return i;
        }
        throw new IllegalStateException("Unexpected zoom ratio: " + Integer.toHexString(zoom));
    }

    private void setZoomCombo(JComboBox combo, int zoom) {
        int zIdx = this.getZoomIndex(zoom);
        if (combo != null) {
            combo.setSelectedIndex(zIdx);
        }
    }

    private int foundZoomMenu(JMenu menu, Object src) {
        boolean found = false;
        int i = 0;
        while (!found && i < menu.getMenuComponentCount()) {
            found = menu.getMenuComponent(i).equals(src);
            if (found) continue;
            ++i;
        }
        if (found) {
            return i;
        }
        return -1;
    }

    private void setZoomMenu(JMenu menu, int zoom) {
        int idx = this.getZoomIndex(zoom);
        for (int i = 0; i < menu.getMenuComponentCount(); ++i) {
            JCheckBoxMenuItem m = (JCheckBoxMenuItem)menu.getMenuComponent(i);
            m.setSelected(idx == i);
        }
    }

    private int getZoomCombo(JComboBox combo) {
        int s = combo.getSelectedIndex();
        return NumberSpectrumTrend3DViewer.zoomInfos[s].ratio;
    }

    private void initSettings() {
        this.autoScaleCheck.setSelected(this.zAutoScale);
        this.minText.setEnabled(!this.zAutoScale);
        this.minText.setText(Double.toString(this.zMin));
        this.maxText.setEnabled(!this.zAutoScale);
        this.maxText.setText(Double.toString(this.zMax));
        this.gradEditor.setGradient(this.gColor);
        this.hLengthText.setText(Integer.toString(this.historyLength));
        this.setZoomCombo(this.vZoomCombo, this.vZoom);
        this.setZoomCombo(this.hZoomCombo, this.hZoom);
        this.logScaleCheck.setSelected(this.logScale);
        this.derivativeCheck.setSelected(this.showDerivative);
        this.formatText.setText(this.format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applySettings() {
        this.applyMinMax();
        this.applyHistoryLength();
        this.applyFormat();
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.buildImage();
        }
        this.repaint();
    }

    private void applyFormat() {
        this.format = this.formatText.getText();
        this.trend.cursorMove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyMinMax() {
        double max;
        double min;
        try {
            min = Double.parseDouble(this.minText.getText());
        }
        catch (NumberFormatException e1) {
            JOptionPane.showMessageDialog(this, "Invalid entry for min\n" + e1.getMessage());
            return;
        }
        try {
            max = Double.parseDouble(this.maxText.getText());
        }
        catch (NumberFormatException e2) {
            JOptionPane.showMessageDialog(this, "Invalid entry for max\n" + e2.getMessage());
            return;
        }
        if (min >= max) {
            JOptionPane.showMessageDialog(this, "min must be lower than max\n");
            return;
        }
        if (this.logScale && !this.zAutoScale && (min <= 0.0 || max <= 0.0)) {
            JOptionPane.showMessageDialog(this, "min and max must be strictly positive in log scale\n");
            return;
        }
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.zMin = min;
            this.zMax = max;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyMinMaxAndBuild() {
        this.applyMinMax();
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.buildImage();
        }
        this.repaint();
    }

    private void applyHistoryLength() {
        int hLength;
        try {
            hLength = Integer.parseInt(this.hLengthText.getText());
        }
        catch (NumberFormatException e1) {
            JOptionPane.showMessageDialog(this, "Invalid entry for history length\n" + e1.getMessage());
            return;
        }
        this.setHistoryLength(hLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyHistoryLengthAndBuild() {
        this.applyHistoryLength();
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.buildImage();
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyLogScale() {
        if (!this.zAutoScale && (this.zMin <= 0.0 || this.zMax <= 0.0)) {
            JOptionPane.showMessageDialog(this, "min and max must be strictly positive in log scale\n");
            this.logScaleCheck.setSelected(false);
            this.logScale = false;
            return;
        }
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.logScale = this.logScaleCheck.isSelected();
            this.buildImage();
        }
        this.repaint();
    }

    private void applyDerivative() {
        this.setShowDerivative(this.derivativeCheck.isSelected());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyAutoScale() {
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.zAutoScale = this.autoScaleCheck.isSelected();
            if (!this.zAutoScale && this.logScale && (this.zMin <= 0.0 || this.zMax <= 0.0)) {
                JOptionPane.showMessageDialog(this, "min and max must be strictly positive in log scale\n");
                this.zAutoScale = true;
                this.autoScaleCheck.setSelected(true);
                return;
            }
            this.minText.setEnabled(!this.zAutoScale);
            this.maxText.setEnabled(!this.zAutoScale);
            this.buildImage();
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyHorizontalZoom() {
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.hZoom = this.getZoomCombo(this.hZoomCombo);
            this.zoomScroll = 0;
            this.buildImage();
        }
        this.repaint();
        this.fireZoomChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyVerticalZoom() {
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.vZoom = this.getZoomCombo(this.vZoomCombo);
            this.buildImage();
        }
        this.repaint();
        this.fireZoomChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyHorizontalZoom(int zIdx) {
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.hZoom = NumberSpectrumTrend3DViewer.zoomInfos[zIdx].ratio;
            if (this.hZoomCombo != null) {
                this.setZoomCombo(this.hZoomCombo, this.hZoom);
            }
            this.zoomScroll = 0;
            this.buildImage();
        }
        this.repaint();
        this.fireZoomChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyVerticalZoom(int zIdx) {
        NumberSpectrumTrend3DViewer numberSpectrumTrend3DViewer = this;
        synchronized (numberSpectrumTrend3DViewer) {
            this.vZoom = NumberSpectrumTrend3DViewer.zoomInfos[zIdx].ratio;
            if (this.vZoomCombo != null) {
                this.setZoomCombo(this.vZoomCombo, this.vZoom);
            }
            this.buildImage();
        }
        this.repaint();
        this.fireZoomChange();
    }

    private void showGradientEditor() {
        Gradient g = JGradientEditor.showDialog(this.settingsFrame, this.gColor);
        if (g != null) {
            this.gColor = g;
            this.gColormap = g.buildColorMap(65536);
            this.gradEditor.setGradient(this.gColor);
            this.gradEditor.repaint();
            this.gradientViewer.setGradient(this.gColor);
            this.gradientViewer.repaint();
        }
    }

    private void constructSettingsPanel() {
        if (this.settingsFrame == null) {
            this.settingsPanel = new JPanel();
            this.settingsPanel.setLayout(null);
            this.settingsPanel.setMinimumSize(new Dimension(290, 290));
            this.settingsPanel.setPreferredSize(new Dimension(290, 290));
            this.attNameLabel = new LabelViewer();
            this.attNameLabel.setOpaque(false);
            this.attNameLabel.setFont(new Font("Dialog", 1, 16));
            this.attNameLabel.setBounds(5, 5, 200, 30);
            this.attNameLabel.setHorizontalAlignment(JSmoothLabel.LEFT_ALIGNMENT);
            this.settingsPanel.add(this.attNameLabel);
            this.attNameLabel.setModel((IAttribute)this.model);
            this.propButton = new JButton();
            this.propButton.setText("?");
            this.propButton.setToolTipText("Edit attribute properties");
            this.propButton.setFont(ATKConstant.labelFont);
            this.propButton.setMargin(new Insets(0, 0, 0, 0));
            this.propButton.setBounds(250, 5, 30, 30);
            this.propButton.addActionListener(this);
            this.settingsPanel.add(this.propButton);
            JSeparator js = new JSeparator();
            js.setBounds(0, 40, 500, 10);
            this.settingsPanel.add(js);
            this.autoScaleCheck = new JCheckBox("Auto scale");
            this.autoScaleCheck.setFont(ATKConstant.labelFont);
            this.autoScaleCheck.setBounds(5, 52, 100, 20);
            this.autoScaleCheck.setToolTipText("Auto scale colormap");
            this.autoScaleCheck.addActionListener(this);
            this.settingsPanel.add(this.autoScaleCheck);
            JLabel minLabel = new JLabel("Min");
            minLabel.setFont(ATKConstant.labelFont);
            minLabel.setBounds(110, 50, 30, 25);
            this.settingsPanel.add(minLabel);
            this.minText = new JTextField();
            this.minText.setBounds(145, 50, 50, 25);
            this.minText.addActionListener(this);
            this.settingsPanel.add(this.minText);
            JLabel maxLabel = new JLabel("Max");
            maxLabel.setFont(ATKConstant.labelFont);
            maxLabel.setBounds(200, 50, 30, 25);
            this.settingsPanel.add(maxLabel);
            this.maxText = new JTextField();
            this.maxText.setBounds(235, 50, 50, 25);
            this.maxText.addActionListener(this);
            this.settingsPanel.add(this.maxText);
            JLabel gradLabel = new JLabel("Colormap");
            gradLabel.setFont(ATKConstant.labelFont);
            gradLabel.setBounds(5, 80, 70, 20);
            this.settingsPanel.add(gradLabel);
            this.gradEditor = new JGradientEditor();
            this.gradEditor.setEditable(false);
            this.gradEditor.setToolTipText("Display the image using this colormap");
            this.gradEditor.setBounds(80, 80, 180, 20);
            this.settingsPanel.add(this.gradEditor);
            this.gradButton = new JButton();
            this.gradButton.setText("...");
            this.gradButton.setToolTipText("Edit colormap");
            this.gradButton.setFont(ATKConstant.labelFont);
            this.gradButton.setMargin(new Insets(0, 0, 0, 0));
            this.gradButton.setBounds(260, 80, 25, 20);
            this.gradButton.addActionListener(this);
            this.settingsPanel.add(this.gradButton);
            JSeparator js2 = new JSeparator();
            js2.setBounds(0, 110, 500, 10);
            this.settingsPanel.add(js2);
            JLabel hLengthLabel = new JLabel("History length");
            hLengthLabel.setFont(ATKConstant.labelFont);
            hLengthLabel.setBounds(5, 120, 90, 25);
            this.settingsPanel.add(hLengthLabel);
            this.hLengthText = new JTextField();
            this.hLengthText.setBounds(100, 120, 185, 25);
            this.hLengthText.addActionListener(this);
            this.settingsPanel.add(this.hLengthText);
            JSeparator js3 = new JSeparator();
            js3.setBounds(0, 150, 500, 10);
            this.settingsPanel.add(js3);
            JLabel hZoomLabel = new JLabel("Horz. zoom");
            hZoomLabel.setFont(ATKConstant.labelFont);
            hZoomLabel.setBounds(5, 160, 70, 20);
            this.settingsPanel.add(hZoomLabel);
            this.hZoomCombo = new JComboBox();
            this.hZoomCombo.setFont(ATKConstant.labelFont);
            for (int i = 0; i < zoomInfos.length; ++i) {
                this.hZoomCombo.addItem(NumberSpectrumTrend3DViewer.zoomInfos[i].text);
            }
            this.hZoomCombo.setBounds(80, 160, 60, 22);
            this.hZoomCombo.addActionListener(this);
            this.settingsPanel.add(this.hZoomCombo);
            JLabel vZoomLabel = new JLabel("Vert. zoom");
            vZoomLabel.setFont(ATKConstant.labelFont);
            vZoomLabel.setBounds(150, 160, 70, 20);
            this.settingsPanel.add(vZoomLabel);
            this.vZoomCombo = new JComboBox();
            this.vZoomCombo.setFont(ATKConstant.labelFont);
            for (int i = 0; i < zoomInfos.length; ++i) {
                this.vZoomCombo.addItem(NumberSpectrumTrend3DViewer.zoomInfos[i].text);
            }
            this.vZoomCombo.setBounds(225, 160, 60, 22);
            this.vZoomCombo.addActionListener(this);
            this.settingsPanel.add(this.vZoomCombo);
            JSeparator js4 = new JSeparator();
            js4.setBounds(0, 190, 500, 10);
            this.settingsPanel.add(js4);
            this.logScaleCheck = new JCheckBox("Display log values");
            this.logScaleCheck.setFont(ATKConstant.labelFont);
            this.logScaleCheck.setBounds(5, 200, 150, 20);
            this.logScaleCheck.setToolTipText("Display log values");
            this.logScaleCheck.addActionListener(this);
            this.settingsPanel.add(this.logScaleCheck);
            this.derivativeCheck = new JCheckBox("Display derivative");
            this.derivativeCheck.setFont(ATKConstant.labelFont);
            this.derivativeCheck.setBounds(155, 200, 150, 20);
            this.derivativeCheck.setToolTipText("Display derivative");
            this.derivativeCheck.addActionListener(this);
            this.settingsPanel.add(this.derivativeCheck);
            JLabel formatLabel = new JLabel("Format");
            formatLabel.setFont(ATKConstant.labelFont);
            formatLabel.setBounds(5, 230, 100, 25);
            this.settingsPanel.add(formatLabel);
            this.formatText = new JTextField();
            this.formatText.addActionListener(this);
            this.formatText.setEditable(true);
            this.formatText.setBounds(110, 230, 175, 25);
            this.settingsPanel.add(this.formatText);
            this.okButton = new JButton();
            this.okButton.setText("Apply");
            this.okButton.setFont(ATKConstant.labelFont);
            this.okButton.setBounds(5, 260, 90, 25);
            this.okButton.addActionListener(this);
            this.settingsPanel.add(this.okButton);
            this.cancelButton = new JButton();
            this.cancelButton.setText("Dismiss");
            this.cancelButton.setFont(ATKConstant.labelFont);
            this.cancelButton.setBounds(195, 260, 90, 25);
            this.cancelButton.addActionListener(this);
            this.settingsPanel.add(this.cancelButton);
            this.settingsFrame = new JFrame();
            this.settingsFrame.setTitle("NumberSpectrumTrend Options");
            this.settingsFrame.setContentPane(this.settingsPanel);
        }
    }

    private void showPropertyFrame() {
        if (this.model != null) {
            if (this.propDialog == null) {
                this.propDialog = new SimplePropertyFrame(this.settingsFrame, true);
            }
            this.propDialog.setModel((IAttribute)this.model);
            this.propDialog.setVisible(true);
        }
    }

    private void readHistory() {
        INumberSpectrumHistory[] history = this.model.getNumberSpectrumHistory();
        if (history != null) {
            for (int i = 0; i < history.length; ++i) {
                TrendData vals = new TrendData();
                vals.values = history[i].getValue();
                vals.time = history[i].getTimestamp();
                this.shiftData();
                this.data[0] = vals;
            }
        }
    }

    private void shiftData() {
        int i;
        for (i = this.historyLength - 1; i > 0; --i) {
            this.data[i] = this.data[i - 1];
        }
        if (this.showDerivative) {
            for (i = this.historyLength - 1; i > 0; --i) {
                this.derivativeData[i] = this.derivativeData[i - 1];
            }
        }
    }

    private double computeHighTen(double d) {
        int p = (int)Math.log10(d);
        return Math.pow(10.0, p + 1);
    }

    private double computeLowTen(double d) {
        int p = (int)Math.log10(d);
        return Math.pow(10.0, p);
    }

    private int getDataLength(TrendData d) {
        if (d == null) {
            return 0;
        }
        if (d.values == null) {
            return 0;
        }
        return d.values.length;
    }

    private void calcD(int i) {
        int l0 = this.getDataLength(this.data[i]);
        int l1 = this.getDataLength(this.data[i + 1]);
        int m = l1 > l0 ? l0 : l1;
        this.derivativeData[i].values = new double[m];
        for (int j = 0; j < m; ++j) {
            this.derivativeData[i].values[j] = (this.data[i].values[j] - this.data[i + 1].values[j]) / ((this.data[i].time - this.data[i + 1].time) / 1000.0);
        }
    }

    private void buildDerivative() {
        this.derivativeData = new TrendData[this.historyLength];
        for (int i = 0; i < this.historyLength - 1; ++i) {
            if (this.data[i] != null && this.data[i + 1] != null) {
                this.derivativeData[i] = new TrendData();
                this.derivativeData[i].time = this.data[i].time;
                this.calcD(i);
                continue;
            }
            this.derivativeData[i] = null;
        }
        this.derivativeData[this.historyLength - 1] = null;
    }

    private void buildImage() {
        TrendData[] source = null;
        source = this.showDerivative ? this.derivativeData : this.data;
        int ymax = 0;
        boolean zRangeOK = false;
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        if (!this.zAutoScale) {
            max = this.zMax;
            min = this.zMin;
        }
        for (int i = 0; i < this.historyLength; ++i) {
            if (source[i] == null || source[i].values == null) continue;
            if (source[i].values.length > ymax) {
                ymax = source[i].values.length;
            }
            if (!this.zAutoScale) continue;
            for (int j = 0; j < source[i].values.length; ++j) {
                double v;
                if (this.logScale) {
                    if (Double.isNaN(source[i].values[j]) || !(source[i].values[j] > 0.0)) continue;
                    v = source[i].values[j];
                    if (v < min) {
                        min = v;
                    }
                    if (v > max) {
                        max = v;
                    }
                    zRangeOK = true;
                    continue;
                }
                v = source[i].values[j];
                if (Double.isNaN(v)) continue;
                if (v < min) {
                    min = v;
                }
                if (v > max) {
                    max = v;
                }
                zRangeOK = true;
            }
        }
        if (zRangeOK) {
            if (this.logScale) {
                if (max - min < 1.0E-100) {
                    max = this.computeHighTen(max);
                    min = this.computeLowTen(min);
                }
            } else if (max - min < 1.0E-100) {
                max += 0.999;
                min -= 0.999;
            }
        } else {
            min = this.zMin;
            max = this.zMax;
        }
        this.gradientViewer.getAxis().setMinimum(min);
        this.gradientViewer.getAxis().setMaximum(max);
        if (this.logScale) {
            this.gradientViewer.getAxis().setScale(1);
        } else {
            this.gradientViewer.getAxis().setScale(0);
        }
        BufferedImage lastImg = this.trend.getImage();
        this.rdimx = this.historyLength;
        this.rdimy = ymax == 0 ? this.rdimy : ymax;
        int dimx = this.hZoom >= 1 ? this.rdimx * this.hZoom : this.rdimx / -this.hZoom;
        int dimy = this.vZoom >= 1 ? this.rdimy * this.vZoom : this.rdimy / -this.vZoom;
        if (lastImg == null || lastImg.getHeight() != dimy || lastImg.getWidth() != dimx) {
            lastImg = new BufferedImage(dimx, dimy, 1);
            this.trend.setImage(lastImg, this.hZoom, this.vZoom);
        }
        if (ymax == 0 || this.zAutoScale && !zRangeOK) {
            Graphics2D g = (Graphics2D)lastImg.getGraphics();
            g.setColor(this.NaNColor);
            g.fillRect(0, 0, dimx, dimy);
        } else {
            if (max - min < 1.0E-20) {
                max += 1.0;
            }
            if (this.logScale) {
                min = Math.log10(min);
                max = Math.log10(max);
            }
            int rgbNaN = this.NaNColor.getRGB();
            int[] rgb = new int[dimx];
            if (this.vZoom >= 1 && this.hZoom >= 1) {
                for (int j = 0; j < this.rdimy; ++j) {
                    for (int i = 0; i < this.rdimx; ++i) {
                        int xpos = this.rdimx - i - 1;
                        if (source[i] == null) {
                            for (int i2 = 0; i2 < this.hZoom; ++i2) {
                                rgb[this.hZoom * xpos + i2] = rgbNaN;
                            }
                            continue;
                        }
                        if (j >= source[i].values.length) {
                            for (int i2 = 0; i2 < this.hZoom; ++i2) {
                                rgb[this.hZoom * xpos + i2] = rgbNaN;
                            }
                            continue;
                        }
                        if (Double.isNaN(source[i].values[j])) {
                            for (int i2 = 0; i2 < this.hZoom; ++i2) {
                                rgb[this.hZoom * xpos + i2] = rgbNaN;
                            }
                            continue;
                        }
                        double c = this.logScale ? (Math.log10(source[i].values[j]) - min) / (max - min) * 65536.0 : (source[i].values[j] - min) / (max - min) * 65536.0;
                        if (c < 0.0) {
                            c = 0.0;
                        }
                        if (c > 65535.0) {
                            c = 65535.0;
                        }
                        for (int i2 = 0; i2 < this.hZoom; ++i2) {
                            rgb[this.hZoom * xpos + i2] = this.gColormap[(int)c];
                        }
                    }
                    for (int j2 = 0; j2 < this.vZoom; ++j2) {
                        lastImg.setRGB(0, this.vZoom * j + j2, dimx, 1, rgb, 0, dimx);
                    }
                }
            } else if (this.vZoom >= 1 && this.hZoom < 0) {
                for (int j = 0; j < this.rdimy; ++j) {
                    for (int i = 0; i < this.rdimx; i += -this.hZoom) {
                        int xpos = (this.rdimx - i - 1) / -this.hZoom;
                        if (source[i] == null) {
                            if (xpos >= dimx) continue;
                            rgb[xpos] = rgbNaN;
                            continue;
                        }
                        if (j >= source[i].values.length) {
                            if (xpos >= dimx) continue;
                            rgb[xpos] = rgbNaN;
                            continue;
                        }
                        if (Double.isNaN(source[i].values[j])) {
                            if (xpos >= dimx) continue;
                            rgb[xpos] = rgbNaN;
                            continue;
                        }
                        double c = this.logScale ? (Math.log10(source[i].values[j]) - min) / (max - min) * 65536.0 : (source[i].values[j] - min) / (max - min) * 65536.0;
                        if (c < 0.0) {
                            c = 0.0;
                        }
                        if (c > 65535.0) {
                            c = 65535.0;
                        }
                        if (xpos >= dimx) continue;
                        rgb[xpos] = this.gColormap[(int)c];
                    }
                    for (int j2 = 0; j2 < this.vZoom; ++j2) {
                        lastImg.setRGB(0, this.vZoom * j + j2, dimx, 1, rgb, 0, dimx);
                    }
                }
            } else if (this.vZoom < 0 && this.hZoom >= 1) {
                for (int j = 0; j < this.rdimy; j += -this.vZoom) {
                    for (int i = 0; i < this.rdimx; ++i) {
                        int xpos = this.rdimx - i - 1;
                        if (source[i] == null) {
                            for (int i2 = 0; i2 < this.hZoom; ++i2) {
                                rgb[this.hZoom * xpos + i2] = rgbNaN;
                            }
                            continue;
                        }
                        if (j >= source[i].values.length) {
                            for (int i2 = 0; i2 < this.hZoom; ++i2) {
                                rgb[this.hZoom * xpos + i2] = rgbNaN;
                            }
                            continue;
                        }
                        if (Double.isNaN(source[i].values[j])) {
                            for (int i2 = 0; i2 < this.hZoom; ++i2) {
                                rgb[this.hZoom * xpos + i2] = rgbNaN;
                            }
                            continue;
                        }
                        double c = this.logScale ? (Math.log10(source[i].values[j]) - min) / (max - min) * 65536.0 : (source[i].values[j] - min) / (max - min) * 65536.0;
                        if (c < 0.0) {
                            c = 0.0;
                        }
                        if (c > 65535.0) {
                            c = 65535.0;
                        }
                        for (int i2 = 0; i2 < this.hZoom; ++i2) {
                            rgb[this.hZoom * xpos + i2] = this.gColormap[(int)c];
                        }
                    }
                    if (j / -this.vZoom >= dimy) continue;
                    lastImg.setRGB(0, j / -this.vZoom, dimx, 1, rgb, 0, dimx);
                }
            } else if (this.vZoom < 0 && this.hZoom < 0) {
                for (int j = 0; j < this.rdimy; j += -this.vZoom) {
                    for (int i = 0; i < this.rdimx; i += -this.hZoom) {
                        int xpos = (this.rdimx - i - 1) / -this.hZoom;
                        if (source[i] == null) {
                            if (xpos >= dimx) continue;
                            rgb[xpos] = rgbNaN;
                            continue;
                        }
                        if (j >= source[i].values.length) {
                            if (xpos >= dimx) continue;
                            rgb[xpos] = rgbNaN;
                            continue;
                        }
                        if (Double.isNaN(source[i].values[j])) {
                            if (xpos >= dimx) continue;
                            rgb[xpos] = rgbNaN;
                            continue;
                        }
                        double c = this.logScale ? (Math.log10(source[i].values[j]) - min) / (max - min) * 65536.0 : (source[i].values[j] - min) / (max - min) * 65536.0;
                        if (c < 0.0) {
                            c = 0.0;
                        }
                        if (c > 65535.0) {
                            c = 65535.0;
                        }
                        if (xpos >= dimx) continue;
                        rgb[xpos] = this.gColormap[(int)c];
                    }
                    if (j / -this.vZoom >= dimy) continue;
                    lastImg.setRGB(0, j / -this.vZoom, dimx, 1, rgb, 0, dimx);
                }
            }
        }
        this.trend.setImage(lastImg, this.rdimx, this.rdimy);
        this.trendView.getViewport().revalidate();
        this.revalidate();
    }

    public void saveDataFile() {
        int status;
        JFileChooser fc = new JFileChooser(".");
        JCheckBox transposeCheck = new JCheckBox("Transpose data");
        transposeCheck.setFont(ATKConstant.labelFont);
        transposeCheck.setSelected(true);
        fc.setAccessory(transposeCheck);
        if (this.currentFile != null) {
            fc.setSelectedFile(this.currentFile);
        }
        if ((status = fc.showSaveDialog(this)) == 0) {
            this.currentFile = fc.getSelectedFile();
            try {
                FileWriter f = new FileWriter(this.currentFile);
                f.write(this.makeTabbedString(transposeCheck.isSelected()));
                f.close();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, ex, "Error while saving data", 0);
            }
        }
    }

    private String buildTime(double time) {
        long t = (long)time;
        long us = (long)(time * 1000.0) - t * 1000L;
        calendar.setTimeInMillis(t);
        Date date = calendar.getTime();
        if (us == 0L) {
            String msStr = String.format(".%03d", t % 1000L);
            return genFormat.format(date) + msStr;
        }
        String usStr = String.format(".%03d%03d", t % 1000L, us);
        return genFormat.format(date) + usStr;
    }

    private String getStringValueAt(int x, int y) {
        if (y < this.data[x].values.length) {
            double val = this.data[x].values[y];
            if (this.format.length() > 0) {
                return ATKFormat.format(this.format, val);
            }
            return Double.toString(val);
        }
        return " ";
    }

    protected String makeTabbedString(boolean transpose) {
        int i;
        StringBuffer str = new StringBuffer();
        int nbCol = this.data.length;
        int nbRow = 0;
        for (i = 0; i < this.data.length; ++i) {
            if (this.data[i].values.length <= nbRow) continue;
            nbRow = this.data[i].values.length;
        }
        if (transpose) {
            for (int j = nbCol - 1; j >= 0; --j) {
                str.append(this.buildTime(this.data[j].time));
                str.append("\t");
                for (int i2 = 0; i2 < nbRow; ++i2) {
                    str.append(this.getStringValueAt(j, i2));
                    str.append("\t");
                }
                str.append("\n");
            }
        } else {
            for (i = nbCol - 1; i >= 0; --i) {
                str.append(this.buildTime(this.data[i].time));
                str.append("\t");
            }
            str.append("\n");
            for (i = 0; i < nbRow; ++i) {
                for (int j = nbCol - 1; j >= 0; --j) {
                    str.append(this.getStringValueAt(j, i));
                    str.append("\t");
                }
                str.append("\n");
            }
        }
        return str.toString();
    }

    public static void main(String[] args) {
        try {
            AttributeList attributeList = new AttributeList();
            final NumberSpectrumTrend3DViewer nstv = new NumberSpectrumTrend3DViewer();
            nstv.readPollingHistory(true);
            nstv.setShowDerivative(true);
            int nbData = 1000;
            double[] dates = new double[nbData];
            double[][] data = new double[nbData][256];
            long startDate = System.currentTimeMillis() - (long)(nbData * 1000);
            for (int i = 0; i < nbData; ++i) {
                dates[i] = (double)(startDate + (long)(i * 1000)) + 0.12;
                for (int j = 0; j < 256; ++j) {
                    data[i][j] = (double)j / 256.0;
                }
            }
            nstv.setData(dates, data);
            nstv.setName("Data test");
            nstv.setUnit("au");
            nstv.setYName("Height");
            nstv.setValueName("Strength");
            nstv.setYUnit("yu");
            nstv.setFormat("%.3f");
            String[] idxName = new String[200];
            for (int i = 0; i < idxName.length; ++i) {
                idxName[i] = new String("I" + i);
            }
            nstv.setYIndexName(idxName);
            nstv.setZAutoScale(true);
            nstv.setZMinimum(-0.5);
            nstv.setZMaximum(0.5);
            attributeList.startRefresher();
            JFrame f = new JFrame();
            JMenuBar menuBar = new JMenuBar();
            JMenu menu = new JMenu("Test");
            menuBar.add(menu);
            JMenuItem clearMenuItem = new JMenuItem("Clear");
            clearMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    nstv.clearData();
                }
            });
            JMenuItem cursorMenuItem = new JMenuItem("Remove cursor");
            cursorMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    nstv.clearStatusLabel();
                }
            });
            JMenuItem cursorCMenuItem = new JMenuItem("Cursor coordinates");
            cursorCMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("X = " + nstv.getXCursor());
                    System.out.println("Y = " + nstv.getYCursor());
                }
            });
            JMenuItem scrollRightMenuItem = new JMenuItem("Scroll to right");
            scrollRightMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    nstv.scrollToRight();
                }
            });
            JMenuItem scrollLeftMenuItem = new JMenuItem("Scroll to left");
            scrollLeftMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    nstv.scrollToLeft();
                }
            });
            menu.add(clearMenuItem);
            menu.add(cursorMenuItem);
            menu.add(cursorCMenuItem);
            menu.add(scrollRightMenuItem);
            menu.add(scrollLeftMenuItem);
            f.setJMenuBar(menuBar);
            f.setContentPane(nstv);
            f.setDefaultCloseOperation(3);
            ATKGraphicsUtils.centerFrameOnScreen(f);
            f.setSize(new Dimension(600, 400));
            f.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

