/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.TangoDs.AttrManip;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.ISpectrumListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.core.NumberSpectrumEvent;
import fr.esrf.tangoatk.widget.attribute.NumberSpectrumTableEditor;
import fr.esrf.tangoatk.widget.attribute.SimplePropertyFrame;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKFormat;
import fr.esrf.tangoatk.widget.util.chart.AdvancedJLChart;
import fr.esrf.tangoatk.widget.util.chart.CfFileReader;
import fr.esrf.tangoatk.widget.util.chart.IJLChartActionListener;
import fr.esrf.tangoatk.widget.util.chart.IJLChartListener;
import fr.esrf.tangoatk.widget.util.chart.JLChartActionEvent;
import fr.esrf.tangoatk.widget.util.chart.JLChartEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import fr.esrf.tangoatk.widget.util.chart.OFormat;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.border.EtchedBorder;

public class NumberSpectrumViewer
extends AdvancedJLChart
implements ISpectrumListener,
INumberScalarListener,
IJLChartActionListener,
IJLChartListener,
JDrawable {
    protected INumberSpectrum model = null;
    protected JLDataView dvy;
    protected SimplePropertyFrame pf = null;
    protected double A0 = 0.0;
    protected double A1 = 1.0;
    protected String xAxisUnit = "";
    protected String format;
    protected boolean unitVisible = false;
    protected boolean qualityVisible = false;
    protected static final String DISPLAY_UNIT_STRING = "Display/Hide Unit";
    protected static final String DISPLAY_QUALITY_STRING = "Display/Hide Attribute Quality";
    protected static final String SET_SPECTRUM_MENU_LABEL = "Set attribute";
    private boolean manageXaxis = false;
    private boolean xAxisManagedByProps = false;
    private boolean xAxisManagedByAtts = false;
    private boolean xAxisMinMaxApplied = false;
    private double xAxisMin = -1.0;
    private double xAxisMax = -1.0;
    private INumberScalar x_min_model = null;
    private INumberScalar x_max_model = null;
    private double x_min_value = 0.0;
    private double x_max_value = 0.0;
    private NumberSpectrumTableEditor spectrumEditor = null;
    private JMenuItem setAttMenuItem = null;
    static String[] exts = new String[]{"manageXaxis", "graphSettings"};

    public NumberSpectrumViewer() {
        this.setBorder(new EtchedBorder());
        this.setBackground(new Color(180, 180, 180));
        this.getY1Axis().setAutoScale(true);
        this.getXAxis().setAutoScale(true);
        this.getXAxis().setAnnotation(2);
        this.dvy = new JLDataView();
        this.getY1Axis().addDataView(this.dvy);
        this.removeMenuItem(6);
        this.removeMenuItem(7);
        this.addUserAction("Attribute properties");
        this.addUserAction(DISPLAY_UNIT_STRING);
        this.addUserAction(DISPLAY_QUALITY_STRING);
        this.addUserAction(SET_SPECTRUM_MENU_LABEL);
        this.setAttMenuItem = this.getUserActionMenuItem(SET_SPECTRUM_MENU_LABEL);
        if (this.setAttMenuItem != null) {
            this.setAttMenuItem.setEnabled(false);
        }
        this.addJLChartActionListener(this);
        this.setJLChartListener(this);
    }

    public JLDataView getDataView() {
        return this.dvy;
    }

    public boolean getManageXaxis() {
        return this.manageXaxis;
    }

    public void setManageXaxis(boolean b) {
        if (this.model != null) {
            return;
        }
        this.manageXaxis = b;
    }

    public String getXAxisUnit() {
        return this.xAxisUnit;
    }

    public void setXAxisUnit(String u) {
        this.xAxisUnit = u;
    }

    public void setXAxisAffineTransform(double a0, double a1) {
        this.A0 = a0;
        this.A1 = a1;
    }

    @Override
    public void initForEditing() {
        this.dvy.add(0.0, 0.0);
        this.dvy.add(2.0, 1.0);
        this.dvy.add(4.0, 1.2);
        this.dvy.add(6.0, 3.0);
        this.dvy.add(8.0, 0.2);
        this.dvy.add(10.0, 1.5);
        this.setPreferredSize(new Dimension(400, 300));
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String getDescription(String name) {
        if (name.equalsIgnoreCase("manageXaxis")) {
            return "When enabled, the viewer will adapt the Xaxis min and Xaxis max \nto the attribute properties defined in the Tango DataBase. \nPossible values are: true, false.";
        }
        if (name.equalsIgnoreCase("graphSettings")) {
            return this.getHelpString();
        }
        return "";
    }

    @Override
    public String[] getExtensionList() {
        return exts;
    }

    @Override
    public boolean setExtendedParam(String name, String value, boolean popupErr) {
        if (name.equalsIgnoreCase("manageXaxis")) {
            if (((String)value).equalsIgnoreCase("true")) {
                this.setManageXaxis(true);
                return true;
            }
            if (((String)value).equalsIgnoreCase("false")) {
                this.setManageXaxis(false);
                return true;
            }
            this.showJdrawError(popupErr, "manageXaxis", "Wrong syntax: 'true' or 'false' expected.");
            return false;
        }
        if (name.equalsIgnoreCase("graphSettings")) {
            String err;
            if (!((String)value).endsWith("\n")) {
                value = (String)value + "\n";
            }
            if ((err = this.setSettings((String)value)).length() > 0) {
                this.showJdrawError(popupErr, "graphSettings", err);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getExtendedParam(String name) {
        if (name.equalsIgnoreCase("manageXaxis")) {
            if (this.getManageXaxis()) {
                return "true";
            }
            return "false";
        }
        if (name.equalsIgnoreCase("graphSettings")) {
            return this.getSettings();
        }
        return "";
    }

    private void showJdrawError(boolean popup, String paramName, String message) {
        if (popup) {
            JOptionPane.showMessageDialog(null, "NumberSpectrumViewer: " + paramName + " incorrect.\n" + message, "Error", 0);
        }
    }

    @Override
    public void actionPerformed(JLChartActionEvent evt) {
        if (evt.getName().equals("Attribute properties")) {
            if (this.pf == null) {
                this.pf = new SimplePropertyFrame();
                this.pf.setModel((IAttribute)this.model);
            }
            this.pf.setVisible(true);
        } else if (DISPLAY_UNIT_STRING.equals(evt.getName())) {
            this.setUnitVisible(!this.isUnitVisible());
        } else if (DISPLAY_QUALITY_STRING.equals(evt.getName())) {
            this.setQualityVisible(!this.isQualityVisible());
        } else if (SET_SPECTRUM_MENU_LABEL.equals(evt.getName())) {
            this.setSpectrumAttribute();
        }
    }

    @Override
    public boolean getActionState(JLChartActionEvent evt) {
        return this.model != null;
    }

    public void errorChange(ErrorEvent errorEvent) {
        if (errorEvent.getSource() != this.model) {
            return;
        }
        if (this.isQualityVisible()) {
            this.setToolTipText(this.model.getName() + ": UNKNOWN");
            this.dvy.setLabelColor(ATKConstant.getColor4Quality("UNKNOWN"));
        }
        this.dvy.reset();
        this.repaint();
        this.refreshTableSingle(this.dvy);
    }

    public void stateChange(AttributeStateEvent evt) {
        if (this.isQualityVisible()) {
            this.setToolTipText(this.model.getName() + ": " + evt.getState());
            this.dvy.setLabelColor(ATKConstant.getColor4Quality(evt.getState()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spectrumChange(NumberSpectrumEvent numberSpectrumEvent) {
        double[] value = numberSpectrumEvent.getValue();
        int length = value.length;
        if (this.xAxisManagedByProps) {
            if (!this.xAxisMinMaxApplied) {
                this.changeXaxisAffineTransform(this.xAxisMin, this.xAxisMax, length);
            } else if (this.dvy == null) {
                this.changeXaxisAffineTransform(this.xAxisMin, this.xAxisMax, length);
            } else if (this.dvy.getDataLength() != length) {
                this.changeXaxisAffineTransform(this.xAxisMin, this.xAxisMax, length);
            }
        }
        if (this.xAxisManagedByAtts && !this.xAxisMinMaxApplied) {
            this.changeXaxisAffineTransform(this.x_min_value, this.x_max_value, length);
        }
        JLDataView jLDataView = this.dvy;
        synchronized (jLDataView) {
            this.dvy.reset();
            for (int i = 0; i < length; ++i) {
                this.dvy.add(this.A0 + this.A1 * (double)i, value[i], false);
            }
            this.dvy.updateFilters();
            this.repaint();
            this.refreshTableSingle(this.dvy);
        }
    }

    @Override
    public String[] clickOnChart(JLChartEvent e) {
        String[] ret;
        if (this.model != null) {
            String yValue = this.format == null ? Double.toString(e.getTransformedYValue()) : (this.format.indexOf(37) == -1 ? AttrManip.format((String)this.format, (double)e.getTransformedYValue()) : ATKFormat.format(this.format, e.getTransformedYValue()));
            ret = new String[]{this.model.getName(), this.xAxisUnit.length() > 0 ? "X=" + e.getTransformedXValue() + " " + this.xAxisUnit : "X=" + e.getTransformedXValue(), "Y=" + yValue + " " + this.model.getUnit()};
        } else {
            ret = new String[]{this.xAxisUnit.length() > 0 ? "X=" + e.getTransformedXValue() + " " + this.xAxisUnit : "X=" + e.getTransformedXValue(), "Y=" + e.getTransformedYValue()};
        }
        return ret;
    }

    public void setModel(INumberSpectrum v) {
        this.clearModel();
        if (v == null) {
            this.repaint();
            return;
        }
        this.model = v;
        if (this.model.isWritable()) {
            if (this.setAttMenuItem != null) {
                this.setAttMenuItem.setEnabled(true);
            }
            this.spectrumEditor = new NumberSpectrumTableEditor();
            this.spectrumEditor.setModel(this.model);
        }
        if (this.manageXaxis) {
            if (!this.model.areAttPropertiesLoaded()) {
                this.model.loadAttProperties();
            }
            if (this.model.hasMinxMaxxAttributes()) {
                this.xAxisManagedByAtts = true;
            } else if (this.model.hasMinxMaxxProperties()) {
                this.xAxisManagedByProps = true;
                this.getXAxis().setAutoScale(false);
                this.xAxisMin = this.model.getMinx();
                this.xAxisMax = this.model.getMaxx();
            }
            this.xAxisMinMaxApplied = false;
        }
        this.format = this.model.getFormat();
        this.dvy.setUserFormat(this.format);
        this.dvy.setUnit(v.getUnit());
        this.dvy.setName(v.getName());
        if (this.isQualityVisible()) {
            this.setToolTipText(this.model.getName() + ": " + this.model.getState());
            this.dvy.setLabelColor(ATKConstant.getColor4Quality(this.model.getState()));
        }
        this.model.addSpectrumListener((ISpectrumListener)this);
        if (this.pf != null) {
            this.pf.setModel((IAttribute)this.model);
        }
        if (this.unitVisible) {
            this.getY1Axis().setName(v.getUnit());
        } else {
            this.getY1Axis().setName("");
        }
        this.repaint();
    }

    public void clearModel() {
        this.xAxisManagedByProps = false;
        this.xAxisManagedByAtts = false;
        this.xAxisMinMaxApplied = false;
        this.xAxisMin = -1.0;
        this.xAxisMax = -1.0;
        this.x_min_value = 0.0;
        this.x_max_value = 0.0;
        if (this.model != null) {
            this.model.removeSpectrumListener((ISpectrumListener)this);
            if (this.pf != null) {
                this.pf.setModel(null);
            }
            this.model = null;
        }
        if (this.x_min_model != null) {
            this.x_min_model.removeNumberScalarListener((INumberScalarListener)this);
            this.x_min_model = null;
        }
        if (this.x_max_model != null) {
            this.x_max_model.removeNumberScalarListener((INumberScalarListener)this);
            this.x_max_model = null;
        }
        this.setToolTipText(null);
        this.dvy.setLabelColor(Color.BLACK);
        if (this.spectrumEditor != null) {
            this.spectrumEditor.clearModel();
            this.spectrumEditor = null;
        }
        if (this.setAttMenuItem != null) {
            this.setAttMenuItem.setEnabled(false);
        }
    }

    public String setSettings(String cfg) {
        CfFileReader f = new CfFileReader();
        if (!f.parseText(cfg)) {
            return "NumberSpectrumViewer.setSettings: Failed to parse given config";
        }
        this.applyConfiguration(f);
        Vector<String> p = f.getParam("xaxis_transform");
        if (p != null) {
            this.setXAxisAffineTransform(OFormat.getDouble(p.get(0).toString()), OFormat.getDouble(p.get(1).toString()));
        }
        if ((p = f.getParam("xaxis_unit")) != null) {
            this.xAxisUnit = p.get(0).toString();
        }
        this.getXAxis().applyConfiguration("x", f);
        this.getY1Axis().applyConfiguration("y1", f);
        this.dvy.applyConfiguration("dvy", f);
        return "";
    }

    public String getSettings() {
        Object to_write = "";
        to_write = (String)to_write + this.getConfiguration();
        to_write = (String)to_write + "xaxis_transform:" + this.A0 + "," + this.A1 + "\n";
        to_write = (String)to_write + "xaxis_unit:'" + this.xAxisUnit + "'\n";
        to_write = (String)to_write + this.getXAxis().getConfiguration("x");
        to_write = (String)to_write + this.getY1Axis().getConfiguration("y1");
        to_write = (String)to_write + this.dvy.getConfiguration("dvy");
        return to_write;
    }

    public boolean isUnitVisible() {
        return this.unitVisible;
    }

    public void setUnitVisible(boolean displayUnit) {
        this.unitVisible = displayUnit;
        if (displayUnit && this.model != null) {
            this.getY1Axis().setName(this.model.getUnit());
        } else {
            this.getY1Axis().setName("");
        }
        this.repaint();
    }

    public boolean isQualityVisible() {
        return this.qualityVisible;
    }

    public void setQualityVisible(boolean qualityVisible) {
        if (this.qualityVisible != qualityVisible) {
            this.qualityVisible = qualityVisible;
            if (qualityVisible) {
                if (this.model != null) {
                    this.setToolTipText(this.model.getName() + ": " + this.model.getState());
                    this.dvy.setLabelColor(ATKConstant.getColor4Quality(this.model.getState()));
                }
            } else {
                this.setToolTipText(null);
                this.dvy.setLabelColor(Color.BLACK);
            }
            this.repaint();
        }
    }

    public void setSpectrumAttribute() {
        if (this.spectrumEditor == null) {
            return;
        }
        this.spectrumEditor.centerWindow();
        this.spectrumEditor.setVisible(true);
    }

    @Override
    public void removeDataView(JLDataView view) {
        if (view != this.dvy) {
            super.removeDataView(view);
        }
    }

    @Override
    protected boolean prepareDataViewMenu(JLDataView dataView) {
        if (dataView == this.dvy) {
            return false;
        }
        boolean b = super.prepareDataViewMenu(dataView);
        return b;
    }

    private void changeXaxisAffineTransform(double minx, double maxx, int nb) {
        if (maxx <= minx) {
            return;
        }
        if (nb <= 0) {
            return;
        }
        this.getXAxis().setMinimum(minx);
        this.getXAxis().setMaximum(maxx);
        double step = (maxx - minx) / (double)nb;
        this.setXAxisAffineTransform(minx, step);
        this.xAxisMinMaxApplied = true;
    }

    private void changeXaxisAffineTransform() {
        if (this.dvy == null) {
            return;
        }
        this.changeXaxisAffineTransform(this.x_min_value, this.x_max_value, this.dvy.getDataLength());
    }

    public void setXaxisModels(INumberScalar min, INumberScalar max) {
        if (!this.manageXaxis) {
            return;
        }
        if (!this.xAxisManagedByAtts) {
            return;
        }
        if (this.x_min_model != null) {
            this.x_min_model.removeNumberScalarListener((INumberScalarListener)this);
            this.x_min_model = null;
        }
        if (this.x_max_model != null) {
            this.x_max_model.removeNumberScalarListener((INumberScalarListener)this);
            this.x_max_model = null;
        }
        this.x_min_value = 0.0;
        this.x_max_value = 0.0;
        this.getXAxis().setAutoScale(true);
        this.xAxisMinMaxApplied = false;
        if (min == null || max == null) {
            return;
        }
        if (min == max) {
            return;
        }
        if (!min.getNameSansDevice().equalsIgnoreCase(this.model.getMinxAttName())) {
            return;
        }
        if (!max.getNameSansDevice().equalsIgnoreCase(this.model.getMaxxAttName())) {
            return;
        }
        this.x_min_model = min;
        this.x_max_model = max;
        this.getXAxis().setAutoScale(false);
        this.x_min_model.addNumberScalarListener((INumberScalarListener)this);
        this.x_max_model.addNumberScalarListener((INumberScalarListener)this);
        min.refresh();
        max.refresh();
    }

    public void numberScalarChange(NumberScalarEvent evt) {
        if (evt.getSource() == this.x_min_model) {
            this.minXchange(evt);
            return;
        }
        if (evt.getSource() == this.x_max_model) {
            this.maxXchange(evt);
            return;
        }
    }

    private void minXchange(NumberScalarEvent evt) {
        this.x_min_value = evt.getValue();
        if (this.x_min_value < this.x_max_value) {
            if (!this.getXAxis().isAutoScale()) {
                // empty if block
            }
            this.getXAxis().setMinimum(this.x_min_value);
            this.getXAxis().setMaximum(this.x_max_value);
            this.changeXaxisAffineTransform();
        }
    }

    private void maxXchange(NumberScalarEvent evt) {
        this.x_max_value = evt.getValue();
        if (this.x_min_value < this.x_max_value) {
            if (!this.getXAxis().isAutoScale()) {
                // empty if block
            }
            this.getXAxis().setMinimum(this.x_min_value);
            this.getXAxis().setMaximum(this.x_max_value);
            this.changeXaxisAffineTransform();
        }
    }

    private static void addXaxisMinMaxAtt(NumberSpectrumViewer viewer, INumberSpectrum vModel) {
        if (viewer == null) {
            return;
        }
        if (vModel == null) {
            return;
        }
        if (vModel.hasMinxMaxxAttributes()) {
            String attFullName = null;
            AttributeList attl = new AttributeList();
            INumberScalar minAtt = null;
            INumberScalar maxAtt = null;
            try {
                if (vModel.getMinxAttName() != null && vModel.getMaxxAttName() != null) {
                    attFullName = vModel.getDevice().getName() + "/" + vModel.getMinxAttName();
                    IEntity ie = attl.add(attFullName);
                    if (ie != null && ie instanceof INumberScalar) {
                        minAtt = (INumberScalar)ie;
                    }
                    if ((ie = attl.add(attFullName = vModel.getDevice().getName() + "/" + vModel.getMaxxAttName())) != null && ie instanceof INumberScalar) {
                        maxAtt = (INumberScalar)ie;
                    }
                }
                if (minAtt != null && maxAtt != null) {
                    viewer.setXaxisModels(minAtt, maxAtt);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) {
        try {
            AttributeList attributeList = new AttributeList();
            NumberSpectrumViewer nsv = new NumberSpectrumViewer();
            nsv.setManageXaxis(true);
            INumberSpectrum ins = (INumberSpectrum)attributeList.add("//acudebian7:10000/jlp/test/1/att_spectrum");
            nsv.setModel(ins);
            nsv.setHeader("Test Header");
            NumberSpectrumViewer.addXaxisMinMaxAtt(nsv, ins);
            nsv.setBorder(BorderFactory.createLoweredBevelBorder());
            nsv.setFont(new Font("Dialog", 0, 12));
            nsv.setXAxisUnit("mA");
            JFrame f = new JFrame();
            attributeList.startRefresher();
            f.setContentPane(nsv);
            f.setSize(640, 480);
            f.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

