/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.IRawImage;
import fr.esrf.tangoatk.core.IRawImageListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.core.RawImageEvent;
import fr.esrf.tangoatk.core.attribute.AttributeFactory;
import fr.esrf.tangoatk.core.attribute.NumberScalar;
import fr.esrf.tangoatk.widget.attribute.IRoiListener;
import fr.esrf.tangoatk.widget.attribute.NumberScalarViewer;
import fr.esrf.tangoatk.widget.attribute.NumberScalarWheelEditor;
import fr.esrf.tangoatk.widget.attribute.RoiEvent;
import fr.esrf.tangoatk.widget.attribute.SimplePropertyFrame;
import fr.esrf.tangoatk.widget.image.IImageFormat;
import fr.esrf.tangoatk.widget.image.Jpeg24ImageFormat;
import fr.esrf.tangoatk.widget.image.Jpeg8ImageFormat;
import fr.esrf.tangoatk.widget.image.LineProfilerViewer;
import fr.esrf.tangoatk.widget.image.Mono16ImageFormat;
import fr.esrf.tangoatk.widget.image.Mono8ImageFormat;
import fr.esrf.tangoatk.widget.image.RGB24ImageFormat;
import fr.esrf.tangoatk.widget.properties.LabelViewer;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKDiagnostic;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorHistory;
import fr.esrf.tangoatk.widget.util.Gradient;
import fr.esrf.tangoatk.widget.util.JGradientEditor;
import fr.esrf.tangoatk.widget.util.JGradientViewer;
import fr.esrf.tangoatk.widget.util.JImage;
import fr.esrf.tangoatk.widget.util.JSmoothLabel;
import fr.esrf.tangoatk.widget.util.JTableRow;
import fr.esrf.tangoatk.widget.util.MultiExtFileFilter;
import fr.esrf.tangoatk.widget.util.chart.AxisPanel;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.EventListenerList;
import javax.swing.filechooser.FileFilter;

public class RawImageViewer
extends JPanel
implements IRawImageListener,
ActionListener,
MouseListener,
MouseMotionListener {
    private IRawImage model;
    private IImageFormat format = null;
    private String encFormat = null;
    private boolean snapToGrid;
    private boolean isNegative;
    private Gradient gColor;
    private int[] gColormap;
    private int iSz;
    private EventListenerList listenerList;
    private Rectangle oldSelection = null;
    private Insets noMargin = new Insets(0, 0, 0, 0);
    private boolean isBestFit;
    private boolean autoZoom = false;
    private boolean firstRefresh = false;
    private boolean userZoom = false;
    private boolean showingMenu;
    private int profileMode;
    private double minFit;
    private double maxFit;
    private String errorString = "No image";
    private int[] rgb;
    private Font panelFont;
    protected JImage imagePanel;
    private JScrollPane imageView;
    private JPopupMenu imgMenu;
    private JCheckBoxMenuItem[] formatMenuItem;
    private JCheckBoxMenuItem bestFitMenuItem;
    private JCheckBoxMenuItem snapToGridMenuItem;
    private JCheckBoxMenuItem negativeMenuItem;
    private JCheckBoxMenuItem toolbarMenuItem;
    private JCheckBoxMenuItem statusLineMenuItem;
    private JCheckBoxMenuItem showGradMenuItem;
    private JMenuItem selectionMenuItem;
    private JMenuItem selectionMaxMenuItem;
    private JMenuItem fileMenuItem;
    private JMenuItem tableMenuItem;
    private JMenuItem lineProfileMenuItem;
    private JMenuItem histogramMenuItem;
    private JMenuItem settingsMenuItem;
    private JMenuItem statsMenuItem;
    private JButton selectButton;
    private JButton selectMaxButton;
    private JButton fileButton;
    private JButton tableButton;
    private JButton profileButton;
    private JButton histoButton;
    private JButton settingsButton;
    private JButton axisButton;
    private JScrollPane buttonView;
    private JDialog settingsDialog = null;
    private LabelViewer attNameLabel;
    private JButton propButton;
    private JCheckBox bestFitCheck;
    private JTextField fitMinText;
    private JTextField fitMaxText;
    private JTextField formatText;
    private JCheckBox snapToGridCheck;
    private JTextField snapToGridText;
    private JCheckBox negativeCheck;
    private JComboBox imageSizeCombo;
    private JGradientEditor gradViewer;
    private JButton gradButton;
    private JButton okButton;
    private JButton cancelButton;
    SimplePropertyFrame propDialog = null;
    private JFrame tableDialog = null;
    private JTableRow tablePanel;
    private LineProfilerViewer lineProfiler = null;
    private JDialog axisDialog = null;
    private JButton axisCloseButton;
    private JPanel cfgPanel;
    private JLabel statusLabel;
    private JLabel rangeLabel;
    private JGradientViewer gradientTool;

    public RawImageViewer() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEtchedBorder());
        this.panelFont = new Font("Dialog", 0, 11);
        this.imagePanel = new JImage();
        this.imagePanel.setBorder(null);
        this.imagePanel.setSnapGrid(8);
        this.imageView = new JScrollPane(this.imagePanel);
        this.add((Component)this.imageView, "Center");
        this.imgMenu = new JPopupMenu();
        JMenuItem infoMenuItem = new JMenuItem("Image Viewer");
        infoMenuItem.setEnabled(false);
        this.bestFitMenuItem = new JCheckBoxMenuItem("Best fit");
        this.bestFitMenuItem.addActionListener(this);
        this.snapToGridMenuItem = new JCheckBoxMenuItem("Align to grid");
        this.snapToGridMenuItem.addActionListener(this);
        this.negativeMenuItem = new JCheckBoxMenuItem("Negative image");
        this.negativeMenuItem.addActionListener(this);
        this.toolbarMenuItem = new JCheckBoxMenuItem("Show toolbar");
        this.toolbarMenuItem.addActionListener(this);
        this.statusLineMenuItem = new JCheckBoxMenuItem("Show status line");
        this.statusLineMenuItem.addActionListener(this);
        this.showGradMenuItem = new JCheckBoxMenuItem("Show gradient");
        this.showGradMenuItem.addActionListener(this);
        this.selectionMenuItem = new JMenuItem("Free selection");
        this.selectionMenuItem.addActionListener(this);
        this.selectionMaxMenuItem = new JMenuItem("Select all");
        this.selectionMaxMenuItem.addActionListener(this);
        this.lineProfileMenuItem = new JMenuItem("Line profile");
        this.lineProfileMenuItem.addActionListener(this);
        this.histogramMenuItem = new JMenuItem("Histogram");
        this.histogramMenuItem.addActionListener(this);
        this.fileMenuItem = new JMenuItem("Save selection");
        this.fileMenuItem.addActionListener(this);
        this.settingsMenuItem = new JMenuItem("Settings");
        this.settingsMenuItem.addActionListener(this);
        this.statsMenuItem = new JMenuItem("Statistics");
        this.statsMenuItem.addActionListener(this);
        this.tableMenuItem = new JMenuItem("Selection to table");
        this.tableMenuItem.addActionListener(this);
        this.imgMenu.add(infoMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.bestFitMenuItem);
        this.imgMenu.add(this.negativeMenuItem);
        this.imgMenu.add(this.snapToGridMenuItem);
        this.imgMenu.add(this.toolbarMenuItem);
        this.imgMenu.add(this.statusLineMenuItem);
        this.imgMenu.add(this.showGradMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.selectionMenuItem);
        this.imgMenu.add(this.selectionMaxMenuItem);
        this.imgMenu.add(this.fileMenuItem);
        this.imgMenu.add(this.tableMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.lineProfileMenuItem);
        this.imgMenu.add(this.histogramMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.settingsMenuItem);
        this.imgMenu.add(this.statsMenuItem);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(null);
        buttonPanel.setPreferredSize(new Dimension(60, 335));
        this.buttonView = new JScrollPane(buttonPanel);
        this.buttonView.setHorizontalScrollBarPolicy(31);
        this.add((Component)this.buttonView, "West");
        this.buttonView.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                RawImageViewer.this.adjustToolbarSize();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                RawImageViewer.this.adjustToolbarSize();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                RawImageViewer.this.adjustToolbarSize();
            }
        });
        this.selectButton = new JButton();
        this.selectButton.setMargin(this.noMargin);
        this.selectButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_select.gif")));
        this.selectButton.setBounds(2, 5, 36, 36);
        this.selectButton.setToolTipText("Free selection");
        this.selectButton.addActionListener(this);
        buttonPanel.add(this.selectButton);
        this.selectMaxButton = new JButton();
        this.selectMaxButton.setMargin(this.noMargin);
        this.selectMaxButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_selectmax.gif")));
        this.selectMaxButton.setBounds(2, 45, 36, 36);
        this.selectMaxButton.setToolTipText("Select whole image");
        this.selectMaxButton.addActionListener(this);
        buttonPanel.add(this.selectMaxButton);
        this.fileButton = new JButton();
        this.fileButton.setMargin(this.noMargin);
        this.fileButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_snapshot.gif")));
        this.fileButton.setBounds(2, 85, 36, 36);
        this.fileButton.setToolTipText("Save snapshot");
        this.fileButton.addActionListener(this);
        buttonPanel.add(this.fileButton);
        this.tableButton = new JButton();
        this.tableButton.setMargin(this.noMargin);
        this.tableButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_table.gif")));
        this.tableButton.setBounds(2, 125, 36, 36);
        this.tableButton.setToolTipText("Selection to table");
        this.tableButton.addActionListener(this);
        buttonPanel.add(this.tableButton);
        this.profileButton = new JButton();
        this.profileButton.setMargin(this.noMargin);
        this.profileButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_profile.gif")));
        this.profileButton.setBounds(2, 170, 36, 36);
        this.profileButton.setToolTipText("Line profile");
        this.profileButton.addActionListener(this);
        buttonPanel.add(this.profileButton);
        this.histoButton = new JButton();
        this.histoButton.setMargin(this.noMargin);
        this.histoButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_histo.gif")));
        this.histoButton.setBounds(2, 205, 36, 36);
        this.histoButton.setToolTipText("Histogram");
        this.histoButton.addActionListener(this);
        buttonPanel.add(this.histoButton);
        this.settingsButton = new JButton();
        this.settingsButton.setMargin(this.noMargin);
        this.settingsButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_option.gif")));
        this.settingsButton.setBounds(2, 250, 36, 36);
        this.settingsButton.setToolTipText("Image viewer settings");
        this.settingsButton.addActionListener(this);
        buttonPanel.add(this.settingsButton);
        this.axisButton = new JButton();
        this.axisButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_axis.gif")));
        this.axisButton.setMargin(this.noMargin);
        this.axisButton.setBounds(2, 295, 36, 36);
        this.axisButton.setToolTipText("Axis settings");
        this.axisButton.addActionListener(this);
        buttonPanel.add(this.axisButton);
        this.cfgPanel = new JPanel();
        this.cfgPanel.setLayout(null);
        this.cfgPanel.setPreferredSize(new Dimension(0, 40));
        this.add((Component)this.cfgPanel, "South");
        this.statusLabel = new JLabel("");
        this.statusLabel.setFont(this.panelFont);
        this.statusLabel.setBounds(5, 0, 400, 20);
        this.cfgPanel.add(this.statusLabel);
        this.rangeLabel = new JLabel("");
        this.rangeLabel.setFont(this.panelFont);
        this.rangeLabel.setBounds(5, 20, 400, 20);
        this.cfgPanel.add(this.rangeLabel);
        this.gradientTool = new JGradientViewer();
        this.gradientTool.getAxis().setMinimum(0.0);
        this.gradientTool.getAxis().setMaximum(256.0);
        this.add((Component)this.gradientTool, "East");
        this.imagePanel.addMouseMotionListener(this);
        this.imagePanel.addMouseListener(this);
        this.isBestFit = false;
        this.setAlignToGrid(true);
        this.isNegative = false;
        this.gColor = new Gradient();
        this.gColormap = this.gColor.buildColorMap(65536);
        this.gradientTool.setGradient(this.gColor);
        this.iSz = 1;
        this.showingMenu = true;
        this.listenerList = new EventListenerList();
        this.profileMode = 0;
        this.minFit = 0.0;
        this.maxFit = 100.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(String encFormat, byte[] rawData) {
        long t0 = System.currentTimeMillis();
        if (encFormat == null) {
            this.format = null;
            this.encFormat = null;
            this.errorString = "No image";
            this.statusLabel.setText("");
            this.imagePanel.setImage(null);
            this.freePopup();
            this.imageView.revalidate();
        } else {
            RawImageViewer rawImageViewer = this;
            synchronized (rawImageViewer) {
                if (this.encFormat == null || !this.encFormat.equalsIgnoreCase(encFormat)) {
                    this.encFormat = encFormat;
                    if (encFormat.equalsIgnoreCase("JPEG_GRAY8")) {
                        this.format = new Jpeg8ImageFormat();
                        this.format.initDefault(this.gradientTool);
                    } else if (encFormat.equalsIgnoreCase("GRAY8")) {
                        this.format = new Mono8ImageFormat();
                        this.format.initDefault(this.gradientTool);
                    } else if (encFormat.equalsIgnoreCase("GRAY16")) {
                        this.format = new Mono16ImageFormat();
                        this.format.initDefault(this.gradientTool);
                    } else if (encFormat.equalsIgnoreCase("JPEG_RGB")) {
                        this.format = new Jpeg24ImageFormat();
                        this.format.initDefault(this.gradientTool);
                        this.setGradientVisible(false);
                    } else if (encFormat.equalsIgnoreCase("RGB24")) {
                        this.format = new RGB24ImageFormat();
                        this.format.initDefault(this.gradientTool);
                        this.setGradientVisible(false);
                    } else {
                        this.errorString = encFormat + " format not supported";
                        this.statusLabel.setText(this.errorString);
                        this.format = null;
                    }
                    if (this.format != null) {
                        this.format.setFitting(this.isBestFit, this.minFit, this.maxFit);
                    }
                }
                if (this.format != null) {
                    try {
                        this.format.setData(rawData);
                    }
                    catch (IOException e) {
                        this.errorString = e.getMessage();
                        this.imagePanel.setImage(null);
                        this.freePopup();
                        this.imageView.revalidate();
                    }
                }
                this.computeAutoZoom();
                this.convertImage();
                this.refreshComponents();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBestFit(boolean b) {
        this.isBestFit = b;
        this.applyFitting();
        RawImageViewer rawImageViewer = this;
        synchronized (rawImageViewer) {
            this.convertImage();
        }
    }

    public boolean isBestFit() {
        return this.isBestFit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGradient(Gradient g) {
        this.gColor = g;
        this.gColormap = g.buildColorMap(65536);
        this.gradientTool.setGradient(this.gColor);
        this.gradientTool.repaint();
        RawImageViewer rawImageViewer = this;
        synchronized (rawImageViewer) {
            this.convertImage();
        }
    }

    public Gradient getGradient() {
        return this.gColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNegative(boolean b) {
        this.isNegative = b;
        RawImageViewer rawImageViewer = this;
        synchronized (rawImageViewer) {
            this.convertImage();
        }
    }

    public boolean isNegative() {
        return this.isNegative;
    }

    public void setToolbarVisible(boolean b) {
        this.buttonView.setVisible(b);
    }

    public boolean isToolbarVisible() {
        return this.buttonView.isVisible();
    }

    public void setStatusLineVisible(boolean b) {
        this.cfgPanel.setVisible(b);
    }

    public boolean isStatusLineVisible() {
        return this.cfgPanel.isVisible();
    }

    public int getZoom() {
        int s = 0;
        switch (this.iSz) {
            case -4: {
                s = 0;
                break;
            }
            case -2: {
                s = 1;
                break;
            }
            case 1: {
                s = 2;
                break;
            }
            case 2: {
                s = 3;
                break;
            }
            case 4: {
                s = 4;
                break;
            }
            case 8: {
                s = 5;
            }
        }
        return s;
    }

    public void setZoom(int zoomIndex) {
        switch (zoomIndex) {
            case 0: {
                this.iSz = -4;
                break;
            }
            case 1: {
                this.iSz = -2;
                break;
            }
            case 2: {
                this.iSz = 1;
                break;
            }
            case 3: {
                this.iSz = 2;
                break;
            }
            case 4: {
                this.iSz = 4;
                break;
            }
            case 5: {
                this.iSz = 8;
                break;
            }
            default: {
                JOptionPane.showMessageDialog(this, "NumberImageViewer.setZoom():\nInvalid zoom index value. [0..5]", "Error", 0);
                this.iSz = 1;
            }
        }
        if (this.iSz < 0) {
            this.imagePanel.setMarkerScale(-this.iSz);
        } else {
            this.imagePanel.setMarkerScale(1.0 / (double)this.iSz);
        }
        this.userZoom = true;
    }

    public void setAutoZoom(boolean auto) {
        this.autoZoom = auto;
    }

    public boolean getAutoZoom() {
        return this.autoZoom;
    }

    public void setAlignToGrid(boolean b) {
        this.snapToGrid = b;
        this.imagePanel.setSnapToGrid(b);
    }

    public boolean isAlignToGrid() {
        return this.snapToGrid;
    }

    public boolean isShowingMenu() {
        return this.showingMenu;
    }

    public void setShowingMenu(boolean b) {
        this.showingMenu = b;
    }

    public void addRoiListener(IRoiListener l) {
        this.listenerList.add(IRoiListener.class, l);
    }

    public void removeRoiListener(IRoiListener l) {
        this.listenerList.remove(IRoiListener.class, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelection(Rectangle r) {
        this.divRect(r);
        this.imagePanel.setSelection(r.x, r.y, r.x + r.width, r.y + r.height);
        RawImageViewer rawImageViewer = this;
        synchronized (rawImageViewer) {
            this.refreshComponents();
        }
    }

    public Rectangle getSelection() {
        Rectangle r = this.imagePanel.getSelectionRect();
        if (r != null) {
            this.mulRect(r);
        }
        return r;
    }

    public Insets getImageMargin() {
        return this.imagePanel.getMargin();
    }

    public void setImageMargin(Insets i) {
        this.imagePanel.setMargin(i);
    }

    public void setSelectionEnabled(boolean b) {
        this.imagePanel.setSelectionEnabled(b);
    }

    public boolean isSelectionEnabled() {
        return this.imagePanel.isSelectionEnabled();
    }

    public void setCrossCursor(boolean enable) {
        this.imagePanel.setCrossCursor(enable);
    }

    public void setCrossCursorColor(Color c) {
        this.imagePanel.setCursorColor(c);
    }

    public int getSelectionMode() {
        return this.imagePanel.getSelectionMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectionMode(int m) {
        this.imagePanel.clearSelection();
        this.imagePanel.setSelectionMode(m);
        this.freePopup();
        RawImageViewer rawImageViewer = this;
        synchronized (rawImageViewer) {
            this.refreshSelectionMinMax();
        }
    }

    public JLAxis getXAxis() {
        return this.imagePanel.getXAxis();
    }

    public JLAxis getYAxis() {
        return this.imagePanel.getYAxis();
    }

    public void setGradientVisible(boolean b) {
        this.gradientTool.setVisible(b);
    }

    public boolean isGradientVisible() {
        return this.gradientTool.isVisible();
    }

    public int getImageXCoord(int x) {
        if (this.iSz < 0) {
            return (x - this.imagePanel.getXOrigin()) / -this.iSz;
        }
        return (x - this.imagePanel.getXOrigin()) * this.iSz;
    }

    public int getImageYCoord(int y) {
        if (this.iSz < 0) {
            return (y - this.imagePanel.getYOrigin()) / -this.iSz;
        }
        return (y - this.imagePanel.getYOrigin()) * this.iSz;
    }

    public Dimension getCurrentImageSize() {
        Dimension d = new Dimension();
        if (this.format != null) {
            d.width = this.format.getWidth();
            d.height = this.format.getHeight();
        } else {
            d.width = 0;
            d.height = 0;
        }
        return d;
    }

    public JImage getImagePanel() {
        return this.imagePanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.settingsMenuItem) {
            this.showSettings();
        } else if (evt.getSource() == this.cancelButton) {
            this.settingsDialog.setVisible(false);
        } else if (evt.getSource() == this.okButton) {
            this.applySettings();
        } else if (evt.getSource() == this.propButton) {
            this.showPropertyFrame();
        } else if (evt.getSource() == this.gradButton) {
            this.showGradientEditor();
        } else if (src == this.selectButton || src == this.selectionMenuItem) {
            this.imagePanel.clearSelection();
            this.imagePanel.setSelectionMode(1);
            this.profileMode = 0;
            this.freePopup();
            RawImageViewer rawImageViewer = this;
            synchronized (rawImageViewer) {
                this.refreshSelectionMinMax();
            }
        } else if (src == this.selectMaxButton || src == this.selectionMaxMenuItem) {
            Dimension d = this.imagePanel.getImageSize();
            this.imagePanel.setSelection(0, 0, d.width, d.height);
            this.selectionChanged();
        } else if (src == this.fileButton || src == this.fileMenuItem) {
            this.saveFile();
        } else if (src == this.tableButton || src == this.tableMenuItem) {
            this.showTable();
        } else if (src == this.profileButton || src == this.lineProfileMenuItem) {
            this.imagePanel.setSelectionMode(0);
            this.constructLineProfiler();
            this.lineProfiler.setLineProfileMode();
            this.lineProfiler.setVisible(true);
            this.profileMode = 1;
            RawImageViewer d = this;
            synchronized (d) {
                this.refreshLineProfile();
                this.refreshSelectionMinMax();
            }
        } else if (src == this.histoButton || src == this.histogramMenuItem) {
            this.imagePanel.setSelectionMode(1);
            this.constructLineProfiler();
            this.lineProfiler.setHistogramMode();
            this.lineProfiler.setVisible(true);
            this.profileMode = 2;
            RawImageViewer d = this;
            synchronized (d) {
                this.refreshLineProfile();
            }
        } else if (src == this.settingsButton) {
            this.showSettings();
        } else if (src == this.axisButton) {
            this.showAxisDialog();
        } else if (src == this.axisCloseButton) {
            this.axisDialog.setVisible(false);
        } else if (src == this.bestFitMenuItem) {
            this.setBestFit(!this.isBestFit());
        } else if (src == this.negativeMenuItem) {
            this.setNegative(!this.isNegative());
        } else if (src == this.snapToGridMenuItem) {
            this.setAlignToGrid(!this.isAlignToGrid());
        } else if (src == this.toolbarMenuItem) {
            this.setToolbarVisible(!this.isToolbarVisible());
        } else if (src == this.statusLineMenuItem) {
            this.setStatusLineVisible(!this.isStatusLineVisible());
        } else if (src == this.showGradMenuItem) {
            this.setGradientVisible(!this.isGradientVisible());
        } else if (src == this.statsMenuItem) {
            JOptionPane.showMessageDialog(this, this.getImageInfo(), "Image Information", 1);
        } else if (src == this.bestFitCheck) {
            boolean sel = this.bestFitCheck.isSelected();
            this.fitMinText.setEnabled(!sel);
            this.fitMaxText.setEnabled(!sel);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
    }

    @Override
    public synchronized void mouseMoved(MouseEvent e) {
        if (this.format == null) {
            return;
        }
        Dimension imgsize = this.getCurrentImageSize();
        int x = this.getImageXCoord(e.getX());
        int y = this.getImageYCoord(e.getY());
        if (x >= imgsize.width || y >= imgsize.height || y < 0 || x < 0) {
            this.statusLabel.setText(this.getLabelInfoString());
        } else {
            this.statusLabel.setText(this.getLabelInfoString() + " (" + x + "," + y + ")=" + this.format.getValueStr(x, y));
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Rectangle newSelection = this.imagePanel.getSelectionRect();
        if (newSelection != null) {
            if (this.oldSelection == null) {
                this.selectionChanged();
            } else if (!newSelection.equals(this.oldSelection)) {
                this.selectionChanged();
            }
        }
        this.oldSelection = newSelection;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 3 && this.showingMenu && e.getSource() == this.imagePanel) {
            this.bestFitMenuItem.setSelected(this.isBestFit());
            this.snapToGridMenuItem.setSelected(this.isAlignToGrid());
            this.negativeMenuItem.setSelected(this.isNegative());
            this.toolbarMenuItem.setSelected(this.isToolbarVisible());
            this.statusLineMenuItem.setSelected(this.isStatusLineVisible());
            this.showGradMenuItem.setSelected(this.isGradientVisible());
            if (this.format != null) {
                this.showGradMenuItem.setEnabled(!this.format.isColorFormat());
            }
            this.imgMenu.show(this.imagePanel, e.getX(), e.getY());
        }
    }

    public void errorChange(ErrorEvent errorEvent) {
        this.setData(null, null);
    }

    public void stateChange(AttributeStateEvent evt) {
    }

    public void rawImageChange(RawImageEvent evt) {
        this.setData(evt.getEncodedFormat(), evt.getValue());
    }

    public void setModel(IRawImage v) {
        if (this.settingsDialog != null) {
            this.attNameLabel.setModel((IAttribute)v);
        }
        if (this.model != null) {
            this.model.removeRawImageListener((IRawImageListener)this);
            this.model = null;
        }
        if (v != null) {
            this.imagePanel.setImage(null);
            this.firstRefresh = !this.userZoom;
            this.freePopup();
            this.model = v;
            this.model.addRawImageListener((IRawImageListener)this);
            this.model.refresh();
        }
    }

    public void clearModel() {
        this.setModel(null);
    }

    private void constructSettingsPanel() {
        if (this.settingsDialog == null) {
            JPanel settingsPanel = new JPanel();
            settingsPanel.setLayout(null);
            settingsPanel.setMinimumSize(new Dimension(290, 235));
            settingsPanel.setPreferredSize(new Dimension(290, 235));
            this.attNameLabel = new LabelViewer();
            this.attNameLabel.setOpaque(false);
            this.attNameLabel.setFont(new Font("Dialog", 1, 16));
            this.attNameLabel.setBounds(5, 5, 200, 30);
            this.attNameLabel.setHorizontalAlignment(JSmoothLabel.LEFT_ALIGNMENT);
            settingsPanel.add(this.attNameLabel);
            this.attNameLabel.setModel((IAttribute)this.model);
            this.propButton = new JButton();
            this.propButton.setText("?");
            this.propButton.setToolTipText("Edit attribute properties");
            this.propButton.setFont(this.panelFont);
            this.propButton.setMargin(new Insets(0, 0, 0, 0));
            this.propButton.setBounds(250, 5, 30, 30);
            this.propButton.addActionListener(this);
            settingsPanel.add(this.propButton);
            JSeparator js = new JSeparator();
            js.setBounds(0, 40, 500, 10);
            settingsPanel.add(js);
            this.bestFitCheck = new JCheckBox("Best fit");
            this.bestFitCheck.setSelected(false);
            this.bestFitCheck.setFont(this.panelFont);
            this.bestFitCheck.setBounds(5, 50, 85, 20);
            this.bestFitCheck.setToolTipText("Display the image using the whole color range");
            this.bestFitCheck.addActionListener(this);
            settingsPanel.add(this.bestFitCheck);
            JLabel fitMinLabel = new JLabel("Min (%)");
            fitMinLabel.setFont(this.panelFont);
            fitMinLabel.setBounds(90, 50, 50, 20);
            fitMinLabel.setHorizontalAlignment(2);
            settingsPanel.add(fitMinLabel);
            this.fitMinText = new JTextField("");
            this.fitMinText.setMargin(this.noMargin);
            this.fitMinText.setFont(this.panelFont);
            this.fitMinText.setBounds(140, 50, 40, 20);
            settingsPanel.add(this.fitMinText);
            JLabel fitMaxLabel = new JLabel("Max (%)");
            fitMaxLabel.setFont(this.panelFont);
            fitMaxLabel.setBounds(190, 50, 50, 20);
            fitMaxLabel.setHorizontalAlignment(2);
            settingsPanel.add(fitMaxLabel);
            this.fitMaxText = new JTextField("");
            this.fitMaxText.setMargin(this.noMargin);
            this.fitMaxText.setFont(this.panelFont);
            this.fitMaxText.setBounds(240, 50, 40, 20);
            settingsPanel.add(this.fitMaxText);
            JSeparator js1 = new JSeparator();
            js1.setBounds(0, 80, 500, 10);
            settingsPanel.add(js1);
            JLabel formatLabel = new JLabel("Format");
            formatLabel.setFont(this.panelFont);
            formatLabel.setBounds(5, 90, 70, 20);
            settingsPanel.add(formatLabel);
            this.formatText = new JTextField("");
            this.formatText.setEditable(false);
            this.formatText.setMargin(this.noMargin);
            this.formatText.setFont(this.panelFont);
            this.formatText.setBounds(80, 90, 200, 20);
            settingsPanel.add(this.formatText);
            JLabel gradLabel = new JLabel("Colormap");
            gradLabel.setFont(this.panelFont);
            gradLabel.setBounds(5, 115, 70, 20);
            settingsPanel.add(gradLabel);
            this.gradViewer = new JGradientEditor();
            this.gradViewer.setGradient(this.gColor);
            this.gradViewer.setEditable(false);
            this.gradViewer.setToolTipText("Display the image using this colormap");
            this.gradViewer.setBounds(80, 115, 180, 20);
            settingsPanel.add(this.gradViewer);
            this.gradButton = new JButton();
            this.gradButton.setText("...");
            this.gradButton.setToolTipText("Edit colormap");
            this.gradButton.setFont(this.panelFont);
            this.gradButton.setMargin(new Insets(0, 0, 0, 0));
            this.gradButton.setBounds(260, 115, 20, 20);
            this.gradButton.addActionListener(this);
            settingsPanel.add(this.gradButton);
            this.negativeCheck = new JCheckBox("Negative image");
            this.negativeCheck.setSelected(false);
            this.negativeCheck.setFont(this.panelFont);
            this.negativeCheck.setBounds(5, 140, 110, 20);
            this.negativeCheck.setToolTipText("Display the negative image");
            settingsPanel.add(this.negativeCheck);
            JLabel imageSizeLabel = new JLabel("Image size");
            imageSizeLabel.setFont(this.panelFont);
            imageSizeLabel.setBounds(115, 140, 85, 20);
            imageSizeLabel.setHorizontalAlignment(0);
            settingsPanel.add(imageSizeLabel);
            this.imageSizeCombo = new JComboBox();
            this.imageSizeCombo.setFont(this.panelFont);
            this.imageSizeCombo.addItem("400  %");
            this.imageSizeCombo.addItem("200  %");
            this.imageSizeCombo.addItem("100  %");
            this.imageSizeCombo.addItem("50   %");
            this.imageSizeCombo.addItem("25   %");
            this.imageSizeCombo.addItem("12.5 %");
            this.imageSizeCombo.setBounds(200, 140, 80, 22);
            settingsPanel.add(this.imageSizeCombo);
            JSeparator js2 = new JSeparator();
            js2.setBounds(0, 168, 500, 10);
            settingsPanel.add(js2);
            this.snapToGridCheck = new JCheckBox("Align to grid");
            this.snapToGridCheck.setSelected(false);
            this.snapToGridCheck.setFont(this.panelFont);
            this.snapToGridCheck.setBounds(5, 175, 100, 20);
            this.snapToGridCheck.setToolTipText("Align the selection to the grid");
            settingsPanel.add(this.snapToGridCheck);
            JLabel snapToGridLabel = new JLabel("Grid spacing");
            snapToGridLabel.setFont(this.panelFont);
            snapToGridLabel.setBounds(110, 175, 90, 20);
            settingsPanel.add(snapToGridLabel);
            this.snapToGridText = new JTextField("");
            this.snapToGridText.setMargin(this.noMargin);
            this.snapToGridText.setFont(this.panelFont);
            this.snapToGridText.setBounds(205, 175, 50, 20);
            settingsPanel.add(this.snapToGridText);
            this.okButton = new JButton();
            this.okButton.setText("Apply");
            this.okButton.setFont(this.panelFont);
            this.okButton.setBounds(5, 205, 80, 25);
            this.okButton.addActionListener(this);
            settingsPanel.add(this.okButton);
            this.cancelButton = new JButton();
            this.cancelButton.setText("Dismiss");
            this.cancelButton.setFont(this.panelFont);
            this.cancelButton.setBounds(205, 205, 80, 25);
            this.cancelButton.addActionListener(this);
            settingsPanel.add(this.cancelButton);
            Window parent = ATKGraphicsUtils.getWindowForComponent(this);
            this.settingsDialog = parent instanceof Frame ? new JDialog((Frame)parent, true) : (parent instanceof Dialog ? new JDialog((Dialog)parent, true) : new JDialog((Frame)null, true));
            this.settingsDialog.setResizable(false);
            this.settingsDialog.setContentPane(settingsPanel);
            this.settingsDialog.setTitle("Image viewer settings");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showSettings() {
        this.constructSettingsPanel();
        this.bestFitCheck.setSelected(this.isBestFit);
        this.snapToGridCheck.setSelected(this.snapToGrid);
        this.negativeCheck.setSelected(this.isNegative);
        this.imageSizeCombo.setSelectedIndex(this.getZoom());
        this.fitMinText.setText(Double.toString(this.minFit));
        this.fitMaxText.setText(Double.toString(this.maxFit));
        this.fitMinText.setEnabled(!this.isBestFit);
        this.fitMaxText.setEnabled(!this.isBestFit);
        this.snapToGridText.setText(Integer.toString(this.imagePanel.getSnapGrid()));
        if (this.format != null) {
            if (this.format.isColorFormat()) {
                this.gradientTool.setVisible(false);
            }
            this.formatText.setText(this.format.getName());
        } else {
            this.formatText.setText("");
        }
        ATKGraphicsUtils.centerDialog(this.settingsDialog);
        this.settingsDialog.setVisible(true);
        RawImageViewer rawImageViewer = this;
        synchronized (rawImageViewer) {
            this.convertImage();
            this.refreshComponents();
        }
    }

    public void setMinFit(double min) {
        this.minFit = min;
        this.applyFitting();
    }

    public void setMaxFit(double max) {
        this.maxFit = max;
        this.applyFitting();
    }

    private void applyFitting() {
        boolean ok = true;
        try {
            if (this.fitMinText != null) {
                this.minFit = Double.parseDouble(this.fitMinText.getText());
                this.maxFit = Double.parseDouble(this.fitMaxText.getText());
            }
        }
        catch (NumberFormatException e) {
            ok = false;
        }
        if (this.format != null && !(ok = this.format.setFitting(this.isBestFit, this.minFit, this.maxFit))) {
            JOptionPane.showMessageDialog(null, "Invalid fitting parameters\nRestoring default", "Error", 0);
            this.format.setFitting(true, 0.0, 100.0);
            this.minFit = 0.0;
            this.maxFit = 100.0;
            this.isBestFit = true;
        }
    }

    private void applySettings() {
        String gridStr = this.snapToGridText.getText();
        this.isBestFit = this.bestFitCheck.isSelected();
        this.applyFitting();
        this.snapToGrid = this.snapToGridCheck.isSelected();
        this.isNegative = this.negativeCheck.isSelected();
        this.setZoom(this.imageSizeCombo.getSelectedIndex());
        this.setAlignToGrid(this.snapToGrid);
        try {
            int g = Integer.parseInt(gridStr);
            this.imagePanel.setSnapGrid(g);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Invalid syntax for grid value", "Error", 0);
        }
        this.settingsDialog.setVisible(false);
    }

    private void showPropertyFrame() {
        if (this.model != null) {
            if (this.propDialog == null) {
                this.propDialog = new SimplePropertyFrame(this.settingsDialog, true);
            }
            this.propDialog.setModel((IAttribute)this.model);
            this.propDialog.setVisible(true);
        }
    }

    private void showGradientEditor() {
        Gradient g = JGradientEditor.showDialog(this.settingsDialog, this.gColor);
        if (g != null) {
            this.gColor = g;
            this.gColormap = g.buildColorMap(65536);
            this.gradViewer.setGradient(this.gColor);
            this.gradViewer.repaint();
            this.gradientTool.setGradient(this.gColor);
            this.gradientTool.repaint();
        }
    }

    private void computeAutoZoom() {
        if (this.format == null) {
            return;
        }
        if (this.firstRefresh || this.autoZoom) {
            int dimx;
            int dimy = this.format.getHeight();
            if (dimy > 0 && dimx > 0) {
                if (dimx > 800 || dimy > 600) {
                    for (sz = 1; (dimx > 800 || dimy > 600) && sz < 8 && dimx % 2 == 0 && dimy % 2 == 0; dimx /= 2, dimy /= 2, sz *= 2) {
                    }
                    this.iSz = sz;
                } else {
                    for (dimx = this.format.getWidth(); dimx < 600 && dimy < 400 && sz < 4; dimx *= 2, dimy *= 2, sz *= 2) {
                    }
                    this.iSz = sz != 1 ? -sz : 1;
                }
                if (this.iSz < 0) {
                    this.imagePanel.setMarkerScale(-this.iSz);
                } else {
                    this.imagePanel.setMarkerScale(1.0 / (double)this.iSz);
                }
                this.firstRefresh = false;
            }
        }
    }

    private void adjustToolbarSize() {
        if (this.buttonView.isVisible()) {
            this.buttonView.setPreferredSize(new Dimension(60, 0));
        }
        this.revalidate();
    }

    private void saveFile() {
        File f;
        int ok = 0;
        FileFilter jpgFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = MultiExtFileFilter.getExtension(f);
                return extension != null && extension.equals("jpg");
            }

            @Override
            public String getDescription() {
                return "jpg - JPEG pictures (Color 24 Bits)";
            }
        };
        FileFilter jpg8Filter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = MultiExtFileFilter.getExtension(f);
                return extension != null && extension.equals("jpg");
            }

            @Override
            public String getDescription() {
                return "jpg - JPEG pictures (Mono 8 Bits)";
            }
        };
        FileFilter pngFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = MultiExtFileFilter.getExtension(f);
                return extension != null && extension.equals("png");
            }

            @Override
            public String getDescription() {
                return "png - PNG pictures (Color 24 Bits)";
            }
        };
        FileFilter png8Filter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = MultiExtFileFilter.getExtension(f);
                return extension != null && extension.equals("png");
            }

            @Override
            public String getDescription() {
                return "png - PNG pictures (Mono 8 Bits)";
            }
        };
        JFileChooser chooser = new JFileChooser(".");
        chooser.addChoosableFileFilter(pngFilter);
        chooser.addChoosableFileFilter(png8Filter);
        chooser.addChoosableFileFilter(jpgFilter);
        chooser.addChoosableFileFilter(jpg8Filter);
        chooser.setDialogTitle("Save snapshot");
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal == 0 && (f = chooser.getSelectedFile()) != null) {
            FileFilter filter = chooser.getFileFilter();
            if (filter == jpgFilter || filter == jpg8Filter) {
                if (MultiExtFileFilter.getExtension(f) == null || !MultiExtFileFilter.getExtension(f).equalsIgnoreCase("jpg")) {
                    f = new File(f.getAbsolutePath() + ".jpg");
                }
            } else if (filter == pngFilter || filter == png8Filter) {
                if (MultiExtFileFilter.getExtension(f) == null || !MultiExtFileFilter.getExtension(f).equalsIgnoreCase("png")) {
                    f = new File(f.getAbsolutePath() + ".png");
                }
            } else {
                JOptionPane.showMessageDialog(this, "Please select a valid image format", "Error", 0);
                return;
            }
            if (f.exists()) {
                ok = JOptionPane.showConfirmDialog(this, "Do you want to overwrite " + f.getName() + " ?", "Confirm overwrite", 0);
            }
            if (ok == 0) {
                if (filter == jpgFilter) {
                    try {
                        ImageIO.write((RenderedImage)this.imagePanel.getImage(), "jpg", f);
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(this, "File could not be saved", "Error", 0);
                    }
                } else if (filter == jpg8Filter) {
                    try {
                        ImageIO.write((RenderedImage)this.get8BitImage(), "jpg", f);
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(this, "File could not be saved", "Error", 0);
                    }
                } else if (filter == pngFilter) {
                    try {
                        ImageIO.write((RenderedImage)this.imagePanel.getImage(), "png", f);
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(this, "File could not be saved", "Error", 0);
                    }
                } else if (filter == png8Filter) {
                    try {
                        ImageIO.write((RenderedImage)this.get8BitImage(), "png", f);
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(this, "File could not be saved", "Error", 0);
                    }
                }
            }
        }
    }

    private BufferedImage get8BitImage() {
        int w = this.imagePanel.getImage().getWidth();
        int h = this.imagePanel.getImage().getHeight();
        BufferedImage newImage = new BufferedImage(w, h, 10);
        Graphics2D g2 = newImage.createGraphics();
        g2.drawImage((Image)this.imagePanel.getImage(), 0, 0, null);
        g2.dispose();
        return newImage;
    }

    private void fireRoiChange() {
        IRoiListener[] list = (IRoiListener[])this.listenerList.getListeners(IRoiListener.class);
        RoiEvent w = new RoiEvent(this, this.getSelection());
        for (int i = 0; i < list.length; ++i) {
            list[i].roiChange(w);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectionChanged() {
        RawImageViewer rawImageViewer = this;
        synchronized (rawImageViewer) {
            this.refreshComponents();
        }
        this.fireRoiChange();
    }

    private void mulRect(Rectangle r) {
        if (this.iSz < 0) {
            r.x /= -this.iSz;
            r.y /= -this.iSz;
            r.width /= -this.iSz;
            r.height /= -this.iSz;
        } else {
            r.x *= this.iSz;
            r.y *= this.iSz;
            r.width *= this.iSz;
            r.height *= this.iSz;
        }
    }

    private void divRect(Rectangle r) {
        if (this.iSz < 0) {
            r.x *= -this.iSz;
            r.y *= -this.iSz;
            r.width *= -this.iSz;
            r.height *= -this.iSz;
        } else {
            r.x /= this.iSz;
            r.y /= this.iSz;
            r.width /= this.iSz;
            r.height /= this.iSz;
        }
    }

    private void mulPoint(Point p) {
        boolean xOk = false;
        boolean yOk = false;
        Dimension d = this.getCurrentImageSize();
        if (this.iSz < 0) {
            p.x /= -this.iSz;
            p.y /= -this.iSz;
        } else {
            if (p.x == d.width / this.iSz - 1) {
                p.x = d.width - 1;
                xOk = true;
            }
            if (p.y == d.height / this.iSz - 1) {
                p.y = d.height - 1;
                yOk = true;
            }
            if (!xOk) {
                p.x *= this.iSz;
            }
            if (!yOk) {
                p.y *= this.iSz;
            }
        }
    }

    private void freePopup() {
        if (this.lineProfiler != null) {
            this.lineProfiler.setData(null);
        }
        if (this.tableDialog != null) {
            this.tablePanel.clearData();
        }
    }

    private void constructTablePanel() {
        if (this.tableDialog == null) {
            this.tablePanel = new JTableRow();
            this.tableDialog = new JFrame();
            this.tableDialog.setContentPane(this.tablePanel);
            this.tableDialog.setTitle("[table] ImageViewer");
            this.tableDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    RawImageViewer.this.tablePanel.clearData();
                    RawImageViewer.this.tableDialog.dispose();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showTable() {
        this.constructTablePanel();
        if (this.tableDialog.isVisible()) {
            this.tableDialog.setVisible(true);
            return;
        }
        RawImageViewer rawImageViewer = this;
        synchronized (rawImageViewer) {
            if (!this.buildTable()) {
                return;
            }
        }
        ATKGraphicsUtils.centerFrameOnScreen(this.tableDialog);
        this.tableDialog.setVisible(true);
    }

    private boolean buildTable() {
        Object[][] d;
        Rectangle r = this.imagePanel.getSelectionRect();
        if (r == null) {
            d = this.imagePanel.getImageSize();
            r = new Rectangle(0, 0, d.width, d.height);
        }
        this.mulRect(r);
        if (r.width <= 0 || r.height <= 0) {
            return false;
        }
        try {
            d = new Double[r.height][r.width];
            for (int j = 0; j < r.height; ++j) {
                for (int i = 0; i < r.width; ++i) {
                    d[j][i] = new Double(this.format.getValue(r.x + i, r.y + j));
                }
            }
            this.tablePanel.setData(d, r.x, r.y);
        }
        catch (OutOfMemoryError e) {
            System.out.println("Out of memory, cannot build the table");
            this.tablePanel.clearData();
        }
        return true;
    }

    private double[] buildHistogramData() {
        int i;
        double[] histo = new double[this.format.getHistogramWidth()];
        Rectangle r = this.imagePanel.getSelectionRect();
        if (r == null) {
            Dimension d = this.imagePanel.getImageSize();
            r = new Rectangle(0, 0, d.width, d.height);
        }
        this.mulRect(r);
        for (i = 0; i < histo.length; ++i) {
            histo[i] = 0.0;
        }
        try {
            for (i = r.x; i < r.x + r.width; ++i) {
                for (int j = r.y; j < r.y + r.height; ++j) {
                    int n = (int)this.format.getValue(i, j);
                    histo[n] = histo[n] + 1.0;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("NumberImageViewer.buildHistogramData() : Cannot build histogram. One or more value exceed the range [0..65535].");
            return null;
        }
        return histo;
    }

    private void refreshComponents() {
        this.refreshLineProfile();
        this.refreshSelectionMinMax();
        if (this.tableDialog != null && this.tableDialog.isVisible()) {
            this.buildTable();
            this.tablePanel.repaint();
        }
    }

    private void constructLineProfiler() {
        if (this.lineProfiler == null) {
            this.lineProfiler = new LineProfilerViewer();
            this.lineProfiler.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    RawImageViewer.this.lineProfiler.setData(null);
                    RawImageViewer.this.lineProfiler.dispose();
                }
            });
        }
    }

    private void refreshLineProfile() {
        if (this.format == null) {
            return;
        }
        if (this.lineProfiler != null && this.lineProfiler.isVisible() && this.profileMode > 0) {
            switch (this.profileMode) {
                case 1: {
                    this.lineProfiler.setData(this.buildProfileData());
                    break;
                }
                case 2: {
                    double[] v = this.buildHistogramData();
                    if (v != null) {
                        this.lineProfiler.setData(v, 0);
                        break;
                    }
                    this.lineProfiler.setData(null);
                }
            }
        }
    }

    private double[] buildProfileData() {
        Dimension d = this.getCurrentImageSize();
        Point[] p = this.imagePanel.getSelectionPoint();
        if (p != null) {
            double[] profile;
            this.mulPoint(p[0]);
            this.mulPoint(p[1]);
            int dx = p[1].x - p[0].x;
            int dy = p[1].y - p[0].y;
            int adx = Math.abs(dx);
            int ady = Math.abs(dy);
            if (adx > ady) {
                double delta = (double)dy / (double)adx;
                profile = new double[adx + 1];
                int xe = p[0].x;
                for (int i = 0; i <= adx; ++i) {
                    int ye = p[0].y + (int)(delta * (double)i);
                    profile[i] = xe >= 0 && xe < d.width && ye >= 0 && ye < d.height ? this.format.getValue(xe, ye) : Double.NaN;
                    if (dx < 0) {
                        --xe;
                        continue;
                    }
                    ++xe;
                }
            } else {
                double delta = (double)dx / (double)ady;
                profile = new double[ady + 1];
                int ye = p[0].y;
                for (int i = 0; i <= ady; ++i) {
                    int xe = p[0].x + (int)(delta * (double)i);
                    profile[i] = xe >= 0 && xe < d.width && ye >= 0 && ye < d.height ? this.format.getValue(xe, ye) : Double.NaN;
                    if (dy < 0) {
                        --ye;
                        continue;
                    }
                    ++ye;
                }
            }
            return profile;
        }
        return null;
    }

    private void showAxisDialog() {
        if (this.axisDialog == null) {
            Window parent = ATKGraphicsUtils.getWindowForComponent(this);
            this.axisDialog = parent instanceof Frame ? new JDialog((Frame)parent, false) : (parent instanceof Dialog ? new JDialog((Dialog)parent, false) : new JDialog((Frame)null, false));
            this.axisDialog.setTitle("Axis settings");
            JPanel innerPanel = new JPanel(null);
            JTabbedPane tabPane = new JTabbedPane();
            AxisPanel xAxisPanel = new AxisPanel(this.getXAxis(), 3, null);
            AxisPanel yAxisPanel = new AxisPanel(this.getYAxis(), 1, null);
            tabPane.add("X axis", xAxisPanel);
            tabPane.add("Y axis", yAxisPanel);
            tabPane.setBounds(5, 5, 300, 370);
            innerPanel.add(tabPane);
            this.axisCloseButton = new JButton("Close");
            this.axisCloseButton.setFont(ATKConstant.labelFont);
            this.axisCloseButton.setBounds(225, 380, 80, 25);
            innerPanel.add(this.axisCloseButton);
            this.axisCloseButton.addActionListener(this);
            innerPanel.setPreferredSize(new Dimension(310, 410));
            tabPane.setBounds(5, 5, 300, 370);
            this.axisDialog.setContentPane(innerPanel);
        }
        ATKGraphicsUtils.centerDialog(this.axisDialog);
        this.axisDialog.setVisible(true);
        this.imagePanel.repaint();
    }

    private void refreshSelectionMinMax() {
        if (this.format == null) {
            return;
        }
        Rectangle r = this.imagePanel.getSelectionRect();
        if (r == null) {
            Dimension d = this.imagePanel.getImageSize();
            r = new Rectangle(0, 0, d.width, d.height);
        }
        this.mulRect(r);
        double curSelMin = 65536.0;
        double curSelMax = 0.0;
        for (int j = r.y; j < r.y + r.height; ++j) {
            for (int i = r.x; i < r.x + r.width; ++i) {
                double v = this.format.getValue(i, j);
                if (v > curSelMax) {
                    curSelMax = v;
                }
                if (!(v < curSelMin)) continue;
                curSelMin = v;
            }
        }
        String sel = "Selection: (" + r.x + "," + r.y + ") - [" + r.width + "," + r.height + "]";
        if (curSelMin <= curSelMax) {
            this.rangeLabel.setText(sel + " Range: " + Double.toString(curSelMin) + " , " + Double.toString(curSelMax));
        } else {
            this.rangeLabel.setText("");
        }
    }

    private String getLabelInfoString() {
        Dimension imgsize = this.getCurrentImageSize();
        int percent = this.iSz < 0 ? (int)(100.0 * (double)(-this.iSz)) : (int)(100.0 / (double)this.iSz);
        return percent + "% [" + imgsize.width + "," + imgsize.height + "]";
    }

    private String getImageInfo() {
        double v;
        int i;
        int j;
        Object retString = "";
        if (this.format == null) {
            return "No image";
        }
        IImageFormat cur = this.format;
        retString = (String)retString + "Format: " + cur.getName() + "\n";
        retString = (String)retString + "Full Width: " + cur.getWidth() + "\n";
        retString = (String)retString + "Full Height: " + cur.getHeight() + "\n\n";
        Rectangle r = this.imagePanel.getSelectionRect();
        if (r == null) {
            Dimension d = this.imagePanel.getImageSize();
            r = new Rectangle(0, 0, d.width, d.height);
        }
        this.mulRect(r);
        retString = (String)retString + "Selection: (" + r.x + "," + r.y + ") - [" + r.width + "," + r.height + "]\n";
        double curSelMin = 65536.0;
        double curSelMax = 0.0;
        double sum = 0.0;
        double sum2 = 0.0;
        double lgth = 0.0;
        for (j = r.y; j < r.y + r.height; ++j) {
            for (i = r.x; i < r.x + r.width; ++i) {
                v = cur.getValue(i, j);
                if (v > curSelMax) {
                    curSelMax = v;
                }
                if (v < curSelMin) {
                    curSelMin = v;
                }
                sum += v;
                lgth += 1.0;
            }
        }
        double avg = sum / lgth;
        for (j = r.y; j < r.y + r.height; ++j) {
            for (i = r.x; i < r.x + r.width; ++i) {
                v = cur.getValue(i, j);
                sum2 += (v - avg) * (v - avg);
            }
        }
        double std = Math.sqrt(sum2 / lgth);
        Double avgD = new Double(avg);
        Double stdD = new Double(std);
        if (curSelMin <= curSelMax) {
            retString = (String)retString + "Minimum: " + Double.toString(curSelMin) + "\n";
            retString = (String)retString + "Maximum: " + Double.toString(curSelMax) + "\n";
        }
        retString = (String)retString + "Average: " + String.format("%.2f", avgD) + "\n";
        retString = (String)retString + "Std deviation: " + String.format("%.2f", stdD) + "\n";
        return retString;
    }

    private void convertImage() {
        int rdimy;
        int rdimx;
        if (this.format == null || this.format.isNull()) {
            this.statusLabel.setText(this.errorString);
            return;
        }
        int dimx = this.format.getWidth();
        int dimy = this.format.getHeight();
        if (dimx == 0 || dimy == 0) {
            return;
        }
        BufferedImage lastImg = this.imagePanel.getImage();
        if (this.iSz < 0) {
            rdimx = dimx * -this.iSz;
            rdimy = dimy * -this.iSz;
        } else {
            rdimx = dimx / this.iSz;
            rdimy = dimy / this.iSz;
        }
        if (lastImg == null || lastImg.getHeight() != rdimy || lastImg.getWidth() != rdimx) {
            this.rgb = new int[rdimx];
            lastImg = new BufferedImage(rdimx, rdimy, 1);
            this.imagePanel.setImage(lastImg);
            this.freePopup();
            this.statusLabel.setText(this.getLabelInfoString());
            this.refreshComponents();
        }
        this.format.computeFitting();
        if (this.isGradientVisible()) {
            this.gradientTool.repaint();
        }
        if (this.iSz < 0) {
            int sz = -this.iSz;
            for (int j = 0; j < dimy; ++j) {
                for (int i = 0; i < dimx; ++i) {
                    int c = this.format.getRGB(this.isNegative, this.gColormap, i, j);
                    for (int k = 0; k < sz; ++k) {
                        this.rgb[i * sz + k] = c;
                    }
                }
                for (int k = 0; k < sz; ++k) {
                    lastImg.getRaster().setDataElements(0, j * sz + k, rdimx, 1, this.rgb);
                }
            }
        } else {
            int j = 0;
            for (int l = 0; l < rdimy; ++l) {
                int i = 0;
                for (int k = 0; k < rdimx; ++k) {
                    this.rgb[k] = this.format.getRGB(this.isNegative, this.gColormap, i, j);
                    i += this.iSz;
                }
                lastImg.getRaster().setDataElements(0, l, rdimx, 1, this.rgb);
                j += this.iSz;
            }
        }
        this.imagePanel.repaint();
        this.imageView.revalidate();
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        RawImageViewer d = new RawImageViewer();
        NumberScalarWheelEditor nse = new NumberScalarWheelEditor();
        NumberScalarViewer nsv = new NumberScalarViewer();
        d.setStatusLineVisible(false);
        d.setGradientVisible(false);
        d.setToolbarVisible(false);
        AttributeList attributeList = new AttributeList();
        final ErrorHistory errWin = new ErrorHistory();
        attributeList.addErrorListener((IErrorListener)errWin);
        d.setBestFit(false);
        Gradient g = new Gradient();
        g.buildRainbowGradient();
        g.setColorAt(0, new Color(10, 10, 10));
        g.addEntry(new Color(255, 255, 50), 0.1);
        d.setGradient(g);
        d.setAutoZoom(false);
        d.setZoom(2);
        try {
            IRawImage theAtt = (IRawImage)AttributeFactory.getInstance().getAttribute("srdiag/ccd/c25-1/jpegimage");
            d.setModel(theAtt);
            theAtt.refresh();
            NumberScalar smooth = (NumberScalar)attributeList.add("srdiag/ccd/c25-1/jpegsmooth");
            nse.setModel((INumberScalar)smooth);
            NumberScalar counter = (NumberScalar)attributeList.add("srdiag/ccd/c25-1/ImageCounter");
            nsv.setModel((INumberScalar)counter);
            class R
            implements INumberScalarListener {
                final /* synthetic */ IRawImage val$theAtt;

                R(IRawImage iRawImage) {
                    this.val$theAtt = iRawImage;
                }

                public void numberScalarChange(NumberScalarEvent evt) {
                    System.out.println("Refresh enter #" + (int)evt.getValue());
                    this.val$theAtt.refresh();
                    System.out.println("Refresh exit #" + (int)evt.getValue());
                }

                public void stateChange(AttributeStateEvent e) {
                }

                public void errorChange(ErrorEvent evt) {
                }
            }
            R Rref = new R(theAtt);
            counter.addNumberScalarListener((INumberScalarListener)Rref);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        f.getContentPane().setLayout(new BorderLayout());
        f.getContentPane().add((Component)d, "Center");
        JPanel panel = new JPanel();
        JButton errorBtn = new JButton("Show errors");
        errorBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                errWin.setVisible(true);
            }
        });
        panel.add(errorBtn);
        JButton diagBtn = new JButton("Show diag");
        diagBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ATKDiagnostic.showDiagnostic();
            }
        });
        panel.add(diagBtn);
        panel.add(nse);
        panel.add(nsv);
        f.getContentPane().add((Component)panel, "South");
        attributeList.setRefreshInterval(1000);
        attributeList.startRefresher();
        f.setDefaultCloseOperation(3);
        f.setTitle("RawImageViewer");
        f.pack();
        f.setVisible(true);
    }
}

