/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IEnumScalar;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.widget.attribute.BooleanScalarCheckBoxViewer;
import fr.esrf.tangoatk.widget.attribute.BooleanScalarComboEditor;
import fr.esrf.tangoatk.widget.attribute.EnumScalarComboEditor;
import fr.esrf.tangoatk.widget.attribute.NumberScalarComboEditor;
import fr.esrf.tangoatk.widget.attribute.NumberScalarWheelEditor;
import fr.esrf.tangoatk.widget.attribute.SimpleEnumScalarViewer;
import fr.esrf.tangoatk.widget.attribute.SimplePropertyFrame;
import fr.esrf.tangoatk.widget.attribute.SimpleScalarViewer;
import fr.esrf.tangoatk.widget.attribute.StringScalarComboEditor;
import fr.esrf.tangoatk.widget.attribute.StringScalarEditor;
import fr.esrf.tangoatk.widget.properties.LabelViewer;
import fr.esrf.tangoatk.widget.util.JAutoScrolledText;
import fr.esrf.tangoatk.widget.util.JAutoScrolledTextListener;
import fr.esrf.tangoatk.widget.util.JSmoothLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ScalarListSetter
extends JPanel
implements JAutoScrolledTextListener {
    public static final String BOOLEAN_DEFAULT_SETTER = "None";
    public static final String BOOLEAN_COMBO_SETTER = "BooleanComboEditor";
    protected Vector<IAttribute> listModel = null;
    protected Vector<LabelViewer> scalarLabels = null;
    protected Vector<JComponent> scalarViewers = null;
    protected Vector<JComponent> scalarSetters = null;
    protected Vector<JButton> scalarPropButtons = null;
    protected SimplePropertyFrame propFrame = new SimplePropertyFrame();
    protected Font theFont = new Font("Dialog", 0, 14);
    private boolean labelVisible = true;
    private boolean viewerVisible = true;
    private boolean propertyButtonVisible = true;
    private boolean propertyListEditable = true;
    private boolean unitVisible = true;
    private String booleanSetterType = "None";
    private Color arrowColor = null;
    private String toolTipDisplay = "Name";
    private String numberSetterType = "deprecated";
    private String stringSetterType = "deprecated";
    public static final String NUMBER_DEFAULT_SETTER = "WheelEditor";
    public static final String NUMBER_COMBO_SETTER = "ComboEditor";
    public static final String STRING_DEFAULT_SETTER = "StringScalarEditor";
    public static final String STRING_COMBO_SETTER = "StringComboEditor";
    public static final String TOOLTIP_DISPLAY_NONE = "None";
    public static final String TOOLTIP_DISPLAY_NAME_ONLY = "Name";
    public static final String TOOLTIP_DISPLAY_ALL = "All";

    public ScalarListSetter() {
        this.setLayout(new GridBagLayout());
    }

    public void setModel(AttributeList scalarList) {
        if (scalarList == null) {
            if (this.listModel != null) {
                this.removeComponents();
            }
            return;
        }
        if (this.listModel != null) {
            return;
        }
        int nbAtts = scalarList.getSize();
        if (nbAtts <= 0) {
            return;
        }
        boolean containsWritableScalarAtt = false;
        for (int idx = 0; idx < nbAtts; ++idx) {
            IAttribute isa;
            Object elem = scalarList.getElementAt(idx);
            if (!(elem instanceof INumberScalar) && !(elem instanceof IStringScalar) && !(elem instanceof IBooleanScalar) && !(elem instanceof IEnumScalar) || !(isa = (IAttribute)elem).isWritable()) continue;
            containsWritableScalarAtt = true;
            break;
        }
        if (!containsWritableScalarAtt) {
            return;
        }
        this.initComponents(scalarList);
        this.setVisible(true);
    }

    public void clearModel() {
        this.setModel(null);
    }

    protected void removeComponents() {
        IAttribute iatt = null;
        JComponent jcomp = null;
        LabelViewer scalarLabel = null;
        SimpleScalarViewer viewer = null;
        BooleanScalarCheckBoxViewer bsViewer = null;
        SimpleEnumScalarViewer esViewer = null;
        NumberScalarWheelEditor wheelSetter = null;
        NumberScalarComboEditor nComboSetter = null;
        StringScalarEditor stringSetter = null;
        StringScalarComboEditor sComboSetter = null;
        BooleanScalarComboEditor bComboSetter = null;
        EnumScalarComboEditor eComboSetter = null;
        Object propertyButton = null;
        this.propFrame = null;
        this.propFrame = new SimplePropertyFrame();
        int nbRows = this.listModel.size();
        for (int indRow = 0; indRow < nbRows; ++indRow) {
            try {
                INumberScalar ins = null;
                IStringScalar iss = null;
                IBooleanScalar ibs = null;
                IEnumScalar ies = null;
                iatt = this.listModel.get(indRow);
                if (iatt instanceof INumberScalar) {
                    ins = (INumberScalar)iatt;
                } else if (iatt instanceof IStringScalar) {
                    iss = (IStringScalar)iatt;
                } else if (iatt instanceof IBooleanScalar) {
                    ibs = (IBooleanScalar)iatt;
                } else if (iatt instanceof IEnumScalar) {
                    ies = (IEnumScalar)iatt;
                }
                if (ins == null && iss == null && ibs == null && ies == null) continue;
                scalarLabel = this.scalarLabels.get(indRow);
                scalarLabel.setModel(null);
                jcomp = this.scalarViewers.get(indRow);
                if (jcomp instanceof SimpleScalarViewer) {
                    viewer = (SimpleScalarViewer)jcomp;
                    viewer.clearModel();
                } else if (jcomp instanceof BooleanScalarCheckBoxViewer) {
                    bsViewer = (BooleanScalarCheckBoxViewer)jcomp;
                    bsViewer.clearModel();
                } else if (jcomp instanceof SimpleEnumScalarViewer) {
                    esViewer = (SimpleEnumScalarViewer)jcomp;
                    esViewer.clearModel();
                }
                jcomp = this.scalarSetters.get(indRow);
                if (jcomp == null) continue;
                if (jcomp instanceof NumberScalarWheelEditor) {
                    wheelSetter = (NumberScalarWheelEditor)jcomp;
                    wheelSetter.setModel(null);
                    continue;
                }
                if (jcomp instanceof NumberScalarComboEditor) {
                    nComboSetter = (NumberScalarComboEditor)jcomp;
                    nComboSetter.setNumberModel(null);
                    continue;
                }
                if (jcomp instanceof StringScalarEditor) {
                    stringSetter = (StringScalarEditor)jcomp;
                    stringSetter.setModel(null);
                    continue;
                }
                if (jcomp instanceof StringScalarComboEditor) {
                    sComboSetter = (StringScalarComboEditor)jcomp;
                    sComboSetter.setStringModel(null);
                    continue;
                }
                if (jcomp instanceof BooleanScalarComboEditor) {
                    bComboSetter = (BooleanScalarComboEditor)jcomp;
                    if (ibs == null || !ibs.isWritable()) continue;
                    bComboSetter.setAttModel(null);
                    continue;
                }
                if (!(jcomp instanceof EnumScalarComboEditor)) continue;
                eComboSetter = (EnumScalarComboEditor)jcomp;
                if (ies == null || !ies.isWritable()) continue;
                eComboSetter.setEnumModel(null);
                continue;
            }
            catch (Exception e) {
                System.out.println("ScalarListSetter : setTheFont : Caught exception  " + e.getMessage());
            }
        }
        this.scalarLabels.removeAllElements();
        this.scalarViewers.removeAllElements();
        this.scalarSetters.removeAllElements();
        this.scalarPropButtons.removeAllElements();
        this.listModel.removeAllElements();
        this.removeAll();
        this.listModel = null;
        this.scalarLabels = null;
        this.scalarViewers = null;
        this.scalarSetters = null;
        this.scalarPropButtons = null;
    }

    public Font getTheFont() {
        return this.theFont;
    }

    public void setTheFont(Font ft) {
        LabelViewer scalarLabel = null;
        JComponent viewer = null;
        JComponent setter = null;
        JButton propertyButton = null;
        if (ft != null) {
            this.theFont = ft;
            if (this.listModel != null) {
                int nbRows = this.listModel.size();
                for (int indRow = 0; indRow < nbRows; ++indRow) {
                    try {
                        scalarLabel = this.scalarLabels.get(indRow);
                        scalarLabel.setFont(this.theFont);
                        viewer = this.scalarViewers.get(indRow);
                        if (viewer != null && (viewer instanceof SimpleScalarViewer || viewer instanceof BooleanScalarCheckBoxViewer || viewer instanceof SimpleEnumScalarViewer)) {
                            viewer.setFont(this.theFont);
                        }
                        if ((setter = this.scalarSetters.get(indRow)) != null && (setter instanceof NumberScalarWheelEditor || setter instanceof NumberScalarComboEditor || setter instanceof StringScalarEditor || setter instanceof StringScalarComboEditor || setter instanceof BooleanScalarComboEditor || setter instanceof EnumScalarComboEditor)) {
                            setter.setFont(this.theFont);
                        }
                        propertyButton = this.scalarPropButtons.get(indRow);
                        propertyButton.setFont(this.theFont);
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println("ScalarListSetter : setTheFont : Caught exception  " + e.getMessage());
                    }
                }
            }
        }
    }

    public boolean getLabelVisible() {
        return this.labelVisible;
    }

    public void setLabelVisible(boolean lv) {
        if (this.labelVisible != lv) {
            this.labelVisible = lv;
            this.changeLabelVisibility();
        }
    }

    private void changeLabelVisibility() {
        LabelViewer scalarLabel = null;
        if (this.scalarLabels != null) {
            int nbRows = this.scalarLabels.size();
            for (int indRow = 0; indRow < nbRows; ++indRow) {
                try {
                    scalarLabel = this.scalarLabels.get(indRow);
                    scalarLabel.setVisible(this.labelVisible);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("ScalarListSetter : changeLabelVisibility : Caught exception  " + e.getMessage());
                }
            }
        }
    }

    public boolean getViewerVisible() {
        return this.viewerVisible;
    }

    public void setViewerVisible(boolean sv) {
        if (this.viewerVisible != sv) {
            this.viewerVisible = sv;
            this.changeViewerVisibility();
        }
    }

    private void changeViewerVisibility() {
        JComponent viewer = null;
        if (this.scalarViewers != null) {
            int nbRows = this.scalarViewers.size();
            for (int indRow = 0; indRow < nbRows; ++indRow) {
                try {
                    viewer = this.scalarViewers.get(indRow);
                    if (viewer == null || !(viewer instanceof SimpleScalarViewer) && !(viewer instanceof BooleanScalarCheckBoxViewer) && !(viewer instanceof SimpleEnumScalarViewer)) continue;
                    viewer.setVisible(this.viewerVisible);
                    if (!(viewer instanceof BooleanScalarCheckBoxViewer) || this.viewerVisible || this.booleanSetterType.equalsIgnoreCase(BOOLEAN_COMBO_SETTER)) continue;
                    viewer.setVisible(true);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("ScalarListSetter : changeViewerVisibility : Caught exception  " + e.getMessage());
                }
            }
        }
    }

    public boolean getPropertyButtonVisible() {
        return this.propertyButtonVisible;
    }

    public void setPropertyButtonVisible(boolean pv) {
        if (this.propertyButtonVisible != pv) {
            this.propertyButtonVisible = pv;
            this.changePropButtonVisibility();
        }
    }

    private void changePropButtonVisibility() {
        JButton propertyButton = null;
        if (this.scalarPropButtons != null) {
            int nbRows = this.scalarPropButtons.size();
            for (int indRow = 0; indRow < nbRows; ++indRow) {
                try {
                    propertyButton = this.scalarPropButtons.get(indRow);
                    propertyButton.setVisible(this.propertyButtonVisible);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("ScalarListSetter : changePropButtonVisibility : Caught exception  " + e.getMessage());
                }
            }
        }
    }

    public boolean getPropertyListEditable() {
        return this.propertyListEditable;
    }

    public void setPropertyListEditable(boolean pv) {
    }

    public boolean getUnitVisible() {
        return this.unitVisible;
    }

    public void setUnitVisible(boolean uv) {
        if (this.unitVisible != uv) {
            this.unitVisible = uv;
            this.changeUnitVisibility();
        }
    }

    private void changeUnitVisibility() {
        JComponent jcomp = null;
        SimpleScalarViewer viewer = null;
        NumberScalarComboEditor setter = null;
        if (this.scalarViewers != null) {
            int nbRows = this.scalarViewers.size();
            for (int indRow = 0; indRow < nbRows; ++indRow) {
                try {
                    jcomp = this.scalarViewers.get(indRow);
                    if (jcomp != null && jcomp instanceof SimpleScalarViewer) {
                        viewer = (SimpleScalarViewer)jcomp;
                        viewer.setUnitVisible(this.unitVisible);
                    }
                    if ((jcomp = this.scalarSetters.get(indRow)) == null || !(jcomp instanceof NumberScalarComboEditor)) continue;
                    setter = (NumberScalarComboEditor)jcomp;
                    setter.setUnitVisible(this.unitVisible);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("ScalarListViewer : changeUnitVisibility : Caught exception  " + e.getMessage());
                }
            }
        }
    }

    public String getBooleanSetterType() {
        return this.booleanSetterType;
    }

    public void setBooleanSetterType(String setType) {
        if (this.listModel != null) {
            return;
        }
        this.booleanSetterType = setType.equalsIgnoreCase("None") ? "None" : (setType.equalsIgnoreCase(BOOLEAN_COMBO_SETTER) ? BOOLEAN_COMBO_SETTER : "None");
    }

    public String getToolTipDisplay() {
        return this.toolTipDisplay;
    }

    public void setToolTipDisplay(String ttType) {
        if (this.listModel != null) {
            return;
        }
        this.toolTipDisplay = ttType.equalsIgnoreCase(TOOLTIP_DISPLAY_ALL) ? TOOLTIP_DISPLAY_ALL : (ttType.equalsIgnoreCase(TOOLTIP_DISPLAY_NAME_ONLY) ? TOOLTIP_DISPLAY_NAME_ONLY : "None");
    }

    public String getNumberSetterType() {
        return this.numberSetterType;
    }

    public void setNumberSetterType(String setType) {
    }

    public String getStringSetterType() {
        return this.stringSetterType;
    }

    public void setStringSetterType(String setType) {
    }

    public Color getArrowColor() {
        if (this.arrowColor == null) {
            return this.getBackground();
        }
        return this.arrowColor;
    }

    public void setArrowColor(Color ac) {
        if (ac == this.arrowColor) {
            return;
        }
        this.changeArrowColors(ac);
        this.arrowColor = ac;
    }

    private void changeArrowColors(Color ac) {
        JComponent jcomp = null;
        NumberScalarWheelEditor setter = null;
        if (this.scalarSetters != null) {
            int nbRows = this.scalarSetters.size();
            for (int indRow = 0; indRow < nbRows; ++indRow) {
                try {
                    jcomp = this.scalarSetters.get(indRow);
                    if (!(jcomp instanceof NumberScalarWheelEditor)) continue;
                    setter = (NumberScalarWheelEditor)jcomp;
                    if (ac == null) {
                        setter.setButtonColor(setter.getBackground());
                        continue;
                    }
                    setter.setButtonColor(ac);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("ScalarListSetter : changeArrowColors : Caught exception  " + e.getMessage());
                }
            }
        }
    }

    @Override
    public void textExceedBounds(JAutoScrolledText source) {
        this.revalidate();
    }

    protected void initComponents(AttributeList scalarList) {
        LabelViewer scalarLabel = null;
        SimpleScalarViewer ssViewer = null;
        BooleanScalarCheckBoxViewer boolViewer = null;
        BooleanScalarComboEditor boolComboSetter = null;
        SimpleEnumScalarViewer enumViewer = null;
        EnumScalarComboEditor enumComboSetter = null;
        NumberScalarWheelEditor wheelSetter = null;
        NumberScalarComboEditor comboSetter = null;
        StringScalarEditor stringSetter = null;
        StringScalarComboEditor stringComboSetter = null;
        Object jcomp = null;
        JComponent viewer = null;
        JComponent setter = null;
        JButton propertyButton = null;
        this.listModel = new Vector();
        this.scalarLabels = new Vector();
        this.scalarViewers = new Vector();
        this.scalarSetters = new Vector();
        this.scalarPropButtons = new Vector();
        int viewerRow = 0;
        int nbAtts = scalarList.size();
        int maxRowElementHeight = 0;
        for (int idx = 0; idx < nbAtts; ++idx) {
            Insets marge;
            int hMargin;
            AAttribute att;
            scalarLabel = null;
            ssViewer = null;
            viewer = null;
            boolViewer = null;
            boolComboSetter = null;
            enumViewer = null;
            enumComboSetter = null;
            wheelSetter = null;
            comboSetter = null;
            setter = null;
            stringSetter = null;
            stringComboSetter = null;
            propertyButton = null;
            Object elem = scalarList.getElementAt(idx);
            if (!(elem instanceof AAttribute) || !(att = (AAttribute)elem).isWritable() || !(elem instanceof INumberScalar) && !(elem instanceof IStringScalar) && !(elem instanceof IBooleanScalar) && !(elem instanceof IEnumScalar)) continue;
            INumberScalar ins = null;
            IStringScalar iss = null;
            IBooleanScalar ibs = null;
            IEnumScalar ies = null;
            if (elem instanceof INumberScalar) {
                ssViewer = new SimpleScalarViewer();
                Insets marge2 = ssViewer.getMargin();
                marge2.left += 2;
                marge2.right += 2;
                ssViewer.setMargin(marge2);
                viewer = ssViewer;
                ins = (INumberScalar)elem;
                boolean insHasValueList = false;
                if (ins.getPossibleValues() != null && ins.getPossibleValues().length > 0) {
                    insHasValueList = true;
                }
                if (insHasValueList) {
                    comboSetter = new NumberScalarComboEditor();
                    comboSetter.setFont(this.theFont);
                    comboSetter.setBackground(this.getBackground());
                    comboSetter.setUnitVisible(this.unitVisible);
                    comboSetter.setNumberModel(ins);
                    this.scalarSetters.add(comboSetter);
                    setter = comboSetter;
                } else {
                    wheelSetter = new NumberScalarWheelEditor();
                    wheelSetter.setFont(this.theFont);
                    wheelSetter.setBackground(this.getBackground());
                    wheelSetter.setModel(ins);
                    this.scalarSetters.add(wheelSetter);
                    setter = wheelSetter;
                }
            } else if (elem instanceof IBooleanScalar) {
                ibs = (IBooleanScalar)elem;
                boolViewer = new BooleanScalarCheckBoxViewer();
                boolViewer.setTrueLabel(new String());
                boolViewer.setFalseLabel(new String());
                viewer = boolViewer;
                if (this.booleanSetterType.equalsIgnoreCase(BOOLEAN_COMBO_SETTER)) {
                    boolComboSetter = new BooleanScalarComboEditor();
                    boolComboSetter.setFont(this.theFont);
                    boolComboSetter.setBackground(this.getBackground());
                    boolComboSetter.setAttModel(ibs);
                    setter = boolComboSetter;
                } else {
                    setter = null;
                }
                this.scalarSetters.add(setter);
            } else if (elem instanceof IEnumScalar) {
                ies = (IEnumScalar)elem;
                enumViewer = new SimpleEnumScalarViewer();
                viewer = enumViewer;
                enumComboSetter = new EnumScalarComboEditor();
                enumComboSetter.setFont(this.theFont);
                enumComboSetter.setBackground(this.getBackground());
                enumComboSetter.setEnumModel(ies);
                setter = enumComboSetter;
                this.scalarSetters.add(setter);
            } else {
                ssViewer = new SimpleScalarViewer();
                viewer = ssViewer;
                iss = (IStringScalar)elem;
                boolean issHasValueList = false;
                if (iss.getPossibleValues() != null && iss.getPossibleValues().length > 0) {
                    issHasValueList = true;
                }
                if (issHasValueList) {
                    stringComboSetter = new StringScalarComboEditor();
                    stringComboSetter.setFont(this.theFont);
                    stringComboSetter.setStringModel(iss);
                    this.scalarSetters.add(stringComboSetter);
                    setter = stringComboSetter;
                } else {
                    stringSetter = new StringScalarEditor();
                    stringSetter.setFont(this.theFont);
                    stringSetter.setModel(iss);
                    this.scalarSetters.add(stringSetter);
                    setter = stringSetter;
                }
            }
            scalarLabel = new LabelViewer();
            propertyButton = new JButton();
            scalarLabel.setFont(this.theFont);
            scalarLabel.setHorizontalAlignment(JSmoothLabel.RIGHT_ALIGNMENT);
            scalarLabel.setBackground(this.getBackground());
            if (ins != null) {
                scalarLabel.setModel((IAttribute)ins);
            } else if (iss != null) {
                scalarLabel.setModel((IAttribute)iss);
            } else if (ibs != null) {
                scalarLabel.setModel((IAttribute)ibs);
            } else if (ies != null) {
                scalarLabel.setModel((IAttribute)ies);
            }
            if (ssViewer != null) {
                if (this.toolTipDisplay.equalsIgnoreCase(TOOLTIP_DISPLAY_ALL)) {
                    ssViewer.setHasToolTip(true);
                    ssViewer.setQualityInTooltip(true);
                } else if (this.toolTipDisplay.equalsIgnoreCase(TOOLTIP_DISPLAY_NAME_ONLY)) {
                    ssViewer.setHasToolTip(true);
                    ssViewer.setQualityInTooltip(false);
                } else {
                    ssViewer.setHasToolTip(false);
                    ssViewer.setQualityInTooltip(false);
                }
                ssViewer.setFont(this.theFont);
                ssViewer.setUnitVisible(this.unitVisible);
                ssViewer.setBackgroundColor(this.getBackground());
                ssViewer.setBorder(BorderFactory.createLoweredBevelBorder());
                ssViewer.setAlarmEnabled(true);
                ssViewer.addTextListener(this);
                if (ins != null) {
                    ssViewer.setModel(ins);
                } else {
                    ssViewer.setModel(iss);
                }
            } else if (boolViewer != null) {
                if (this.toolTipDisplay.equalsIgnoreCase(TOOLTIP_DISPLAY_ALL) || this.toolTipDisplay.equalsIgnoreCase(TOOLTIP_DISPLAY_NAME_ONLY)) {
                    boolViewer.setHasToolTip(true);
                } else {
                    boolViewer.setHasToolTip(false);
                }
                boolViewer.setAttModel(ibs);
                boolViewer.setBackground(this.getBackground());
            } else if (enumViewer != null) {
                if (this.toolTipDisplay.equalsIgnoreCase(TOOLTIP_DISPLAY_ALL)) {
                    enumViewer.setHasToolTip(true);
                    enumViewer.setQualityInTooltip(true);
                } else if (this.toolTipDisplay.equalsIgnoreCase(TOOLTIP_DISPLAY_NAME_ONLY)) {
                    enumViewer.setHasToolTip(true);
                    enumViewer.setQualityInTooltip(false);
                } else {
                    enumViewer.setHasToolTip(false);
                    enumViewer.setQualityInTooltip(false);
                }
                enumViewer.setFont(this.theFont);
                enumViewer.setBackgroundColor(this.getBackground());
                enumViewer.setBorder(BorderFactory.createLoweredBevelBorder());
                enumViewer.setAlarmEnabled(true);
                enumViewer.addTextListener(this);
                enumViewer.setModel(ies);
            }
            propertyButton.setFont(this.theFont);
            propertyButton.setBackground(this.getBackground());
            propertyButton.setText(" ... ");
            propertyButton.setMargin(new Insets(-3, 0, 3, 0));
            propertyButton.setToolTipText("Attribute Properties");
            propertyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ScalarListSetter.this.propertyButtonActionPerformed(evt);
                }
            });
            scalarLabel.setVisible(this.labelVisible);
            viewer.setVisible(this.viewerVisible);
            propertyButton.setVisible(this.propertyButtonVisible);
            if (ibs != null && !this.viewerVisible && !this.booleanSetterType.equalsIgnoreCase(BOOLEAN_COMBO_SETTER)) {
                viewer.setVisible(true);
            }
            if (ins != null) {
                ins.refresh();
            } else if (iss != null) {
                iss.refresh();
            } else if (ibs != null) {
                ibs.refresh();
            } else if (ies != null) {
                ies.refresh();
            }
            maxRowElementHeight = 0;
            int currH = scalarLabel.getPreferredSize().height + 4;
            if (currH > maxRowElementHeight) {
                maxRowElementHeight = currH;
            }
            if ((currH = setter.getPreferredSize().height + 4) > maxRowElementHeight) {
                maxRowElementHeight = currH;
            }
            if (viewer != null && viewer.isVisible() && (currH = viewer.getPreferredSize().height + 4) > maxRowElementHeight) {
                maxRowElementHeight = currH;
            }
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = viewerRow;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 6, 2, 1);
            this.add((Component)scalarLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = viewerRow;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 3, 2, 1);
            this.add((Component)viewer, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = viewerRow;
            gridBagConstraints.fill = 1;
            if (setter != null) {
                if (ins != null) {
                    gridBagConstraints.insets = new Insets(1, 3, 1, 1);
                    this.add((Component)setter, gridBagConstraints);
                } else if (iss != null) {
                    gridBagConstraints.insets = new Insets(2, 3, 2, 1);
                    this.add((Component)setter, gridBagConstraints);
                } else if (ibs != null) {
                    gridBagConstraints.insets = new Insets(2, 3, 2, 1);
                    this.add((Component)setter, gridBagConstraints);
                } else if (ies != null) {
                    gridBagConstraints.insets = new Insets(2, 3, 2, 1);
                    this.add((Component)setter, gridBagConstraints);
                }
            }
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = viewerRow;
            gridBagConstraints.insets = new Insets(2, 3, 2, 6);
            this.add((Component)propertyButton, gridBagConstraints);
            if (ins != null) {
                this.listModel.add((IAttribute)ins);
            } else if (iss != null) {
                this.listModel.add((IAttribute)iss);
            } else if (ibs != null) {
                this.listModel.add((IAttribute)ibs);
            } else if (ies != null) {
                this.listModel.add((IAttribute)ies);
            }
            this.scalarLabels.add(scalarLabel);
            this.scalarViewers.add(viewer);
            this.scalarPropButtons.add(propertyButton);
            if (setter instanceof StringScalarEditor) {
                StringScalarEditor sse = (StringScalarEditor)setter;
                currH = setter.getPreferredSize().height;
                hMargin = currH < maxRowElementHeight ? (maxRowElementHeight - currH) / 2 : 0;
                marge = sse.getMargin();
                marge.top += hMargin;
                marge.bottom += hMargin;
                marge.left += 2;
                marge.right += 2;
                sse.setMargin(marge);
            }
            if (viewer.isVisible()) {
                if (viewer instanceof SimpleScalarViewer) {
                    SimpleScalarViewer sv = (SimpleScalarViewer)viewer;
                    currH = viewer.getPreferredSize().height;
                    hMargin = currH < maxRowElementHeight ? (maxRowElementHeight - currH) / 2 : 0;
                    marge = sv.getMargin();
                    marge.top += hMargin;
                    marge.bottom += hMargin;
                    marge.left += 2;
                    marge.right += 2;
                    sv.setMargin(marge);
                } else if (viewer instanceof SimpleEnumScalarViewer) {
                    SimpleEnumScalarViewer sesv = (SimpleEnumScalarViewer)viewer;
                    currH = viewer.getPreferredSize().height;
                    hMargin = currH < maxRowElementHeight ? (maxRowElementHeight - currH) / 2 : 0;
                    marge = sesv.getMargin();
                    marge.top += hMargin;
                    marge.bottom += hMargin;
                    marge.left += 2;
                    marge.right += 2;
                    sesv.setMargin(marge);
                }
            }
            ++viewerRow;
        }
    }

    private void propertyButtonActionPerformed(ActionEvent evt) {
        int buttonIndex = -1;
        if (this.scalarPropButtons == null) {
            return;
        }
        if (this.listModel == null) {
            return;
        }
        int nbButtons = this.scalarPropButtons.size();
        for (int ind = 0; ind < nbButtons; ++ind) {
            try {
                JButton propertyButton = this.scalarPropButtons.get(ind);
                if (!propertyButton.equals(evt.getSource())) continue;
                buttonIndex = ind;
                break;
            }
            catch (Exception e) {
                System.out.println("ScalarListSetter : propertyButtonActionPerformed : Caught exception  " + e.getMessage());
                return;
            }
        }
        if (buttonIndex < 0) {
            return;
        }
        INumberScalar ins = null;
        IStringScalar iss = null;
        IBooleanScalar ibs = null;
        IEnumScalar ies = null;
        try {
            IAttribute iatt = this.listModel.get(buttonIndex);
            if (iatt instanceof INumberScalar) {
                ins = (INumberScalar)iatt;
            } else if (iatt instanceof IStringScalar) {
                iss = (IStringScalar)iatt;
            } else if (iatt instanceof IBooleanScalar) {
                ibs = (IBooleanScalar)iatt;
            } else if (iatt instanceof IEnumScalar) {
                ies = (IEnumScalar)iatt;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ins == null && iss == null && ibs == null && ies == null) {
            return;
        }
        if (this.propFrame != null) {
            if (ins != null) {
                this.propFrame.setModel((IAttribute)ins);
            } else if (iss != null) {
                this.propFrame.setModel((IAttribute)iss);
            } else if (ibs != null) {
                this.propFrame.setModel((IAttribute)ibs);
            } else if (ies != null) {
                this.propFrame.setModel((IAttribute)ies);
            }
            this.propFrame.setVisible(true);
        }
    }

    public static void main(String[] args) {
        final AttributeList attList = new AttributeList();
        ScalarListSetter scalarls = new ScalarListSetter();
        scalarls.setTheFont(new Font("Lucida Bright", 0, 18));
        scalarls.setViewerVisible(false);
        scalarls.setBooleanSetterType(BOOLEAN_COMBO_SETTER);
        try {
            INumberScalar attn = (INumberScalar)attList.add("jlp/test/1/att_un");
            attn = (INumberScalar)attList.add("jlp/test/1/att_deux");
            attn = (INumberScalar)attList.add("jlp/test/1/att_trois");
            attn = (INumberScalar)attList.add("jlp/test/1/att_quatre");
            IStringScalar attstr = (IStringScalar)attList.add("jlp/test/1/att_cinq");
            IBooleanScalar attbool = (IBooleanScalar)attList.add("jlp/test/1/Att_boolean");
            IAttribute iatt = (IAttribute)attList.add("jlp/test/1/att_six");
            scalarls.setModel(attList);
        }
        catch (Exception ex) {
            System.out.println("caught exception : " + ex.getMessage());
            ex.printStackTrace();
            System.exit(-1);
        }
        JFrame mainFrame = new JFrame();
        mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent evt) {
                attList.startRefresher();
            }
        });
        mainFrame.setContentPane(scalarls);
        mainFrame.pack();
        mainFrame.setVisible(true);
    }
}

