/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.BooleanScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IBooleanScalarListener;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.ISetErrorListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.widget.attribute.SimpleScalarViewer;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class SignalScalarButtonSetter
extends JButton
implements ActionListener,
IBooleanScalarListener,
INumberScalarListener,
ISetErrorListener {
    protected IAttribute attModel = null;
    protected String trueLabel = "True";
    protected String falseLabel = "False";
    protected boolean setValue;
    protected String tooltipText = null;
    protected boolean enabled = true;
    protected boolean inError = false;

    public SignalScalarButtonSetter(boolean setValue) {
        super(setValue ? "True" : "False");
        this.setValue = setValue;
        this.attModel = null;
        this.addActionListener(this);
        super.setEnabled(false);
    }

    public IAttribute getAttModel() {
        return this.attModel;
    }

    public void setBooleanScalarModel(IBooleanScalar boolModel) {
        if (this.attModel != null) {
            this.clearModel();
        }
        if (boolModel == null) {
            return;
        }
        if (!boolModel.isWritable()) {
            throw new IllegalArgumentException("SignalScalarButtonSetter: Only accept writeable attribute.");
        }
        this.inError = false;
        this.attModel = boolModel;
        this.manageToolTip();
        this.manageDisponibility();
        this.attModel.addSetErrorListener((ISetErrorListener)this);
        this.attModel.refresh();
        this.repaint();
    }

    public void setNumberScalarModel(INumberScalar boolModel) {
        if (this.attModel != null) {
            this.clearModel();
        }
        if (boolModel == null) {
            return;
        }
        if (!boolModel.isWritable()) {
            throw new IllegalArgumentException("SignalScalarButtonSetter: Only accept writeable attribute.");
        }
        this.inError = false;
        this.attModel = boolModel;
        this.manageToolTip();
        this.manageDisponibility();
        ((INumberScalar)this.attModel).addNumberScalarListener((INumberScalarListener)this);
        this.attModel.addSetErrorListener((ISetErrorListener)this);
        this.attModel.refresh();
        this.repaint();
    }

    public void clearModel() {
        if (this.attModel != null) {
            if (this.attModel instanceof IBooleanScalar) {
                ((IBooleanScalar)this.attModel).removeBooleanScalarListener((IBooleanScalarListener)this);
            } else if (this.attModel instanceof INumberScalar) {
                ((INumberScalar)this.attModel).removeNumberScalarListener((INumberScalarListener)this);
            }
            this.attModel.removeSetErrorListener((ISetErrorListener)this);
            this.attModel = null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.attModel instanceof IBooleanScalar) {
            ((IBooleanScalar)this.attModel).setValue(this.setValue);
        } else if (this.attModel instanceof INumberScalar) {
            ((INumberScalar)this.attModel).setValue(this.setValue ? 1.0 : 0.0);
        }
    }

    public void booleanScalarChange(BooleanScalarEvent e) {
        this.inError = false;
        this.manageToolTip();
        this.manageDisponibility();
    }

    public void numberScalarChange(NumberScalarEvent arg0) {
        this.inError = false;
        this.manageToolTip();
        this.manageDisponibility();
    }

    public void stateChange(AttributeStateEvent e) {
    }

    public void errorChange(ErrorEvent evt) {
        this.inError = true;
        this.manageToolTip();
        this.manageDisponibility();
    }

    public void setErrorOccured(ErrorEvent evt) {
        this.errorChange(evt);
    }

    public String getFalseLabel() {
        return this.falseLabel;
    }

    public void setFalseLabel(String falseLabel) {
        this.falseLabel = falseLabel;
        this.manageText();
        this.manageToolTip();
        this.repaint();
    }

    public String getTrueLabel() {
        return this.trueLabel;
    }

    public void setTrueLabel(String trueLabel) {
        this.trueLabel = trueLabel;
        this.manageText();
        this.manageToolTip();
        this.repaint();
    }

    protected void manageToolTip() {
        if (this.inError) {
            if (this.attModel == null) {
                super.setToolTipText("Error");
            } else {
                super.setToolTipText(this.attModel.getName() + " is in Error");
            }
        } else if (this.tooltipText == null) {
            if (this.attModel == null) {
                super.setToolTipText(this.setValue ? this.trueLabel : this.falseLabel);
            } else {
                super.setToolTipText(this.attModel.getName());
            }
        } else {
            super.setToolTipText(this.tooltipText);
        }
    }

    protected void manageText() {
        if (this.setValue) {
            this.setText(this.trueLabel);
        } else {
            this.setText(this.falseLabel);
        }
    }

    protected void manageDisponibility() {
        if (this.inError) {
            super.setEnabled(false);
        } else {
            super.setEnabled(this.enabled);
        }
    }

    @Override
    public void setEnabled(boolean b) {
        this.enabled = b;
        this.manageDisponibility();
    }

    @Override
    public void setToolTipText(String text) {
        this.tooltipText = text;
        this.manageToolTip();
    }

    public static void main(String[] args) {
        AttributeList attl = new AttributeList();
        JFrame f = new JFrame();
        SignalScalarButtonSetter ssbsTrue = new SignalScalarButtonSetter(true);
        SignalScalarButtonSetter ssbsFalse = new SignalScalarButtonSetter(false);
        String attributeName = "tango/tangotest/1/boolean_scalar";
        try {
            if (args.length > 0) {
                attributeName = args[0];
            }
            SimpleScalarViewer label = new SimpleScalarViewer();
            label.setText(attributeName);
            label.setHasToolTip(true);
            JPanel mainPanel = new JPanel();
            mainPanel.setLayout(new GridLayout(1, 3));
            IEntity ie = attl.add(attributeName);
            if (!(ie instanceof IBooleanScalar) && !(ie instanceof INumberScalar)) {
                System.out.println(attributeName + " is not a valid attribute");
                System.exit(0);
            }
            if (ie instanceof IBooleanScalar) {
                label.setModel((IBooleanScalar)ie);
                ssbsTrue.setBooleanScalarModel((IBooleanScalar)ie);
                ssbsFalse.setBooleanScalarModel((IBooleanScalar)ie);
            } else {
                label.setModel((INumberScalar)ie);
                ssbsTrue.setNumberScalarModel((INumberScalar)ie);
                ssbsFalse.setNumberScalarModel((INumberScalar)ie);
            }
            mainPanel.add(label);
            mainPanel.add(ssbsTrue);
            mainPanel.add(ssbsFalse);
            f.setContentPane(mainPanel);
        }
        catch (Exception ex) {
            System.out.println("Cannot connect to " + attributeName);
        }
        attl.startRefresher();
        f.setDefaultCloseOperation(3);
        f.pack();
        f.setVisible(true);
    }
}

