/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.BooleanScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IBooleanScalarListener;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.ISetErrorListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;

public class SignalScalarComboEditor
extends JComboBox
implements ActionListener,
IBooleanScalarListener,
INumberScalarListener,
ISetErrorListener {
    protected IAttribute attModel = null;
    protected String trueLabel = "True";
    protected String falseLabel = "False";
    protected DefaultComboBoxModel comboModel = null;
    protected String defActionCmd = "setAttActionCmd";
    protected String[] optionList = new String[]{this.trueLabel, this.falseLabel};
    protected static final int trueIndex = 0;
    protected static final int falseIndex = 1;

    public SignalScalarComboEditor() {
        this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
        this.setModel(this.comboModel);
        this.setActionCommand(this.defActionCmd);
        this.addActionListener(this);
    }

    public IAttribute getAttModel() {
        return this.attModel;
    }

    public void setBooleanScalarModel(IBooleanScalar boolModel) {
        if (this.attModel != null) {
            this.clearModel();
        }
        if (boolModel == null) {
            return;
        }
        if (!boolModel.isWritable()) {
            throw new IllegalArgumentException("SignalScalarComboEditor: Only accept writeable attribute.");
        }
        this.optionList = new String[]{this.trueLabel, this.falseLabel};
        this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
        this.setModel(this.comboModel);
        this.attModel = boolModel;
        ((IBooleanScalar)this.attModel).addBooleanScalarListener((IBooleanScalarListener)this);
        this.attModel.addSetErrorListener((ISetErrorListener)this);
        this.attModel.refresh();
        this.repaint();
    }

    public void setNumberScalarModel(INumberScalar boolModel) {
        if (this.attModel != null) {
            this.clearModel();
        }
        if (boolModel == null) {
            return;
        }
        if (!boolModel.isWritable()) {
            throw new IllegalArgumentException("SignalScalarComboEditor: Only accept writeable attribute.");
        }
        this.optionList = new String[]{this.trueLabel, this.falseLabel};
        this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
        this.setModel(this.comboModel);
        this.attModel = boolModel;
        ((INumberScalar)this.attModel).addNumberScalarListener((INumberScalarListener)this);
        this.attModel.addSetErrorListener((ISetErrorListener)this);
        this.attModel.refresh();
        this.repaint();
    }

    public void clearModel() {
        if (this.attModel != null) {
            if (this.attModel instanceof IBooleanScalar) {
                ((IBooleanScalar)this.attModel).removeBooleanScalarListener((IBooleanScalarListener)this);
            } else if (this.attModel instanceof INumberScalar) {
                ((INumberScalar)this.attModel).removeNumberScalarListener((INumberScalarListener)this);
            }
            this.attModel.removeSetErrorListener((ISetErrorListener)this);
            this.attModel = null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean selectedOption;
        JComboBox cb = null;
        if (!e.getActionCommand().equals(this.defActionCmd)) {
            return;
        }
        if (this.attModel == null) {
            return;
        }
        cb = (JComboBox)e.getSource();
        if (cb.getSelectedIndex() < 0) {
            return;
        }
        boolean bl = selectedOption = cb.getSelectedIndex() == 0;
        if (this.attModel instanceof IBooleanScalar) {
            if (selectedOption) {
                ((IBooleanScalar)this.attModel).setValue(true);
            } else {
                ((IBooleanScalar)this.attModel).setValue(false);
            }
        } else if (this.attModel instanceof INumberScalar) {
            if (selectedOption) {
                ((INumberScalar)this.attModel).setValue(1.0);
            } else {
                ((INumberScalar)this.attModel).setValue(0.0);
            }
        }
    }

    public void booleanScalarChange(BooleanScalarEvent e) {
        boolean setpoint = this.hasFocus() ? ((IBooleanScalar)this.attModel).getDeviceSetPoint() : ((IBooleanScalar)this.attModel).getSetPoint();
        this.changeCurrentSelection(setpoint);
    }

    public void stateChange(AttributeStateEvent e) {
    }

    public void errorChange(ErrorEvent evt) {
        this.disableExecution();
        this.setSelectedIndex(-1);
        this.repaint();
        this.enableExecution();
    }

    public void setErrorOccured(ErrorEvent evt) {
        if (this.attModel == null) {
            return;
        }
        if (evt.getSource() != this.attModel) {
            return;
        }
        if (this.attModel instanceof IBooleanScalar) {
            this.changeCurrentSelection(((IBooleanScalar)this.attModel).getDeviceSetPoint());
        } else if (this.attModel instanceof INumberScalar) {
            this.changeCurrentSelection(((INumberScalar)this.attModel).getNumberScalarDeviceSetPoint() != 0.0);
        }
    }

    protected void changeCurrentSelection(boolean newValue) {
        this.disableExecution();
        if (newValue) {
            this.setSelectedIndex(0);
        } else {
            this.setSelectedIndex(1);
        }
        this.repaint();
        this.enableExecution();
    }

    public void enableExecution() {
        this.setActionCommand(this.defActionCmd);
    }

    public void disableExecution() {
        this.setActionCommand("dummy");
    }

    public static void main(String[] args) {
        AttributeList attl = new AttributeList();
        JFrame f = new JFrame();
        SignalScalarComboEditor bsce = new SignalScalarComboEditor();
        String attributeName = "tango/tangotest/1/boolean_scalar";
        try {
            IEntity ie;
            if (args.length > 0) {
                attributeName = args[0];
            }
            if (!((ie = attl.add(attributeName)) instanceof IBooleanScalar) && !(ie instanceof INumberScalar)) {
                System.out.println(attributeName + " is not a valid attribute");
                System.exit(0);
            }
            if (ie instanceof IBooleanScalar) {
                bsce.setBooleanScalarModel((IBooleanScalar)ie);
            } else {
                bsce.setNumberScalarModel((INumberScalar)ie);
            }
        }
        catch (Exception ex) {
            System.out.println("Cannot connect to " + attributeName);
        }
        attl.startRefresher();
        f.setContentPane(bsce);
        f.setDefaultCloseOperation(3);
        f.pack();
        f.setVisible(true);
    }

    public String getFalseLabel() {
        return this.falseLabel;
    }

    public void setFalseLabel(String falseLabel) {
        this.falseLabel = falseLabel;
    }

    public String getTrueLabel() {
        return this.trueLabel;
    }

    public void setTrueLabel(String trueLabel) {
        this.trueLabel = trueLabel;
    }

    public void numberScalarChange(NumberScalarEvent arg0) {
        boolean setpoint = this.hasFocus() ? ((INumberScalar)this.attModel).getNumberScalarDeviceSetPoint() != 0.0 : ((INumberScalar)this.attModel).getNumberScalarSetPoint() != 0.0;
        this.changeCurrentSelection(setpoint);
    }
}

