/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.BooleanScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IBooleanScalarListener;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;

public class SignalScalarLightViewer
extends JButton
implements INumberScalarListener,
IBooleanScalarListener {
    public static final ImageIcon bulbOff = new ImageIcon(SignalScalarLightViewer.class.getResource("/fr/esrf/tangoatk/widget/icons/bulbDisabled.gif"));
    public static final ImageIcon bulbOn = new ImageIcon(SignalScalarLightViewer.class.getResource("/fr/esrf/tangoatk/widget/icons/bulbEnabled.gif"));
    public static final ImageIcon bulbKO = new ImageIcon(SignalScalarLightViewer.class.getResource("/fr/esrf/tangoatk/widget/icons/bulbKO.gif"));
    public static final ImageIcon blueLED = new ImageIcon(SignalScalarLightViewer.class.getResource("/fr/esrf/tangoatk/widget/icons/ledBlue.gif"));
    public static final ImageIcon brownGrayLED = new ImageIcon(SignalScalarLightViewer.class.getResource("/fr/esrf/tangoatk/widget/icons/ledBrownGray.gif"));
    public static final ImageIcon darkGrayLED = new ImageIcon(SignalScalarLightViewer.class.getResource("/fr/esrf/tangoatk/widget/icons/ledDarkGray.gif"));
    public static final ImageIcon darkOrangeLED = new ImageIcon(SignalScalarLightViewer.class.getResource("/fr/esrf/tangoatk/widget/icons/ledDarkOrange.gif"));
    public static final ImageIcon grayLED = new ImageIcon(SignalScalarLightViewer.class.getResource("/fr/esrf/tangoatk/widget/icons/ledGray.gif"));
    public static final ImageIcon greenLED = new ImageIcon(SignalScalarLightViewer.class.getResource("/fr/esrf/tangoatk/widget/icons/ledGreen.gif"));
    public static final ImageIcon darkGreenLED = new ImageIcon(SignalScalarLightViewer.class.getResource("/fr/esrf/tangoatk/widget/icons/ledDarkGreen.gif"));
    public static final ImageIcon lightOrangeLED = new ImageIcon(SignalScalarLightViewer.class.getResource("/fr/esrf/tangoatk/widget/icons/ledLightOrange.gif"));
    public static final ImageIcon pinkLED = new ImageIcon(SignalScalarLightViewer.class.getResource("/fr/esrf/tangoatk/widget/icons/ledPink.gif"));
    public static final ImageIcon redLED = new ImageIcon(SignalScalarLightViewer.class.getResource("/fr/esrf/tangoatk/widget/icons/ledRed.gif"));
    public static final ImageIcon whiteLED = new ImageIcon(SignalScalarLightViewer.class.getResource("/fr/esrf/tangoatk/widget/icons/ledWhite.gif"));
    public static final ImageIcon yellowLED = new ImageIcon(SignalScalarLightViewer.class.getResource("/fr/esrf/tangoatk/widget/icons/ledYellow.gif"));
    public static final ImageIcon KOLED = new ImageIcon(SignalScalarLightViewer.class.getResource("/fr/esrf/tangoatk/widget/icons/ledKO.gif"));
    private ImageIcon m_iconLightOn;
    private ImageIcon m_iconLightOff;
    private ImageIcon m_iconLightKO;
    private IAttribute attributeModel = null;
    private String falseLabel = "FALSE";
    private String trueLabel = "TRUE";
    private String errorLabel = "ERROR";
    private Boolean formerValue = null;
    public static final int booleanLabel = 0;
    public static final int label = 1;
    public static final int name = 2;
    public static final int completeName = 3;
    public static final int customLabel = 4;
    public static final int labelAndBoolean = 5;
    public static final int nameAndBoolean = 6;
    private int chosenLabel = 0;
    private boolean viewLabel;

    public SignalScalarLightViewer() {
        this(false);
    }

    public SignalScalarLightViewer(boolean viewLabel) {
        this.viewLabel = viewLabel;
        this.setIconLightOn(redLED);
        this.setIconLightOff(grayLED);
        this.setIconLightKO(KOLED);
        this.setIcon(this.m_iconLightKO);
        this.repaint();
    }

    public void numberScalarChange(NumberScalarEvent arg0) {
        Boolean boolValue = null;
        try {
            if (arg0.getValue() == 1.0) {
                this.setIcon(this.m_iconLightOn);
                boolValue = new Boolean(true);
            } else {
                this.setIcon(this.m_iconLightOff);
                boolValue = new Boolean(false);
            }
        }
        catch (Exception e) {
            this.setIcon(this.m_iconLightKO);
        }
        this.manageLabel(boolValue);
        this.repaint();
    }

    public void setViewLabel(boolean b) {
        this.viewLabel = b;
        this.manageLabel(this.formerValue);
    }

    public boolean isViewLabel() {
        return this.viewLabel;
    }

    public void stateChange(AttributeStateEvent arg0) {
    }

    public void errorChange(ErrorEvent arg0) {
        this.setIcon(this.m_iconLightKO);
        this.manageLabel(null);
        this.repaint();
    }

    public IAttribute getAttributeModel() {
        return this.attributeModel;
    }

    public void setAttributeModel(IAttribute numberModel) {
        if (!(numberModel instanceof INumberScalar) && !(numberModel instanceof IBooleanScalar)) {
            return;
        }
        this.clearAttributeModel();
        this.attributeModel = numberModel;
        if (this.attributeModel instanceof INumberScalar) {
            ((INumberScalar)numberModel).addNumberScalarListener((INumberScalarListener)this);
            if (this.viewLabel) {
                this.setText(this.attributeModel.getLabel());
            }
        }
        if (this.attributeModel instanceof IBooleanScalar) {
            ((IBooleanScalar)numberModel).addBooleanScalarListener((IBooleanScalarListener)this);
            if (this.viewLabel) {
                this.setText(this.attributeModel.getLabel());
            }
        }
    }

    public void clearAttributeModel() {
        if (this.attributeModel != null) {
            if (this.attributeModel instanceof INumberScalar) {
                ((INumberScalar)this.attributeModel).removeNumberScalarListener((INumberScalarListener)this);
            }
            if (this.attributeModel instanceof IBooleanScalar) {
                ((IBooleanScalar)this.attributeModel).removeBooleanScalarListener((IBooleanScalarListener)this);
            }
            this.attributeModel = null;
        }
    }

    public int getChosenLabel() {
        return this.chosenLabel;
    }

    public void setChosenLabel(int chosenLabel) {
        this.chosenLabel = chosenLabel;
    }

    public String getFalseLabel() {
        return this.falseLabel;
    }

    public void setFalseLabel(String falseLabel) {
        this.falseLabel = falseLabel;
    }

    public String getTrueLabel() {
        return this.trueLabel;
    }

    public void setTrueLabel(String trueLabel) {
        this.trueLabel = trueLabel;
    }

    private void manageLabel(Boolean booleanValue) {
        this.formerValue = booleanValue;
        if (this.viewLabel) {
            if (this.attributeModel == null) {
                this.setText("Unknown Attribute");
                return;
            }
            switch (this.chosenLabel) {
                case 1: {
                    this.setText(this.attributeModel.getLabel());
                    break;
                }
                case 2: {
                    this.setText(this.attributeModel.getNameSansDevice());
                    break;
                }
                case 0: {
                    if (booleanValue == null) {
                        this.setText(this.errorLabel);
                        break;
                    }
                    if (booleanValue.booleanValue()) {
                        this.setText(this.trueLabel);
                        break;
                    }
                    this.setText(this.falseLabel);
                    break;
                }
                case 5: {
                    if (booleanValue == null) {
                        this.setText(this.attributeModel.getLabel() + ":" + this.errorLabel);
                        break;
                    }
                    if (booleanValue.booleanValue()) {
                        this.setText(this.attributeModel.getLabel() + ":" + this.trueLabel);
                        break;
                    }
                    this.setText(this.attributeModel.getLabel() + ":" + this.falseLabel);
                    break;
                }
                case 6: {
                    if (booleanValue == null) {
                        this.setText(this.attributeModel.getNameSansDevice() + ":" + this.errorLabel);
                        break;
                    }
                    if (booleanValue.booleanValue()) {
                        this.setText(this.attributeModel.getNameSansDevice() + ":" + this.trueLabel);
                        break;
                    }
                    this.setText(this.attributeModel.getNameSansDevice() + ":" + this.falseLabel);
                    break;
                }
                case 3: {
                    this.setText(this.attributeModel.getName());
                    break;
                }
            }
        }
    }

    public void setIconLightOn(ImageIcon icon) {
        this.m_iconLightOn = icon;
    }

    public void setIconLightOff(ImageIcon icon) {
        this.m_iconLightOff = icon;
    }

    public void setIconLightKO(ImageIcon icon) {
        this.m_iconLightKO = icon;
    }

    public void booleanScalarChange(BooleanScalarEvent arg0) {
        try {
            if (arg0.getValue()) {
                this.setIcon(this.m_iconLightOn);
            } else {
                this.setIcon(this.m_iconLightOff);
            }
        }
        catch (Exception e) {
            this.setIcon(this.m_iconLightKO);
        }
        this.manageLabel(new Boolean(arg0.getValue()));
        this.repaint();
    }

    public static void main(String[] args) {
        AttributeList attributeList = new AttributeList();
        SignalScalarLightViewer sslv = new SignalScalarLightViewer(true);
        try {
            if (args.length != 0) {
                sslv.setAttributeModel((IAttribute)attributeList.add(args[0]));
            } else {
                sslv.setAttributeModel((IAttribute)attributeList.add("test/testSignal2/1/signal"));
            }
            attributeList.setRefreshInterval(1000);
            attributeList.startRefresher();
            JFrame f = new JFrame(sslv.getAttributeModel().getName().substring(0, sslv.getAttributeModel().getName().lastIndexOf("/")));
            f.setDefaultCloseOperation(3);
            f.getContentPane().add(sslv);
            f.setSize(300, 50);
            f.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

