/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.EnumScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IEnumScalar;
import fr.esrf.tangoatk.core.IEnumScalarListener;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.JAutoScrolledText;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawable;
import java.awt.Color;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class SimpleEnumScalarViewer
extends JAutoScrolledText
implements IEnumScalarListener,
IErrorListener,
JDrawable {
    private IEnumScalar model = null;
    private String invalidText = "-----";
    private Color backgroundColor = ATKConstant.getColor4Quality("VALID");
    private boolean alarmEnabled = true;
    private boolean hasToolTip = false;
    private boolean qualityInTooltip = false;
    static String[] exts = new String[]{"alarmEnabled", "validBackground"};

    public SimpleEnumScalarViewer() {
        this.setOpaque(true);
    }

    public void setInvalidText(String s) {
        this.invalidText = s;
    }

    public String getInvalidText() {
        return this.invalidText;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color bg) {
        this.backgroundColor = bg;
    }

    public void setAlarmEnabled(boolean b) {
        this.alarmEnabled = b;
    }

    public boolean isAlarmEnabled() {
        return this.alarmEnabled;
    }

    public IEnumScalar getModel() {
        return this.model;
    }

    public void setModel(IEnumScalar enumeration) {
        this.clearModel();
        if (enumeration != null) {
            this.model = enumeration;
            this.model.addEnumScalarListener((IEnumScalarListener)this);
            if (this.hasToolTip) {
                this.setToolTipText(this.model.getName());
            }
            this.model.refresh();
        }
    }

    public void clearModel() {
        if (this.hasToolTip) {
            this.setToolTipText(null);
        }
        if (this.model != null) {
            this.model.removeEnumScalarListener((IEnumScalarListener)this);
            this.model = null;
        }
    }

    public void enumScalarChange(EnumScalarEvent evt) {
        String val = evt.getValue();
        if (val == null) {
            this.setText(this.invalidText);
            return;
        }
        String oldVal = this.getText();
        if (!val.equals(oldVal)) {
            this.setText(val);
        }
    }

    public void stateChange(AttributeStateEvent evt) {
        String state = evt.getState();
        if (this.hasToolTip && this.qualityInTooltip) {
            IAttribute attSource = (IAttribute)evt.getSource();
            this.setToolTipText(attSource.getName() + " : " + state);
        }
        if (state.equals("INVALID")) {
            this.setText(this.invalidText);
        }
        if (!this.alarmEnabled) {
            return;
        }
        if (state.equals("VALID")) {
            this.setBackground(this.backgroundColor);
            return;
        }
        this.setBackground(ATKConstant.getColor4Quality(state));
    }

    public void errorChange(ErrorEvent evt) {
        this.setText(this.invalidText);
        if (!this.alarmEnabled) {
            return;
        }
        this.setBackground(ATKConstant.getColor4Quality("UNKNOWN"));
    }

    public boolean getHasToolTip() {
        return this.hasToolTip;
    }

    public void setHasToolTip(boolean b) {
        if (this.hasToolTip == b) {
            return;
        }
        this.hasToolTip = b;
        this.setToolTipText(null);
        if (this.hasToolTip && this.model != null) {
            this.setToolTipText(this.model.getName());
        }
    }

    public boolean getQualityInTooltip() {
        return this.qualityInTooltip;
    }

    public void setQualityInTooltip(boolean b) {
        if (this.qualityInTooltip == b) {
            return;
        }
        this.qualityInTooltip = b;
        if (!this.hasToolTip) {
            return;
        }
        if (!this.qualityInTooltip && this.model != null) {
            this.setToolTipText(this.model.getName());
        }
    }

    @Override
    public void initForEditing() {
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String getDescription(String name) {
        if (name.equalsIgnoreCase("alarmEnabled")) {
            return "When enabled, the background color change with the\nTango attribute quality factor.\nDefault colors are: ( unless they have been changed with\nATKConstant.setColor4Quality() )\n VALID   => Green\n INVALID => Grey\n ALARM   => Orange\n WARNING => Orange\n CHANGING => Blue\n UNKNOWN => Grey\nPossible values are: true, false.";
        }
        if (name.equalsIgnoreCase("validBackground")) {
            return "Sets the background color (r,g,b) for the VALID quality factor for this viewer.\nHas effect only if alarmEnabled is true.";
        }
        return "";
    }

    @Override
    public String[] getExtensionList() {
        return exts;
    }

    @Override
    public boolean setExtendedParam(String name, String value, boolean popupErr) {
        if (name.equalsIgnoreCase("alarmEnabled")) {
            if (value.equalsIgnoreCase("true")) {
                this.setAlarmEnabled(true);
                return true;
            }
            if (value.equalsIgnoreCase("false")) {
                this.setAlarmEnabled(false);
                return true;
            }
            this.showJdrawError(popupErr, "alarmEnabled", "Wrong syntax: 'true' or 'false' expected.");
            return false;
        }
        if (name.equalsIgnoreCase("validBackground")) {
            String[] c = value.split(",");
            if (c.length != 3) {
                this.showJdrawError(popupErr, "validBackground", "Integer list expected: r,g,b");
                return false;
            }
            try {
                int r = Integer.parseInt(c[0]);
                int g = Integer.parseInt(c[1]);
                int b = Integer.parseInt(c[2]);
                if (r < 0 || r > 255 || g < 0 || g > 255 || b < 0 || b > 255) {
                    this.showJdrawError(popupErr, "validBackground", "Parameter out of bounds. [0..255]");
                    return false;
                }
                this.setBackgroundColor(new Color(r, g, b));
                return true;
            }
            catch (NumberFormatException e) {
                this.showJdrawError(popupErr, "validBackground", "Wrong integer syntax.");
                return false;
            }
        }
        return false;
    }

    @Override
    public String getExtendedParam(String name) {
        if (name.equals("alarmEnabled")) {
            return this.isAlarmEnabled() ? "true" : "false";
        }
        if (name.equalsIgnoreCase("validBackground")) {
            Color c = this.backgroundColor;
            return c.getRed() + "," + c.getGreen() + "," + c.getBlue();
        }
        return "";
    }

    private void showJdrawError(boolean popup, String paramName, String message) {
        if (popup) {
            JOptionPane.showMessageDialog(null, "SimpleScalarViewer: " + paramName + " incorrect.\n" + message, "Error", 0);
        }
    }

    public static void main(String[] args) throws Exception {
        AttributeList attributeList = new AttributeList();
        SimpleEnumScalarViewer sesv = new SimpleEnumScalarViewer();
        IEnumScalar enumeration = (IEnumScalar)attributeList.add("//acudebian7:10000/dev/test/10/DynEnum_attr");
        sesv.setHasToolTip(true);
        sesv.setModel(enumeration);
        sesv.setBorder(BorderFactory.createLoweredBevelBorder());
        sesv.setBackgroundColor(Color.WHITE);
        sesv.setForeground(Color.BLACK);
        sesv.setFont(new Font("Dialog", 1, 30));
        sesv.setAutoScroll(30);
        JFrame f = new JFrame();
        f.setContentPane(sesv);
        f.pack();
        f.setVisible(true);
        attributeList.startRefresher();
    }
}

