/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.DispLevel;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.core.Property;
import fr.esrf.tangoatk.core.attribute.ANumber;
import fr.esrf.tangoatk.widget.attribute.BooleanScalarCheckBoxViewer;
import fr.esrf.tangoatk.widget.attribute.BooleanScalarComboEditor;
import fr.esrf.tangoatk.widget.attribute.NumberScalarWheelEditor;
import fr.esrf.tangoatk.widget.attribute.SimpleScalarViewer;
import fr.esrf.tangoatk.widget.attribute.StringScalarEditor;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.JAutoScrolledText;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class SimplePropertyFrame
extends JDialog {
    private JPanel identPanel;
    private JLabel deviceLabel;
    private JTextField deviceText;
    private JLabel attLabel;
    private JTextField attText;
    private SimpleScalarViewer numberAndStringValue = null;
    private BooleanScalarCheckBoxViewer booleanValue = null;
    private NumberScalarWheelEditor numberSetter = null;
    private StringScalarEditor stringSetter = null;
    private BooleanScalarComboEditor booleanSetter = null;
    private JPanel propPanel;
    private JLabel nameLabel;
    private JTextField nameText;
    private JLabel minLabel;
    private JTextField minText;
    private JLabel maxLabel;
    private JTextField maxText;
    private JLabel alminLabel;
    private JTextField alminText;
    private JLabel almaxLabel;
    private JTextField almaxText;
    private JLabel minWarningLabel;
    private JTextField minWarningText;
    private JLabel maxWarningLabel;
    private JTextField maxWarningText;
    private JLabel deltaTLabel;
    private JTextField deltaTText;
    private JLabel deltaValLabel;
    private JTextField deltaValText;
    private JLabel formatLabel;
    private JTextField formatText;
    private JLabel unitLabel;
    private JTextField unitText;
    private JScrollPane textView;
    private JTextArea descText;
    private JButton okButton;
    private JButton applyButton;
    private JButton infoButton;
    private boolean editable = true;
    private IAttribute model;
    Dimension appsize = new Dimension(460, 490);

    public SimplePropertyFrame() {
        super((Frame)null, false);
        this.initComponents();
    }

    public SimplePropertyFrame(JDialog parent, boolean modal) {
        super((Dialog)parent, modal);
        this.initComponents();
    }

    public SimplePropertyFrame(JFrame parent, boolean modal) {
        super((Frame)parent, modal);
        this.initComponents();
    }

    @Override
    public void pack() {
    }

    private void initComponents() {
        Container pane = this.getContentPane();
        pane.setLayout(null);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent evt) {
                SimplePropertyFrame.this.setModel(null);
                SimplePropertyFrame.this.dispose();
            }
        });
        Font labelFont = new Font("Dialog", 0, 11);
        Insets noMargin = new Insets(0, 0, 0, 0);
        this.identPanel = new JPanel();
        this.identPanel.setLayout(null);
        this.identPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Identification", 1, 2, labelFont));
        this.deviceLabel = new JLabel("Device");
        this.identPanel.add(this.deviceLabel);
        this.deviceText = new JTextField();
        this.deviceText.setMargin(noMargin);
        this.deviceText.setEditable(false);
        this.identPanel.add(this.deviceText);
        this.attLabel = new JLabel("Attribute");
        this.identPanel.add(this.attLabel);
        this.attText = new JTextField();
        this.attText.setMargin(noMargin);
        this.attText.setEditable(false);
        this.identPanel.add(this.attText);
        pane.add(this.identPanel);
        this.numberAndStringValue = new SimpleScalarViewer();
        this.numberAndStringValue.setFont(new Font("Dialog", 1, 30));
        this.numberAndStringValue.setBorder(BorderFactory.createLoweredBevelBorder());
        this.numberAndStringValue.setSizingBehavior(JAutoScrolledText.MATRIX_BEHAVIOR);
        this.booleanValue = new BooleanScalarCheckBoxViewer();
        this.booleanValue.setQualityEnabled(true);
        this.booleanValue.setTrueLabel("True");
        this.booleanValue.setFalseLabel("False");
        this.booleanValue.setOpaque(true);
        this.booleanValue.setFont(new Font("Dialog", 1, 30));
        this.booleanValue.setBorder(BorderFactory.createLoweredBevelBorder());
        pane.add(this.numberAndStringValue);
        this.numberSetter = new NumberScalarWheelEditor();
        this.numberSetter.setFont(new Font("Dialog", 1, 20));
        this.numberSetter.setVisible(false);
        this.stringSetter = new StringScalarEditor();
        this.stringSetter.setFont(new Font("Dialog", 0, 14));
        this.stringSetter.setVisible(false);
        this.booleanSetter = new BooleanScalarComboEditor();
        this.booleanSetter.setFont(new Font("Dialog", 0, 14));
        this.booleanSetter.setVisible(false);
        pane.add(this.numberSetter);
        this.propPanel = new JPanel();
        this.propPanel.setLayout(null);
        this.propPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Properties", 1, 2, labelFont));
        this.nameLabel = new JLabel("Label");
        this.propPanel.add(this.nameLabel);
        this.nameText = new JTextField();
        this.nameText.setMargin(noMargin);
        this.nameText.setEditable(true);
        this.propPanel.add(this.nameText);
        this.minLabel = new JLabel("Minimum value");
        this.propPanel.add(this.minLabel);
        this.minText = new JTextField();
        this.minText.setMargin(noMargin);
        this.minText.setEditable(true);
        this.propPanel.add(this.minText);
        this.maxLabel = new JLabel("Maximum value");
        this.propPanel.add(this.maxLabel);
        this.maxText = new JTextField();
        this.maxText.setMargin(noMargin);
        this.maxText.setEditable(true);
        this.propPanel.add(this.maxText);
        this.alminLabel = new JLabel("Minimum alarm");
        this.propPanel.add(this.alminLabel);
        this.alminText = new JTextField();
        this.alminText.setMargin(noMargin);
        this.alminText.setEditable(true);
        this.propPanel.add(this.alminText);
        this.almaxLabel = new JLabel("Maximum alarm");
        this.propPanel.add(this.almaxLabel);
        this.almaxText = new JTextField();
        this.almaxText.setMargin(noMargin);
        this.almaxText.setEditable(true);
        this.propPanel.add(this.almaxText);
        this.minWarningLabel = new JLabel("Min. warning");
        this.propPanel.add(this.minWarningLabel);
        this.minWarningText = new JTextField();
        this.minWarningText.setMargin(noMargin);
        this.minWarningText.setEditable(true);
        this.propPanel.add(this.minWarningText);
        this.maxWarningLabel = new JLabel("Max. warning");
        this.propPanel.add(this.maxWarningLabel);
        this.maxWarningText = new JTextField();
        this.maxWarningText.setMargin(noMargin);
        this.maxWarningText.setEditable(true);
        this.propPanel.add(this.maxWarningText);
        this.deltaTLabel = new JLabel("Delta t(ms)");
        this.propPanel.add(this.deltaTLabel);
        this.deltaTText = new JTextField();
        this.deltaTText.setMargin(noMargin);
        this.deltaTText.setEditable(true);
        this.propPanel.add(this.deltaTText);
        this.deltaValLabel = new JLabel("Delta Val");
        this.propPanel.add(this.deltaValLabel);
        this.deltaValText = new JTextField();
        this.deltaValText.setMargin(noMargin);
        this.deltaValText.setEditable(true);
        this.propPanel.add(this.deltaValText);
        this.formatLabel = new JLabel("Format");
        this.propPanel.add(this.formatLabel);
        this.formatText = new JTextField();
        this.formatText.setMargin(noMargin);
        this.formatText.setEditable(true);
        this.propPanel.add(this.formatText);
        this.unitLabel = new JLabel("Unit");
        this.propPanel.add(this.unitLabel);
        this.unitText = new JTextField();
        this.unitText.setMargin(noMargin);
        this.unitText.setEditable(true);
        this.propPanel.add(this.unitText);
        this.descText = new JTextArea();
        this.descText.setEditable(true);
        this.textView = new JScrollPane(this.descText);
        this.propPanel.add(this.textView);
        pane.add(this.propPanel);
        this.okButton = new JButton("Dismiss");
        this.okButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SimplePropertyFrame.this.setVisible(false);
                SimplePropertyFrame.this.dispose();
            }
        });
        this.infoButton = new JButton("Information");
        this.infoButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SimplePropertyFrame.this.showInformation();
            }
        });
        this.applyButton = new JButton("Apply change");
        this.applyButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SimplePropertyFrame.this.applyChange();
            }
        });
        pane.add(this.applyButton);
        pane.add(this.infoButton);
        pane.add(this.okButton);
        this.setTitle("Attribute property editor");
        this.placeComponents();
        Dimension d = this.getSize();
        this.setPreferredSize(d);
        ATKGraphicsUtils.centerDialog(this);
    }

    public boolean propertyReset(String s) {
        return s.equalsIgnoreCase("Not specified") || s.equals("") || s.equalsIgnoreCase("NaN");
    }

    public void applyChange() {
        Map pmap = this.model.getPropertyMap();
        Property p = (Property)pmap.get("label");
        p.setValue((Object)this.nameText.getText());
        p.refresh();
        if (this.model instanceof ANumber) {
            Double d;
            ANumber aNbModel = (ANumber)this.model;
            p = (Property)pmap.get("min_value");
            String v = this.minText.getText();
            if (this.propertyReset(v)) {
                p.setValue((Object)"NaN");
            } else {
                try {
                    d = new Double(aNbModel.getValueInDeviceUnit(Double.parseDouble(v)));
                    p.setValue((Object)d);
                    p.refresh();
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(this, "Invalid minimum value\n" + e.getMessage(), "Error", 0);
                }
            }
            p = (Property)pmap.get("max_value");
            v = this.maxText.getText();
            if (this.propertyReset(v)) {
                p.setValue((Object)"NaN");
            } else {
                try {
                    d = new Double(aNbModel.getValueInDeviceUnit(Double.parseDouble(v)));
                    p.setValue((Object)d);
                    p.refresh();
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(this, "Invalid maximum value\n" + e.getMessage(), "Error", 0);
                }
            }
            p = (Property)pmap.get("min_alarm");
            v = this.alminText.getText();
            if (this.propertyReset(v)) {
                p.setValue((Object)"NaN");
            } else {
                try {
                    d = new Double(aNbModel.getValueInDeviceUnit(Double.parseDouble(v)));
                    p.setValue((Object)d);
                    p.refresh();
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(this, "Invalid minimum alarm\n" + e.getMessage(), "Error", 0);
                }
            }
            p = (Property)pmap.get("max_alarm");
            v = this.almaxText.getText();
            if (this.propertyReset(v)) {
                p.setValue((Object)"NaN");
            } else {
                try {
                    d = new Double(aNbModel.getValueInDeviceUnit(Double.parseDouble(v)));
                    p.setValue((Object)d);
                    p.refresh();
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(this, "Invalid maximum alarm\n" + e.getMessage(), "Error", 0);
                }
            }
            p = (Property)pmap.get("min_warning");
            v = this.minWarningText.getText();
            if (this.propertyReset(v)) {
                p.setValue((Object)"NaN");
            } else {
                try {
                    d = new Double(aNbModel.getValueInDeviceUnit(Double.parseDouble(v)));
                    p.setValue((Object)d);
                    p.refresh();
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(this, "Invalid minimum warning\n" + e.getMessage(), "Error", 0);
                }
            }
            p = (Property)pmap.get("max_warning");
            v = this.maxWarningText.getText();
            if (this.propertyReset(v)) {
                p.setValue((Object)"NaN");
            } else {
                try {
                    d = new Double(aNbModel.getValueInDeviceUnit(Double.parseDouble(v)));
                    p.setValue((Object)d);
                    p.refresh();
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(this, "Invalid maximum warning\n" + e.getMessage(), "Error", 0);
                }
            }
            p = (Property)pmap.get("delta_t");
            v = this.deltaTText.getText();
            if (this.propertyReset(v)) {
                p.setValue((Object)"NaN");
            } else {
                try {
                    d = new Double(v);
                    p.setValue((Object)d);
                    p.refresh();
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(this, "Invalid delta t\n" + e.getMessage(), "Error", 0);
                }
            }
            p = (Property)pmap.get("delta_val");
            v = this.deltaValText.getText();
            if (this.propertyReset(v)) {
                p.setValue((Object)"NaN");
            } else {
                try {
                    d = new Double(aNbModel.getValueInDeviceUnit(Double.parseDouble(v)));
                    p.setValue((Object)d);
                    p.refresh();
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(this, "Invalid delta val\n" + e.getMessage(), "Error", 0);
                }
            }
        }
        p = (Property)pmap.get("format");
        p.setValue((Object)this.formatText.getText());
        p.refresh();
        p = (Property)pmap.get("unit");
        p.setValue((Object)this.unitText.getText());
        p.refresh();
        p = (Property)pmap.get("description");
        p.setValue((Object)this.descText.getText());
        p.refresh();
        this.model.storeConfig();
        this.updateComponents();
    }

    public void updateComponents() {
        if (this.model == null) {
            return;
        }
        Container pane = this.getContentPane();
        pane.remove(1);
        this.deviceText.setText(this.model.getDeviceName());
        this.attText.setText(this.model.getNameSansDevice());
        if (this.model instanceof INumberScalar) {
            this.numberAndStringValue.setModel((INumberScalar)this.model);
            this.numberAndStringValue.setVisible(true);
            this.booleanValue.clearModel();
            this.booleanValue.setVisible(false);
            pane.add((Component)this.numberAndStringValue, 1);
        } else if (this.model instanceof IStringScalar) {
            this.numberAndStringValue.setModel((IStringScalar)this.model);
            this.numberAndStringValue.setVisible(true);
            this.booleanValue.clearModel();
            this.booleanValue.setVisible(false);
            pane.add((Component)this.numberAndStringValue, 1);
        } else {
            this.numberAndStringValue.clearModel();
            this.numberAndStringValue.setText("");
            this.numberAndStringValue.setVisible(false);
            if (this.model instanceof IBooleanScalar) {
                this.booleanValue.setAttModel((IBooleanScalar)this.model);
                this.booleanValue.setVisible(true);
                pane.add((Component)this.booleanValue, 1);
            } else {
                this.booleanValue.clearModel();
                this.booleanValue.setVisible(false);
                pane.add((Component)this.numberAndStringValue, 1);
            }
        }
        if (pane.getComponent(2) == this.numberSetter || pane.getComponent(2) == this.stringSetter || pane.getComponent(2) == this.booleanSetter) {
            pane.remove(2);
        }
        if (this.model.isWritable()) {
            if (this.model instanceof INumberScalar) {
                this.numberSetter.setModel((INumberScalar)this.model);
                this.numberSetter.setVisible(true);
                this.stringSetter.setModel(null);
                this.stringSetter.setVisible(false);
                this.booleanSetter.setAttModel(null);
                this.booleanSetter.setVisible(false);
                pane.add((Component)this.numberSetter, 2);
            } else if (this.model instanceof IStringScalar) {
                this.numberSetter.setModel(null);
                this.numberSetter.setVisible(false);
                this.stringSetter.setModel((IStringScalar)this.model);
                this.stringSetter.setVisible(true);
                this.booleanSetter.setAttModel(null);
                this.booleanSetter.setVisible(false);
                pane.add((Component)this.stringSetter, 2);
            } else if (this.model instanceof IBooleanScalar) {
                this.numberSetter.setModel(null);
                this.numberSetter.setVisible(false);
                this.stringSetter.setModel(null);
                this.stringSetter.setVisible(false);
                this.booleanSetter.setAttModel((IBooleanScalar)this.model);
                this.booleanSetter.setVisible(true);
                pane.add((Component)this.booleanSetter, 2);
            } else {
                this.numberSetter.setModel(null);
                this.numberSetter.setVisible(false);
                this.stringSetter.setModel(null);
                this.stringSetter.setVisible(false);
                this.booleanSetter.setAttModel(null);
                this.booleanSetter.setVisible(false);
            }
        } else {
            this.numberSetter.setModel(null);
            this.numberSetter.setVisible(false);
            this.stringSetter.setModel(null);
            this.stringSetter.setVisible(false);
            this.booleanSetter.setAttModel(null);
            this.booleanSetter.setVisible(false);
        }
        pane.repaint();
        this.nameText.setText(this.model.getLabel());
        if (this.model instanceof ANumber) {
            ANumber m = (ANumber)this.model;
            double v = m.getMinValue();
            if (Double.isNaN(v)) {
                this.minText.setText("Not specified");
            } else {
                this.minText.setText(Double.toString(m.getValueInDisplayUnit(v)));
            }
            v = m.getMaxValue();
            if (Double.isNaN(v)) {
                this.maxText.setText("Not specified");
            } else {
                this.maxText.setText(Double.toString(m.getValueInDisplayUnit(v)));
            }
            v = m.getMinAlarm();
            if (Double.isNaN(v)) {
                this.alminText.setText("Not specified");
            } else {
                this.alminText.setText(Double.toString(m.getValueInDisplayUnit(v)));
            }
            v = m.getMaxAlarm();
            if (Double.isNaN(v)) {
                this.almaxText.setText("Not specified");
            } else {
                this.almaxText.setText(Double.toString(m.getValueInDisplayUnit(v)));
            }
            v = m.getMinWarning();
            if (Double.isNaN(v)) {
                this.minWarningText.setText("Not specified");
            } else {
                this.minWarningText.setText(Double.toString(m.getValueInDisplayUnit(v)));
            }
            v = m.getMaxWarning();
            if (Double.isNaN(v)) {
                this.maxWarningText.setText("Not specified");
            } else {
                this.maxWarningText.setText(Double.toString(m.getValueInDisplayUnit(v)));
            }
            v = m.getDeltaT();
            if (Double.isNaN(v)) {
                this.deltaTText.setText("Not specified");
            } else {
                this.deltaTText.setText(Double.toString(v));
            }
            v = m.getDeltaVal();
            if (Double.isNaN(v)) {
                this.deltaValText.setText("Not specified");
            } else {
                this.deltaValText.setText(Double.toString(m.getValueInDisplayUnit(v)));
            }
        } else {
            this.minText.setText("None");
            this.maxText.setText("None");
            this.alminText.setText("None");
            this.almaxText.setText("None");
            this.minWarningText.setText("None");
            this.maxWarningText.setText("None");
            this.deltaTText.setText("None");
            this.deltaValText.setText("None");
        }
        this.formatText.setText(this.model.getFormat());
        this.unitText.setText(this.model.getUnit());
        this.descText.setText(this.model.getDescription());
    }

    public void placeComponents() {
        this.identPanel.setBounds(5, 5, 440, 80);
        this.deviceLabel.setBounds(10, 15, 65, 25);
        this.deviceText.setBounds(80, 15, 345, 25);
        this.attLabel.setBounds(10, 45, 65, 25);
        this.attText.setBounds(80, 45, 345, 25);
        if (this.numberAndStringValue.isVisible()) {
            if (!this.numberSetter.isVisible() && !this.stringSetter.isVisible()) {
                this.numberAndStringValue.setBounds(5, 87, 435, 45);
            } else {
                w = (int)this.numberSetter.getPreferredSize().getWidth();
                this.numberAndStringValue.setBounds(5, 87, 435 - w, 45);
                this.numberSetter.setBounds(440 - w, 87, w, 45);
                this.stringSetter.setBounds(440 - w, 87, w, 45);
            }
            this.propPanel.setBounds(5, 135, 440, 280);
        } else if (this.booleanValue.isVisible()) {
            if (!this.booleanSetter.isVisible()) {
                this.booleanValue.setBounds(5, 87, 435, 45);
            } else {
                w = (int)this.booleanSetter.getPreferredSize().getWidth();
                this.booleanValue.setBounds(5, 87, 435 - w, 45);
                this.booleanSetter.setBounds(440 - w, 87, w, 45);
            }
            this.propPanel.setBounds(5, 135, 440, 280);
        } else {
            this.propPanel.setBounds(5, 85, 440, 280);
        }
        this.nameLabel.setBounds(10, 15, 110, 25);
        this.nameText.setBounds(120, 15, 310, 25);
        this.minLabel.setBounds(10, 45, 110, 25);
        this.minText.setBounds(120, 45, 100, 25);
        this.maxLabel.setBounds(225, 45, 110, 25);
        this.maxText.setBounds(330, 45, 100, 25);
        this.alminLabel.setBounds(10, 75, 110, 25);
        this.alminText.setBounds(120, 75, 100, 25);
        this.almaxLabel.setBounds(225, 75, 110, 25);
        this.almaxText.setBounds(330, 75, 100, 25);
        this.formatLabel.setBounds(10, 105, 110, 25);
        this.formatText.setBounds(120, 105, 100, 25);
        this.unitLabel.setBounds(225, 105, 110, 25);
        this.unitText.setBounds(330, 105, 100, 25);
        this.minWarningLabel.setBounds(10, 135, 110, 25);
        this.minWarningText.setBounds(120, 135, 100, 25);
        this.maxWarningLabel.setBounds(225, 135, 110, 25);
        this.maxWarningText.setBounds(330, 135, 100, 25);
        this.deltaTLabel.setBounds(10, 165, 110, 25);
        this.deltaTText.setBounds(120, 165, 100, 25);
        this.deltaValLabel.setBounds(225, 165, 110, 25);
        this.deltaValText.setBounds(330, 165, 100, 25);
        this.textView.setBounds(10, 195, 425, 80);
        if (this.numberAndStringValue.isVisible() || this.booleanValue.isVisible()) {
            this.applyButton.setBounds(5, 420, 120, 30);
            this.infoButton.setBounds(160, 420, 120, 30);
            this.okButton.setBounds(322, 420, 120, 30);
            this.setSize(this.appsize);
        } else {
            this.applyButton.setBounds(5, 370, 120, 30);
            this.infoButton.setBounds(160, 370, 120, 30);
            this.okButton.setBounds(322, 370, 120, 30);
            Dimension d = new Dimension(this.appsize);
            d.height -= 50;
            this.setSize(d);
        }
        this.textView.revalidate();
    }

    public void setModel(IAttribute m) {
        this.model = m;
        if (this.model != null) {
            this.updateComponents();
            this.placeComponents();
            this.model.refresh();
        }
    }

    public void setEditable(boolean b) {
        this.editable = b;
        this.nameText.setEditable(b);
        this.minText.setEditable(b);
        this.maxText.setEditable(b);
        this.alminText.setEditable(b);
        this.almaxText.setEditable(b);
        this.formatText.setEditable(b);
        this.unitText.setEditable(b);
        this.descText.setEditable(b);
        this.applyButton.setEnabled(b);
    }

    public boolean isEditable() {
        return this.editable;
    }

    private void showInformation() {
        String msg = "Attribute: " + this.model.getName() + "\n\n";
        msg = msg + "Type: " + this.model.getType() + "\n";
        AttrWriteType wt = (AttrWriteType)this.model.getProperty("writable").getValue();
        switch (wt.value()) {
            case 0: {
                msg = msg + "Writable: READ\n";
                break;
            }
            case 1: {
                msg = msg + "Writable: READ_WITH_WRITE\n";
                break;
            }
            case 3: {
                msg = msg + "Writable: READ_WRITE\n";
                break;
            }
            case 2: {
                msg = msg + "Writable: WRITE\n";
            }
        }
        DispLevel dl = (DispLevel)this.model.getProperty("level").getValue();
        switch (dl.value()) {
            case 1: {
                msg = msg + "Display level: EXPERT\n";
                break;
            }
            case 0: {
                msg = msg + "Display level: OPERATOR\n";
            }
        }
        msg = msg + "Display unit factor: " + this.model.getDisplayUnitFactor() + "\n";
        msg = msg + "Standart unit factor: " + this.model.getStandardUnitFactor() + "\n";
        msg = msg + "Writable attribute: " + this.model.getProperty("writable_attr_name").getValue().toString() + "\n";
        msg = msg + "Max X dimension: " + this.model.getMaxXDimension() + "\n";
        msg = msg + "Max Y dimension: " + this.model.getMaxYDimension() + "\n";
        JOptionPane.showMessageDialog(this, msg, "Information", 1);
    }

    public static void main(String[] args) {
        SimplePropertyFrame pf = new SimplePropertyFrame();
        IAttribute testModel = null;
        AttributeList attributeList = new AttributeList();
        try {
            testModel = (IAttribute)attributeList.add("sr/d-fuse/c04-2/interlock_state");
            pf.setModel(testModel);
        }
        catch (Exception e) {
            System.out.println("attributeList.add() failed with " + e.getMessage());
            e.printStackTrace();
        }
        pf.setDefaultCloseOperation(2);
        pf.setVisible(true);
    }
}

