/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.TangoDs.AttrManip;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.BooleanScalarEvent;
import fr.esrf.tangoatk.core.EnumScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IBooleanScalarListener;
import fr.esrf.tangoatk.core.IEnumScalar;
import fr.esrf.tangoatk.core.IEnumScalarListener;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.core.IStringScalarListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.core.Property;
import fr.esrf.tangoatk.core.StringScalarEvent;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKFormat;
import fr.esrf.tangoatk.widget.util.JAutoScrolledText;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawable;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class SimpleScalarViewer
extends JAutoScrolledText
implements IEnumScalarListener,
INumberScalarListener,
IStringScalarListener,
IBooleanScalarListener,
PropertyChangeListener,
IErrorListener,
JDrawable,
MouseListener {
    INumberScalar numberModel = null;
    IStringScalar stringModel = null;
    IBooleanScalar booleanModel = null;
    IEnumScalar enumModel;
    boolean alarmEnabled = true;
    String userFormat = "";
    ATKFormat atkUserFormat = null;
    String format = "";
    String state = "VALID";
    String error = "-----";
    boolean unitVisible = true;
    Color backgroundColor = ATKConstant.getColor4Quality("VALID");
    JPopupMenu popupMenu;
    private boolean hasToolTip = false;
    private boolean qualityInTooltip = false;
    static String[] exts = new String[]{"unitVisible", "userFormat", "alarmEnabled", "validBackground", "invalidText"};

    public SimpleScalarViewer() {
        this.setOpaque(true);
        this.popupMenu = new JPopupMenu();
        JMenuItem copyMenuItem = new JMenuItem("Copy");
        this.popupMenu.add(copyMenuItem);
        copyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection stringSelection = new StringSelection(SimpleScalarViewer.this.getText());
                clipboard.setContents(stringSelection, null);
            }
        });
        this.addMouseListener(this);
        this.setMargin(new Insets(0, 0, 0, 0));
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color bg) {
        this.backgroundColor = bg;
    }

    @Override
    public void initForEditing() {
        this.setText("000.00 unit");
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String getDescription(String name) {
        if (name.equals("unitVisible")) {
            return "Display the unit of the tango attribute when enabled.\nPossible values are: true, false.";
        }
        if (name.equalsIgnoreCase("userFormat")) {
            return "Overrides the tango attribute format property when specified.\nSupports C format, ex:%5.2f .";
        }
        if (name.equalsIgnoreCase("alarmEnabled")) {
            return "When enabled, the background color change with the\nTango attribute quality factor.\nDefault colors are: ( unless they have been changed with\nATKConstant.setColor4Quality() )\n VALID   => Green\n INVALID => Grey\n ALARM   => Orange\n WARNING => Orange\n CHANGING => Blue\n UNKNOWN => Grey\nPossible values are: true, false.";
        }
        if (name.equalsIgnoreCase("invalidText")) {
            return "Text displayed when the qulaity factor is INVALID\nor when the connection is lost.";
        }
        if (name.equalsIgnoreCase("validBackground")) {
            return "Sets the background color (r,g,b) for the VALID quality factor for this viewer.\nHas effect only if alarmEnabled is true.";
        }
        return "";
    }

    @Override
    public String[] getExtensionList() {
        return exts;
    }

    @Override
    public boolean setExtendedParam(String name, String value, boolean popupErr) {
        if (name.equalsIgnoreCase("unitVisible")) {
            if (value.equalsIgnoreCase("true")) {
                this.setUnitVisible(true);
                this.setText("000.00 unit");
                return true;
            }
            if (value.equalsIgnoreCase("false")) {
                this.setUnitVisible(false);
                this.setText("000.00");
                return true;
            }
            this.showJdrawError(popupErr, "unitVisible", "Wrong syntax: 'true' or 'false' expected.");
            return false;
        }
        if (name.equalsIgnoreCase("userFormat")) {
            this.setUserFormat(value);
            return true;
        }
        if (name.equalsIgnoreCase("alarmEnabled")) {
            if (value.equalsIgnoreCase("true")) {
                this.setAlarmEnabled(true);
                return true;
            }
            if (value.equalsIgnoreCase("false")) {
                this.setAlarmEnabled(false);
                return true;
            }
            this.showJdrawError(popupErr, "alarmEnabled", "Wrong syntax: 'true' or 'false' expected.");
            return false;
        }
        if (name.equalsIgnoreCase("invalidText")) {
            this.setInvalidText(value);
            return true;
        }
        if (name.equalsIgnoreCase("validBackground")) {
            String[] c = value.split(",");
            if (c.length != 3) {
                this.showJdrawError(popupErr, "validBackground", "Integer list expected: r,g,b");
                return false;
            }
            try {
                int r = Integer.parseInt(c[0]);
                int g = Integer.parseInt(c[1]);
                int b = Integer.parseInt(c[2]);
                if (r < 0 || r > 255 || g < 0 || g > 255 || b < 0 || b > 255) {
                    this.showJdrawError(popupErr, "validBackground", "Parameter out of bounds. [0..255]");
                    return false;
                }
                this.setBackgroundColor(new Color(r, g, b));
                return true;
            }
            catch (NumberFormatException e) {
                this.showJdrawError(popupErr, "validBackground", "Wrong integer syntax.");
                return false;
            }
        }
        return false;
    }

    @Override
    public String getExtendedParam(String name) {
        if (name.equals("unitVisible")) {
            return this.getUnitVisible() ? "true" : "false";
        }
        if (name.equalsIgnoreCase("userFormat")) {
            return this.getUserFormat();
        }
        if (name.equals("alarmEnabled")) {
            return this.isAlarmEnabled() ? "true" : "false";
        }
        if (name.equals("invalidText")) {
            return this.getInvalidText();
        }
        if (name.equalsIgnoreCase("validBackground")) {
            Color c = this.backgroundColor;
            return c.getRed() + "," + c.getGreen() + "," + c.getBlue();
        }
        return "";
    }

    private void showJdrawError(boolean popup, String paramName, String message) {
        if (popup) {
            JOptionPane.showMessageDialog(null, "SimpleScalarViewer: " + paramName + " incorrect.\n" + message, "Error", 0);
        }
    }

    public void stringScalarChange(StringScalarEvent evt) {
        String oldVal;
        String val = this.getDisplayString(evt);
        if (!val.equals(oldVal = this.getText())) {
            this.setText(val);
        }
    }

    public void numberScalarChange(NumberScalarEvent evt) {
        String val = this.getDisplayString(evt);
        if (this.unitVisible) {
            this.setText(val + " " + this.numberModel.getUnit());
        } else {
            this.setText(val);
        }
    }

    public void enumScalarChange(EnumScalarEvent evt) {
        String oldVal;
        String val = evt.getValue();
        if (!val.equals(oldVal = this.getText())) {
            this.setText(val);
        }
    }

    public void booleanScalarChange(BooleanScalarEvent evt) {
        String oldVal;
        String val = this.getDisplayString(evt);
        if (!val.equals(oldVal = this.getText())) {
            this.setText(val);
        }
    }

    private String getDisplayString(StringScalarEvent evt) {
        if (this.atkUserFormat != null) {
            return this.atkUserFormat.format(evt.getValue());
        }
        return evt.getValue();
    }

    private String getDisplayString(NumberScalarEvent evt) {
        String dispStr;
        if (this.state.equals("INVALID") || Double.isNaN(evt.getValue())) {
            dispStr = this.error;
        } else if (Double.isInfinite(evt.getValue())) {
            dispStr = Double.toString(evt.getValue());
        } else if (this.atkUserFormat != null) {
            dispStr = this.atkUserFormat.format(new Double(evt.getValue()));
        } else {
            try {
                dispStr = this.userFormat.length() > 0 ? ATKFormat.format(this.userFormat, evt.getValue()) : (this.format.indexOf(37) == -1 ? AttrManip.format((String)this.format, (double)evt.getValue()) : ATKFormat.format(this.format, evt.getValue()));
            }
            catch (Exception e) {
                return "Exception while formating";
            }
        }
        return dispStr;
    }

    private String getDisplayString(BooleanScalarEvent evt) {
        if (this.atkUserFormat != null) {
            return this.atkUserFormat.format(new Boolean(evt.getValue()));
        }
        return Boolean.toString(evt.getValue());
    }

    public void setUserFormat(String format) {
        this.userFormat = format == null ? "" : format;
    }

    public void setUserFormat(ATKFormat format) {
        this.atkUserFormat = format;
    }

    public String getUserFormat() {
        return this.userFormat;
    }

    public void setUnitVisible(boolean b) {
        this.unitVisible = b;
    }

    public boolean getUnitVisible() {
        return this.unitVisible;
    }

    public void setAlarmEnabled(boolean b) {
        this.alarmEnabled = b;
    }

    public boolean isAlarmEnabled() {
        return this.alarmEnabled;
    }

    public void stateChange(AttributeStateEvent evt) {
        this.state = evt.getState();
        if (this.hasToolTip && this.qualityInTooltip) {
            IAttribute attSource = (IAttribute)evt.getSource();
            this.setToolTipText(attSource.getName() + " : " + this.state);
        }
        if (this.state.equals("INVALID")) {
            this.setText(this.error);
        }
        if (!this.alarmEnabled) {
            return;
        }
        if (this.state.equals("VALID")) {
            this.setBackground(this.backgroundColor);
            return;
        }
        this.setBackground(ATKConstant.getColor4Quality(this.state));
    }

    public void errorChange(ErrorEvent evt) {
        this.setText(this.error);
        if (!this.alarmEnabled) {
            return;
        }
        this.setBackground(ATKConstant.getColor4Quality("UNKNOWN"));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Property src = (Property)evt.getSource();
        if (this.numberModel != null) {
            if (src.getName().equalsIgnoreCase("format")) {
                this.format = src.getValue().toString();
            }
            this.numberModel.refresh();
        }
        if (this.stringModel != null) {
            if (src.getName().equalsIgnoreCase("format")) {
                this.format = src.getValue().toString();
            }
            this.stringModel.refresh();
        }
        if (this.booleanModel != null) {
            if (src.getName().equalsIgnoreCase("format")) {
                this.format = src.getValue().toString();
            }
            this.booleanModel.refresh();
        }
    }

    public void setModel(INumberScalar scalar) {
        this.clearModel();
        if (scalar != null) {
            this.format = scalar.getProperty("format").getPresentation();
            this.numberModel = scalar;
            this.numberModel.addNumberScalarListener((INumberScalarListener)this);
            this.numberModel.getProperty("format").addPresentationListener((PropertyChangeListener)this);
            this.numberModel.getProperty("unit").addPresentationListener((PropertyChangeListener)this);
            if (this.hasToolTip) {
                this.setToolTipText(scalar.getName());
            }
            this.numberModel.refresh();
        }
    }

    public void setModel(IStringScalar scalar) {
        this.clearModel();
        if (scalar != null) {
            this.format = scalar.getProperty("format").getPresentation();
            this.stringModel = scalar;
            this.stringModel.addStringScalarListener((IStringScalarListener)this);
            this.stringModel.getProperty("format").addPresentationListener((PropertyChangeListener)this);
            this.stringModel.refresh();
            if (this.hasToolTip) {
                this.setToolTipText(scalar.getName());
            }
        }
    }

    public void setModel(IEnumScalar scalar) {
        this.clearModel();
        if (scalar != null) {
            this.format = scalar.getProperty("format").getPresentation();
            this.enumModel = scalar;
            this.enumModel.addEnumScalarListener((IEnumScalarListener)this);
            this.enumModel.getProperty("format").addPresentationListener((PropertyChangeListener)this);
            this.enumModel.refresh();
            if (this.hasToolTip) {
                this.setToolTipText(scalar.getName());
            }
        }
    }

    public void setModel(IBooleanScalar scalar) {
        this.clearModel();
        if (scalar != null) {
            this.format = scalar.getProperty("format").getPresentation();
            this.booleanModel = scalar;
            this.booleanModel.addBooleanScalarListener((IBooleanScalarListener)this);
            this.booleanModel.getProperty("format").addPresentationListener((PropertyChangeListener)this);
            this.booleanModel.refresh();
            if (this.hasToolTip) {
                this.setToolTipText(scalar.getName());
            }
        }
    }

    public void clearModel() {
        if (this.hasToolTip) {
            this.setToolTipText(null);
        }
        if (this.stringModel != null) {
            this.stringModel.removeStringScalarListener((IStringScalarListener)this);
            this.stringModel.getProperty("format").removePresentationListener((PropertyChangeListener)this);
            this.stringModel = null;
        }
        if (this.numberModel != null) {
            this.numberModel.removeNumberScalarListener((INumberScalarListener)this);
            this.numberModel.getProperty("format").removePresentationListener((PropertyChangeListener)this);
            this.numberModel.getProperty("unit").removePresentationListener((PropertyChangeListener)this);
            this.numberModel = null;
        }
        if (this.booleanModel != null) {
            this.booleanModel.removeBooleanScalarListener((IBooleanScalarListener)this);
            this.booleanModel.getProperty("format").removePresentationListener((PropertyChangeListener)this);
            this.booleanModel = null;
        }
        if (this.enumModel != null) {
            this.enumModel.removeEnumScalarListener((IEnumScalarListener)this);
            this.enumModel.getProperty("format").removePresentationListener((PropertyChangeListener)this);
            this.enumModel = null;
        }
    }

    public void setInvalidText(String s) {
        this.error = s;
    }

    public String getInvalidText() {
        return this.error;
    }

    public INumberScalar getNumberModel() {
        return this.numberModel;
    }

    public IStringScalar getStringModel() {
        return this.stringModel;
    }

    public IBooleanScalar getBooleanModel() {
        return this.booleanModel;
    }

    public boolean getHasToolTip() {
        return this.hasToolTip;
    }

    public void setHasToolTip(boolean b) {
        if (this.hasToolTip == b) {
            return;
        }
        this.hasToolTip = b;
        if (!this.hasToolTip) {
            this.setToolTipText(null);
            return;
        }
        if (this.stringModel != null) {
            this.setToolTipText(this.stringModel.getName());
            return;
        }
        if (this.numberModel != null) {
            this.setToolTipText(this.numberModel.getName());
            return;
        }
        if (this.booleanModel != null) {
            this.setToolTipText(this.booleanModel.getName());
            return;
        }
    }

    public boolean getQualityInTooltip() {
        return this.qualityInTooltip;
    }

    public void setQualityInTooltip(boolean b) {
        IStringScalar attModel = null;
        if (!this.hasToolTip) {
            this.qualityInTooltip = b;
            return;
        }
        if (this.qualityInTooltip != b) {
            if (this.stringModel != null) {
                attModel = this.stringModel;
            } else if (this.numberModel != null) {
                attModel = this.numberModel;
            } else if (this.booleanModel != null) {
                attModel = this.booleanModel;
            }
            if (!b && attModel != null) {
                this.setToolTipText(attModel.getName());
            }
            this.qualityInTooltip = b;
        }
    }

    public static void main(String[] args) throws Exception {
        AttributeList attributeList = new AttributeList();
        SimpleScalarViewer snv = new SimpleScalarViewer();
        String attributeName = "srdiag/ccd/c25-1/ImageCounter";
        if (args != null && args.length > 0) {
            attributeName = args[0];
        }
        IAttribute attribute = null;
        try {
            attribute = (IAttribute)attributeList.add(attributeName);
        }
        catch (Exception e) {
            attribute = null;
        }
        if (attribute instanceof INumberScalar) {
            snv.setModel((INumberScalar)attribute);
        } else if (attribute instanceof IStringScalar) {
            snv.setModel((IStringScalar)attribute);
        } else if (attribute instanceof IBooleanScalar) {
            snv.setModel((IBooleanScalar)attribute);
        } else {
            System.err.println(attributeName + " is not a valid attribute or is not available");
            System.exit(1);
        }
        snv.setBorder(BorderFactory.createLoweredBevelBorder());
        snv.setBackgroundColor(Color.WHITE);
        snv.setForeground(Color.BLACK);
        snv.setFont(new Font("Dialog", 1, 30));
        attribute.refresh();
        JFrame f = new JFrame();
        f.setContentPane(snv);
        f.pack();
        f.setVisible(true);
        attributeList.startRefresher();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 3) {
            this.popupMenu.show(this, e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

