/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.DevStateScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IDevStateScalar;
import fr.esrf.tangoatk.core.IDevStateScalarListener;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;

public class StateViewer
extends JPanel
implements IDevStateScalarListener {
    private JLabel textLabel;
    private JLabel valueLabel;
    private IDevStateScalar model = null;
    private boolean useDeviceAlias = true;
    private String currentState = "UNKNOWN";
    private boolean externalSetText = false;
    private boolean stateInTooltip = false;
    private final JPanel thisPanel = this;

    public StateViewer() {
        this.initComponents();
    }

    private void initComponents() {
        this.textLabel = new JLabel();
        this.valueLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.textLabel.setText("Not Connected");
        this.textLabel.setFont(new Font("Dialog", 0, 12));
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(0, 4, 0, 3);
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 0.0;
        this.add((Component)this.textLabel, gridBagConstraints1);
        this.valueLabel.setBackground(Color.red);
        this.valueLabel.setFont(new Font("Dialog", 0, 12));
        this.valueLabel.setPreferredSize(new Dimension(40, 14));
        this.valueLabel.setOpaque(true);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(0, 3, 0, 4);
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.weightx = 0.0;
        gridBagConstraints1.weighty = 0.0;
        this.add((Component)this.valueLabel, gridBagConstraints1);
    }

    public void clearModel() {
        if (this.model != null) {
            this.model.removeDevStateScalarListener((IDevStateScalarListener)this);
            this.model = null;
        }
    }

    public void setModel(IDevStateScalar stateAtt) {
        if (this.model != null) {
            this.clearModel();
        }
        if (stateAtt == null) {
            return;
        }
        this.model = stateAtt;
        if (!stateAtt.areAttPropertiesLoaded()) {
            stateAtt.loadAttProperties();
        }
        stateAtt.addDevStateScalarListener((IDevStateScalarListener)this);
        if (!this.externalSetText) {
            if (this.useDeviceAlias) {
                if (this.model.getDevice().getAlias() != null) {
                    this.textLabel.setText(this.model.getDevice().getAlias());
                } else {
                    this.textLabel.setText(this.model.getDevice().getName());
                }
            } else {
                this.textLabel.setText(this.model.getDevice().getName());
            }
        }
        if (this.model.getName().toLowerCase().endsWith("/state")) {
            this.setToolTipText(this.model.getDevice().getName());
        } else {
            this.setToolTipText(this.model.getName());
        }
        stateAtt.refresh();
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.valueLabel.setToolTipText(text);
        this.textLabel.setToolTipText(text);
        MouseInputListener ml = new MouseInputListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                this.dispatch(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.dispatch(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.dispatch(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                this.dispatch(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.dispatch(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                this.dispatch(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                this.dispatch(e);
            }

            public void dispatch(MouseEvent e) {
                StateViewer.this.dispatchEvent(SwingUtilities.convertMouseEvent(e.getComponent(), e, StateViewer.this.thisPanel));
            }
        };
        this.valueLabel.addMouseListener(ml);
        this.textLabel.addMouseListener(ml);
    }

    public IDevStateScalar getModel() {
        return this.model;
    }

    public void setLabel(String label) {
        this.externalSetText = true;
        this.textLabel.setText(label);
    }

    public String getLabel() {
        return this.textLabel.getText();
    }

    public void setLabelVisible(boolean visible) {
        this.textLabel.setVisible(visible);
    }

    public boolean isLabelVisible() {
        return this.textLabel.isVisible();
    }

    public boolean getUseDeviceAlias() {
        return this.useDeviceAlias;
    }

    public void setUseDeviceAlias(boolean b) {
        this.useDeviceAlias = b;
    }

    public void setStateVisible(boolean visible) {
        this.valueLabel.setVisible(visible);
    }

    public boolean isStateVisible() {
        return this.valueLabel.isVisible();
    }

    public boolean getStateInTooltip() {
        return this.stateInTooltip;
    }

    public void setStateInTooltip(boolean b) {
        if (this.stateInTooltip != b) {
            if (!b && this.model != null) {
                this.valueLabel.setToolTipText(this.model.getDevice().getName());
            }
            this.stateInTooltip = b;
        }
    }

    public void stateChange(AttributeStateEvent e) {
    }

    public void devStateScalarChange(DevStateScalarEvent evt) {
        this.setCurrentState(evt.getValue());
    }

    public void errorChange(ErrorEvent evt) {
        this.setCurrentState("UNKNOWN");
    }

    private void setCurrentState(String stateStr) {
        this.currentState = stateStr;
        this.valueLabel.setBackground(ATKConstant.getColor4State(this.currentState, this.model.getInvertedOpenClose(), this.model.getInvertedInsertExtract()));
        if (this.stateInTooltip) {
            this.valueLabel.setToolTipText(this.model.getDevice().getName() + " : " + this.currentState);
        }
    }

    public String getCurrentState() {
        return this.currentState;
    }

    public void setStateText(String text) {
        this.valueLabel.setText(text);
    }

    public String getStateText() {
        return this.valueLabel.getText();
    }

    public void setStateFont(Font font) {
        this.valueLabel.setFont(font);
    }

    @Override
    public void setFont(Font font) {
        if (this.valueLabel != null) {
            this.valueLabel.setFont(font);
        }
        if (this.textLabel != null) {
            this.textLabel.setFont(font);
        }
        super.setFont(font);
    }

    public Font getStateFont() {
        return this.valueLabel.getFont();
    }

    public void setStateForeground(Color color) {
        this.valueLabel.setForeground(color);
    }

    public Color getStateForeground() {
        return this.valueLabel.getForeground();
    }

    @Override
    public void setForeground(Color color) {
        if (this.valueLabel != null) {
            this.valueLabel.setForeground(color);
        }
        if (this.textLabel != null) {
            this.textLabel.setForeground(color);
        }
        super.setForeground(color);
    }

    public void setStateHorizontalAlignment(int i) {
        this.valueLabel.setHorizontalAlignment(i);
    }

    public int getStateHorizontalAlignment() {
        return this.valueLabel.getHorizontalAlignment();
    }

    public void setStatePreferredSize(Dimension dimension) {
        this.valueLabel.setPreferredSize(dimension);
    }

    public Dimension getStatePreferredSize() {
        return this.valueLabel.getPreferredSize();
    }

    public void setStateBorder(Border border) {
        if (this.valueLabel == null) {
            return;
        }
        this.valueLabel.setBorder(border);
    }

    public Border getStateBorder() {
        if (this.valueLabel == null) {
            return null;
        }
        return this.valueLabel.getBorder();
    }

    public static void main(String[] args) {
        final AttributeList attList = new AttributeList();
        StateViewer stv = new StateViewer();
        try {
            IDevStateScalar attState = (IDevStateScalar)attList.add("sr/d-fofbcorrection/globalx/State");
            stv.setModel(attState);
            stv.setLabel("globalx status");
        }
        catch (Exception ex) {
            System.out.println("caught exception : " + ex.getMessage());
            System.exit(-1);
        }
        JFrame mainFrame = new JFrame();
        mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent evt) {
                attList.startRefresher();
            }
        });
        mainFrame.setContentPane(stv);
        mainFrame.pack();
        mainFrame.setVisible(true);
    }
}

