/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.core.IStringScalarListener;
import fr.esrf.tangoatk.core.StringScalarEvent;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class StatusViewer
extends JPanel
implements IStringScalarListener,
JDrawable {
    private JScrollPane scrollPane;
    private JTextArea status;
    private IStringScalar model = null;
    private boolean useDeviceAlias = true;
    static String[] exts = new String[]{"verticalScrollBar", "horizontalScrollBar"};

    public StatusViewer() {
        this.initComponents();
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.status = new JTextArea();
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder("Status"));
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.status.setLineWrap(true);
        this.status.setEditable(false);
        this.status.setColumns(50);
        this.status.setRows(4);
        this.status.setText("Unknown");
        this.status.setBackground(new Color(204, 204, 204));
        this.scrollPane.setViewportView(this.status);
        this.add((Component)this.scrollPane, "Center");
    }

    public void setModel(IStringScalar statusAtt) {
        if (this.model != null) {
            this.model.removeStringScalarListener((IStringScalarListener)this);
        }
        this.status.setText("Unknown");
        this.model = statusAtt;
        if (this.model != null) {
            this.model.addStringScalarListener((IStringScalarListener)this);
            this.setStatus(this.model.getStringDeviceValue());
            if (this.getBorder() instanceof TitledBorder) {
                if (this.useDeviceAlias) {
                    if (this.model.getDevice().getAlias() != null) {
                        this.setBorder(new TitledBorder(this.model.getDevice().getAlias()));
                    } else {
                        this.setBorder(new TitledBorder(this.model.getDevice().getName()));
                    }
                } else {
                    this.setBorder(new TitledBorder(this.model.getDevice().getName()));
                }
            }
        }
    }

    public void clearModel() {
        this.setModel(null);
    }

    public IStringScalar getModel() {
        return this.model;
    }

    public int getRows() {
        return this.status.getRows();
    }

    public void setRows(int rows) {
        this.status.setRows(rows);
    }

    public int getColumns() {
        return this.status.getColumns();
    }

    public void setColumns(int columns) {
        this.status.setColumns(columns);
    }

    public boolean getUseDeviceAlias() {
        return this.useDeviceAlias;
    }

    public void setUseDeviceAlias(boolean b) {
        this.useDeviceAlias = b;
    }

    public JTextArea getText() {
        return this.status;
    }

    public void stringScalarChange(StringScalarEvent evt) {
        if (!this.status.isEnabled()) {
            this.status.setEnabled(true);
        }
        this.setStatus(evt.getValue());
    }

    public void errorChange(ErrorEvent evt) {
        this.setStatus("UNKNOWN");
        this.status.setEnabled(false);
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
        this.attStateChange(attributeStateEvent.getState());
    }

    private void setStatus(String s) {
        if (s == null) {
            if ("".equals(this.status.getText()) || this.status.getText() == null) {
                return;
            }
            this.status.setText("");
        } else {
            if (s.equals(this.status.getText())) {
                return;
            }
            this.status.setText(s);
            this.status.setCaretPosition(0);
        }
    }

    private void attStateChange(String state) {
        if ("VALID".equals(state)) {
            this.status.setBackground(this.getBackground());
            return;
        }
        this.status.setBackground(ATKConstant.getColor4Quality(state));
    }

    @Override
    public void setFont(Font font) {
        if (this.status != null) {
            this.status.setFont(font);
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.status != null) {
            this.status.setBackground(color);
        }
    }

    @Override
    public void initForEditing() {
        this.status.setText("This is a multiline\nsample text");
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String[] getExtensionList() {
        return exts;
    }

    @Override
    public boolean setExtendedParam(String name, String value, boolean popupAllowed) {
        if (name.equals("verticalScrollBar")) {
            if (value.equalsIgnoreCase("ASNEEDED")) {
                this.scrollPane.setVerticalScrollBarPolicy(20);
                return true;
            }
            if (value.equalsIgnoreCase("ALWAYS")) {
                this.scrollPane.setVerticalScrollBarPolicy(22);
                return true;
            }
            if (value.equalsIgnoreCase("NEVER")) {
                this.scrollPane.setVerticalScrollBarPolicy(21);
                return true;
            }
            this.showJdrawError(popupAllowed, "verticalScrollBar", "Wrong syntax: 'ASNEEDED','ALWAYS'or 'NEVER' expected.");
            return false;
        }
        if (name.equals("horizontalScrollBar")) {
            if (value.equalsIgnoreCase("ASNEEDED")) {
                this.scrollPane.setHorizontalScrollBarPolicy(30);
                return true;
            }
            if (value.equalsIgnoreCase("ALWAYS")) {
                this.scrollPane.setHorizontalScrollBarPolicy(32);
                return true;
            }
            if (value.equalsIgnoreCase("NEVER")) {
                this.scrollPane.setHorizontalScrollBarPolicy(31);
                return true;
            }
            this.showJdrawError(popupAllowed, "horizontalScrollBar", "Wrong syntax: 'ASNEEDED','ALWAYS'or 'NEVER' expected.");
            return false;
        }
        return false;
    }

    @Override
    public String getExtendedParam(String name) {
        if (name.equals("verticalScrollBar")) {
            return this.getScrollBarPolicy(this.scrollPane.getVerticalScrollBarPolicy());
        }
        if (name.equals("horizontalScrollBar")) {
            return this.getScrollBarPolicy(this.scrollPane.getHorizontalScrollBarPolicy());
        }
        return "";
    }

    @Override
    public String getDescription(String extName) {
        if (extName.equals("verticalScrollBar")) {
            return "Vertical scrollBar policy.\nPossible values are: ASNEEDED,ALWAYS,NEVER";
        }
        if (extName.equals("horizontalScrollBar")) {
            return "Horizontal scrollBar policy.\nPossible values are: ASNEEDED,ALWAYS,NEVER";
        }
        return "";
    }

    private String getScrollBarPolicy(int policy) {
        switch (policy) {
            case 22: 
            case 32: {
                return "ALWAYS";
            }
            case 21: 
            case 31: {
                return "NEVER";
            }
            case 20: 
            case 30: {
                return "ASNEEDED";
            }
        }
        return Integer.toString(policy);
    }

    private void showJdrawError(boolean popup, String paramName, String message) {
        if (popup) {
            JOptionPane.showMessageDialog(null, "StatusViewer: " + paramName + " incorrect.\n" + message, "Error", 0);
        }
    }

    public static void main(String[] args) {
        final AttributeList attList = new AttributeList();
        StatusViewer stsv = new StatusViewer();
        try {
            IStringScalar attStatus = (IStringScalar)attList.add("dev/test/10/Status");
            stsv.setModel(attStatus);
        }
        catch (Exception ex) {
            System.out.println("caught exception : " + ex.getMessage());
            System.exit(-1);
        }
        JFrame mainFrame = new JFrame();
        mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent evt) {
                attList.startRefresher();
            }
        });
        mainFrame.setContentPane(stsv);
        mainFrame.pack();
        mainFrame.setVisible(true);
    }
}

