/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class StringScalarNumberComboEditor
extends JComboBox
implements ActionListener,
INumberScalarListener {
    private DefaultComboBoxModel comboModel = null;
    private String defActionCmd = "setAttActionCmd";
    private INumberScalar numberModel = null;
    private String[] optionList = new String[]{"0.0"};

    public StringScalarNumberComboEditor() {
        this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
        this.setModel(this.comboModel);
        this.setActionCommand(this.defActionCmd);
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionevent) {
        double d = 0.0;
        int i = this.getSelectedIndex();
        if (!actionevent.getActionCommand().equals(this.defActionCmd)) {
            return;
        }
        if (this.numberModel == null) {
            return;
        }
        d = Double.NaN;
        d = this.getValues(i);
        if (!Double.isNaN(d)) {
            this.numberModel.setValue(d);
        }
    }

    private void changeCurrentSelection(int i) {
        this.disableExecution();
        this.setSelectedIndex(i);
        this.repaint();
        this.enableExecution();
    }

    private void changeSelectedOption(double d) {
        this.changeCurrentSelection(this.getIndex(d));
    }

    public void disableExecution() {
        this.setActionCommand("dummy");
    }

    public void enableExecution() {
        this.setActionCommand(this.defActionCmd);
    }

    public void errorChange(ErrorEvent errorevent) {
        this.changeSelectedOption(Double.NaN);
    }

    private int getIndex(double value) {
        if (this.numberModel == null) {
            return 0;
        }
        double[] ad = this.numberModel.getPossibleValues();
        for (int i = 0; i < ad.length; ++i) {
            if (ad[i] != value) continue;
            return i;
        }
        return 0;
    }

    public double getValues(int index) {
        double[] ad = this.numberModel.getPossibleValues();
        if (ad == null) {
            return Double.NaN;
        }
        if (index > ad.length || index < 0) {
            return Double.NaN;
        }
        return ad[index];
    }

    public void numberScalarChange(NumberScalarEvent numberscalarevent) {
        double d = Double.NaN;
        d = this.hasFocus() ? this.numberModel.getNumberScalarSetPointFromDevice() : this.numberModel.getNumberScalarSetPoint();
        this.changeSelectedOption(d);
    }

    public void setNumberModel(INumberScalar inumberscalar) {
        this.clearModel();
        if (inumberscalar == null) {
            return;
        }
        if (!inumberscalar.isWritable()) {
            return;
        }
        this.numberModel = inumberscalar;
        this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
        this.setModel(this.comboModel);
        this.numberModel.addNumberScalarListener((INumberScalarListener)this);
        this.numberModel.refresh();
    }

    public INumberScalar getNumberModel() {
        return this.numberModel;
    }

    public void clearModel() {
        if (this.numberModel != null) {
            this.numberModel.removeNumberScalarListener((INumberScalarListener)this);
        }
    }

    public void setOptionList(String[] optionList) {
        this.optionList = optionList;
        this.comboModel = new DefaultComboBoxModel<String>(optionList);
        this.setModel(this.comboModel);
        this.repaint();
    }

    public void stateChange(AttributeStateEvent attributestateevent) {
    }
}

