/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.DevStateScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IDevStateScalar;
import fr.esrf.tangoatk.core.IDevStateScalarListener;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.plaf.metal.MetalTabbedPaneUI;

public class TabbedPaneDevStateScalarViewer
extends JTabbedPane
implements IDevStateScalarListener {
    public static final int TOOLTIP_NONE = 0;
    public static final int TOOLTIP_STATE = 1;
    public static final int TOOLTIP_NAME = 2;
    public static final int TOOLTIP_NAME_AND_STATE = 3;
    private HashMap<IDevStateScalar, Integer> stateModelMap = new HashMap();
    private HashMap<Integer, IDevStateScalar> indexStateAttMap = new HashMap();
    private int tooltipMode = 0;

    public TabbedPaneDevStateScalarViewer() {
        this.setUI(new DevStateTabbedPaneUI());
    }

    public int getTooltipMode() {
        return this.tooltipMode;
    }

    public void setTooltipMode(int ttmode) {
        if (this.tooltipMode == ttmode) {
            return;
        }
        if (ttmode < 0 || ttmode > 3) {
            return;
        }
        this.tooltipMode = ttmode;
        int nbtabs = this.getTabCount();
        if (nbtabs <= 0) {
            return;
        }
        block10: for (int i = 0; i < nbtabs; ++i) {
            switch (this.tooltipMode) {
                case 0: {
                    this.setToolTipTextAt(i, null);
                    continue block10;
                }
                case 1: {
                    IDevStateScalar stateAtt = this.getStateAttAt(i);
                    if (stateAtt == null) {
                        this.setToolTipTextAt(i, "NoState");
                        continue block10;
                    }
                    try {
                        this.setToolTipTextAt(i, stateAtt.getValue());
                    }
                    catch (Exception ex) {
                        this.setToolTipTextAt(i, "UNKNOWN");
                    }
                    continue block10;
                }
                case 2: {
                    IDevStateScalar stateAtt = this.getStateAttAt(i);
                    if (stateAtt == null) {
                        this.setToolTipTextAt(i, "NoName");
                        continue block10;
                    }
                    this.setToolTipTextAt(i, stateAtt.getName());
                    continue block10;
                }
                case 3: {
                    IDevStateScalar stateAtt = this.getStateAttAt(i);
                    if (stateAtt == null) {
                        this.setToolTipTextAt(i, "NoNameAndState");
                        continue block10;
                    }
                    Object tt = stateAtt.getName();
                    try {
                        tt = (String)tt + " : " + stateAtt.getValue();
                    }
                    catch (Exception ex) {
                        tt = (String)tt + " : UNKNOWN";
                    }
                    this.setToolTipTextAt(i, (String)tt);
                }
            }
        }
    }

    public IDevStateScalar getStateAttAt(int tidx) {
        if (tidx < 0 || tidx >= this.getTabCount()) {
            return null;
        }
        Integer tabIndex = new Integer(tidx);
        if (!this.indexStateAttMap.containsKey(tabIndex)) {
            return null;
        }
        if (!this.stateModelMap.containsValue(tabIndex)) {
            return null;
        }
        IDevStateScalar stateAtt = this.indexStateAttMap.get(tabIndex);
        return stateAtt;
    }

    public int getTabIndexForStateAtt(IDevStateScalar stateAtt) {
        if (stateAtt == null) {
            return -1;
        }
        if (!this.stateModelMap.containsKey(stateAtt)) {
            return -1;
        }
        Integer stateIdx = this.stateModelMap.get(stateAtt);
        if (stateIdx == null) {
            return -1;
        }
        return stateIdx;
    }

    public void addDevStateScalarModel(Integer tabIndex, IDevStateScalar devStateAtt) {
        if (tabIndex == null || devStateAtt == null) {
            return;
        }
        if (tabIndex < 0 || tabIndex >= this.getTabCount()) {
            return;
        }
        if (this.stateModelMap.containsValue(tabIndex)) {
            return;
        }
        this.indexStateAttMap.put(tabIndex, devStateAtt);
        this.stateModelMap.put(devStateAtt, tabIndex);
        if (!devStateAtt.areAttPropertiesLoaded()) {
            devStateAtt.loadAttProperties();
        }
        devStateAtt.addDevStateScalarListener((IDevStateScalarListener)this);
        devStateAtt.addErrorListener((IErrorListener)this);
        devStateAtt.refresh();
        switch (this.tooltipMode) {
            case 0: {
                this.setToolTipTextAt(tabIndex, null);
                break;
            }
            case 1: {
                try {
                    this.setToolTipTextAt(tabIndex, devStateAtt.getValue());
                }
                catch (Exception ex) {
                    this.setToolTipTextAt(tabIndex, "UNKNOWN");
                }
                break;
            }
            case 2: {
                this.setToolTipTextAt(tabIndex, devStateAtt.getName());
                break;
            }
            case 3: {
                Object tt = devStateAtt.getName();
                try {
                    tt = (String)tt + " : " + devStateAtt.getValue();
                }
                catch (Exception ex) {
                    tt = (String)tt + " : UNKNOWN";
                }
                this.setToolTipTextAt(tabIndex, (String)tt);
            }
        }
    }

    public void removeDevStateScalarModel(Integer tabIndex, IDevStateScalar devStateAtt) {
        if (tabIndex == null || devStateAtt == null) {
            return;
        }
        if (tabIndex < 0 || tabIndex >= this.getTabCount()) {
            return;
        }
        if (!this.stateModelMap.containsKey(devStateAtt)) {
            return;
        }
        if (!this.indexStateAttMap.containsKey(tabIndex)) {
            return;
        }
        Integer tidx = this.stateModelMap.get(devStateAtt);
        if (tidx.intValue() != tabIndex.intValue()) {
            return;
        }
        devStateAtt.removeDevStateScalarListener((IDevStateScalarListener)this);
        devStateAtt.removeErrorListener((IErrorListener)this);
        this.stateModelMap.remove(devStateAtt);
        this.indexStateAttMap.remove(tabIndex);
    }

    public void devStateScalarChange(DevStateScalarEvent evt) {
        IDevStateScalar stateAtt = null;
        if (!(evt.getSource() instanceof IDevStateScalar)) {
            return;
        }
        stateAtt = (IDevStateScalar)evt.getSource();
        this.setStateOnTab(stateAtt, evt.getValue());
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    public void errorChange(ErrorEvent evt) {
        IDevStateScalar stateAtt = null;
        if (!(evt.getSource() instanceof IDevStateScalar)) {
            return;
        }
        stateAtt = (IDevStateScalar)evt.getSource();
        this.setStateOnTab(stateAtt, "UNKNOWN");
    }

    private void setStateOnTab(IDevStateScalar stateAtt, String currentState) {
        if (stateAtt == null) {
            return;
        }
        if (!this.stateModelMap.containsKey(stateAtt)) {
            return;
        }
        Integer tidx = this.stateModelMap.get(stateAtt);
        try {
            this.setBackgroundAt(tidx, ATKConstant.getColor4State(currentState, stateAtt.getInvertedOpenClose(), stateAtt.getInvertedInsertExtract()));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        if (this.tooltipMode != 1 && this.tooltipMode != 3) {
            return;
        }
        int ind = this.getTabIndexForStateAtt(stateAtt);
        if (ind < 0 || ind >= this.getTabCount()) {
            return;
        }
        if (this.tooltipMode == 1) {
            this.setToolTipTextAt(ind, currentState);
        } else {
            this.setToolTipTextAt(ind, stateAtt.getName() + " : " + currentState);
        }
    }

    public static void main(String[] args) {
        AttributeList attList = new AttributeList();
        JPanel jp1 = new JPanel();
        JPanel jp2 = new JPanel();
        TabbedPaneDevStateScalarViewer tbv = new TabbedPaneDevStateScalarViewer();
        jp1.setPreferredSize(new Dimension(300, 200));
        jp2.setPreferredSize(new Dimension(300, 200));
        tbv.setTooltipMode(3);
        tbv.addTab("jlptest1", jp1);
        tbv.addTab("jlptest2", jp2);
        try {
            IDevStateScalar attState1 = (IDevStateScalar)attList.add("jlp/test/1/State");
            IDevStateScalar attState2 = (IDevStateScalar)attList.add("jlp/test/2/State");
            int tabidx1 = tbv.indexOfComponent(jp1);
            Integer tabIndex1 = new Integer(tabidx1);
            tbv.addDevStateScalarModel(tabIndex1, attState1);
            int tabidx2 = tbv.indexOfComponent(jp2);
            Integer tabIndex2 = new Integer(tabidx2);
            tbv.addDevStateScalarModel(tabIndex2, attState2);
        }
        catch (Exception ex) {
            System.out.println("caught exception : " + ex.getMessage());
            System.exit(-1);
        }
        JFrame mainFrame = new JFrame();
        mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
        });
        mainFrame.setContentPane(tbv);
        attList.startRefresher();
        mainFrame.pack();
        mainFrame.setVisible(true);
    }

    class DevStateTabbedPaneUI
    extends MetalTabbedPaneUI {
        DevStateTabbedPaneUI() {
        }

        @Override
        protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
            super.paintTabBackground(g, tabPlacement, tabIndex, x, y, w, h, false);
        }
    }
}

