/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.Tango.DevSource;
import fr.esrf.Tango.DevState;
import fr.esrf.tangoatk.core.ATKException;
import fr.esrf.tangoatk.core.AttributePolledList;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IDevStateScalar;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IEntityFilter;
import fr.esrf.tangoatk.core.IEnumScalar;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.IListStateListener;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.IRefresherListener;
import fr.esrf.tangoatk.widget.attribute.ConfigPanel;
import fr.esrf.tangoatk.widget.attribute.SimplePropertyFrame;
import fr.esrf.tangoatk.widget.attribute.SpectrumItem;
import fr.esrf.tangoatk.widget.attribute.TrendRenderer;
import fr.esrf.tangoatk.widget.attribute.TrendSelectionNode;
import fr.esrf.tangoatk.widget.util.ATKDiagnostic;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorHistory;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.IControlee;
import fr.esrf.tangoatk.widget.util.JDWAttribute;
import fr.esrf.tangoatk.widget.util.MultiExtFileFilter;
import fr.esrf.tangoatk.widget.util.chart.CfFileReader;
import fr.esrf.tangoatk.widget.util.chart.IJLChartActionListener;
import fr.esrf.tangoatk.widget.util.chart.IJLChartListener;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLChartActionEvent;
import fr.esrf.tangoatk.widget.util.chart.JLChartEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import fr.esrf.tangoatk.widget.util.chart.OFormat;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.border.EtchedBorder;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class Trend
extends JPanel
implements IControlee,
ActionListener,
IJLChartActionListener,
IRefresherListener,
IListStateListener,
IJLChartListener,
JDrawable {
    public static final int SEL_NONE = 0;
    public static final int SEL_X = 1;
    public static final int SEL_Y1 = 2;
    public static final int SEL_Y2 = 3;
    public static final int DEVICE_LABEL_AUTO = 0;
    public static final int DEVICE_LABEL_NEVER = 1;
    public static final int DEVICE_LABEL_ALWAYS = 2;
    protected static Color[] defaultColor = new Color[]{Color.red, Color.blue, Color.cyan, Color.green, Color.magenta, Color.orange, Color.pink, Color.yellow, Color.black};
    protected JFrame parent = null;
    protected JToolBar theToolBar;
    protected JPopupMenu toolMenu;
    protected JButton optionButton;
    protected JMenuItem optionMenuI;
    protected JButton startStopButton;
    protected ImageIcon startIcon;
    protected ImageIcon stopIcon;
    protected JMenuItem startStopMenuI;
    protected JButton loadButton;
    protected JMenuItem loadMenuI;
    protected JButton saveButton;
    protected JMenuItem saveMenuI;
    protected JButton zoomButton;
    protected JMenuItem zoomMenuI;
    protected JButton timeButton;
    protected JMenuItem timeMenuI;
    protected JMenu sourceMenuI;
    protected JCheckBoxMenuItem sourceDEVMenuI;
    protected JCheckBoxMenuItem sourceCACHEMenuI;
    protected JCheckBoxMenuItem sourceCACHEDEVMenuI;
    protected JButton cfgButton;
    protected JMenuItem cfgMenuI;
    protected JButton resetButton;
    protected JMenuItem resetMenuI;
    protected JCheckBoxMenuItem offLineButton;
    protected JMenuItem showErrorMenuI;
    protected JMenuItem showDiagMenuI;
    protected JMenuItem showtoolMenuI;
    protected JPanel innerPanel;
    protected JLabel dateLabel;
    protected JScrollPane treeView = null;
    protected JTree mainTree = null;
    protected DefaultTreeModel mainTreeModel = null;
    protected TrendSelectionNode rootNode = null;
    protected JPopupMenu treeMenu;
    protected JMenuItem addXMenuItem;
    protected JMenuItem addY1MenuItem;
    protected JMenuItem addY2MenuItem;
    protected JCheckBoxMenuItem showMinAlarmMenuItem;
    protected JCheckBoxMenuItem showMaxAlarmMenuItem;
    protected JMenuItem removeMenuItem;
    protected JMenuItem optionMenuItem;
    protected JMenuItem attOptionMenuItem;
    protected JLChart theGraph;
    private String graphTitle = "";
    private ConfigPanel cfgPanel = null;
    private static Point framePos = new Point(0, 0);
    private static Point frameDimension = new Point(640, 480);
    protected AttributePolledList attList = null;
    private TrendSelectionNode lastAdded = null;
    private AttributePolledList lastCreatedList = null;
    private SimplePropertyFrame propFrame = null;
    private String lastConfig = "";
    private boolean singleDevice = true;
    private int isShowingDeviceName = 0;
    static final GregorianCalendar calendar = new GregorianCalendar();
    static final SimpleDateFormat genFormat = new SimpleDateFormat("EEE dd/MM/yy HH:mm:ss");
    protected Map buttonMap;
    public static final String startStop = "STARTSTOP";
    public static final String save = "SAVE";
    public static final String load = "LOAD";
    public static final String zoom = "ZOOM";
    public static final String time = "TIME";
    public static final String option = "OPTION";
    public static final String config = "CONFIG";
    public static final String reset = "RESET";
    private int timePrecision = 0;
    protected int minRefreshInterval = 0;
    private boolean manageIntervalTrend = false;
    private long currentTime = 0L;
    private long oldCurrentTime = 0L;
    protected JToolBar panelToolBarTrend;
    protected JToolBar panelToolBar;
    protected JButton timeButtonTrend;
    protected JButton refreshButton;
    protected JMenuItem timeMenuTrendI;
    protected JMenuItem refreshMenuI;
    protected int minRefreshTrendInterval = 0;
    private int refreshIntervalTrend = 1000;
    protected boolean offLineMode = false;
    protected DevSource listSource = DevSource.CACHE_DEV;
    protected ErrorHistory errWin;
    static String[] exts = new String[]{"trendSettings"};
    private Vector<JDWAttribute> dvs = null;

    public Trend(JFrame parent) {
        this();
        this.parent = parent;
        this.theGraph.setFrameParent(parent);
    }

    public Trend() {
        this.buttonMap = new HashMap();
        this.theToolBar = new JToolBar();
        this.toolMenu = new JPopupMenu();
        this.optionButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_settings.gif")));
        this.optionButton.setToolTipText("Global settings");
        this.optionMenuI = new JMenuItem("Global settings");
        this.stopIcon = new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_stop.gif"));
        this.startIcon = new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_start.gif"));
        this.startStopButton = new JButton(this.startIcon);
        this.startStopButton.setToolTipText("Start monitoring");
        this.startStopMenuI = new JMenuItem("Start monitoring");
        this.startStopMenuI.addActionListener(this);
        this.loadButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_load.gif")));
        this.loadButton.setToolTipText("Load configuration");
        this.loadMenuI = new JMenuItem("Load configuration");
        this.saveButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_save.gif")));
        this.saveButton.setToolTipText("Save configuration");
        this.saveMenuI = new JMenuItem("Save configuration");
        this.zoomButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_zoom.gif")));
        this.zoomButton.setToolTipText("Zoom");
        this.zoomMenuI = new JMenuItem("Zoom");
        this.timeButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_time.gif")));
        this.timeButton.setToolTipText("Set refresh interval");
        this.timeMenuI = new JMenuItem("Set refresh interval");
        this.sourceMenuI = new JMenu("Source");
        this.sourceDEVMenuI = new JCheckBoxMenuItem("Device");
        this.sourceCACHEMenuI = new JCheckBoxMenuItem("Cache");
        this.sourceCACHEDEVMenuI = new JCheckBoxMenuItem("Cache Device");
        this.sourceCACHEDEVMenuI.setSelected(true);
        this.sourceMenuI.add(this.sourceDEVMenuI);
        this.sourceMenuI.add(this.sourceCACHEMenuI);
        this.sourceMenuI.add(this.sourceCACHEDEVMenuI);
        this.cfgButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_config.gif")));
        this.cfgButton.setToolTipText("Add new attribute");
        this.cfgMenuI = new JMenuItem("Add new attribute");
        this.resetButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_reset.gif")));
        this.resetButton.setToolTipText("Reset trend");
        this.resetMenuI = new JMenuItem("Reset trend");
        this.showtoolMenuI = new JMenuItem("Hide toolbar");
        this.offLineButton = new JCheckBoxMenuItem("Off line mode");
        this.showErrorMenuI = new JMenuItem("View errors");
        this.showDiagMenuI = new JMenuItem("Diagnostic");
        this.theToolBar.setFloatable(true);
        this.loadButton.addActionListener(this);
        this.loadMenuI.addActionListener(this);
        this.saveButton.addActionListener(this);
        this.saveMenuI.addActionListener(this);
        this.optionButton.addActionListener(this);
        this.optionMenuI.addActionListener(this);
        this.zoomButton.addActionListener(this);
        this.zoomMenuI.addActionListener(this);
        this.startStopButton.addActionListener(this);
        this.timeButton.addActionListener(this);
        this.timeMenuI.addActionListener(this);
        this.cfgButton.addActionListener(this);
        this.cfgMenuI.addActionListener(this);
        this.resetButton.addActionListener(this);
        this.resetMenuI.addActionListener(this);
        this.showtoolMenuI.addActionListener(this);
        this.offLineButton.addActionListener(this);
        this.showErrorMenuI.addActionListener(this);
        this.showDiagMenuI.addActionListener(this);
        this.sourceDEVMenuI.addActionListener(this);
        this.sourceCACHEDEVMenuI.addActionListener(this);
        this.sourceCACHEMenuI.addActionListener(this);
        this.theToolBar.add(this.loadButton);
        this.theToolBar.add(this.saveButton);
        this.theToolBar.add(this.optionButton);
        this.theToolBar.add(this.zoomButton);
        this.theToolBar.add(this.startStopButton);
        this.theToolBar.add(this.timeButton);
        this.theToolBar.add(this.cfgButton);
        this.theToolBar.add(this.resetButton);
        this.buttonMap.put(load, this.loadButton);
        this.buttonMap.put(save, this.saveButton);
        this.buttonMap.put(option, this.optionButton);
        this.buttonMap.put(zoom, this.zoomButton);
        this.buttonMap.put(startStop, this.startStopButton);
        this.buttonMap.put(time, this.timeButton);
        this.buttonMap.put(config, this.cfgButton);
        this.buttonMap.put(reset, this.resetButton);
        this.toolMenu.add(this.loadMenuI);
        this.toolMenu.add(this.saveMenuI);
        this.toolMenu.add(this.optionMenuI);
        this.toolMenu.add(this.zoomMenuI);
        this.toolMenu.add(this.startStopMenuI);
        this.toolMenu.add(this.timeMenuI);
        this.toolMenu.add(this.sourceMenuI);
        this.toolMenu.add(this.cfgMenuI);
        this.toolMenu.add(this.resetMenuI);
        this.toolMenu.add(this.showtoolMenuI);
        this.toolMenu.add(this.offLineButton);
        this.toolMenu.add(this.showErrorMenuI);
        this.toolMenu.add(this.showDiagMenuI);
        this.theGraph = new JLChart();
        this.theGraph.setBorder(new EtchedBorder());
        this.theGraph.setBackground(new Color(180, 180, 180));
        this.theGraph.getY1Axis().setAutoScale(true);
        this.theGraph.getY2Axis().setAutoScale(true);
        this.theGraph.getXAxis().setAutoScale(true);
        this.theGraph.setDisplayDuration(300000.0);
        this.theGraph.addUserAction("chkShow toolbar");
        this.theGraph.addUserAction("chkShow selection tree");
        this.theGraph.addUserAction("chkShow date");
        this.theGraph.addUserAction("Load configuration");
        this.theGraph.addUserAction("Save configuration");
        this.theGraph.addUserAction("View errors");
        this.theGraph.addUserAction("Diagnostic");
        this.theGraph.addJLChartActionListener(this);
        this.theGraph.setJLChartListener(this);
        this.innerPanel = new JPanel();
        this.innerPanel.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.add((Component)this.theToolBar, "North");
        this.innerPanel.add((Component)this.theGraph, "Center");
        this.add((Component)this.innerPanel, "Center");
        this.treeMenu = new JPopupMenu();
        this.addXMenuItem = new JMenuItem("Set to X");
        this.addY1MenuItem = new JMenuItem("Add to Y1");
        this.addY2MenuItem = new JMenuItem("Add to Y2");
        this.removeMenuItem = new JMenuItem("Remove");
        this.showMinAlarmMenuItem = new JCheckBoxMenuItem("Show min alarm");
        this.showMaxAlarmMenuItem = new JCheckBoxMenuItem("Show max alarm");
        this.optionMenuItem = new JMenuItem("Graphic properties");
        this.attOptionMenuItem = new JMenuItem("Attribute properties");
        this.treeMenu.add(this.addXMenuItem);
        this.treeMenu.add(this.addY1MenuItem);
        this.treeMenu.add(this.addY2MenuItem);
        this.treeMenu.add(this.removeMenuItem);
        this.treeMenu.add(this.showMinAlarmMenuItem);
        this.treeMenu.add(this.showMaxAlarmMenuItem);
        this.treeMenu.add(this.optionMenuItem);
        this.treeMenu.add(this.attOptionMenuItem);
        this.setManageIntervalTrend();
        if (this.manageIntervalTrend) {
            this.initTrendRefresher();
        }
        this.addXMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TrendSelectionNode selNode = (TrendSelectionNode)Trend.this.mainTree.getSelectionPath().getLastPathComponent();
                INumberScalar m = selNode.getModel();
                if (m != null) {
                    int i = 0;
                    boolean found = false;
                    Vector dv = Trend.this.rootNode.getSelectableItems();
                    TrendSelectionNode n = null;
                    while (!found && i < dv.size()) {
                        n = (TrendSelectionNode)dv.get(i);
                        found = n.getSelected() == 1;
                        if (found) continue;
                        ++i;
                    }
                    if (found) {
                        n.setSelected(0);
                    }
                    selNode.setSelected(1);
                    Trend.this.mainTree.repaint();
                    Trend.this.theGraph.repaint();
                }
            }
        });
        this.addY1MenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreePath[] selPaths = Trend.this.mainTree.getSelectionPaths();
                for (int i = 0; i < selPaths.length; ++i) {
                    TrendSelectionNode selNode = (TrendSelectionNode)selPaths[i].getLastPathComponent();
                    if (!selNode.hasModel() || selNode.getSelected() == 2) continue;
                    selNode.setSelected(2);
                }
                Trend.this.mainTree.repaint();
                Trend.this.theGraph.repaint();
            }
        });
        this.addY2MenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreePath[] selPaths = Trend.this.mainTree.getSelectionPaths();
                for (int i = 0; i < selPaths.length; ++i) {
                    TrendSelectionNode selNode = (TrendSelectionNode)selPaths[i].getLastPathComponent();
                    if (!selNode.hasModel() || selNode.getSelected() == 3) continue;
                    selNode.setSelected(3);
                }
                Trend.this.mainTree.repaint();
                Trend.this.theGraph.repaint();
            }
        });
        this.removeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreePath[] selPaths = Trend.this.mainTree.getSelectionPaths();
                for (int i = 0; i < selPaths.length; ++i) {
                    TrendSelectionNode selNode = (TrendSelectionNode)selPaths[i].getLastPathComponent();
                    if (!selNode.hasModel() || selNode.getSelected() == 0) continue;
                    selNode.setSelected(0);
                }
                Trend.this.mainTree.repaint();
                Trend.this.theGraph.repaint();
            }
        });
        this.showMinAlarmMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreePath[] selPaths = Trend.this.mainTree.getSelectionPaths();
                for (int i = 0; i < selPaths.length; ++i) {
                    TrendSelectionNode selNode = (TrendSelectionNode)selPaths[i].getLastPathComponent();
                    if (selNode.getModel() == null) continue;
                    if (Trend.this.showMinAlarmMenuItem.isSelected()) {
                        selNode.showMinAlarm();
                        continue;
                    }
                    selNode.hideMinAlarm();
                }
                Trend.this.mainTree.repaint();
                Trend.this.theGraph.repaint();
            }
        });
        this.showMaxAlarmMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreePath[] selPaths = Trend.this.mainTree.getSelectionPaths();
                for (int i = 0; i < selPaths.length; ++i) {
                    TrendSelectionNode selNode = (TrendSelectionNode)selPaths[i].getLastPathComponent();
                    if (selNode.getModel() == null) continue;
                    if (Trend.this.showMaxAlarmMenuItem.isSelected()) {
                        selNode.showMaxAlarm();
                        continue;
                    }
                    selNode.hideMaxAlarm();
                }
                Trend.this.mainTree.repaint();
                Trend.this.theGraph.repaint();
            }
        });
        this.optionMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TrendSelectionNode selNode = (TrendSelectionNode)Trend.this.mainTree.getSelectionPath().getLastPathComponent();
                if (selNode.hasModel()) {
                    selNode.showOptions();
                }
            }
        });
        this.attOptionMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TrendSelectionNode selNode = (TrendSelectionNode)Trend.this.mainTree.getSelectionPath().getLastPathComponent();
                INumberScalar m = selNode.getModel();
                if (m == null) {
                    m = selNode.getEnumModel();
                }
                if (m == null) {
                    m = selNode.getBooleanModel();
                }
                if (m == null) {
                    m = selNode.getDevStateModel();
                }
                if (m == null) {
                    m = selNode.getSpectrumModel();
                }
                if (m != null) {
                    if (Trend.this.propFrame == null) {
                        Trend.this.propFrame = new SimplePropertyFrame();
                    }
                    Trend.this.propFrame.setModel((IAttribute)m);
                    Trend.this.propFrame.setVisible(true);
                }
            }
        });
        calendar.setTimeInMillis(System.currentTimeMillis());
        this.dateLabel = new JLabel();
        this.dateLabel.setText(genFormat.format(calendar.getTime()));
        this.dateLabel.setHorizontalAlignment(0);
        this.dateLabel.setVisible(false);
        this.add((Component)this.dateLabel, "South");
        this.errWin = new ErrorHistory();
    }

    @Override
    public String[] clickOnChart(JLChartEvent e) {
        TrendSelectionNode node = this.getNodeForDataView(e.searchResult.dataView);
        if (node != null && node.getDevStateModel() != null) {
            int state = (int)(e.searchResult.value.y + 0.5);
            String[] str = new String[]{e.searchResult.dataView.getExtendedName() + " " + e.searchResult.axis.getAxeName(), "Time= " + JLAxis.formatTimeValue(e.searchResult.value.x), "Y= " + state + "(" + Device.toString((DevState)DevState.from_int((int)state)) + ")"};
            return str;
        }
        return this.theGraph.buildPanelString(e.searchResult);
    }

    void refreshNode(TrendSelectionNode n) {
        this.theGraph.repaint();
        this.mainTreeModel.nodeChanged(n);
    }

    private void initTrendRefresher() {
        this.panelToolBar = new JToolBar();
        this.panelToolBarTrend = new JToolBar();
        this.timeButtonTrend = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_refresh_time.png")));
        this.timeButtonTrend.setToolTipText("Set refresh interval Trend");
        this.timeMenuTrendI = new JMenuItem("Set refresh interval Trend");
        this.refreshButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_refresh.png")));
        this.refreshButton.setToolTipText("Refresh trend");
        this.refreshMenuI = new JMenuItem("Refresh trend");
        this.timeButtonTrend.addActionListener(this);
        this.timeMenuTrendI.addActionListener(this);
        this.refreshButton.addActionListener(this);
        this.panelToolBar.setFloatable(false);
        this.panelToolBarTrend.setFloatable(false);
        this.panelToolBar.add(this.loadButton);
        this.panelToolBar.add(this.saveButton);
        this.panelToolBar.add(this.optionButton);
        this.panelToolBar.add(this.zoomButton);
        this.panelToolBar.add(this.startStopButton);
        this.panelToolBar.add(this.timeButton);
        this.panelToolBar.add(this.cfgButton);
        this.panelToolBar.add(this.resetButton);
        this.panelToolBarTrend.add(this.timeButtonTrend);
        this.panelToolBarTrend.add(this.refreshButton);
        this.theToolBar.setLayout(new BorderLayout());
        this.theToolBar.add((Component)this.panelToolBar, "West");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.panelToolBarTrend, "Center");
        this.theToolBar.add((Component)jPanel, "East");
        this.buttonMap.put(reset, this.refreshButton);
        this.toolMenu.add(this.timeMenuTrendI);
    }

    private void setSource(DevSource source) {
        if (this.attList != null) {
            try {
                this.attList.setSource(source);
                this.sourceDEVMenuI.setSelected(source == DevSource.DEV);
                this.sourceCACHEDEVMenuI.setSelected(source == DevSource.CACHE_DEV);
                this.sourceCACHEMenuI.setSelected(source == DevSource.CACHE);
            }
            catch (ATKException e) {
                ErrorPane.showErrorMessage((Component)this, "Trend (SetSource)", e);
            }
            this.listSource = source;
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object o = evt.getSource();
        if (o == this.optionButton || o == this.optionMenuI) {
            this.optionButtonActionPerformed();
        } else if (o == this.startStopButton || o == this.startStopMenuI) {
            if (this.attList != null) {
                if (this.attList.isRefresherStarted()) {
                    this.attList.stopRefresher();
                } else {
                    this.attList.startRefresher();
                }
            }
        } else if (o == this.loadButton || o == this.loadMenuI) {
            this.loadButtonActionPerformed();
        } else if (o == this.saveButton || o == this.saveMenuI) {
            this.saveButtonActionPerformed();
        } else if (o == this.zoomButton || o == this.zoomMenuI) {
            this.theGraph.enterZoom();
        } else if (o == this.timeButton || o == this.timeMenuI) {
            this.setRefreshInterval();
        } else if (o == this.cfgButton || o == this.cfgMenuI) {
            if (this.cfgPanel == null) {
                Window w = ATKGraphicsUtils.getWindowForComponent(this);
                this.cfgPanel = w instanceof Frame ? new ConfigPanel((Frame)w, this) : (w instanceof Dialog ? new ConfigPanel((Dialog)w, this) : new ConfigPanel((Frame)null, this));
            }
            this.cfgPanel.showPanel();
        } else if (o == this.showtoolMenuI) {
            boolean b = this.isButtonBarVisible();
            b = !b;
            this.setButtonBarVisible(b);
        } else if (o == this.resetButton || o == this.resetMenuI) {
            this.resetTrend();
        } else if (o == this.refreshButton || o == this.refreshButton) {
            this.refreshTrend();
        } else if (o == this.timeButtonTrend || o == this.timeMenuTrendI) {
            this.setRefreshIntervalTrend();
        } else if (o == this.offLineButton) {
            this.setOffLineMode(this.offLineButton.isSelected());
        } else if (o == this.showErrorMenuI) {
            ATKGraphicsUtils.centerFrameOnScreen(this.errWin);
            this.errWin.setVisible(true);
        } else if (o == this.showDiagMenuI) {
            ATKDiagnostic.showDiagnostic();
        } else if (o == this.sourceDEVMenuI) {
            this.setSource(DevSource.DEV);
        } else if (o == this.sourceCACHEDEVMenuI) {
            this.setSource(DevSource.CACHE_DEV);
        } else if (o == this.sourceCACHEMenuI) {
            this.setSource(DevSource.CACHE);
        }
    }

    @Override
    public void actionPerformed(JLChartActionEvent evt) {
        if (evt.getName().equals("Show toolbar")) {
            this.setButtonBarVisible(evt.getState());
        } else if (evt.getName().equals("Show selection tree")) {
            this.setSelectionTreeVisible(evt.getState());
        } else if (evt.getName().equals("Show date")) {
            this.setDateVisible(evt.getState());
        } else if (evt.getName().equalsIgnoreCase("Load configuration")) {
            this.loadButtonActionPerformed();
        } else if (evt.getName().equalsIgnoreCase("Save configuration")) {
            this.saveButtonActionPerformed();
        } else if (evt.getName().equalsIgnoreCase("View errors")) {
            ATKGraphicsUtils.centerFrameOnScreen(this.errWin);
            this.errWin.setVisible(true);
        } else if (evt.getName().equalsIgnoreCase("Diagnostic")) {
            ATKDiagnostic.showDiagnostic();
        }
    }

    @Override
    public boolean getActionState(JLChartActionEvent evt) {
        if (evt.getName().equals("Show toolbar")) {
            return this.isButtonBarVisible();
        }
        if (evt.getName().equals("Show selection tree")) {
            return this.isSelectionTreeVisible();
        }
        if (evt.getName().equals("Show date")) {
            return this.isDateVisible();
        }
        return false;
    }

    public int getTimePrecision() {
        return this.timePrecision;
    }

    public void setTimePrecision(int timePrecision) {
        this.timePrecision = timePrecision;
        if (this.theGraph != null) {
            this.theGraph.setTimePrecision(timePrecision);
        }
    }

    public void refreshStep() {
        if (this.isDateVisible()) {
            calendar.setTimeInMillis(System.currentTimeMillis());
            this.dateLabel.setText(genFormat.format(calendar.getTime()));
        }
        if (this.theGraph.getXAxis().getPercentScrollback() == 0.0 && !this.offLineMode) {
            if (!this.manageIntervalTrend) {
                this.theGraph.repaint();
            } else {
                this.currentTime = System.currentTimeMillis();
                if (this.currentTime - this.oldCurrentTime > (long)this.getRefreshIntervalTrend()) {
                    this.theGraph.repaint();
                    this.oldCurrentTime = this.currentTime;
                }
            }
        }
    }

    public void stateChange(int state) {
        this.updateStartStopButton();
    }

    public void setOffLineMode(boolean mode) {
        this.offLineMode = mode;
    }

    private void setRefreshInterval() {
        int old_it = this.attList.getRefreshInterval();
        String i = JOptionPane.showInputDialog(this, "Enter refresh interval (ms)", new Integer(old_it));
        if (i != null) {
            try {
                int it = Integer.parseInt(i);
                if (it < this.getMinRefreshInterval()) {
                    JOptionPane.showMessageDialog(this.parent, "Invalid number ! Can not be less than " + this.getMinRefreshInterval(), "Error", 0);
                    return;
                }
                this.attList.setRefreshInterval(it);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this.parent, "Invalid number !", "Error", 0);
            }
        }
    }

    private void setRefreshIntervalTrend() {
        int old_it = this.getRefreshIntervalTrend();
        String i = JOptionPane.showInputDialog(this, "Enter refresh interval Trend (ms)", new Integer(old_it));
        if (i != null) {
            try {
                int it = Integer.parseInt(i);
                if (it < this.getMinRefreshInterval()) {
                    JOptionPane.showMessageDialog(this.parent, "Invalid number ! Can not be less than " + this.getMinRefreshInterval(), "Error", 0);
                    return;
                }
                if (it < this.attList.getRefreshInterval() || it % this.attList.getRefreshInterval() != 0) {
                    JOptionPane.showMessageDialog(this.parent, "Invalid values !\nThe value must be greater and multiple than the refresh interval Values " + this.attList.getRefreshInterval(), "Error", 0);
                } else {
                    this.setRefreshIntervalTrend(it);
                }
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this.parent, "Invalid number !", "Error", 0);
            }
        }
    }

    private void updateModel() {
        this.singleDevice = true;
        if (this.attList != null) {
            int i;
            int sz = this.attList.size();
            if (sz > 1) {
                IAttribute s = (IAttribute)this.attList.get(0);
                String dName = s.getDeviceName();
                for (i = 1; i < sz && this.singleDevice; ++i) {
                    s = (IAttribute)this.attList.get(i);
                    this.singleDevice = dName.equalsIgnoreCase(s.getDeviceName());
                }
            }
            Vector v = this.rootNode.getSelectableItems();
            for (i = 0; i < v.size(); ++i) {
                ((TrendSelectionNode)v.get(i)).refreshNode();
            }
        }
    }

    private void updateStartStopButton() {
        if (this.attList != null) {
            if (this.attList.isRefresherStarted()) {
                this.startStopButton.setIcon(this.stopIcon);
                this.startStopButton.setToolTipText("Stop monitoring");
                this.startStopMenuI.setText("Stop monitoring");
            } else {
                this.startStopButton.setIcon(this.startIcon);
                this.startStopButton.setToolTipText("Start monitoring");
                this.startStopMenuI.setText("Start monitoring");
            }
        }
    }

    public void clearModel() {
        this.setModel((AttributePolledList)null);
    }

    public void setModel(AttributePolledList list) {
        this.setModel(list, null);
    }

    private void setModel(AttributePolledList list, Vector<SpectrumItem> sIdx) {
        int i;
        this.theGraph.unselectAll();
        if (this.attList != null) {
            this.attList.removeErrorListener((IErrorListener)this.errWin);
            this.attList.removeRefresherListener((IRefresherListener)this);
            this.attList.removeListStateListener((IListStateListener)this);
        }
        if (this.rootNode != null) {
            Vector dv = this.rootNode.getSelectableItems();
            for (i = 0; i < dv.size(); ++i) {
                TrendSelectionNode n = (TrendSelectionNode)dv.get(i);
                n.clearModel();
            }
        }
        if (this.lastCreatedList != null) {
            this.lastCreatedList.stopRefresher();
            this.lastCreatedList.clear();
            this.lastCreatedList = null;
        }
        if (this.treeView != null) {
            this.innerPanel.remove(this.treeView);
            this.treeView = null;
        }
        this.rootNode = new TrendSelectionNode(this);
        if (list != null) {
            for (i = 0; i < list.size(); ++i) {
                if (list.get(i) instanceof INumberScalar) {
                    this.lastAdded = this.rootNode.addItem(this, (INumberScalar)list.get(i), defaultColor[i % defaultColor.length]);
                }
                if (list.get(i) instanceof IBooleanScalar) {
                    this.lastAdded = this.rootNode.addItem(this, (IBooleanScalar)list.get(i), defaultColor[i % defaultColor.length]);
                }
                if (list.get(i) instanceof IDevStateScalar) {
                    this.lastAdded = this.rootNode.addItem(this, (IDevStateScalar)list.get(i), defaultColor[i % defaultColor.length]);
                }
                if (list.get(i) instanceof IEnumScalar) {
                    this.lastAdded = this.rootNode.addItem(this, (IEnumScalar)list.get(i), defaultColor[i % defaultColor.length]);
                }
                if (!(list.get(i) instanceof INumberSpectrum) || sIdx == null) continue;
                for (int j = 0; j < sIdx.get((int)i).items.size(); ++j) {
                    int idx = sIdx.get((int)i).items.get(j);
                    this.lastAdded = this.rootNode.addItem(this, (INumberSpectrum)list.get(i), idx, defaultColor[i % defaultColor.length]);
                }
            }
        }
        TrendRenderer renderer = new TrendRenderer();
        this.mainTreeModel = new DefaultTreeModel(this.rootNode);
        this.mainTree = new JTree(this.mainTreeModel);
        this.mainTree.setCellRenderer(renderer);
        this.mainTree.setEditable(false);
        this.mainTree.getSelectionModel().setSelectionMode(4);
        this.mainTree.setShowsRootHandles(true);
        this.mainTree.setRootVisible(true);
        this.mainTree.setBorder(BorderFactory.createLoweredBevelBorder());
        this.treeView = new JScrollPane(this.mainTree);
        this.mainTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Trend.this.revalidate();
                int selRow = Trend.this.mainTree.getRowForLocation(e.getX(), e.getY());
                TreePath[] selPaths = Trend.this.mainTree.getSelectionPaths();
                if (selRow != -1 && e.getClickCount() == 1 && e.getButton() == 3 && selPaths != null && selPaths.length > 0) {
                    if (selPaths.length == 1) {
                        TrendSelectionNode selNode = (TrendSelectionNode)selPaths[0].getLastPathComponent();
                        if (selNode.hasModel()) {
                            Trend.this.addXMenuItem.setEnabled(selNode.getSelected() != 1);
                            Trend.this.addY1MenuItem.setEnabled(selNode.getSelected() != 2);
                            Trend.this.addY2MenuItem.setEnabled(selNode.getSelected() != 3);
                            Trend.this.removeMenuItem.setEnabled(selNode.getSelected() != 0);
                            Trend.this.showMinAlarmMenuItem.setSelected(selNode.isShowingMinAlarm());
                            Trend.this.showMaxAlarmMenuItem.setSelected(selNode.isShowingMaxAlarm());
                            Trend.this.treeMenu.show(Trend.this.mainTree, e.getX(), e.getY());
                        } else if (selNode == Trend.this.rootNode) {
                            if (Trend.this.isButtonBarVisible()) {
                                Trend.this.showtoolMenuI.setText("Hide toolbar");
                            } else {
                                Trend.this.showtoolMenuI.setText("Show toolbar");
                            }
                            Trend.this.toolMenu.show(Trend.this.mainTree, e.getX(), e.getY());
                        }
                    } else {
                        TrendSelectionNode lastAttributeNode = null;
                        int attributeCount = 0;
                        boolean containsRootNode = false;
                        for (int i = 0; i < selPaths.length; ++i) {
                            TrendSelectionNode selNode = (TrendSelectionNode)selPaths[i].getLastPathComponent();
                            if (selNode.getModel() != null) {
                                ++attributeCount;
                                lastAttributeNode = selNode;
                                continue;
                            }
                            if (selNode != Trend.this.rootNode) continue;
                            containsRootNode = true;
                        }
                        if (attributeCount > 0) {
                            if (attributeCount == 1) {
                                Trend.this.addXMenuItem.setEnabled(lastAttributeNode.getSelected() != 1);
                                Trend.this.addY1MenuItem.setEnabled(lastAttributeNode.getSelected() != 2);
                                Trend.this.addY2MenuItem.setEnabled(lastAttributeNode.getSelected() != 3);
                                Trend.this.removeMenuItem.setEnabled(lastAttributeNode.getSelected() != 0);
                                Trend.this.showMinAlarmMenuItem.setSelected(lastAttributeNode.isShowingMinAlarm());
                                Trend.this.showMaxAlarmMenuItem.setSelected(lastAttributeNode.isShowingMaxAlarm());
                            } else {
                                Trend.this.addXMenuItem.setEnabled(false);
                                Trend.this.addY1MenuItem.setEnabled(true);
                                Trend.this.addY2MenuItem.setEnabled(true);
                                Trend.this.removeMenuItem.setEnabled(true);
                                Trend.this.showMinAlarmMenuItem.setSelected(false);
                                Trend.this.showMaxAlarmMenuItem.setSelected(false);
                            }
                            Trend.this.treeMenu.show(Trend.this.mainTree, e.getX(), e.getY());
                            lastAttributeNode = null;
                        } else if (containsRootNode) {
                            if (Trend.this.isButtonBarVisible()) {
                                Trend.this.showtoolMenuI.setText("Hide toolbar");
                            } else {
                                Trend.this.showtoolMenuI.setText("Show toolbar");
                            }
                            Trend.this.toolMenu.show(Trend.this.mainTree, e.getX(), e.getY());
                        }
                    }
                }
            }
        });
        this.innerPanel.add((Component)this.treeView, "West");
        this.innerPanel.revalidate();
        this.attList = list;
        if (this.attList != null) {
            this.attList.addRefresherListener((IRefresherListener)this);
            this.attList.addListStateListener((IListStateListener)this);
            this.attList.addErrorListener((IErrorListener)this.errWin);
        }
        this.updateStartStopButton();
        this.updateModel();
    }

    private int getIndex(String attName) {
        String[] splitted = attName.split("/");
        if (splitted.length == 5) {
            try {
                return Integer.parseInt(splitted[4]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    private String getAttName(String attName) {
        return attName.substring(0, attName.lastIndexOf(47));
    }

    public void addAttribute(String name) {
        int sIdx = this.getIndex(name);
        if (sIdx >= 0) {
            name = this.getAttName(name);
        }
        try {
            IAttribute att;
            if (this.attList == null) {
                AttributePolledList alist = new AttributePolledList();
                alist.add(name);
                SpectrumItem it = new SpectrumItem(name);
                it.addItem(sIdx);
                Vector<SpectrumItem> itv = new Vector<SpectrumItem>();
                itv.add(it);
                this.setModel(alist, itv);
                this.lastCreatedList = alist;
                alist.setRefreshInterval(1000);
                alist.startRefresher();
            } else if (this.attList.get(name) == null) {
                att = (IAttribute)this.attList.add(name);
                int i = this.attList.size();
                if (att instanceof INumberSpectrum) {
                    INumberSpectrum nscalar = (INumberSpectrum)this.attList.add(name);
                    this.lastAdded = this.rootNode.addItem(this, nscalar, sIdx, defaultColor[i % defaultColor.length]);
                } else if (att instanceof IBooleanScalar) {
                    IBooleanScalar bscalar = (IBooleanScalar)this.attList.add(name);
                    this.lastAdded = this.rootNode.addItem(this, bscalar, defaultColor[i % defaultColor.length]);
                } else if (att instanceof IDevStateScalar) {
                    IDevStateScalar stscalar = (IDevStateScalar)this.attList.add(name);
                    this.lastAdded = this.rootNode.addItem(this, stscalar, defaultColor[i % defaultColor.length]);
                } else if (att instanceof IEnumScalar) {
                    IEnumScalar escalar = (IEnumScalar)this.attList.add(name);
                    this.lastAdded = this.rootNode.addItem(this, escalar, defaultColor[i % defaultColor.length]);
                } else {
                    INumberScalar scalar = (INumberScalar)this.attList.add(name);
                    this.lastAdded = this.rootNode.addItem(this, scalar, defaultColor[i % defaultColor.length]);
                }
                this.mainTreeModel = new DefaultTreeModel(this.rootNode);
                this.mainTree.setModel(this.mainTreeModel);
            } else if (sIdx >= 0 && (att = this.attList.get(name)) instanceof INumberSpectrum) {
                int i = this.attList.size();
                this.lastAdded = this.rootNode.addItem(this, (INumberSpectrum)att, sIdx, defaultColor[i % defaultColor.length]);
                this.mainTreeModel = new DefaultTreeModel(this.rootNode);
                this.mainTree.setModel(this.mainTreeModel);
            }
            TreePath np = new TreePath(this.lastAdded.getPath());
            this.mainTree.setSelectionPath(np);
            this.mainTree.expandPath(np);
            this.mainTree.makeVisible(np);
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
        this.updateModel();
        this.theGraph.repaint();
        this.innerPanel.revalidate();
    }

    public void addAttribute(INumberScalar scalar) {
        if (this.attList == null) {
            AttributePolledList alist = new AttributePolledList();
            alist.add((IEntity)scalar);
            this.setModel(alist);
            this.lastCreatedList = alist;
            alist.setRefreshInterval(1000);
            alist.startRefresher();
        } else if (!this.attList.contains((Object)scalar)) {
            this.attList.add((IEntity)scalar);
            int i = this.attList.size();
            this.lastAdded = this.rootNode.addItem(this, scalar, defaultColor[i % defaultColor.length]);
            this.mainTreeModel = new DefaultTreeModel(this.rootNode);
            this.mainTree.setModel(this.mainTreeModel);
        }
        TreePath np = new TreePath(this.lastAdded.getPath());
        this.mainTree.setSelectionPath(np);
        this.mainTree.expandPath(np);
        this.mainTree.makeVisible(np);
        this.updateModel();
        this.theGraph.repaint();
        this.innerPanel.revalidate();
    }

    public void removeAttribute(INumberScalar scalar) {
        this.lastAdded = null;
        if (this.attList.contains((Object)scalar)) {
            System.out.println("Removing " + scalar.getName());
            this.rootNode.delItem(scalar);
            this.attList.remove(scalar.getName());
            this.mainTreeModel = new DefaultTreeModel(this.rootNode);
            this.mainTree.setModel(this.mainTreeModel);
            this.innerPanel.revalidate();
            this.updateModel();
        }
    }

    public void setModel(INumberScalar scalar) {
        throw new IllegalStateException("Please use addAttribute() instead of setModel() ");
    }

    public AttributePolledList getModel() {
        return this.attList;
    }

    private void optionButtonActionPerformed() {
        this.theGraph.showOptionDialog();
    }

    private void saveButtonActionPerformed() {
        File f;
        int returnVal;
        int ok = 0;
        JFileChooser chooser = new JFileChooser(".");
        chooser.addChoosableFileFilter(new MultiExtFileFilter("Text files", "txt", new String[0]));
        if (this.lastConfig.length() > 0) {
            chooser.setSelectedFile(new File(this.lastConfig));
        }
        if ((returnVal = chooser.showSaveDialog(this.parent)) == 0 && (f = chooser.getSelectedFile()) != null) {
            if (MultiExtFileFilter.getExtension(f) == null) {
                f = new File(f.getAbsolutePath() + ".txt");
            }
            if (f.exists()) {
                ok = JOptionPane.showConfirmDialog(this.parent, "Do you want to overwrite " + f.getName() + " ?", "Confirm overwrite", 0);
            }
            if (ok == 0) {
                this.saveSetting(f.getAbsolutePath());
            }
        }
    }

    private void loadButtonActionPerformed() {
        String err;
        File f;
        int returnVal;
        boolean ok = false;
        JFileChooser chooser = new JFileChooser(".");
        chooser.addChoosableFileFilter(new MultiExtFileFilter("Text files", "txt", new String[0]));
        if (this.lastConfig.length() > 0) {
            chooser.setSelectedFile(new File(this.lastConfig));
        }
        if ((returnVal = chooser.showOpenDialog(this.parent)) == 0 && (f = chooser.getSelectedFile()) != null && !ok && (err = this.loadSetting(f.getAbsolutePath())).length() > 0) {
            JOptionPane.showMessageDialog(this.parent, err, "Errors reading " + f.getName(), 0);
        }
    }

    public String getSettings() {
        return this.getSettings(false);
    }

    public String getSettings(boolean forJDraw) {
        Object to_write = "";
        to_write = (String)to_write + this.theGraph.getConfiguration();
        to_write = (String)to_write + "toolbar_visible:" + this.isButtonBarVisible() + "\n";
        to_write = (String)to_write + "tree_visible:" + this.isSelectionTreeVisible() + "\n";
        to_write = (String)to_write + "date_visible:" + this.isDateVisible() + "\n";
        if (!forJDraw) {
            if (this.graphTitle.length() > 0) {
                to_write = (String)to_write + "frame_title:'" + this.graphTitle + "'\n";
            }
            to_write = (String)to_write + "window_pos:" + this.getLocationOnScreen().x + "," + this.getLocationOnScreen().y + "\n";
            to_write = (String)to_write + "window_size:" + this.getSize().width + "," + this.getSize().height + "\n";
        }
        to_write = (String)to_write + "show_device_name:" + this.isShowingDeviceNames() + "\n";
        if (this.attList != null) {
            to_write = (String)to_write + "refresh_time:" + this.attList.getRefreshInterval() + "\n";
            to_write = (String)to_write + "source:" + this.listSource.value() + "\n";
        }
        to_write = (String)to_write + "min_refresh_time:" + this.getMinRefreshInterval() + "\n";
        to_write = (String)to_write + this.theGraph.getXAxis().getConfiguration("x");
        to_write = (String)to_write + this.theGraph.getY1Axis().getConfiguration("y1");
        to_write = (String)to_write + this.theGraph.getY2Axis().getConfiguration("y2");
        if (forJDraw) {
            to_write = (String)to_write + "dv_number:" + this.dvs.size() + "\n";
            for (int i = 0; i < this.dvs.size(); ++i) {
                to_write = (String)to_write + "dv" + i + "_name:'" + this.dvs.get((int)i).attName + "'\n";
                to_write = (String)to_write + "dv" + i + "_selected:" + this.dvs.get((int)i).axis + "\n";
                to_write = (String)to_write + this.dvs.get((int)i).dv.getConfiguration("dv" + i);
            }
            return to_write;
        }
        if (this.rootNode == null) {
            return to_write;
        }
        Vector dv = this.rootNode.getSelectableItems();
        to_write = (String)to_write + "dv_number:" + dv.size() + "\n";
        for (int i = 0; i < dv.size(); ++i) {
            TrendSelectionNode n = (TrendSelectionNode)dv.get(i);
            to_write = (String)to_write + "dv" + i + "_name:'" + n.getModelName() + "'\n";
            to_write = (String)to_write + "dv" + i + "_selected:" + n.getSelected() + "\n";
            to_write = (String)to_write + "dv" + i + "_showminalarm:" + n.isShowingMinAlarm() + "\n";
            to_write = (String)to_write + "dv" + i + "_showmaxalarm:" + n.isShowingMaxAlarm() + "\n";
            to_write = (String)to_write + n.getData().getConfiguration("dv" + i);
            if (n.isShowingMinAlarm()) {
                to_write = (String)to_write + n.getMinAlarmData().getConfiguration("dv_min_alarm" + i);
            }
            if (!n.isShowingMaxAlarm()) continue;
            to_write = (String)to_write + n.getMaxAlarmData().getConfiguration("dv_max_alarm" + i);
        }
        return to_write;
    }

    private String applySettings(CfFileReader f, boolean forJdraw) {
        int j;
        int i;
        int nbDv;
        Object errBuff = "";
        this.theGraph.setDisplayDuration(Double.POSITIVE_INFINITY);
        Vector<String> p = f.getParam("show_device_name");
        if (p != null) {
            this.setShowingDeviceNames(OFormat.getInt(p.get(0).toString()));
        }
        AttributePolledList alist = new AttributePolledList();
        if (!forJdraw) {
            alist.setFilter(new IEntityFilter(){

                public boolean keep(IEntity entity) {
                    if (entity instanceof INumberScalar) {
                        return true;
                    }
                    if (entity instanceof IEnumScalar) {
                        return true;
                    }
                    if (entity instanceof IBooleanScalar) {
                        return true;
                    }
                    if (entity instanceof IDevStateScalar) {
                        return true;
                    }
                    if (entity instanceof INumberSpectrum) {
                        return true;
                    }
                    System.out.println(entity.getName() + " not imported (only NumberScalar, EnumScalar, BooleanScalar or NumberSpectrum!)");
                    return false;
                }
            });
            alist.addErrorListener((IErrorListener)this.errWin);
        }
        if ((p = f.getParam("dv_number")) != null) {
            try {
                nbDv = Integer.parseInt(p.get(0).toString());
            }
            catch (NumberFormatException e) {
                errBuff = (String)errBuff + "dv_number: invalid number\n";
                return errBuff;
            }
            Vector<SpectrumItem> spectrumIDS = new Vector<SpectrumItem>();
            for (i = 0; i < nbDv; ++i) {
                p = f.getParam("dv" + i + "_name");
                if (p == null) {
                    errBuff = (String)errBuff + "Unable to find dv" + i + "_name param\n";
                    return errBuff;
                }
                if (forJdraw) continue;
                try {
                    IEntity entity;
                    String attName = p.get(0).toString();
                    int sIdx = this.getIndex(attName);
                    if (sIdx >= 0) {
                        attName = this.getAttName(attName);
                    }
                    if ((entity = alist.get(attName)) == null) {
                        alist.add(attName);
                        SpectrumItem it = new SpectrumItem(attName);
                        it.addItem(sIdx);
                        spectrumIDS.add(it);
                        continue;
                    }
                    if (!(entity instanceof INumberSpectrum)) continue;
                    boolean found = false;
                    j = 0;
                    while (!found && j < spectrumIDS.size()) {
                        found = spectrumIDS.get((int)j).attName.equalsIgnoreCase(attName);
                        if (found) continue;
                        ++j;
                    }
                    if (!found) {
                        System.out.println("Trend.applySettings() Invalid attribute name " + attName);
                        continue;
                    }
                    spectrumIDS.get(j).addItem(sIdx);
                    continue;
                }
                catch (Exception e) {
                    errBuff = (String)errBuff + e.getMessage() + "\n";
                }
            }
            p = f.getParam("min_refresh_time");
            if (p != null) {
                this.setMinRefreshInterval(OFormat.getInt(p.get(0).toString()));
            }
            if (alist.getRefreshInterval() < this.getMinRefreshInterval()) {
                alist.setRefreshInterval(this.getMinRefreshInterval());
            }
            if (nbDv > 0) {
                if (!forJdraw && this.attList != null) {
                    this.innerPanel.remove(this.treeView);
                    this.treeView = null;
                    this.mainTree = null;
                }
                p = f.getParam("refresh_time");
                int refreshInterval = 1000;
                if (p != null) {
                    refreshInterval = OFormat.getInt(p.get(0).toString());
                }
                if (refreshInterval < this.getMinRefreshInterval()) {
                    refreshInterval = this.getMinRefreshInterval();
                }
                alist.setRefreshInterval(refreshInterval);
                if (!forJdraw) {
                    alist.startRefresher();
                    this.setModel(alist, spectrumIDS);
                }
                this.lastCreatedList = alist;
            }
        } else {
            nbDv = 0;
        }
        this.innerPanel.revalidate();
        this.theGraph.applyConfiguration(f);
        p = f.getParam("toolbar_visible");
        if (p != null) {
            this.setButtonBarVisible(OFormat.getBoolean(p.get(0).toString()));
        }
        if ((p = f.getParam("tree_visible")) != null) {
            this.setSelectionTreeVisible(OFormat.getBoolean(p.get(0).toString()));
        }
        if ((p = f.getParam("date_visible")) != null) {
            this.setDateVisible(OFormat.getBoolean(p.get(0).toString()));
        }
        if (!forJdraw) {
            p = f.getParam("frame_title");
            if (p != null) {
                this.graphTitle = p.get(0).toString();
                if (this.parent != null) {
                    this.parent.setTitle(this.graphTitle);
                }
            }
            if ((p = f.getParam("window_pos")) != null) {
                framePos = OFormat.getPoint(p);
            }
            if ((p = f.getParam("window_size")) != null) {
                frameDimension = OFormat.getPoint(p);
            }
        }
        if ((p = f.getParam("source")) != null) {
            this.listSource = DevSource.from_int((int)OFormat.getInt(p.get(0).toString()));
            this.setSource(this.listSource);
        }
        this.theGraph.getXAxis().applyConfiguration("x", f);
        this.theGraph.getY1Axis().applyConfiguration("y1", f);
        this.theGraph.getY2Axis().applyConfiguration("y2", f);
        if (!forJdraw) {
            if (this.rootNode == null) {
                return errBuff;
            }
            Vector dv = this.rootNode.getSelectableItems();
            TrendSelectionNode n = null;
            for (i = 0; i < nbDv; ++i) {
                String pref = "dv" + i;
                p = f.getParam(pref + "_name");
                String attName = p.get(0).toString();
                p = f.getParam(pref + "_selected");
                if (p == null) continue;
                int s = OFormat.getInt(p.get(0).toString());
                j = 0;
                boolean found = false;
                while (!found && j < dv.size()) {
                    n = (TrendSelectionNode)dv.get(j);
                    found = n.getModelName().equals(attName);
                    if (found) continue;
                    ++j;
                }
                if (!found) continue;
                if (s > 0) {
                    n.setSelected(s);
                }
                JLDataView d = n.getData();
                d.applyConfiguration(pref, f);
                p = f.getParam(pref + "_showminalarm");
                if (p != null) {
                    boolean showMinAlarm = OFormat.getBoolean(p.get(0).toString());
                    if (showMinAlarm) {
                        n.showMinAlarm();
                        String prefMinAlarm = "dv_min_alarm" + i;
                        n.getMinAlarmData().applyConfiguration(prefMinAlarm, f);
                    } else {
                        n.hideMinAlarm();
                    }
                }
                if ((p = f.getParam(pref + "_showmaxalarm")) == null) continue;
                boolean showMaxAlarm = OFormat.getBoolean(p.get(0).toString());
                if (showMaxAlarm) {
                    n.showMaxAlarm();
                    String prefMaxAlarm = "dv_max_alarm" + i;
                    n.getMaxAlarmData().applyConfiguration(prefMaxAlarm, f);
                    continue;
                }
                n.hideMaxAlarm();
            }
        } else {
            Vector<JDWAttribute> ndvs = new Vector<JDWAttribute>();
            for (i = 0; i < nbDv; ++i) {
                int s;
                String pref = "dv" + i;
                p = f.getParam(pref + "_name");
                String attName = p.get(0).toString();
                p = f.getParam(pref + "_selected");
                if (p != null) {
                    s = OFormat.getInt(p.get(0).toString());
                    if (s < 0 || s > 3) {
                        return pref + "_selected, invalid use: 0 for none, 1 for X,2 for Y1,3 for Y2";
                    }
                } else {
                    return pref + "_selected, not found";
                }
                JDWAttribute item = new JDWAttribute();
                item.axis = s;
                item.attName = attName;
                item.dv = new JLDataView();
                item.dv.applyConfiguration(pref, f);
                ndvs.add(item);
            }
            this.dvs = ndvs;
        }
        return errBuff;
    }

    public String setSetting(String txt) {
        return this.setSetting(txt, false);
    }

    public String setSetting(String txt, boolean forJdraw) {
        CfFileReader f = new CfFileReader();
        if (!f.parseText(txt)) {
            return "Trend.setSettings: Failed to parse given text";
        }
        return this.applySettings(f, forJdraw);
    }

    public void saveSetting(String filename) {
        try {
            FileWriter f = new FileWriter(filename);
            String s = this.getSettings();
            f.write(s, 0, s.length());
            f.close();
            this.lastConfig = filename;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.parent, "Failed to write " + filename, "Error", 0);
        }
    }

    public String loadSetting(String filename) {
        CfFileReader f = new CfFileReader();
        if (!f.readFile(filename)) {
            return "Failed to read " + filename;
        }
        this.lastConfig = filename;
        return this.applySettings(f, false);
    }

    public String getTitle() {
        return this.graphTitle;
    }

    public void setLegendVisible(boolean b) {
    }

    public boolean isLegendVisible() {
        return false;
    }

    public void setSamplingRate(double rate) {
    }

    public double getSamplingRate() {
        return 0.0;
    }

    public void setXAxisLength(int length) {
    }

    public int getXAxisLength() {
        return 0;
    }

    public void setLogarithmicScale(boolean logarithmic) {
    }

    public boolean isLogarithmicScale() {
        return false;
    }

    public void setListVisible(boolean b) {
    }

    public boolean isListVisible() {
        return false;
    }

    public void setShowingNames(boolean b) {
    }

    public boolean isShowingNames() {
        return false;
    }

    public void setShowingDeviceNames(int mode) {
        this.isShowingDeviceName = mode;
    }

    public int isShowingDeviceNames() {
        return this.isShowingDeviceName;
    }

    boolean displayDeviceNames() {
        switch (this.isShowingDeviceName) {
            case 2: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        return !this.singleDevice;
    }

    public void setButtonBarVisible(boolean b) {
        if (this.theToolBar != null) {
            this.theToolBar.setVisible(b);
        }
    }

    public boolean isButtonBarVisible() {
        if (this.theToolBar != null) {
            return this.theToolBar.isVisible();
        }
        return false;
    }

    public void setDateVisible(boolean b) {
        if (this.dateLabel != null) {
            this.dateLabel.setVisible(b);
        }
    }

    public boolean isDateVisible() {
        if (this.dateLabel != null) {
            return this.dateLabel.isVisible();
        }
        return false;
    }

    public void setSelectionTreeVisible(boolean b) {
        if (this.treeView != null) {
            this.treeView.setVisible(b);
            this.revalidate();
        }
    }

    public boolean isSelectionTreeVisible() {
        if (this.treeView != null) {
            return this.treeView.isVisible();
        }
        return false;
    }

    public JLChart getChart() {
        return this.theGraph;
    }

    @Override
    public void ok() {
        this.getRootPane().getParent().setVisible(false);
    }

    public void disableButton(String buttonName) {
        JButton b = (JButton)this.buttonMap.get(buttonName);
        if (b != null) {
            b.setEnabled(false);
        }
    }

    public void enableButton(String buttonName) {
        JButton b = (JButton)this.buttonMap.get(buttonName);
        if (b != null) {
            b.setEnabled(true);
        }
    }

    public void addToAxis(String attributeName, int axisSelection, boolean addToModel) {
        if (addToModel) {
            try {
                if (this.getModel() == null) {
                    this.addAttribute(attributeName);
                } else if (this.getModel().get(attributeName) == null) {
                    this.addAttribute(attributeName);
                }
            }
            catch (ClassCastException e) {
                return;
            }
        }
        if (this.rootNode == null) {
            return;
        }
        int i = 0;
        Vector dv = this.rootNode.getSelectableItems();
        TrendSelectionNode attributeNode = null;
        boolean present = false;
        while (!present && i < dv.size()) {
            attributeNode = (TrendSelectionNode)dv.get(i);
            present = attributeNode != null && attributeNode.getModel() != null && attributeNode.getModel().getName().equals(attributeName);
            if (present) continue;
            ++i;
        }
        if (present) {
            switch (axisSelection) {
                case 1: {
                    int j = 0;
                    boolean found = false;
                    TrendSelectionNode nodeSetToX = null;
                    while (!found && j < dv.size()) {
                        nodeSetToX = (TrendSelectionNode)dv.get(j);
                        found = nodeSetToX != null && nodeSetToX.getSelected() == 1;
                        if (found) continue;
                        ++j;
                    }
                    if (found) {
                        nodeSetToX.setSelected(0);
                    }
                }
                case 0: 
                case 2: 
                case 3: {
                    attributeNode.setSelected(axisSelection);
                    this.mainTree.repaint();
                    this.theGraph.repaint();
                }
            }
            return;
        }
    }

    public void addToAxis(INumberScalar attribute, int axisSelection, boolean addToModel) {
        if (addToModel) {
            if (this.getModel() == null) {
                this.addAttribute(attribute);
            } else if (this.getModel().get(attribute.getName()) == null) {
                this.addAttribute(attribute);
            }
        }
        if (this.rootNode == null) {
            return;
        }
        int i = 0;
        Vector dv = this.rootNode.getSelectableItems();
        TrendSelectionNode attributeNode = null;
        boolean present = false;
        while (!present && i < dv.size()) {
            attributeNode = (TrendSelectionNode)dv.get(i);
            present = attributeNode != null && attributeNode.getModel() != null && attributeNode.getModel().getName().equals(attribute.getName());
            if (present) continue;
            ++i;
        }
        if (present) {
            switch (axisSelection) {
                case 1: {
                    int j = 0;
                    boolean found = false;
                    TrendSelectionNode nodeSetToX = null;
                    while (!found && j < dv.size()) {
                        nodeSetToX = (TrendSelectionNode)dv.get(j);
                        found = nodeSetToX != null && nodeSetToX.getSelected() == 1;
                        if (found) continue;
                        ++j;
                    }
                    if (found) {
                        nodeSetToX.setSelected(0);
                    }
                }
                case 0: 
                case 2: 
                case 3: {
                    attributeNode.setSelected(axisSelection);
                    this.mainTree.repaint();
                    this.theGraph.repaint();
                }
            }
            return;
        }
    }

    public int getAxisForAttribute(String attributeName) {
        int selectedAxis = 0;
        if (this.rootNode == null) {
            return selectedAxis;
        }
        int i = 0;
        Vector dv = this.rootNode.getSelectableItems();
        TrendSelectionNode attributeNode = null;
        boolean present = false;
        while (!present && i < dv.size()) {
            attributeNode = (TrendSelectionNode)dv.get(i);
            present = attributeNode != null && attributeNode.getModel() != null && attributeNode.getModel().getName().equals(attributeName);
            if (present) continue;
            ++i;
        }
        if (present) {
            selectedAxis = attributeNode.getSelected();
        }
        return selectedAxis;
    }

    private TrendSelectionNode getNodeForDataView(JLDataView dv) {
        Vector nodes = this.rootNode.getSelectableItems();
        int i = 0;
        boolean found = false;
        while (!found && i < nodes.size()) {
            found = ((TrendSelectionNode)nodes.get(i)).getData() == dv;
            if (found) continue;
            ++i;
        }
        if (found) {
            return (TrendSelectionNode)nodes.get(i);
        }
        return null;
    }

    public JLDataView getDataViewForAttribute(String attributeName) {
        JLDataView selectedData = null;
        if (this.rootNode == null) {
            return selectedData;
        }
        int i = 0;
        Vector dv = this.rootNode.getSelectableItems();
        TrendSelectionNode attributeNode = null;
        boolean present = false;
        while (!present && i < dv.size()) {
            attributeNode = (TrendSelectionNode)dv.get(i);
            present = attributeNode != null && attributeNode.getModel() != null && attributeNode.getModel().getName().equals(attributeName);
            if (present) continue;
            ++i;
        }
        if (present) {
            selectedData = attributeNode.getData();
        }
        return selectedData;
    }

    public void setMaxDisplayDuration(double maxDisplay) {
        this.theGraph.setMaxDisplayDuration(maxDisplay);
    }

    public double getMaxDisplayDuration() {
        return this.theGraph.getMaxDisplayDuration();
    }

    protected int getMinRefreshInterval() {
        return this.minRefreshInterval;
    }

    protected void setMinRefreshInterval(int minRefreshInterval) {
        this.minRefreshInterval = minRefreshInterval;
        if (this.attList != null && this.attList.getRefreshInterval() < minRefreshInterval) {
            this.attList.setRefreshInterval(minRefreshInterval);
        }
    }

    public void resetTrend() {
        if (this.rootNode != null) {
            Vector dv = this.rootNode.getSelectableItems();
            for (int i = 0; i < dv.size(); ++i) {
                TrendSelectionNode n = (TrendSelectionNode)dv.get(i);
                if (n == null || n.getData() == null) continue;
                n.getData().reset();
            }
            this.theGraph.repaint();
        }
    }

    protected int getMinRefreshTrendInterval() {
        return this.minRefreshTrendInterval;
    }

    protected void setMinRefreshTrendInterval(int minRefreshTrendInterval) {
        this.minRefreshTrendInterval = minRefreshTrendInterval;
        if (this.attList != null && this.getRefreshIntervalTrend() < minRefreshTrendInterval) {
            this.setRefreshIntervalTrend(minRefreshTrendInterval);
        }
    }

    public int getRefreshIntervalTrend() {
        return this.refreshIntervalTrend;
    }

    public void setRefreshIntervalTrend(int refreshIntervalTrend) {
        this.refreshIntervalTrend = refreshIntervalTrend;
    }

    public boolean isManageIntervalTrend() {
        return this.manageIntervalTrend;
    }

    public void setManageIntervalTrend() {
        URL tmpUrl = this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend.properties");
        if (tmpUrl != null) {
            this.manageIntervalTrend = true;
        }
    }

    public void refreshTrend() {
        this.theGraph.repaint();
    }

    public static void main(String[] args) throws Exception {
        JFrame f = new JFrame();
        Trend t = new Trend(f);
        f.setTitle("Trends");
        if (args.length > 0) {
            String err = t.loadSetting(args[0]);
            if (err.length() > 0) {
                JOptionPane.showMessageDialog(null, err, "Errors reading " + f.getName(), 0);
            }
        } else {
            AttributePolledList lst = new AttributePolledList();
            t.setModel(lst);
        }
        f.setDefaultCloseOperation(3);
        if (t.getTitle().length() > 0) {
            f.setTitle(t.getTitle());
        }
        f.setContentPane(t);
        Image image = Toolkit.getDefaultToolkit().getImage(t.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_icon.gif"));
        if (image != null) {
            f.setIconImage(image);
        }
        if (args.length > 0) {
            f.pack();
            f.setBounds(Trend.framePos.x, Trend.framePos.y, Trend.frameDimension.x, Trend.frameDimension.y);
        } else {
            t.setPreferredSize(new Dimension(640, 480));
            ATKGraphicsUtils.centerFrameOnScreen(f);
        }
        f.setVisible(true);
    }

    @Override
    public void initForEditing() {
        if (this.dvs == null || this.dvs.size() == 0) {
            this.dvs = new Vector();
            JDWAttribute jdwAtt = new JDWAttribute();
            jdwAtt.attName = "my/device/example/my_attribute";
            jdwAtt.dv = new JLDataView();
            jdwAtt.axis = 2;
            this.dvs.add(jdwAtt);
        }
        this.setPreferredSize(new Dimension(400, 300));
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String[] getExtensionList() {
        return exts;
    }

    @Override
    public boolean setExtendedParam(String name, String value, boolean popupAllowed) {
        if (name.equalsIgnoreCase("trendSettings")) {
            String err;
            if (!((String)value).endsWith("\n")) {
                value = (String)value + "\n";
            }
            if ((err = this.setSetting((String)value, true)).length() > 0) {
                this.showJdrawError(popupAllowed, "graphSettings", err);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getExtendedParam(String name) {
        if (name.equalsIgnoreCase("trendSettings")) {
            return this.getSettings(true);
        }
        return "";
    }

    @Override
    public String getDescription(String extName) {
        return "";
    }

    private void showJdrawError(boolean popup, String paramName, String message) {
        String msg = "Trend: " + paramName + " incorrect.\n" + message;
        if (popup) {
            JOptionPane.showMessageDialog(null, msg, "Error", 0);
        } else {
            System.out.println("Warning, " + msg);
        }
    }

    public int getJDWAttributeNumber() {
        return this.dvs.size();
    }

    public JDWAttribute getJDWAttribute(int idx) {
        return this.dvs.get(idx);
    }
}

