/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.command;

import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.command.VoidVoidCommand;
import fr.esrf.tangoatk.widget.command.VoidVoidCommandViewer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ConfirmCommandViewer
extends VoidVoidCommandViewer {
    protected Component confirmDialParent = null;
    protected String confirmTitle = "Command Execute Confirm Window";
    protected String confirmMessage = "Do you really want to execute this command?\n";
    protected String commandLabel = null;

    public Component getConfirmDialParent() {
        return this.confirmDialParent;
    }

    public void setConfirmDialParent(Component parent) {
        this.confirmDialParent = parent;
    }

    public String getConfirmTitle() {
        return this.confirmTitle;
    }

    public void setConfirmTitle(String title) {
        this.confirmTitle = title;
    }

    public String getConfirmMessage() {
        return this.confirmMessage;
    }

    public void setConfirmMessage(String msg) {
        this.confirmMessage = msg;
    }

    public String getCommandLabel() {
        return this.commandLabel;
    }

    public void setCommandLabel(String cmdLabel) {
        this.commandLabel = cmdLabel;
        if (this.commandLabel == null) {
            this.setText(this.model.getNameSansDevice() + " ...");
        }
    }

    @Override
    public void setModel(ICommand cmd) {
        if (this.model != null) {
            this.setText("command-name ...");
            this.setToolTipText(null);
            this.model = null;
        }
        if (cmd != null && cmd instanceof VoidVoidCommand) {
            this.model = cmd;
            if (this.commandLabel != null) {
                this.setText(this.commandLabel);
            } else {
                this.setText(this.model.getNameSansDevice() + " ...");
            }
            this.setToolTipText(this.model.getDevice().toString());
        }
    }

    @Override
    protected void executeButtonActionPerformed(ActionEvent actionevent) {
        int userAnswer = 1;
        try {
            userAnswer = JOptionPane.showConfirmDialog(this.confirmDialParent, this.confirmMessage, this.confirmTitle, 0);
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        if (userAnswer == 0 && this.model != null) {
            this.model.execute();
        }
    }

    public static void main(String[] args) {
        CommandList cmdl = new CommandList();
        ConfirmCommandViewer ccv = new ConfirmCommandViewer();
        try {
            ICommand ic = (ICommand)cmdl.add("elin/gun/aux/Off");
            String title = "Gun aux OFF command confirmation";
            String msg = "If you turn off the Gun Aux device now, \nnext time when it is turned on it will take 7 minutes for the Gun AUX to heat again.\n\nDo you really want to turn off the Gun AUX?\n";
            ccv.setModel(ic);
            ccv.setConfirmTitle(title);
            ccv.setConfirmMessage(msg);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        JFrame f = new JFrame();
        f.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 5);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        f.getContentPane().add((Component)ccv, gbc);
        ccv.setConfirmDialParent(f);
        f.pack();
        f.setVisible(true);
    }

    @Override
    public String toString() {
        return "{ConfirmCommandViewer}";
    }
}

