/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.command;

import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.command.BooleanVoidCommand;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class OnOffCheckBoxCommandViewer
extends JCheckBox
implements ActionListener,
IErrorListener {
    ICommand cmdModel = null;

    public OnOffCheckBoxCommandViewer() {
        this.addActionListener(this);
    }

    public OnOffCheckBoxCommandViewer(String title) {
        super(title);
        this.addActionListener(this);
    }

    public ICommand getCmdModel() {
        return this.cmdModel;
    }

    public void setCmdModel(ICommand onOffModel) {
        if (this.cmdModel != null) {
            this.cmdModel.removeErrorListener((IErrorListener)this);
            this.cmdModel = null;
            this.setText("");
        }
        if (onOffModel != null && onOffModel instanceof BooleanVoidCommand) {
            this.cmdModel = onOffModel;
            this.setText(onOffModel.getNameSansDevice() + " Off");
            this.cmdModel.addErrorListener((IErrorListener)this);
        }
    }

    public void clearModel() {
        this.setCmdModel(null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String boolStr;
        JCheckBox cb = null;
        Vector<String> inarg = new Vector<String>();
        cb = (JCheckBox)e.getSource();
        if (cb.isSelected()) {
            boolStr = new String("true");
            String textStr = this.getText();
            textStr = textStr.replaceFirst(" Off", " On");
            this.setText(textStr);
        } else {
            boolStr = new String("false");
            String textStr = this.getText();
            textStr = textStr.replaceFirst(" On", " Off");
            this.setText(textStr);
        }
        if (this.cmdModel != null) {
            inarg.add(0, boolStr);
            this.cmdModel.execute(inarg);
        }
    }

    public void errorChange(ErrorEvent e) {
        if (e.getSource() == this.cmdModel) {
            JOptionPane.showMessageDialog(this, "Failed to execute command:\n" + e.getError().getMessage());
        }
    }

    public static void main(String[] args) {
        CommandList commandlist = new CommandList();
        JFrame f = new JFrame();
        JPanel jp = new JPanel();
        OnOffCheckBoxCommandViewer onOff = new OnOffCheckBoxCommandViewer();
        onOff.setBorder(BorderFactory.createEtchedBorder());
        jp.add(onOff);
        try {
            IEntity ie = commandlist.add("sr/Agilent_4395a/1/AveragingOnOff");
            if (ie instanceof BooleanVoidCommand) {
                System.out.println("Oui c'est un booleanVoid command");
            } else {
                System.out.println("Desolee ce n'est pas un booleanVoid command");
            }
            if (ie instanceof ICommand) {
                ICommand ic = (ICommand)ie;
                onOff.setCmdModel(ic);
                onOff.setText("Averaging");
            }
        }
        catch (Exception ex) {
            System.out.println("Cannot connect to sr/agilent/1/AveragingOnOff");
        }
        f.setContentPane(jp);
        f.setDefaultCloseOperation(3);
        f.pack();
        f.setVisible(true);
    }
}

