/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.command;

import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.command.BooleanVoidCommand;
import fr.esrf.tangoatk.widget.util.ThreeStateSwitch;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class OnOffSwitchCommandViewer
extends ThreeStateSwitch
implements ActionListener,
IErrorListener {
    ICommand model = null;

    public OnOffSwitchCommandViewer() {
        this.addActionListener(this);
    }

    public OnOffSwitchCommandViewer(String title, Font tFont) {
        super(title, tFont);
        this.addActionListener(this);
    }

    public ICommand getModel() {
        return this.model;
    }

    public void setModel(ICommand onOffModel) {
        if (this.model != null) {
            this.model.removeErrorListener((IErrorListener)this);
            this.model = null;
        }
        if (onOffModel != null && onOffModel instanceof BooleanVoidCommand) {
            this.model = onOffModel;
            this.model.addErrorListener((IErrorListener)this);
        }
    }

    public void clearModel() {
        this.setModel(null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Vector<String> inarg = new Vector<String>();
        String boolStr = switch (this.getState()) {
            case 1 -> new String("true");
            case 2 -> new String("false");
            case 0 -> new String("false");
            default -> new String("false");
        };
        if (this.model != null) {
            inarg.add(0, boolStr);
            this.model.execute(inarg);
        }
    }

    public void errorChange(ErrorEvent e) {
        if (e.getSource() == this.model) {
            JOptionPane.showMessageDialog(this, "Failed to execute command:\n" + e.getError().getMessage());
        }
    }

    public static void main(String[] args) {
        CommandList commandlist = new CommandList();
        JFrame f = new JFrame();
        JPanel jp = new JPanel();
        OnOffSwitchCommandViewer onOff = new OnOffSwitchCommandViewer();
        onOff.setBorder(BorderFactory.createEtchedBorder());
        jp.add(onOff);
        try {
            IEntity ie = commandlist.add("sr/Agilent_4395a/1/AveragingOnOff");
            if (ie instanceof BooleanVoidCommand) {
                System.out.println("Oui c'est un booleanVoid command");
            } else {
                System.out.println("Desolee ce n'est pas un booleanVoid command");
            }
            if (ie instanceof ICommand) {
                ICommand ic = (ICommand)ie;
                onOff.setModel(ic);
                onOff.setTitle("Averaging");
            }
        }
        catch (Exception ex) {
            System.out.println("Cannot connect to sr/agilent/1/AveragingOnOff");
        }
        f.setContentPane(jp);
        f.setDefaultCloseOperation(3);
        f.pack();
        f.setVisible(true);
    }
}

