/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.command;

import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.command.CommandFactory;
import fr.esrf.tangoatk.widget.command.SimpleCommandButtonViewer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class SettableCommandButtonViewer
extends SimpleCommandButtonViewer {
    protected boolean defaultHelpText = false;
    protected String helpText = "";
    protected String buttonText = "";
    protected boolean askConfirmation = false;
    protected String askConfirmationTitle = "Confirmation";
    protected String askConfirmationText = "Execute command ?";
    protected String errorTitle = "Error";
    protected String errorText = "Can not execute command";
    protected String errorReasonTitle = "Reason:";
    protected String[] commandInput = new String[]{""};
    protected List<String> m_argin = null;
    protected boolean threadedCommand = false;

    public SettableCommandButtonViewer() {
        this.setEnabled(true);
        this.setHorizontalAlignment(0);
    }

    public String getHelpText() {
        return this.helpText;
    }

    public void setHelpText(String helpText) {
        this.helpText = helpText;
        if (this.isDefaultHelpText()) {
            super.setToolTipText(this.getText());
            return;
        }
        if (helpText.equals("")) {
            super.setToolTipText(null);
            return;
        }
        super.setToolTipText(helpText);
    }

    public boolean isDefaultHelpText() {
        return this.defaultHelpText;
    }

    public void setDefaultHelpText(boolean defaultHelpText) {
        this.defaultHelpText = defaultHelpText;
        this.setHelpText(this.helpText);
    }

    public void setCommandInput(String[] input) {
        this.commandInput = input;
        if (input == null || input.length == 0) {
            if (this.m_argin != null) {
                this.m_argin.clear();
            }
            this.m_argin = null;
            return;
        }
        this.m_argin = new Vector<String>();
        for (int i = 0; i < input.length; ++i) {
            if ("".equals(input[i])) {
                this.m_argin.clear();
                this.m_argin = null;
                return;
            }
            this.m_argin.add(input[i]);
        }
    }

    public String[] getCommandInput() {
        return this.commandInput;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.getCommandModel() == null) {
            return;
        }
        int result = 0;
        if (this.askConfirmation) {
            result = JOptionPane.showConfirmDialog(this, this.askConfirmationText, this.askConfirmationTitle, 0);
        }
        if (result == 0) {
            if (this.m_argin != null && this.getCommandModel().takesInput()) {
                if (this.isThreadedCommand()) {
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                SettableCommandButtonViewer.this.getCommandModel().execute(SettableCommandButtonViewer.this.m_argin);
                            }
                            catch (Throwable t) {
                                SettableCommandButtonViewer.this.displayErrorMessage(t, SettableCommandButtonViewer.this.getCommandModel());
                            }
                        }
                    }.start();
                } else {
                    try {
                        this.getCommandModel().execute(this.m_argin);
                    }
                    catch (Throwable t) {
                        this.displayErrorMessage(t, this.getCommandModel());
                    }
                }
            } else {
                super.actionPerformed(event);
            }
        }
    }

    public String getButtonText() {
        return this.buttonText;
    }

    public void setButtonText(String buttonText) {
        this.buttonText = buttonText;
        this.setText(buttonText);
    }

    public boolean isAskConfirmation() {
        return this.askConfirmation;
    }

    public void setAskConfirmation(boolean askConfirmation) {
        this.askConfirmation = askConfirmation;
    }

    public String getAskConfirmationText() {
        return this.askConfirmationText;
    }

    public void setAskConfirmationText(String textAskConfirmation) {
        if (!textAskConfirmation.equals("")) {
            this.askConfirmationText = textAskConfirmation;
        }
    }

    public String getAskConfirmationTitle() {
        return this.askConfirmationTitle;
    }

    public void setAskConfirmationTitle(String titleAskConfirmation) {
        if (!titleAskConfirmation.equals("")) {
            this.askConfirmationTitle = titleAskConfirmation;
        }
    }

    protected void displayErrorMessage(Throwable error, ICommand command) {
        StringBuffer errorMessage = new StringBuffer(this.errorText);
        if (command != null) {
            errorMessage.append(" ").append(command.getName());
        }
        if (error != null) {
            errorMessage.append(this.errorReasonTitle);
            errorMessage.append("\n-").append(error.getClass()).append("-");
            errorMessage.append("\n").append(error.getMessage());
        }
        JOptionPane.showMessageDialog(this, error, errorMessage.toString(), 0);
    }

    public String getErrorTitle() {
        return this.errorTitle;
    }

    public void setErrorTitle(String errorTitle) {
        if (errorTitle != null && !"".equals(errorTitle)) {
            this.errorTitle = errorTitle;
        }
    }

    public String getErrorText() {
        return this.errorText;
    }

    public void setErrorText(String errorText) {
        if (errorText != null && !"".equals(errorText)) {
            this.errorText = errorText;
        }
    }

    public String getErrorReasonTitle() {
        return this.errorReasonTitle;
    }

    public void setErrorReasonTitle(String errorReasonTitle) {
        if (errorReasonTitle != null && !"".equals(errorReasonTitle)) {
            this.errorReasonTitle = errorReasonTitle;
        }
    }

    public boolean isThreadedCommand() {
        return this.threadedCommand;
    }

    public void setThreadedCommand(boolean threadedCommand) {
        this.threadedCommand = threadedCommand;
    }

    public static void main(String[] args) throws ConnectionException, DevFailed {
        JFrame frame = new JFrame();
        String commandName = "tango/tangotest/1/DevShort";
        if (args.length > 0) {
            commandName = args[0];
        }
        SettableCommandButtonViewer f = new SettableCommandButtonViewer();
        f.setCommandModel(CommandFactory.getInstance().getCommand(commandName));
        f.setAskConfirmation(true);
        f.setDefaultHelpText(true);
        frame.getContentPane().add((Component)f, "Center");
        frame.setSize(640, 480);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }
}

