/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.device;

import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IStateListener;
import fr.esrf.tangoatk.core.StateEvent;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import javax.swing.JButton;

public class DeviceStateButtonViewer
extends JButton
implements IStateListener {
    private Device deviceModel = null;
    private boolean alarmEnabled = true;
    private boolean viewLabel = true;
    private boolean defaultLabel = true;

    public DeviceStateButtonViewer() {
        this.setHorizontalAlignment(0);
    }

    public void stateChange(StateEvent evt) {
        if (this.viewLabel && this.defaultLabel) {
            this.setText(evt.getState());
        }
        if (this.alarmEnabled) {
            this.setBackground(ATKConstant.getColor4State(evt.getState(), this.deviceModel.getInvertedOpenClose(), this.deviceModel.getInvertedInsertExtract()));
        }
    }

    public boolean isDefaultLabel() {
        return this.defaultLabel;
    }

    public void setDefaultLabel(boolean defaultLabel) {
        this.defaultLabel = defaultLabel;
    }

    public boolean isViewLabel() {
        return this.viewLabel;
    }

    public void setViewLabel(boolean viewLabel) {
        this.viewLabel = viewLabel;
        if (!viewLabel) {
            this.setText("");
        } else {
            this.setText("UNKNOWN");
        }
    }

    public boolean isAlarmEnabled() {
        return this.alarmEnabled;
    }

    public void setAlarmEnabled(boolean alarmEnabled) {
        this.alarmEnabled = alarmEnabled;
    }

    public Device getDeviceModel() {
        return this.deviceModel;
    }

    public void setDeviceModel(Device devModel) {
        if (this.deviceModel != null) {
            this.clearModel();
        }
        if (devModel == null) {
            return;
        }
        this.deviceModel = devModel;
        if (!this.deviceModel.areDevPropertiesLoaded()) {
            this.deviceModel.loadDevProperties();
        }
        this.deviceModel.addStateListener((IStateListener)this);
    }

    public void clearModel() {
        if (this.deviceModel != null) {
            this.deviceModel.removeStateListener((IStateListener)this);
            this.deviceModel = null;
        }
    }

    public void errorChange(ErrorEvent evt) {
        if (this.viewLabel && this.defaultLabel) {
            this.setText("UNKNOWN");
        }
        if (this.alarmEnabled) {
            this.setBackground(ATKConstant.getColor4State("UNKNOWN"));
        }
    }
}

