/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.device;

import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.IStateListener;
import fr.esrf.tangoatk.core.StateEvent;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import javax.swing.JButton;
import javax.swing.JFrame;

public class DeviceStateLightViewer
extends JButton
implements IStateListener,
IErrorListener {
    private Device deviceModel;
    private boolean viewLabel;
    private int chosenLabel;
    private static final String defaultName = "No device defined";
    public static final int name = 0;
    public static final int state = 1;
    public static final int nameAndState = 2;
    public static final int customLabel = 3;

    public DeviceStateLightViewer() {
        this.chosenLabel = 0;
        this.viewLabel = false;
        this.setDeviceModel(null);
    }

    public DeviceStateLightViewer(Device device, int kindOfLabel, boolean viewLbl) {
        this.chosenLabel = kindOfLabel;
        this.viewLabel = viewLbl;
        this.setDeviceModel(device);
    }

    public void setDeviceModel(Device device) {
        if (this.deviceModel != null) {
            this.deviceModel.removeStateListener((IStateListener)this);
            this.deviceModel.removeErrorListener((IErrorListener)this);
        }
        this.deviceModel = null;
        this.deviceModel = device;
        if (this.deviceModel != null) {
            this.deviceModel.addStateListener((IStateListener)this);
            this.deviceModel.addErrorListener((IErrorListener)this);
            this.manageLabel(this.deviceModel.getState());
            this.setIcon(ATKConstant.getIcon4State(this.deviceModel.getState()));
        } else {
            this.manageLabel("Unknown state");
            this.setIcon(ATKConstant.getIcon4State("UNKNOWN"));
        }
    }

    public void clearDeviceModel() {
        this.setDeviceModel(null);
    }

    public Device getDeviceModel() {
        return this.deviceModel;
    }

    public void setViewLabel(boolean b) {
        this.viewLabel = b;
        if (this.deviceModel != null) {
            this.manageLabel(this.deviceModel.getState());
        } else {
            this.manageLabel("unknown state");
        }
    }

    public boolean isViewLabel() {
        return this.viewLabel;
    }

    public void setChosenLabel(int chosen) {
        this.chosenLabel = chosen;
    }

    private void manageLabel(String myState) {
        if (this.viewLabel) {
            switch (this.chosenLabel) {
                case 0: {
                    if (this.deviceModel == null) {
                        this.setText(defaultName);
                        break;
                    }
                    this.setText(this.deviceModel.getName());
                    break;
                }
                case 1: {
                    this.setText(myState);
                    break;
                }
                case 2: {
                    if (this.deviceModel == null) {
                        this.setText("No device defined : " + myState);
                        break;
                    }
                    this.setText(this.deviceModel.getName() + " : " + myState);
                    break;
                }
            }
        }
    }

    public void stateChange(StateEvent evt) {
        this.manageLabel(evt.getState());
        this.setIcon(ATKConstant.getIcon4State(evt.getState()));
        this.repaint();
    }

    public void errorChange(ErrorEvent evt) {
        this.manageLabel("Error occured");
        this.setIcon(ATKConstant.getIcon4State("UNKNOWN"));
        this.repaint();
    }

    public static void main(String[] args) {
        try {
            Device d = args.length != 0 ? DeviceFactory.getInstance().getDevice(args[0]) : DeviceFactory.getInstance().getDevice("tango/tangotest/1");
            DeviceStateLightViewer dslv = new DeviceStateLightViewer(d, 2, true);
            JFrame f = new JFrame(dslv.getDeviceModel().getName());
            f.getContentPane().add(dslv);
            f.setSize(300, 50);
            f.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

